 
          "          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

 
         "          $  '                                                                                   '8oZ ! (JD  +V  -^xz  /c  3f   # 7gg ) ;c ( 8\Z ( 5S\ $ 0H  $ ,=zz # *0 $ ("*E   ! (	6   )30  ) )Z ! -" $ 0  ' 1y{ ) . + -C   * + ( /6e + 0dZ / 0  1 , 3 (yz 1 % , 	 ) : % 6 " %Z ! 		. ! 	; % 	L.y{ * 		y_ - 8y	 .  E ,  , 8Z . 	 + 2  \ 5 ~ 1zz 5 8  5  	 5 m 5 	'' 3 C5ZZ 3 [47 / fo* . p#Dz{ .   0 R 	 2 C 6 s 5 	  8Z 3 
;  3  D| 4 hi xy 6 #/T  9 &	?G	 < '*
 = & ~ : & Z : & 
 < %1 r < !D Dy{ : T  4 5 h  		 2   3    D 5 
  Z 8   K 9 
_  n 5  Pyz 2     2 7  	 4 
{ w b 6  q   9  o pZ ; $ j %  ; 
H `4Wq ; 
^ W5x{ ; e P, : 	c Q#	 ; ^ M   < Y F 	  ; P < Z 8  K 3  5J (  vu 7I   zz 8  F  j 7 A  '	 7 ;  8 	9} 9 6Z = 2 @ , x @ ' 9y{ = % B <  	 =   u ? y = 
tZ < t < { z ?   y| E &  H * &	 H + n H ,  D , )Z B '  ? " } =    ";y{ < "3 8 %5	 7 -w 5 $ 6   !Z 2   D , } ) Sy| /  ; 	 J 1 S @ 
b U > &Z P ) ? D  U~ 3 a/xz $ iw  
 }߷	 '  ۹ =   Q  Z R 
  @ 
  (  y|  6  	 #  1   9  NZ <   @  >x| /& #f	 1  6O $!.Z 8% B !S >  ]{| 2 
) &	 # % * % Z       - ! 
 z{ ,  p 4 * 5	 3 
> P + 	W o " m [Z y 3   ! }jz| % os ( `y	 + L + 
 7l , 

 &gZ - 		  / 
  - ry} '  &%
! '	 ' &/Z !6 t0* `&x} 
L! y6 p
!  
sh 
j	 alZ Te 	F 
8y} -_ 
(|
! 
$f 
%I	 */.Z -g 
/A 
0 z| .  - 
! 
,d ,E -rxZ *h 
&W3 
 Cy{ 	8 2R
! . 
'  !;Z $ -- 86y{ I1w  ]'
! #w! "  %Z ,o 
.~ ,gDzz &Ju& ".
! # 'G (L}Z 'y
 & )zy  -r+ ߥ
D# 1p N hMZ     yx   " {
D) , 2 oZ,? 1 0K )Tyw Z+d`  6H
D"h2#r(  "{"oZ  zw


 
D M 	 Z  h  "yt  
D l ?z 2Z &7hztOXm
D
L :Z   B:zr;,
A(53Z -*4?#P zqw\j_&
AcYwgO'mGZ sEBr@j;xoe29b#
w
Ab lj t ܳZ 	v݅ssyl|)
A}i!UZ E+2{xk ( 
A   &QZ  j4 H  4 '  +yk 	# 
A $|Z cjE   ixi % 
&  o{\Z 2T
ݪܙxh	
& "Z!!0-xiBC[
&rM
Z! 	5  # " 4~M3zh ' +r5  h,
&\$_!Q (A M 3Z!03 s1( p# 2 oyg 2 }+ 
&!  G 
 Z! c+ %xg! ' *;%
& H NU.6 @ `mM
  AZ!  jsY ^yhnghe
&nr\m]Z!cObY .{{jP xhgkg>  ~pSD  2Q	OR6g7  .7 / ( %BZ! C g !8 0 p  W  Vy yk )w z 	~     Z!    $  >   D *ym ( Q z	  ۄ Z  x       F { yo " r X    * 	 	 y  E - 	 LZ  L< , yq  
	    06Z /}z&Dy!yt |_	   W  \Z       Yyx 6   O	 K S <  A Z  [  a u 1x{ Y }	 q  u f  Z[Z ; Ne  Y F  X} :z~ Ix #y 9u 	 -u  $v	 &t
Z 0o.   Gj6 	 Xe0y O_p'J 5_Y!	 _D ["
VRZQR[ W x ;X  SSn	 NO+  : 1N O 	Q 	
Z T  	T{ 
 S Wy Q 7 "R 	 L1   
Fn[C ,Z
G 
FI} 
|D y!>- %=c 	 < 9 
< : ) mZ : T^ !$< s 2 &>  ,y 
+B  6 .C  2/	 )2D  (q B0G  	"G K'G 	 Z   CF%  0F0  #J* z ,O" 0R$ H	 0T%  1T   /-T fZ B'V  P Z   _^   x   af   ^s ۱	 Y| 
 U	  
         "          $  '                                                                                 W pZ e xL  p q  j  x  V   8  	   
n     Z    i   }=z -lUs 3Xk*	 .H6 +?3U *=)Z -4" 1!  8y A   GR	 D	 :u )+Z y- o6 
d0  
x Y 0pS2	 >pYo DvhF  Jyp Z  Nxj  Pz\  VO 4z gE   u?	 ; I 	 <   E ?Z  vQ  t[s  u`Q7y h`E  N#^C 	 D+`' N1Z ' [6M 5WZ   a=A   4Y  cKF  *  iXX ~ 
#`y  k]j U 	   bTr 9  	 YLp  X [Qj  lafMZ  {df  }[g  T % |Okx y ) {LkI   ! iVeF S	 
 Ef_j  8rcl   HrY 	Z K - 6  +  1z  9  #.  J : 	  P j   J  H =   Z :x R NO   q1 Xx  %2  @ v*[ 
	 N a:w] k E gR}   . m  KZ 
 {~ ^ $ Sa  4K >: ~ 5+y T M 
,5 ' q = 
$	 = s% m   5 ^C   " $ Ve  
Z  b   
 u' ~   z[  z  r  q  i  2	 5 q   I    Q 
  	Z E    -       Wy  
  4 + w  	 0 kl  
e 0 d`  - i[ Z * x_   ) ~b  
 ' l] y % ZQ8 
  YI5 '	  bsB. p  gl5/  ! ki " .Z 0 vd 
 A ~b  
 J ~^  "y H ~V  3 > zR  5	 4 qV  - / o`  $ ) kf n !Z $ _g V  C % Vg 2  . [f Yy 6 bf  8 ce# 	 2 ^bEZ  + `Zd& Y ( hM Z ) j@  , b7:  3 `+e Uy > d#  E m#"k 	| F |3 	ۣ C 3 m B (%  Z D  G #z G }
y| I M I 	| H  E y  E 9>Z I 
 K 	> E y{ A v ? x(,	| @ ~=?1q @ Xt6Y E {.Z L % S !Y X  `yz Y - X 	| S .! J G2 A zaZ ? }k I j. P yy M tt F aU	| C \ 
 @ X ; S%+MZ 8 W<) : ^c > b[yw ? \!g D Pkt.n	| J LZ. I SLc A \E bZ < X};  9 O(	 < K
tyw C N I O	 O O	 N J!D @ @+/Z 0 6.6 ) 500C - 45k&yu 3 1AK! : 1Q' l	 @ 3`
g A 6p > 8kZ ; =c : C 6 Dayv 4 F [ : B 	 A ;   D 6}	, B 4bZ ? 3 ; 09 6 0cys 0 /p - #~	 * S + }3 1 !aZ 5 6 2 ) B -  zt '  " 8	    %    / 8 Z 8 & d > %-q < 	6}ys 6 1 ) 0  '	 4  !    | - 8 Z ? 9 q ? 
	 4
&{q .$ +   	 $   H  Z  
   ; !  yp &  u -  ߆	 ,  x P ,  a  2  =  HZ 0 ,	  K
  Qyq  o	   ' * -eZ 2 u ! ( wz 
yp+* )65	 2 )  "uZ $  - zpzq	 sO {x	ZZ0k  y?yo sb<	 s /?Af %E ZS: |#9 	zo 
 #r i	q   &P  GZ  pw Hr axp r H+ v y 	yv (oz 5 | 3Z 	 s*S  Y# q zp  l ,	  by  8"  {Za 6o  Yyo t' s 
x	 z z  M WܯZ~ }[i o pqypz X N	| P]u Tq XaZk ^
k U]r <yox
 .q
 6~	c :^
 1b_  &Z_ 4` 4b +ypc
#b
 	h n
th	ZVd~LNbyqI
 9|	/or9TO:Z`(}`	^ܒyq\	w\	V
R[b#Zh:|t,syrcDS	PFSPXZa|n3#Y3xqv5,	$}wS!k >Zik{gT6jBzrq1m *	 
U 
Zx,~zu
aas gyrt(u,1	p=mMnX'Znd|zlrk}Vyqmjm		m
ixaeZg5yh&l xqou p2;
qd62s._v A%]Zs !Eyp ^ofzrop
m8!mmoZr&yw|~:yr~z!{z9F
}vP hcۂTuZFy?:yq42
136Z93y<  = zq? r? 

= ;  0< 6Z@ /xJ &NN !yqxM rrNX
eU  @_ Uf= [Z]iEy 	in GlZxosv ,y	 
Lyqlv)yZ~ Vy q` yp. HjQ v
li 
fZ p[ IZ0  Uy  
xp 
kv 
|}    Zv.yl6@1xp']  !
 ~TZ{yvyp\D
77~LTz  
"Z ycyo4'W
q ` .Z Iy yn
 H {   yZQy
,eyo6
l2V		L( <"\, Z#z yn!N	{,	  16hZ;z}9x1yoy6#{>۶	 |1~ 
         "          $  '                                                                                \ZyC{royn{	j_K)Z
U{  yo -  {)	 C  5 [3d  X ')Z  m "|   byp [R 7T	  p 3^'Z <| > 7yp 'X o	B a 'Z ]r| 
 1 9 7yq O  > =	  bB Ox;ZQ|_ I 07xr N 
 S	 =  '^ 25LZi B4t}h  P+ E T#ryr  Q   , C 	 f#[ 8e *{ A q
h YXZ - ' l}  y\ c wyt ` Y  7_	  7" (  G  ?  HUZ 4  KG}   \ S `xv K 9' r 	  K - Z oV} 
 `yw F  	 m sr v Z $}  4; , 5Jzz   },a A}$&	u x u ?ouZ /wt| i{h ' xQy| Z iu6 ^ Pr(P	u < 8s  	 &u {!v$Z j,wb| b=y ( jH}ތy} 	 F= & >	u / >}g   x?| Z6~Z >"{ 0 Ay o'  76	u P A~ wM |a8Z e w{ ; 
  !x  72 	 S5	u $ ]- F e$ \ u!3Z _  \y F   u<ty KO 3O
	u :<  b# s +  Z [ y o  a y :     #	: q "ۦ s "\ 
 { 6{Z #  ?x 9  1 B  "y 4 h )%  / E	:   ^ h bHZ  Yw I D +  /y Q  + ^  9	: R  G1^ 9  M6p  q Q/#Z  x Z%v   d!t ) u f yy P Y eK p ? r	: s ) ? U  N   b Z I u K  M d" y ( $  h $ 	:  &|   '}  a %{ iZ < s t ) h  1  e	uy L &h j +h"	: { 2i4 y Af> a P`MZ 9 [`^r  Xg`_8  ?|`Ox  :a? ' >e=9	 C Gk@	 P Tk6/ L hh/Z : w(g 6q + y5n 0 + p;s &y < h7t |! R b.s a 	 a ])u J b \&x ,< V d"} Z D mp ; q > ky F Y} I @7	 @ *. 6 $z	o 0 .zZ / ?o 5 R[ D dy W my f i!	 j a% o e ]% =M [ e [zZ V s {$m ]  < p  y  r   K W	 ~ 3  h q$   P Y Z B BJl D ;-c T E 6x~ i P 1 p V (	 k X "# _ W   W QC Z ^ G j q D  { | JL Jz~ k WQ = T Z	 ` U
  M#]  IZ  :N	i Y % 9  y| 5 #ے A!߄	 RM \  ^ oZZ ] (g \ S  U
l{| J] G ".	 U 
a p w'  "J}Z  30M 4f v :Hgt b 3^ ~y| [ "n #+ b v 06E	 i  72 j 1 C)6 ae N"Z X   U e R  X Z 
j Xy{ d 
P V; j 9 H	 i ~, 8k b m  *# ^ W "Z [ @ d j /    ,5qyz  (-WA  ,1}	 u $5 c 9_ Y8
Z T5 c S0j C W$R yz [; ^#o	 ] [U RmZ JSb G?F O5zz \2 a4	O ];( [Dg5 ^KQ3Z ]UM*ua WdT#) FqU yz :uK  8yEC	O BJ NN< SKZ LLNa @Y 4Oix{ 2rG :t
	O Fs J{v I}Z Gc[a Iu NYzy{ RN# RU	O Lg-n D 8AwZ 1
g&` 0fu 8Hby| =p.y# 8X	O 6 7G 1%Z 'z 4` $t+4 (i +z| 1Z # :I 	O @8 4 @)B 7Z -}` * (Xtz| %71 # !	 %~ )} ){#EZ #y8` yc v܄z} 	t] uG	 | # ( #Z & `   60  ?y| $ 7F ' ]	    uf G O Z !? a  2 # $3y{ 5 -	 $ %! > EZ 
@a 
8E @y} O #L	 (<\ (@ !XZ {Za |? ,y| ,I '	   Z  b    Ky|    	 
   vX  KZ %  c *  &x{  A 2
$ 61 
.o %cZ '!>c &c S "Rz| !"X '!j
$ &e T ~XxZpvdaP7x{ 	:  "n
$ & !e Z d  w
 #py| 6 K
$ g  x #| Z #r #e k h y|b \c

$f*]kA0PmC6Zv>/eF&^S!y~\ j]P
$[^HaHZ\f X ZBz~ f 	 p
<p{ZdJzXZT8fT;UyR'0H_
T<N  v1-6Z)Eg$!z^
 Z.Tg 6 1z 'sp !
`  T F WZ7 h(  y  
   >  `  
FZ 4h  vcz X C
 1 Y'Z@hy T
9 eZ%h
{,(yA6t2d
  ()"^* Z%ch 
y  "O
 
spkZ~~h
wvyxX
y
 sL  k 
         "          $  '                                                                                 
eVZ 
bHh_5VyNK
L<b Lg  
IZ  

B[h@   E 9 y
J ] 	L ~  )
	Q   5
X 3c )Z
k "gn  o yr{ d
	    {~
 3Zgx  
  m   Z Uf
  .y1  +Z uf  "y   d ]   '    5-Z    4~e  +$  #xy}  z    h   ^ h Y  P YZ E  d  8` y{ c 7 ) Z^cyxu 	d 
Z [D gZLcUzv f > \ a  Z $eb 4#   5\yt  ,  $6
  !    ?    Z     a      yr   
 N
   {   [7Z  	 =`  d "ޫyp )6 +
 $a ~ aZ! A	^ " xn 
 >
 
} 	z ~AZ!  ]zy
sl!xls]2 uN6
 |@- ~2% .!GZ! 	4 p\ 
ALxjVk,
 5Z" 
[ 
yhP "C
 >ۿ ^^ uZ" Z  #zh %: %
 $ ! _Z" Y 
 
yf  	
 1B 6~  /GZ# &W ! 
 zye R  
DNZ#WK yc 
   
  $  W   ]Z#  U   p/aycbv t
 	 a   dZ# Uwwa  
, 	  /JZ# 6S $0   (&ya  *!  , ~
,  /}  .0  *Z#  $zS    ya  !n *)
,  .' 	 ,	  *Z#  ,R  ,J  *y_ 
 %R  %
,  &e  *A  +iZ$  'Q  ",  zb    L
,    #t   -bZ$ & AWP ; \D-5 Y ,6ya m 1 w '(
, s 9"- _ <  ; x)Z$  @ P 5 
Gyb  (RC 9 G]
, V VV J S;\  8"Z$  O?xc  ,ێ d  _	   )     PZ$   N  > 
 yd|w t t	}  G  z  t :s iZ$ T Ek  N !d D_ 5yevS *H 6*	C 2 W @ i)=  ; )"Z$ 3 M <+ .$xg h & /  	  % R   7Z# \ )lM s v p oxj W [ 1 u	  3 |. `Z# 1 	BM a ]%  !yl ) *3F	 9  94 ` ~=Z# 4 $HL R, "Wyo :  Y U -^y	 ] Db(8 H 1c5{  cL3Z#ep*yLti#hj yql n.	 ^ *p  ho(  mZ# v wn>K G K
s  xyt y:  s
	 "o 9#qF L%uZ# M "x<K 5 y x\zww w	
yY 
w T {]Z"  v{
J  {Z  uxx  rw ] wugr	 8 9yd 2 }l Fxx%Z" d uw4J | !wg4  6yW+yy n 4wO# I wH 	 {C A|AZ!y3jJ -w d|_x|  >~  k|	i  lwm \ ?t 0r`Z! qJ s rbx} ?m. [e$	i \a. >c3 h;Z!|gGJaf^`fsycy- -`qu	i c a] | >cH6 v [eEZ  X NhWJ 1 $kk" it3fy hs5 "jw-/	i Ck{$ a m! o "s ?Z  _ yJ 3xB zx~~	i Z 9 f  Z  NK  fn t amy T Lxg 8 /	i +  1  D Z Y  K f   ^  Ly~ C    	i 
 ]  Z  K /  L  ry~ ] $  	 Y 2 1	b E 1 6@ . ) .   %%Z   8!KK %  L _ 8 
 [!y~ K  a N  e
	b @  r$ (     }Z  "K   Dy~     +   	b @ 1     M I \ N Y qZ E ] L 8 Y o 1 S kz} 4 K { > F 	b G @ s N = j N ? Z J ? L > : | / , y| "  H   
\	b     0% & 
 6Z <  w/L K - f&p Q > S!y{ K F H m < >v HX	b ) /o G  " *f . W & /\  UZ 2 2O 	 L < )C   @ > & Sy{ D < &  ? ;  	m - 9 
   7  ;  ZB  CKI  
) 
L + 	yz O * - + U  k	m - (^ T # .h !  (t 0 5Z 
 "~ * EK  $    )  yz ! %  [ + ! & 	m 4 $    4 -  ) , 	MZ    
.+K  	 
 6 19yz '   !	m    
    dZ #  K " y 	  u 	!y{ 
 p   d 
	m  G 
=  % d $   	
cZ )   lJ & +  iz{     	m i U@Z*J   y{  	ma &G |,  LZ I 	x  	+x~  6] 	 2l	  ( "T   Z I  y~  @	   <  ^ _Z| H$y ۿ	
 ޳+ r 
         "          $  '                                                                                C =Z  _ 7Gw  y
 v	 	
 I   ZBG  |y  )l	 5 3 	)Z" 
"F! 
  y  W	  n
 #Z$ EF l x 
  	  i  ݟZ G %E l   y    x	   z   Z7 mDP q x  B	  & 5	Z 4D +- #sx    	 	U 	 GZ} Dj 
Mp xp c V	Y :M JP Zd jCg R y: 
( 	% 5 
*C Z@ 4C4 + By0 = 	H TN <T Za $"Bq 
4 } 
5by , $A	    < Z
 B  y z I	t n} ko >Z
kd BkV qA ޶yy3 	* z	% /  Z A i x ' 	@ b7  Z \A 
f) !NyG 2H 5	) - %
! !'Z+  J@  ry~  	 	
	  	l  Z | ?    y}w  f p 	>	 X ۏ  ~  KZ Y ? & z  zz / 

 % 	     7Z ?  yx @| j	~ 0{ 6]z /<Zz %>|} !]~  Vxv 2 	 ( 3  Z ) > : 3 : yu @  U 	 j 6 w  x 9Z } =  :  <yr  Y  S	    C  HZ  =    ]xp     	  	N    /	Z  6<   !0
  &xn  !   o	  p  + k Z W r< F   > ym 7 h + !	  & 	 Z < J vxm 7 	 \ 3 WZv <e U yjI 9 ;	#   | Z 
; 
, 6yj 1  (-	"-    Z ;xja@(	Z3Z@:qyhۗF	Q~|wDpQNZ i
: f ezh h `u	Q Vb Q X3mZ [ : V2 Szh U * XS6/	Q U3 O')j Pk"Z S 9 V Uxg UA Z 	Q ^o _% ^}Z `h8 gJ  j+yi h n	Q $|% /- 0Z .r 8 +B; %yi    [	Q   ! F ' Z * 7 ' B # xl #  $ f	, ' (% ) 5 + {4/Z
 .u {*7 2] #K 5I  xl 6D   :J R	, AZ  Ej G E Z
 G S6 H Hyo K0L LF  
	, KW 8 Jc JpZ
 M+5 Ns LLzp M  Q	,  PO  N  KVZ
  J
4  IZ  Jyt  I 
 Iv	,  J  I  G%dZ 
 F44 
 E|5  Bz+xu  ?}#  > 	,  Bx #  @o   @m	 Z  Co w3  Ep   Cnnzv  =k +  <l	% $ >l # Am$   >j0Z  =f6?2   =f: # =i;\yz $ >i< & Ac7	% ) Da0 + C^& + E]Z / I[1 5 LV : JRy{ ; HR0 9 FUw	% 9 LV : RV5 9 NPZ 4 FOn1 2 CS" ; GWw3My~ E M\W5 J MaA-Q	% K Kg3$ H Mo!  ! @ Qx EZ @ Q  0 C O K J L z P K  R I 	% U F X X G  [ M Z ^ ] / ` n  c x y j t ~ m c 	% i Q  _ J   Y M   Z ] R . g V  p Z  9x n ^   i \  	% c L    _ 9$   K ^ , Z ^ - q. a ; I g L $;y s ^   k1	A  u6B  s.  `%Z z C^!M- h *1  ] _ # "y ` 1  m E 	A { O )  NL    D Z u : *, j - H  b  Xy a C  f $ 	A t =  .  \a  t\Z  z+  un  kmx  \7{  K  	A ~ >f q  > k  K Z  _
+  my  ky  [[9  B  
0	A  .  s $o / o / 
6Z } F 
/*  ]Q &  n 
!x  w 
 d  u U	A  dS 
  K 	W  8 
UZ  4 
*  7    ? 2 Sz  J S   M t 	k  D    3       )Z ~   G) u 
   s   x }   '  #  k	k  2  R  <    >  
1Z  7  D)  ,    ! 	y   Y  2 	k  H 	   &^ t    ,q Z  0 -)  - 6   1Ux z  ' q  !	k r    ~    $ gZ  3 (  9   8 !z  3   -n 	k  )K ?  '% m  (   
Z  - '  5 W  8 chy  2 1   % 	k     q U  @ Z  ,&    
 y~   
   
	k   ,     	 	 MZ   & }  K   +y}   6c  	 	2	  
 
(   
"n   
 Z v 	% o  n 	y| s  y S	 ~  ~  y 
tZ s{ 
$ rn  t^ ny{ {P 	 G 	 Cޤ ?" ] 
         "          $  '                                                                                   53 8Z { -I ;$ w +b x/vy{ y1 { x2 	 r2 S j5  g6 Z k5  H# v8   {A 1 gyz |J M  zQ ] ):	 yS n 5 wZ 3 r
g *Z o!w "" q-   w0   yy |5   ;  _	 zA   oA t _@ +Z V>( " T>0  Y?:  xx b@C 
A g>H  
 d?GH [B#F܅ SCQHݕZ Q=}K! R3J  T-E zx U(@  W$@ x
 Z!
A  Z>x Z6Z Tu3 i  J;  B@ yz ?; 	 ? E/ $
 B0  E
5 & F
2 4Z G$ 4  D& +C C3   #|yy AA   >U   	
 <f  Z ?t    D{ GZ J} } N} qI Jy ly{ Fl i ?^ kQ
 =R {E ;D r <9 Z <1 q ;+ ܡ 8* x{ 5)  5' 
 0$
 -' +( Z -!+) 20 4!/:z} 9,4 6.:
 /+;H ((9# &,=yZ $1E# 5L3 6O5my~ 8C, 5: $L
a 7<   ?E  9 G>Z K3# K3 M5 x~ Q.  W. I
a Z5 _7 `)IZ c   
i.  o<x q/ ka
a 
j # l2 m-Z o tgyyzy  
a y h    !Z  Q  
= !z 2 6
a i.
 M% 0!-Z  Rxf
a/rZo+yb
[ۄIH3ZRjxx
8q2Z y   3
06j	//]ZH&f!c%m Xy)c5&
/6Z @6xU
 xS ~
 6 pGm R $ +6Zy &j% t 8x p Z )R
 a f 6  5 8> [p& 2BZ f 8O Z JR ]Ty * c  ] 
VN \	/ i _Q  _ e.Z$ ~ l6 v  q0 s'z l! c x
 Y Y|  * E7 5 Z |   Zzqx8 *
7 p_	 E ZZ] L  O  X\x  % q `
h [ 0 #TZ 0   .y~   d>
 D g ] z6PZ ^ &,>6z~`2 y(E
 `"3 +s swZ)- = *Hy|uE77
 ;& TIV ,	ZW_Z)$x|6 ۛy &(
 t f *@Z   u oyzQ m X
 0  jjLZ%      zz {.  *OQ5
 3  g)[ U"ZA+  0  yzP  v 
 w`Dc4 ` ZF E ^/ }h  zx SO
o|u8  Z_  (%zwY 5
Kz  sw  ' xxtZ vy_Ly M& 6yp 
ywC z9 }~ 	
}Z 'MF~R 5` y*  4)Z * 
#>  zw 8    B
lz  8 
 Z E  &  Wzv WYH    
    e'   
  Z   0 R  _:xw   D & 
 9D B 
^KZR dQM yxZ  n
 T 
{u C}B   %.Zh d 4r/ V  5W O ,yx " #  G  
 u
   0 ] 5  Z 1   " >   5  {zy ) j :I 0 a 
( V / } } # 	  v b Z 9 8    9   Xxz 7  
 P  
 3  &  M  
Z       / z{   
4 0 ' | y
 i V  o  	8I ;  Zf   E <  "i   - 37y|   D 	5 n  -q
 G  $ H g ! _ >  JZ b M  Q b 
X T 6 z x    
  } b . E    5  Z e~ 	 6  S Zz ] 
߫ 6 
  S8   
  Z N]  ) u   CL 
By 
- 	 H 
 q  r ^  yi Z = t  - r    w %y   m 1
S  o 6b   .    %Z r !c [  o l 9y     . (
S * >     BZ  w?  r   Y xz  q i,   a=
S  md  rh v lNZ  t `  z ^w  ay  ]  z @
S 7 }  F x} 2 rZ  ss-
 xZ }Q y |Y H  r^ 

%
S " nF    t /  z6Z  o00  W&  I !y " Y 	   o 
w
S  r  #  g y - g tZ ? |X
 6 A  }`sy} b.  Vw 	 6 a\ 	 e ~E # l BjZ B {a]  R Esz|  ZY/ F mly	 P k\ = e . qU6Z ( FG  pw  Uz|   U] 1 gw	 6 c  0 HS 2 :Z B N- E _6 , X1wzz  I'  G"		 ! O  3 N 9 C,Z / ?6  $ D#  $ H 8yx 5 J	  E <5	 < Y   

Z   - 5 0 1  ۆzv !    	    	  m  	 3Z 8  ?  L  
 G = zr 7 ` c  . N 	  Bw   YZ  u 
 V    L  +yq  $B 
6b  2	  (  " 2L Z F  O R 7 $yn      `	    	 ( 
zZ ,  % $  zk    	~)  	 y7 ޖ .o? M 
         "          $  '                                                                                 1dH 7Z (_] C `  ` zh _ { %O 
	 )6  Y "    / 
Z M U      \yg 9%  ] @2 )	 ,= 5 J 3X  *0Z d  # m  
  #u  yd (z	 0  |  	 z  0 }   	 
KZ    "   .  ;yb :  

q O  s 	U	% f a >    8 ܲ   N ݜZ   B  n V   5y_ s	 	%p 1   z 7Z  +  @   1y^N L  1	%P 4 &  5 Z  s
 4: u +  #x] v a
   o W  *	%{ U !}
 < %! _ $hZ   KX	  g 
  x[ H
 U n
 R q	%!   vi  E  ;ZA  ݥ  ܫ    y[     " p 	% 		 v  %   .
! Z
d66 7|  
  JyZ .w   a  	% ^ N  T . B   | SZm ? #) S  3: u 5yZ N , 9 $_  . !     =  o Z @ $ )  ] 
 zZE< / 
J .X   v#[Z:r]qM z[, E B  
$ m Z	  %\ ] y[ A c  	W t 
Z	 4 

S  y]2az6h$y ) .$/	} B %1 Y !4Zk   V~    x^ 6~  i ;x  N Un      d \- (ZzS? eGNc ,/I Cy`7C 	 PG 
 
kM  ۋyR eU 0Z7!]A i v ya/~g zX re Xku  f| 8Z^ W ^EQt xd3Q 
,U 
TY 0[6c/Zf &,h !{Xhi   lyfcKk NTt x< Jv  PvZ 
=z^ }zuM x}ygyPVy 'Zz )| bL IZf /} " o| @yl } h~ ]<@} }  	H~  RZ  C |Y gylN[ }> {* 	 
$ .Z[s+ 6AM+ 0_B  '=yoF  
!R}   ps  m  P^j  Z_)j  6n V v (  xr  " #>O3b !P4Y 	  ZPp r ]A OytQaU a) UX h[c 8Hq YZnhK j )q xwrY y^n LD=g )?` 
 %g^a }Z;eS bsp ,e}O 6xz 	2,  (n 6 
"Q     Z  
    x} 0 b Sk 
  E  "o   N "Z e u5 wia !xG +۶ 5 - 8 6v% 1PZ<*]V /&  8 ^* Gy|, C  e0 .n?&" w 
  bZ Us 	 	  
|8 z ; *7 
G 6 i3C8) ["Z "O  \+P ; 5 x& 
< J@3 }G  n WQ' #&FXS Z zZg 
2[o 
	 U]	 #z 3^ 7d T 8N,i 2<oo[ 0n 'Z  i  ]i /o x .t  &u %Iq% m Ao Z Xu   y  : uwC #x  +w * y W~x 7 '  xu ' 1 w 5dt =wF 4TZz *C{G  #b v   x zx     $ b c y    Y   Z 	  $g D " "$ 2  y  j 4`  }      h   % 9Z   "  / #Z  !Qx   + i   h (   A L oZ x  %  
 r w 6 y 9 Z   	  $ 
  C |   %Z cW  4n -  5<    ,By v :  $ WJ Y   .C   ?  -
  9  Z b    f:   G	 y 6 ^ D E f7  V _   Lo   0%  Z &   D   i j   `z h    B    ! k   ( i   V t p #Z  P     ,    y    N n E  X8 
  I	 E T F  u Z Z  ( 4   "I  35y   E 5   8 - 
 $ n !; {  hZ `vti 	 g5*a ~ :ZJ x !Bd  %<{  54   2R ) . Z >   W a h? 
y  	$ #Au sk  <zz Z y >  # *  4n Lz M`3N2  {!  h "A e  Z	  z  N [   ! ": z  li~ n G| 1	4 w 6p iU/ 7ea%Z	Ic/!o jv s  [u ?z} 
 .	4 "b 	B 
 C   # n Z	   H# =    hj  yy a   `
  	4 }  
c K q nL 4 @Z	 t 5   b$ ~h 5 yw% J$) 	4  -   F5 $ > #Z
 0Gf 4 6 DH  1@ !yt}8 (G?q2 )

	4 cO -  F~ 5/  86Z
  /0T XO '&   &!yr  A * 6N0 -	4ei 31bH 5  6Z
  b 6   4 2xo /8  ] +$	  ; &	=  Z i  Z	  t i d  [ &ynz3 (:=$ #	ui h  
  kk FZ	H S  	^> LL2  E  zl 3 (z +	  ( G "U _ Z	 $ -
3O 6 = 1yi xC !'iC  "-	FO  P   ^  "Z	 Ml ?  fs  v 	Ixi uC   u 	 = u f w  y 
Z	 8G|V 8 S  & ۔xh   ߹ {  	 K =u 
 - 'z p $3Z !R9	 00 [yg  1: 	 m 
< X $h   zv  TZ m   \h 
 O g 
+vyf n F 
6m y T 2	 j > 
)& 5 8 "  % - 	 Z  S   & < E  D Aze UW  a  y	 f	 3 X  ;Z   t T  mye  @ %4 	 0 ޏ > F 
         "          $  '                                                                                 G AZ O Y O]  L {yc F R : V	 ,A m .  <" Z J  e M0  I Wya K' o; L(	 J5 >3 4` *cZ =# #+ K*  Ec  za %K 	 p	 	 EDF * W( V $?[Z tk tx elaLya JuD
 0/
   
 ! <ݏZ : 5 X / m/>y` g E
 ,2  K C@Z  ~- T ~A p{=y^ gx DA*
 #5 9&Y 64Z  14 )={+ 8JV#z^ @A Z  F,b B
 J) A P5 K:Z  .Bo=Ay^ 
 (	
 (]  _Z  u	 
ܶ y] 	 
  A > \Z  XE
 1 %Yy] 4
 )
 $d , *;Z  ?#  m3 5y] - 
$
1 ! T5Z 
mE x]  
Z
1 
 
  yZ  /K
 >L| Ix] O T3
1 ]
 e t \ Z ] G K 8 f; 5x]8 3D ""
1]   jy   Z  8u y^l2Wp65
1.W|%Z!LZ  gy^^ #
A F *
18 ` 5  C  -Z   7 jy`'Kd
4-uۅGsn~Z ya
4j2;Z N~xcf
Rp
4lN0=61/Z &&F'!/ sxe>VlI
4kMQyKW<Z  |nQ[
zgu?]U
4R \: uL NZ F y. i ?Ayj pb
4uc
JV'RZ R@yXRp 
g\sixmtWxE 
!r:gEWf .Z O 6 M 60T J'Vypd d!q v 
!| d \Y~ Z td| "`~ 'Q ytE H I
!V~ dgy
$q|q5Z mnjG%^iiatHmgHyy:{_<Q
!PFugCF{{B^Z JC-''BM,*@Iy{uF=<ag=?P
!M@HIEF VLBgZ fxZJ/)pWcW,t@lW6y~tFv22Hn^
(
!ar"\V TZ VU,`.o x Y 4
!zu^vZ L 	.F P Uxi   	!  v{ 	cVZ g 51Z cx R jn 
yS Q \ Ei q	v X
  `  D jZ  [  3|  y c PP cyS |r5*N fg]6	s -]t 3l XX ) VW"Z  P   6Gt ] E+ ys HK ^ J &	i EF (?<- %:x 2 "Z  , 8  + 1xIr8LX @	 4D_ E jBkZ ?: <<R:>tycCjfH  M	O! 6U 
C\ Z "d ; EmBt y{ l\	v{ '|  
5TSL 4iZ a *< #g @	V xf
p l=]	   4 N  Z 8% [=@! *  x~ ]  	     o4 9" AZ  zf>amrP.da!1y  Bl 	[2  J b 3 QZ u>R ?Y"y _3y  ? j	  E  y yK < 8N5 $Z ; Nh 4D>  O '59 S e 0,Gy T p )$ x SP  	  Z   1 [c !n  Z Iw  > 6 { ^  	zy F
 	8 . 	G  4 * C
 v>Z y  =  w   Fy R 
 O u	G 0E~  8 R  G Eq 
Z  1 v7 < 8MwB-  ? IP 	G B  U   F 8 " Z  K 
;  "   3yE R 6  
p t  -	G   $ ! p!: 2 M  iZ  > a 
: 7  `   y = 5	G {  g, w dM Z   oK8  d M vx| d J a. h	G hs l . j  R k Z  j  6 r   `  7=y| 7    h 	G {I $ W. O_  I ^Z  T ^ N4   V   xx   / W 1~	  . ~16u  sZ/ ! n%Z  6 n!t3 M r w W uFyx T t L qn8	  F DeI G )] K 0YZ  E JVK1 < WT ; PQxt H LS [ ]Qq	  _ rTL T q^Lh G \jIZ  F ?t4/ N -um X )u |zr [ %{  X  	  ^  r n . p  = gZ   >  R"- v * 7 ^  yp H . D $		  L @ \ 
 c/ k 6Z  l 	0`+ ^ v& S 
N!xm Y   z j t	  y $}# } J8z w ]qZ  s P ) v 4 y hxl q $ Y \ I B	M U 2 t 6)Z   ES'  F  @xk m > _ A"  q \ B; P _ <S ~ a .a 'Z  b %m& >& c "~(  i >  xj o a 	W or  hb   a E  ` #vH kZ  f 'ry -$ u o 6  k1wj  c ' w ^ " bZ   X[  _` Z  kd # ohD 
 jnn ;xk hw  o  xT } xu
Z  mv! b" bI  Ykۊxk \ߏ b] f h\ g  Z  e| 
! j| 
 p} ym v  u~  pz $ nz 	| r  8Z  w   r  e +.yp V 6M P 2	, [ 	)% k 
" py  Z  l | f  e'xr gs i`]	, dc ^h gfuZ  y ~Z  "oMS cIxt n``V M]y	, 9lWY <zR
 
 	         "          $ 	 '                                                                                 TTZ  j_1 sk pxyv f* _ S#  	, ;oF &` rZ  2A Y   yx  (	, k 5 7 3 _  *YZ   M # _   6   yz [ - m ~	, b ' ? ' l $ ?Z m   v $   4y{ 4 
 w 	     ܼ h XZ  3 -! 
 8r @y}} ?  0a	 > + S Hf V sZ  I e" - k  Fz| Dj r	 X Q _ % ? 4Z  T W4# T M+ = f#y| $ o   h -	p 5  uZ  
& $ 3b Np D~ S/y| .Z  $ 		  ,
 wZ # ] %G C ܐ Z R ry| P z  ; s	 < / I'IZ 83'+6KyzJYx	 _gRgOk5Z `)#G)C-3'15xx(-8$
`
! 
} N )Z  ~EF+ sXn`xvmnl
^
l
y
 Z  p |, K BB 2>xtP E =
  J :Z x 2.R b+ xtY  <"
\ g" Z ] m*0b 5  qzr* 21R 569
j~.qPss%g1	`!KZ 7F e2K 3"L/fxqP2j0-
%-Z %U3LEo<ypfl
sG~Qp	Z 6zxo~-S ;
s>8[4;Z .L8'rxpm

s  0q 6 /Z L&Z9!!  uxp_
s<]fbZ ;;]
xpx~
sm@b[
PZ S`<K!HAypGsEb
sA ? FCQZ K	>Q
Whyrbn 
v {  .zZ  
w6@ [1 D'rys 1!  
  "_ *Z  3B 4  2yu /| /j@
 .T` /:
6 .Z  *D *e 0yv 8 8
 5__ 7:, ?BZ  LE W    ^xy  ^
d ]88
 ^ [
  b R /Z  H eF ? 9,> : 6szz @2S Fs(
 E6"U G  SZ  e'[H t2
 s=z| ]HT KI
 \F ~Gp L, Z  |O 
I sL  vKKFy vK tH !
 tB | w= f }9   QZ  5 J }36  }3R x 3U /Im
 %C D
 ;aZ   K       #y  )  a5
  93q  ) "Z    L  	  y  X z 
 v  
u x 9 1 x \ Z  {  
M      
y      
   _     `Z   	M 	 + 8  y    R  5
      2   Z    
M   -   y   t 3  {
 P  '6 i  54   4pZ   +N   #j    x  e    b Z
  p   t L  dZ  # W  TM < S  a Q w  M 
Z  P #
  V   Z g 	 V 
KZ    @ M  >  	  j x      m 
  o A      JZ    M   	S    x    z  b
 ^$ b QS  x( $Z    4/K 	 5O  q"C ,mz  X+C $)  b(7 
 
 p > 
 9 |A  7 Z  & J  	  
z ; E 6 	
       vjZ  r2I ~ ދ  /y    X
     x  m  Z  l d H x : 
   y  3 z
  u e6 f Z  nX 
F mA ! d5 2y a" $5 h! +-
 m( $$ _0 !- O6  WZ  M4  D T* w U #y N  I 
 Lr x R`  TP Z  QC B H<  =5 y <1  >6 
۴
 ;B ` 6U  .d Z  'u @    2x    
 B{  ^x 
V dv Z  Su 
> =x  1} x  4~    D  1X
1 V +6} \ 5/9 O 5%Z  98 /!}; *T - } $d 1Pz w 9 9B
1 
 3M  -  %Z  !L9 5
 " h
n 'w {P * gC 2
1 <E < P Fc  L EZ   '1 @7  : ?p J @y R < Kq ;
1 /_ 6qH .q "Z  !
 !5 :  0t z  4  V  	
1 v"  q& /o Z+{ 6Z  C(V 03  9= & % 7O !y , A    O 
1 U 7 Hc  ) Z  
y 1   y A8 f 13	 ^ R 	~ , e  h Z  ] \/ S  \ ry j    d u	 7 C Q L  1 | 4  > (Z   [ C.  j   i )y~ s '`  	 }    3w   Nw  BZ  Jv  -c- &q  
6n  	1x}r  ("t  "7	n  # g  #h Z  l +  j   	 0c  Dyz L[    VW  	 GW  ` %Y \ Z  ` * j) , +q% !ۗxx (w
 &{   *H	 
  #   c   "Z     !)   ! # u #yw ( Q # !  '  	  # ( 0  '  :Z  
 q) p 
 +xt %s 6K 5R2	v 2%)C $"  Z (C;yr  #k	v / % 0y  ' oD 	Z   "h '  ,`^  #Z [yq Z~ 	 [ 		v ![ d Y 4\   
 
        !"          $ 
 '                                                                                 <[ Z  2\5 E' _W  bi 
yoeu ne 	v` S X 
  R 	Z  (Q M& " R  &Uyn /\ (d(~	v k5x4 *Z  ##3& /  - zn F 	v  <  
MZ  & ) ,Eyl &
 	7 3ycPZ m<& dp f yn )q  .} k	7 ( y    S p  4  Z     n%    $   ym 0  2 	7 . ( ) %  4Z   4% 	+ #yo      <  /	7 $ S  ' _  "  }Z  ~   % ~ u 
} 0yq } 	 ! 	7 6  R ] $p Z  ( %  ܁  Uyr 
 
  	7   	 	 h Z  Z '$ \ e~Cyt or   sm  	7 ygJ W >Z  (#$ 3    5yv  -/ ! $	7 &  g! 0 * W N C 8 CZ  M / K$ ? u     i yxd a [	7 Z   .G   F +Z  @ $ ) Kw{o0 	7E ._ 5 # z . Z  l V '  $  s  K  u  y| L N{ # k , 	7\  ^gS }K 
Z I # ' 
J  K M 	 ,y~ B O 	2	 V 6<	7_.Oi%u?k !IZ [l 8  ]# o \ 	 Tw e y  N I 

  | / $	7 [ m 5   $ 4 U   (Z   #  J 
  y 2  G - 	\ D T t + D    Z  " |{ nx U # :	\ L " + _ T  Z o9Z  E k " ( C 
   oy  
  ^	\  0V  6 (  /Z  & +  &|"  $! ymq  	\W kt l Z    ! &  h % 
 * "y     	\ ' L WYZ KL! E  L>z  Oy  O f	\ \ 
 u G SZo t | `  
 U gz~  M )  D 	 2 , B $  E{  C.PZ /6  
14   'y~  ! '   	 2 ( 0 9j  &Z-\x}-K	
q 
_  PXZ  2  "n x{
  	 e 
* 	4 d 	GZ  
  
  P z{   ?	 G 	   i   Z   , ) 6yy@ 2|^ 	(	{ 
"o   Z|  
      yx  ( a  % 
	   { Z  & 	xx 
   	   	 	  b   WZ    | 	  u~ xy   hv   %EYg m	 ! 9`PX  " CmMP  <uOTjZ  '|S\   X] 
VW yzNQ )sGG 6	kJB 
3 hV? ) bc; 
"Z Ze.   
Tf  Oi	)yy Lq x 
Fu +	 ?w  :w K  "5w Z  ,5~   51 8  7' w
8x{  + f  S	  8܆ 	     TZ    8  y} (  + A	 (p   %RB %7 Z 0   < >  F 
z~  L s  Q _
J  R '  S 58  M 4Z D(y +A <3n # 77
g  z 37e  ' ,;o s
J (?"y  1A%g e  CB Q Z DHW m 3Qm * 'Xv x )W	r  z 2UxU
J  6TV  9Y  I`tZ  ZaW  UZf   >Qz -N 0M~
J 3FwK %8} -tSZ $n
 pZ  uy v uj
J zZ  $RZ 4  5d 4,x = $> B !
J  <  @  5  .7 Z %[ 
 $~  " y # G " 
 &v  (o  7 &l & Z !l B x o X ޲ $m j )y .e |  :_  L
 F^  Mb  	 Qe  Z	  Ui  ~  Qk|    Jho  z B_^	 . <ZR u
 7_H6  2m>L - 2{6\ 	pZ
 65` 
 98e !| 39r 
2y )6 6 !1-
  -% &,!- -0  TZ 06 
  6< 	}  A@ x  DC 	  ?E 
  4H w  -N 	  *Wl Z %Yb     Ve  TY Gy %c: 1 +s  ۛ
 "x 2 r  ^ 	qZ x     x %  1 
  >~   D A  D zZ  @ o 	 ; b    7 Q  ry  ; >    E & 1*
  L  6|  G  /O  >  &Z
  9 	 !{ 
 9 x  8Oy 2 0D
 5P =  C Z
  F W  K  	 L y 
 K   J  ;
 
 Hr 	 Ebj  @QZ   =?w =&q 8 y ,	   
  t  y 
 Z 
 . w 
Uy 7( 	
  /V 6Z 0 ' !x   
 O  Z#y E E 	  	%Z 
k  #cy 0   < z   81 U ,_ { #z'Z  D   x e     !2 Z 9  -5 C6 O1y [(? 	h"D t  z { Zx v w Pyvs
zp
AZiۧx~i3   i (&Z A! [ qz} ~ 	   1 	    =Z [  ? 
 *z{  6C  32  )d  "  Z   , ;Jzz G Ot2 W. \ cZ 
  g	 
 g azw ] ^&2 _@ _ 
         ""          $  '                                                                                 ZZ TA H >yw 5c 
)2 O    Z 
 J    yv    (D2  5  4  *Z  #8  x   o yu  kE  l  2  t ;      NZ        Mxu  
   #? ~ q { w   nCZ ' e , Xd , Ext * ( (} c? 'y &sk 'jjZ $_6l $Y #Wyt #QV &I? 'F &KB% #J4Z #J5 $Nt+ (Tx#ys )V  )W  A? (Yu (^ *aZ -e( +g ,kJzs (r ' 'w ^? #v  &v  *{ AZ . ' + ܉ ' Pys &  ' ? &  ! 1   Z # ? (  + _zt ,  * t? & dj $ R ' CZ , 2" , !3 + 
5zu )-g '$? &!4 % e (Z *e . -	yu ,  $ $n? # * *  1 Z . ; ) V - Zߋxv 4 ^ / o? '  $  ' Z ,  + ] ) yw )  * $? ) h &  " Z     q % xw )1 *	6[? '. "% !!hZ $ y '> $yx - F?   NZ    {  zx    C=  ێ    Z       yx     =     
 EZ     }  zdyw  x
k  p"=  k00  d6  a0
Z!  _&  [! 
 X yv  Wt  V=  Uv  Tu  U	Z!  X  Ys 
 Z0zv 	 Y
 
 [=  ]  _2  ^gZ!  _C  b  fIzu g dp= ]  XR x VcZ! z R  ~ Qy M|ztn Jg L <d Md KS` E.9Z!\ =6\ 21b` 'zsb "
_ <ZXx[Z!][g4WByqVX O<[{[
XZ![Mcv
ktzqih
ci<ci_ib$n]4Z!qdotsyo~+< MZ"h.+?6aypO2!a(<2r"g/ !Z"zoT < 1 Hp dZ"  N zn  ޳8oA1?Z"ADXznX8NZ"|yn)_583)"Z" yoe 8 
{ ~1  Z" h A
1yp ' %8  z  ݟ 
 Z#    {  gyq  Rz  F8  Fz  M!  OnZ#  M  I  Iys  D?  >H  C&  G5  B4Z#  :+D  8#  9 yv  >   ?hH  >  BX  NZ#  Y]  e  ryy  {c  MH  ~n % s ( e|Z# % _ % ] + Jx| 1 * - H  2  =Z# ' .JI +z} %  "[YH !
8 # '$Z# ,@3 )	5j $,y $B  H  r 6 = !Z$ & )	 $tz E M ! $B Z$ b   y &} ';M !o } yZ$ ry #m m{ j0 gxM $bV X2 MijZ% G
l D 1!O !H x2y $M 6  #T.M !Y:%/  Zn!B Z fZ& \ a &dDz 3d_" 2dvM hn) sZ& 8o
 Gi" +dZy hh mۥM 2p* ?p` TmZ' skH  Hi <k*y o $  qMo eq jt\ ?|"Z' *!  '  Kcy  1I =6 3/ I&4Z( C! 2   %ly    aI 'i 2 8zZ) 9sc 7^ 2Iz (D $4|I  (=  1f 7Z) 9\ <b >x ?x :kI  .[f  'In +,Z* 5
" 5  3 y 6  ; 	fI 7  2 / 6~ 6Z* <w 0 9x '" 4 !x 2   / I / M 5  ; Z+ ; ~$ : t 8 _z : FJ <x .R4 @m 	 Ac[ >`UZ+ <`p 8^ 6WePy 9R: <P~4 >OT =Kv ;H!Z, @CkA LEB  [N"y  _S_  SR)4 @OB  /RT ,XVZ, 7^M- E`P6 Ndk2y   Lh(O  Gi"D4  Bg   Ad BdZ- Dg Go IvLy  Jz  C}x4  ;ri  ;f  @QZZ-  D; C! D۫y| EJ E4   G  NlZ 
 P?Z-  L'	 	 C5  ;:xz >?x CJ4  JQ 
 NNs  SG "Z.  RB, 
 R; 	 R.*zw  Q)6+  P
B3&  	 Pa)s  Q"  Q Z.  P  P  PJFzt  P  Op   P,  QV  VZ.  Z
  X   U Eyq  R x  R /   T	 % ! T  
         #"          $  '                                                                                 % R Z/ ! PC9  Nb  Nyn  JY  F"   G'K  J.  N5Z/   N<C # LD) ( JN>yk ) H[VH " Ckg(   ;|o5~  1x4.  .~*Z/  :v#@ , Kt  0 Ls yi ) AhJ ! =S   ?9B  <y  -RZ/  &p
 # 0H + 9%'Oyh . :L
 , 8|  S
 ) :  $ ;x  ! 6n z.Z0 ! /b Wv & )Y -V ( (Pzd ( (aH & *9t_
 & )# $ 'h $ &LRZ0 ' #mo , ${ . $yc . $ /  
 - S ( %n ' N4Z0 ' v5. , r 5, / v $yb 1 z ! 2 z  F
 / w# + 	t@ ) 
xSZ0 ( ~[ ( c ) dHza , 
a / 	]
 . 
V / K 0 y:oZ/ ,  u*3 'sh %gx` %X 'J
 *I  /J  /F Z/ .;  */  & ;z_ $	 | " h
 ! P@ # . & dZ/ (" (3H $5y` "-c #$
 &f! *M O *3Z. !]   
y_  j
 , . %Z. 	 ? ߝy` ) 0
 3 "8  )@#Z- *GC %LcC Ny_ V 
_
 bY c fZ- i !n4 rza p1 l6V
 q. }% !]Z,  l |5 ${y` !~$ 8
   :Z+  n  zb    	T
Y  
u  i 
 Z+      yc    
Y      7Z*     
 Wyd  "
D  #
Y  &0
  .6  30/Z)  7&  7! 	 : ye  = A,
Y  B  @  <Z)  <  7z  25yg  . 	 +	
Y  *	   -V   .bZ(  ( 	 $  ';xj 	 -  5f
Y < CG JZZ' S ` nwyj |   
H      .
Z& 6 1 'zm "  
H
Z%%,>1xo7=W
H?>
=Z$?<5yq6@
HIcJ(B5Z#;>GysLO1
HQR RPZ"S=Z+`6jxvf2yl(
Hoq"|dm ThZ"Cg5k5nyu9nW9g
H7`7\m9UZ!<M	>DE7xwJ&Mޞ
INZT =[ HZ \ ^ b yzh qg Ee
Ic +^ [ ZZXVkU{y~Tf)6R85
IU3V*Rw"ZI6 G Oi%yVvZ%
I[
`CjZtx5yv
^yy2}
r
Iܠ"ݟZ/6zx	5
IO:$Z3;5:*y1OB*t
H&54Z+s # . x ; & Ez
H I Kj QZ Vm X) Yx Tv Qq
H T Q QݚZ Yܸ ` ^x V W
H c2 q u9Z q sF |x  Q
H ! k #Z 3 5r ,y $M  
H  4  !Z   x B 
: ~ ~L xZ g T Ty ]L _
: N 6 )Z %]  y\
:    =Z 
   2vy6.
:%%!,   OZ 	 } x  
:  k  +   ;Z  L  o  x  j  }
:  %  Z Lo y 	 ||
: * 1* 1Z 1| 0w} !w 
 0
 u6j 3Q/i >H&Z >M!m :H a 3=Ay +3 (#8
 0
@ >  F Z C < =  = x| @  A 
 = {@ 6 p? , fZ & `$ ) U; 5 B^y{ A -V D "
 < A 5{ K 6x Z 8y  ;{ f =x !y{ <u 1  7w A	)
 2{ Q= 1x e. 1p ~6Z 4q 0 3z '" 6 !zz ;  w ? }
 : = /  % zZ "	 `
 ) A 4 #wyw : . 6=	 1	 /t -m_Z '	IK "O #xw *
 *U	 ,v( -UF /6Z / 3 =xu G1 H	 ? m 5x 2xiZ 5k, 8f6r ?J2 {t Q (B Rv%"+	 >a\  )I +3Z 9  > B18xs  K[ 
 Q	  KU ? 5S_Z 0  : ,  1ۘxq  A  N	  J %q  75 BF *F A Z "T 4 _ 1 d 1zo %h 0f ,o 1	  -x 8  +} A^  & O Z  X  a  r*Ozo !  6  & 3/	  + )  - "  -  Z  0   -  $ Dzn    j	  	 $       Z 	     	 #   $ xl   1    4	     
   
 
        $"          $ 
 '                                                                                   Z  % 8  '   & xj  & P  ' q	  & c?  # b   aZ 
  Z8   U   Qyi 
  M   K'	  
 I5g   B4>   A*Z   G#L   K   	 F yg   EN 
  G	   I@   J   FMZ   ?	   A  EPye  I
  N 	    L 	 7  Z 	 N  
<  yd    N	    jV  TZ  Y    xb  p  	    %  4kZ  
5"  ,!  #z`  
1  
 
] 4	  v  
   Z     {  8y`   !  	 !        Z   D  #R  %z_     	    )  7  BZ  J  O  [6x^  h  v	  };  z  |0Z " "S  3-  5y]  -  $	 ! !  &  O #~ Z  r b o  r x^ z   k	    (  * Z ! /  x  ߻y^  ۿ   	 $  +  +! Z "#  " 7  y_ %
  , 	 , S &   Z     " {y_ ' 1 & 6\	   .  %  !bZ (  l * 9 & x_  )  =	 $  (  'AZ !   @za W t	 " e " @ "{ Z $i t (c { *g yb 'j  "m |	  t y $  ( +Z (  %  $ @zd " 

 !  	 "  / " 6   02Z  x&  k! ! ] vxf % Nk ' C	 # 6m  ~ &e z Z !}  #z] !vxj  u w		 ~& b AZ z z nxm \] I=	 ?l 4 &&Z   Cxq   
+ 0  -Z 6 1k 'yt !  
+  o Z  $ yw  jD
+ N"x 1.
 
9Z  I 
Wj Zߢy| Om 8
+ M 
@ tZ 
  ~y J g
+ |s  8 	Z 
 
h+p K  6Ky 3/ 2 E 	(
+ 
^ "t z   
 
Z
    z R 
+ |    	t ( o i :Z
 ^ C& S E  L O 
y A `  2 m 
   l 5  o &  |7Z
  
      oy      T
         UZ      T   Hx   )     5
    3     *:   #
Z 	 
         )y 
 ) z 
 1   $
  5  :: 
 B Z  K   Q 2 	 U 
lz  Z [  i 
  !v ܤ  (} }  ( Z  $   #  $ 
 ) v x  ) i { 	 ' [ 
 	 , M  
 9 2 ( 	 D&   wZ 
 >1    28  %  *5 
x 	 -'   5 
 8&c  ?4 
 M4Z  [b+  bH#  VD y  EA   /  E%
  S  \q  Z Z
 
 T  o  P ,  Ph x  QZs z  UQZ 
  _J:   eH [ 	 cH  ݸZ
  [F ܫ 
 SK   OV y  Pa   Uj 
  ]n  +  _s    ^z 5Z
  Y    UF 	 Py  R   W P
  Y   Y+ :  \E #Z 
 ]X 3 
 ]u 5 
 Yz ,x 
 Xq $a  Xd  
 
 WU  6 
 WD  X.F %Z  Ym   Z   X z  T F  T   X    _ 2 ] 
 f F  Z 
 g) W   dC m   ^Y  z  ]n  2  c|    m    w    u  Z  n  X   f    e  y  a  	  ^  ` 	 Z    X    Y  5Z 
 b~  ! 
 pw  
   |q  2Xy  m  6  j  .8  ~i  %A  fk  !<  Mj  
 [Z 	 Sk n 
!  oq 8   x . y  h ^   H t   , M w 2 m    s Z j $" n I go y  Nk  ) ?F ۇ  L   f '  s Z  n" "  YJ  Ip 
	x F 
 H 	 E 	  F   B ) J C Z  P ^ " V r  Y  
y~ R  
 =  
0 # #  	6 )  / 
 @  &CZ o   !# y  } X% ]y} /L  R U   = [ )'  8" Z >! \"  ;#  	 -. y{ $6 I -"  >   @  W  2  Z  %  +"   Q   {zz   m      P    X    Z $  " !  l   yy         	
       
.  6Z z 0" l 'D  d !yw  ^    V  P L L 
 J Z  F 
! C  9 }xu / 8 - O
 3 
  7  : Z A Z! J 
; P 	xu Q 
 S Z
 V , X 
J" X Z W   P  A zt 3 8 + 
 !  l  ^  	3Z 
,  
6v 2!xs (b "9
w  W / Zy 	p i 	Eytax U; 
K 
hJ Ro Z Y  ^ 
 bN ۶yt k 
x@ 
 
s 
Rf Zu  @ 
xr nU 
 ~ f    
Z X   |  *%yr m 6
  3P
 
) 0 
" `  Z  	     	Nyq      q
z *y  w Z 	x  t l ,yo
j kt	 I
 ~   ~   
         %"          $  '                                                                                ~  Z  6    yo   M   
   D  
  Z  >      xn  "   '
  5d  4b   
*Z 
  
#h 
  	     zn   _   
 P 
  	 [Z      Xyl   
   
    /   Z  7  .   	xl   	 F
 
   L   Z   P       yk  b 
 |
 
 K  $ " 4LZ ) 5+    ,7  $xi       -
  r  b  HZ  +    x   4yj    
    '  . Z >B S T  
4 d H 
yj t a  f | O 	
 i !  5r  }n  |Z|t _ ;!yj Wg e
 E $  r 
ZK` " ?Q  2j35xk  - q  $
  c !
  |  :  N|# Z 6h  N <rxkcwhT
ZZZ 7L~ `8Z G$I!ayla'=ۣa1dm
@= J ~ G\zZ  q"    yn f  A p
Y  8N    Z   # y M   T%$yq  81g U"76F
b*J  .:-o  %X-!HZ, N$  1  n7yt  =  I'
  bV bb f0Z]c!%ie sh Pyv 
j ~ Wg 
 s`7 Q S\a 
 ,Vm 
ZTT b&UW& p> ] uyyf+` c h
 " p f t   Z re u' &Bg0 z~J(	OM
s   /  6 "  0;Z B &) 0 !]  ey' `i
 y
^- [  i C `x BZ D Ib ^*  kJ \  \/  y  >  
 <   	&
  [    9Z # + / Q 
w X { y Y  	W 8}7
 sej^f'Zec-b`Gx . D_  b Vc  
 l 4f   J d \-ZX6.^1fz'yg"g 
 g lzpZ]q0Bp+d;ox_Nt wj 	J
z9 
  | 
 . " 2Z 6 /1   4w)ߏx
  Z  
   O 3  	 D Z " ? 3 ' #   }x     "
   x     5    Z     5 , ! +A . M 6Iz " x R2  | W)
 _ m  " L [    Wz - Z  [g  6 ! C_ N  ( 1Z z y  AY V T SW  
 ,O & ? P m/ L Z 7 =8 ?   E5x (  
 f
  1Z 9     `x  &vF
 2` 1b g@Z X:	?',y( 
5
 $3 ,1*H 4@#Z =I ; IQ Y]  'y ki w k !
 g   e 
<  k 
Z 	 
s <  v 6 th 
z~ vM  z4
 gܸ \ k ^Z c= b W	y{ P3m OJ
 XYs ct imZ p> | yy v c{
 T$&# M+4 H4  4Z <G+? ,X# "_ yw b  ' d 	
 i 	 $j l /k Z :i l@ Cg ) Ef xt Jd { R_ 
 aa  kj 	 rn Z vf ܙ@ x\  rJ 
yr i1  d* 
 ]= . YU  ^}W 	8Z i|G A rz;K uv7yp rw1 ouU
 pq sn   wl#dZ }j3A fs5 hN,xm f+$~ _!
 X K yW hXGZ [VA PV KQxl JRC  c HR 
4 BQ   ;Q .PZeZ #:QhA  FT) &+Vyj 0T ! 9R 
4 CQ   KV   N\ Z Id YA ;h  .i  zj &im $lVY
4 &lY 'ny (q$Z #x @  ]   2;zh   6) $P .Q
4 * %N 5!9 E TZ V @ b  c2 xf ^F  YU 
4 Sa v Lg  Gk Z Co /@ Bn s Ao 6yf @h  8d y
4 +_  !Y  N Z > 
? #*  , xe 3  6 
4 5  . 	2 $ Z  ? 	f v < 
xf  
   0	  6  /  &MZ  !>   s  Zzd  !  'U	  +Y  /   /Z   (Y>      zd   m y $	 p  o Z r  wZ x  > |  K   {ye {  l  {  	 y  T y  b z  Z u  = "q  -u% yf 3y5   8{C 		 =zE  9u[ . "n 6Z n 1= 2uc 'q <{e !yf *}    	 z 
d |  
 Z ,=n  P yg  V 
Gp `	_j 
' @  ' Z " e=; /N 
yi 
   i	_ 2  7   P  Z    "=     yj   = 
  	_ 	 y  i  E   
Z  
,]= 	  	6y $ b 2Dym 3 E ( 2 4 "T	_ / +    + (   $ ' Z    =    
  Oxo ,  @ 	_ A 
j 
 * 	   
 Z  k = 
A  
 ۸yq   ( 		_  .s 
e , *U K = G Z - 7 > 
   yt  p   	_ #   0 { m , x  Z y) > y9 SvE)xwv`6y3t	G ) 
"   Z " > A   U  ayzX  Y 	G 	e 9 x  ' Z " !?   
 	  my     a	G 
   z 
         &"          $  '                                                                                  Z  5@ 
     x  E 
 	G ?  Z x8A  g   hx " n & p'k	G (t5T 'c  4y &F +Z #F #|B [   W  (x ; 	n $ 	G "` ( v,mZ `,)C M( =+uz 017 +9		` -Jg 3d^ 
8xZ Cw5D Rx;  a&z ,i #p 	Z	` t   v  `{  Z . 
dE  J 
  V y  > t 0 : 	|	` : w 
-   $   4CZ  b5FG ' j,[   $y     4  1	` 9  2 } 
    Z  I    :y      	` ,   /  G #  Z   pJ   (  y   R   	` 3   E q  O  4 yZ H  ; 
K / m     "y  h j  I 	` % 8 % -  | 5 
Z 6 !M *  	2   5{  - # 
$	 " 	! #  G /~  Z >  keN >v 5qx -@ .h	 1  3   0 Z + O )  -wz 8[ۦ @  / _	 @ 
 | 7   - Z % Q $  
" . ` x 8 ?  B   	 F 
 A J   L   Z P  R P 	  Q  z H  1P > 1 6Z	 @ H 
/
 H 	k % L  !]Z J  ^S N 	  4 W   z W  ( I 	 8	 = 	'  A <  M X <Z T x T Z   ^  y ] d  V  	 L a ^ I 
  L N 
Z P 	 
nU T 
	  U ( y S H 
 T j 
s	 R  
q M   I  	 Z F V 
V E !
  E  ${ G 
	 L v"	 P  / Q  	6 O #0 0nZ M "  &V L  ! M m  ~y L W y L  R  *	 M ^  M v 	w J  Z I 
 W F  n C  'z ? 7  A _ 	X	 H   P   P  MZ N  W N ' q M R y K y f H  	C	 E  m E 	  C  .Z E W H	  L' Ly~ L F I g 
$ @   8 I 8 -cZ >T 6W E 1 E 7'y{ @M b  " :   
$ 7l    5  2 Z 0 W 07 4"yy 7> :YS
$ 7l 2@y  
 )v vZ  
W  
ۇ  	 
~yv )! 
J -8 

$ -M T (Y  ^ Z ^ 
W a   b~ys ] #P!
$ )Dx += 0 !8rZ 0 W &+  6Fxp 2 #)/
$ ""    Z  W  / xn _ 
$   ( u 9Z J`W bt. bszm 
N <Y
Y + $ Z=Z  V    
  mzk    T
Y  r U n/ VLZ =V "   zh(5
Y4 *v #(Z V }=yg{~5
YKZVC   
ye    C  
Y g b Z ~Vx $s"ydrEppg
Ykue#`tZ_Vd!nybu{ J
t| %z 4z  4Z} +V #  yb
   .
t  t  Z
mV
(
xau
t3Z {VWza
t	$ZV@y`J
t#%Z3V5 -z` $ !
t ExBZ[ WW V 	y`A 	T 
      Z W [=- y_y8  8  
" 	 a ?ZIWnxa8 
u V
x    ! ZMX E 2xa 62 .r
X  %j!G aZ   X 
 & Sza +
  /Z FY 
  
 /xyc q v
 p  g  v 	Z  }Y    ye      
   ) Z  Z   _ 
yg k 0]
d6j{X/[ ,z )&`Z {![ 0 A    o 9L Yyi&  l W
- ] & 	U !  iZ G 8 $U\   ` zjX
^Gq [
9  
0  Sb | D 
WZ $  \  <   sym v ` b K 
  	H  U#  Z $ 9 2 	^  c r  ;  	xo (   w  
 I @  % 
.y  ? 6Z   "15_ G 3' * % !ys a  _
u   Z l 4` w  xv  T w

Z  B 
Z   wb v   yzr
Q> wT  o4Z 
f;,c \ Py| <P )
 4 { >"Z *,Ee  F(6   h#2wy  U#W( 7)"u
 #3  $=y >>FZ KCV  #f )N  V lx 4T '  nOH  
  JT^`Z (] h [ p j_S y "b  e 
 " +e  s  "dc 	a  Z 
` *j e Nh  x Q
m    m 
l #  
k  ~ C ]n :  Z @ ]q  
l t# 	'xA )x |  
6 7  3
 =  ) 7 
" ( W   Z K `   m B 5   bcy =  t
s U?8 t = % vZ b  #o N 0 
 2 ; "y / g  \t
 H s^ 
         '"          $  '                                                                                 Z 
 6q ? f
H S Hz P d
z? - s
 p ; 	   /Z  9t 	 e  1 w ~y T } { E Ot'5
  <p5D  rH[4 "-+0Z G#u w  
 x ,y 7 lu E h
 5 pf " 4  O{nZ  ex,w rs  o\vy  cWH % Ya5
 0 XR < \9m ? ^-Z / ax   c    h z  o   y J
 / {  G v P H m Z : i m^y 1 n X ( u D
x ! | n ' f
 6  ? ${ @ 46Z E 5hz H q, A T$Ay 4 !
 1  H
 6  7  6 Z B { P N L %Fy ? 	 ; 
 < ' 8 ~ : LZ A 
@ޖ| H 
& C z > Q G &"
 S 47 P >= F E:Z ? G+} ; L 8 Z)1y : i=x A r3
 I y3 K   L 
Z Q !} W 2 O t6y ? eq- 9 [@%
f = S!< J P d X M	Z a Jd} X I5 J Cz C 5 H (r
f O  T  S PZ J } C + C `%y I ۩ O GO
f I u B y< C o6Z N e^$} W cx* T iy N o F s '
f C p LW C b  B P
 Z > N  } : T   < S  y < G 1K 6 9	6
f 7 +/I @ *& > 8!Z 6 E
 } 9 ?t%[ > 'MDy 9 'KP 0 F[
f . C 0 .9 1 1< WZ 5 Y} 6 tu 6a{z ,Su % K_
E , 0D6m 6 8=& 3 ;LZ );ax} (6Z .3Hy 01/ ) 6#{
E   
<%}  >!  <1Z (A| 1J 5R 0yz 6\ 	 2e  
E n /r v ~6 
 p0Z  Z'| $ 5! #  xx ( &Q
E  h H!Z | 2 8Q?yu ,= 	
EHbZ 	| -k nys x @U
E }:(|CZ {  I   ]yq       
&v" rB"vV-IZ{f6z {w1 z(%yn s"3 i 
&ctfkk^ZlSz 	iPF aWykacfoi
&f~zY-KZOFzZhۜaUsyi ]M> S
P
&LXaG2TCKFZEd*zJ|NygJB)
&<
8 78{ cZ
=V XzF" *L 6JzeM 3
K )O
&Bg "8I  71 Z
> zL ?R
 sydK nl8 w$
&( }, x8 jZC _zB Z  hC QxcG CI :B
H 3D *
G  ;ZK {Q> UR eyb]Z f`P
fi\tV{KZZ|dfy`d(c_5
`4ce*gL#7Z
g5 |c aCy`dg;
iwfNQc%
Z	h}kFf
y`] ^~J
hVq5HpZ	mf~styai^]
dcy~hZo chyao#m[
8d%e4q5 Z+Q#w
 ydp .s	
8s
hU{ZZUxO
7J Uye[ v{ 
8khueU
6 Z Ly G{yguW
8Y"ZCoyjR;YGR
8~#"Z3?5an-FykTy$k]!"
8$C S'S#{NZ${,s{4yol=_D
8Qg_fZqjeudl7xp
Y|jZJEd}yslU
Yn83ZRoy^ (1yt {	=6CU.
Y uv%D Re	!OhyY `ZZ!`1 c_yw.`2 +z]
Yx_dHj>8kBZ3k_8s?~3yz? 0Kx
Y% Z* ' ' Kx|1 A /
YO KT 0,R ZO /M H]V H
vy~j R6{ \09
 R6 T/ X&sZ M! O p g\x q  aX
  SX  T  AZ  4S  x ! y   N
 3 N # XC  I.Z  +   3* 
 Fex   *Q .
 =3 C Z Z My Ly  6n
 ?Q C., 1 }6Z -d<1. T' sGO!z 7  F'!
  2[  
  8 Z	 \  i ly l= ie
 b
_ ^(g  WS#Z	  Bd  4 F1x pX Y
 y." QF m7  ?
Z Z
 Yk 
 {    y 
 {	%2 
 `	R
 \q ^ p Z  , ( q6v ! tw2x  p( `"p
 K   3  Z
  y  ~ Xy  (
 Av  V 5 p1 Z > xR2 ) .  z  5  d 
  K   D # 	 Z = v;  @ {  1  y   ^   
    ` 7 Z R  I q 3 }X)y ! fC5  SD3
  AS)  /I" "   Z *      3    =  py F  # C  
 1   @ !  }   !  mZ .  g- ?  s
; F  x >  { 2  \܄
 -  9ݾ 2  B 
         ("          $  '                                                                                 <  Z @  2 C   A  z < l 
5 > L 
 I . 6 N   E  Z 6 4 +   0  	]z @  
= S  &
 \  5* Y  4 O wl +IZ F b_ # E YG   F 'X  &y F 3X 
s D BB 	
 I H d S H 	 W > 
kZ P 0q & G V  G " tz H  W E b H  V m~ _ *Z X  J  C $_  y I ( O +I M .{ H .BT C .Z G 2f S 5  ^ 7  z a 9}  w \ Bk _ O On 
 F Y 
$H F f 4"Z N u5z S=, S$Ty L* ! F
  O H >6  Q t  0 X # Z V   S #  X .. Zy c 4[o f 2* ` 1S U 5& P =4A Z K E`o  E K{5 F Owx J P]Z M SD   L U2  M [# S   W x\ eZ ` V C \ L , M H LCz 8 M { 2 nT
    @ UV3 E V ;Sg  b 0M 
Z a 9G   ! Y ZB   2 Q r>   6z G w= .	 ? n>-  %+ < i8S  !G A e+   k O \  Z  _ L
   g IO   e X   z T o   =  }  } &  j# "  Y - n VZ! > B Z   M e `  l Z < qGz d $ m۝ a 0Z >- S R ^ C q 5 zNZ" - p 1 Z-! A ?y} Q )  Y    S %QP E 71 7 P2Z" 0 iQ 0 o|h 7 Zyz ? 5z1 G s6 Mo/Z Nn;& Kzc!~Z# B w ,O yv  D ! L J c3 eKzKZ# Pa, 2 yt 
H 
l K\ /+E CTObZ$ IuXc Ac /mkw{xp q' 
j 
@m  +  %Z$ .G    '+  ^ ym   	 z  /? 46 F 0Z$ V  '" e! r yj  '  _U 
z q  o   | (Z$      Eyi 	 H  	 &- 2 )K 2 !jcZ%  !R .zg -r 2L 4:r ;? <9:Z% C+ 
U jZyd } x	 
 m
  e  \  -Z% O6 
Iz 1 Vh (4yc `P "5 U:  
 K) W
   p Z$ {  v C vb ya P  P Z
b nm 8 	+f Z$ #C f  	 ے E Gx^ I|  .D 
# P5 r@ Z$7  
+  
% qz]H { 
 k   6Z#C
Z!*X+6-y\1J35)`
 0" vZ#(k <s y\_ hO3 !
AG  *a z=Z#@>q xY (7
o X @LZ"4 E i lyY  |]
 oc l0 l]Z" a  H .~zY #(:# $5
+  47/ *, #JZ!  UxYK
"^(Z!
[
zZ E 

BSZ tvfj&QxZFuiR`	
e^qsv#ztZ |#y[rW
jw%+45Z,# z\ <
   Z!3?Fy_`{
  7  F @ 2Z * &m , 'y_{ N e
 f 
 w ,  Z  ~ >W ya% s F
. t  "Z C 3` u 5 5 h \ -Xyd  G $ !"
fs  V?+ K( ]Z[   + yf 2 m 
w  }   Z<} %ߔ   yj b |  |  
j V        8$ Zf: JcvB 	R; zm~9  UZ
j 6 '} ! <z SZ3 PI3 @mD1ynutU6Od.
j &j% [ S!X ^ U# jZ 6 k - F
H  yqw 2[w 
j]X  46Z   d  &# xu9Y q
j=O qCM m Z     S yv # Y k  2 c
j   hv r5hl Zgb ] vY \ `
Vyy -X G <Q Q0
3 ,M u6 R h0` :&Z1`g E!7_ c  .wN =ny|@    ;6 n
3  <= ;l ! !S ; % r Z  j %y x n 
3 !F 0 .
6 R  %D & Z f ; Z3 m syUc" _ \DX- I 
3^n= 7 ;J   L RZ  GMi  I<@a $ By    
3r 	$ .b 6Z ] 1[ `'  N!y+? 1H
3]5P  v3<F ,ID ZNT> 4^  f y NkV Pq	 4s
 xeZ{ y , 7#j	 22 "A6  ZjF  XQggy~= |	 :x ^ R P`Z 9+ 6p A 2y Q ( X "}	 @j  W  cZ a& O 1fy -" <	 ? (> =AZ LHx KS @^ y 4g ޿ -h  }	 ,c  X 3S  \ DA  Z ]3    y)  !  y   w 		 d Fp 4  Z -   /  4 )fx 7 	5 9 3	 : * 7 # 1  Z 4   D , ^ xz z (  	  E    Z w 6 d 
U T  y O Y R 
  ܛ	 Y  ݳ ^ ' / 
         )"          $  '                                                                                 ` 9  Z d B  6 h J  l P x s U 3  ] 	  o 7 
 |    Z 
 
  4        Ly       &	 x  5 j  4 p j +eZ  A #  #    +z }  { p  	 p' l w)|]  |g nZ H + +v  % xy   j  T 	    
  n ݘ (5L Z 7B  {;;  w/. z x-:  w9 K	 |9     W Z h t hy} fx  nC P	  |     $ #   4Z *  3 5 '  ] , %   $dy|  "  !  /   P	  ;   K' 8  Z9 Z  bZ   ci   iY ax{  wO  
 t_ 	  Wx ^ Jw    Y\Z  t@  7"  5 xz ( 4 ? ( 2 	  %   |	   v  Z  m    e   c :zx  _   M	  5!:  (  m #  
`Z   !B    2    6-yw /  .'  ? Y %>	x ! ; B!I * B h ' lJZ  y  D% 8$yu       	x   =, , ) Ql  - = 
%Z , u {  &p   s  txsxH ۟}R 	x   Q  :  3 Z  Z A Uy*   7 #q * r  xq *  uO  / ?{* 	x # ~ D y   m Z . .e  1 j 3 0q Myp 6 m 0 4 d 6|	x  ] /jW 	&Q !pZ
N<  fO C 
M ym % H\  > 0FxH	x -H -K +BtJZ 3i  
 'p l yl P  #/  ?	e #&%W '#"   IZ 	# Y,  z7  syk >  C Z	e O ` c  &u Z 1 xw 6 x 1 cyi ' E	P    1q	e  
 / $ 
 6 5   0Z	 @'%  @! -  xh  ' H	e   &Z	 +  ,} (7xh &SC .		e 9 b 6 V  \Z o . xg F Jm h tB	e d !Uf 7}> J0Z . 	Lyg9 # 	v PT+ L@ . %,Z  n{6 
 y_2Bt8(Hyh  l""; 6 `c 	v K ] 7`? "JhBZ 0Ul  =h/H 
 ,fHyhi!rd	v &u _t` YvV,Z !   ۢY6yj ~ 1|	v 1 P  )  ZZ 1 Y  T  X Z vyk 3  	v p    $   Z :  *y* j 6)zm i 32q )|  	v {" #%  )Z   #E /  yo I o $H'	v +ZR  
{I k)yp g&4dH	]YZ= \7Z '_(  "`H 	fMNyrk<m/=	 q+ }, 29Z 1   3 ;.xt A' "E5v	 @46)  * #GZ    # /   4 Kyv -   C	  O Z  D & * N  
yx   d 
&  	 #      _Z    E (  yx   Q 
 	 
  [    | aZ  w  , r   _ xz 	 I   B 
 J %J} J 4 w D 5$Z  t H , . s O 
$ v O  yyy P  <{ U 
 w [  
t \  u \ Z  
y \  1 	 f @  z y{      
         <Z  
  b 4      x| !     
 	      
  	$Z    
 7   
C   x{     J
 

   _  "Z  	 3P 9 ) 5 3 -y} 
6 $ 8 !/
 
8  _ :  
; iZ  ;  < 
=  ? y| B n 
@ 
 ;  2  / Z  
, V > ( ߪ $ y|   	  

  
   	   Z   > @ 
   
  x}      	R
  m   T   @ 	Z  ,  B     
1x}  6Q  .
  % y 	!X ]  eZ L / E 9  % y}  4 
 

  	 " 5 2 Z "@ n G (M 	 *c ,y} &  Z 
h
 
 R    zZ  ~ H     &  x~ (   % {
    
,  
Z  	 J  	G z 
(y X   
/
 ! 6  0*  	&Z j ! L    $ ty u  " 	r
 ) m     M 
Z J h N  "  y v   
 | 
T l 
L  ` 
Z !Z\  O U% %  H 
oy  	= U  
F: 
  
Y /  e  	?  a 
Z ! W 
 P   W> X   ^ y  `    \P X
  \   e 
-  q 6Z  w 1k R  { '   !x       
   o      Z  
 " S   	 "  y   
@   s=  	 
  	i   T }Z  	@ j T  , ߴ  | 	y  { 
   Q=  	    
!  	 Z    T  s   c y  K 
*  , =   
 G      Z	   + U   6Z   2y  s (  _ 
"u=  E    #    Z
 "   V       Xy     { =  a v  B   ! Z    W      %   x ( #  ޘ & ! ` P= $  . 7     E   Z    W  B    
y "  
f & ? 	= " 
 
   b  " Z   
k X  p l  $1 )%x  ( 	5 ! ) 3t $ ! 	*& %  	" !   Z
  $  Y  '|    %pE pz   `v 
  H 
t  . 5     K Z   
& Z   
Y   7y   z  K ܙt  !y ݉  # 	 
         *"          $  '                                                                                  $ 
Z  % 
" Z   % 
  %9 
yy  $a 	  # 
~t  ! (  # 	v  ! Z   $ $ Z   I   " m (y  .    6  &}t  7  4  ; 4  BD +sZ  Hq # [  I    G  z  E q  I  t  M  [  
Q8 	  VO 
[Z  Xg 
 [  Y~   ^ fz  _g   [ 
Y- 
\ݜ  _ܫZ  ]   \  Z   X y 	 Z   [ , 
 Y   \ 7  [ Z 	 X K \  T    Uy 	YS  X   	X Y  Y  #  \3Z  ^5| \  _,  as  $Wx  fi    l`  7   oW 
  qM 	*  m? Z  k5  \  j+ 	 m Sy  o  
q  m e  j   r Z   } \  	  Uy }e   |I   }. |  z   gZ ~  ]  s y}  Lg 

 $    	 @   
Z   ] j2k  Y6y{  S.%   Y%3 i!2   Q Z  ]    < yy   _      u            Z  	  . ]      
 zw   ہ       &   "    ( wZ  %,  ]  .)  .'yv 
 (( 
  !    7   	    	Z    ]     	   yr 
   0    6    / 
    &0    !Z     n ] 
 #  N  &   yr  # E    O  ! s    " h      ^  KZ    U ^  " J 	 # A #yp 
 $ ;   $ 7 Ys  & 0 C 
 ( -   ) + 	 Z  ) ' @ ^  * # =d 	 +  O]xo  -  U 	 -  UGs  +  OO  * G  , ?Z  , @f ^  - H  , R wm  - Y	!  . [/s  0 X.  1 M6  2| @0Z  1h 4'7 ^  .R .! -? 1 zk  -. 0  / #Ns  .   +  +Z  . _  0   0 ?zj   , R   , 	s  -    0   0 `Z   ,{ T _ 'f 	 (E yh '* f  ' 6s  # T  #    & "Z  )  `  '   &
 
Azh  ( 
  +  x,  + x  ( \  )k ,Z  '#N 
6 `  '(< 	2 )-6 ([yf *35 
">  )81 
 ,  '9+   '3" 	  *+ 
Z +  a * :   ' zf  )v   / 
U,  2 
  2+" n   0? VZ  .<M  b  0 ۝ 	 1yf 
 2   1i
 n,  1H H  02  
 /-   Z 	 -6  b  .Ad   .I rwc  ,P   +V ,  -]X l 	 /e 
   2n Z  0n   c  /f > *I 
 ,c ^ 6yc  ,i } 3H  .r  ), 
 0s  	"  .q    	 *o Z  'q d 	 'r#R 	 's6zc  (vI  x  'u\ 1, 	 %wn  	 $~   &Z 	 ) e  (  
  ' Ixb  % 9  ! 
  "   #   $ 0Z  #  f  #   # Hxb 	 "   # ?
  "    !   :Z  ! g      !yc !' !5\
   4D  * #KZ   g  
    Hzc       =
    I Z    h J   
xc    
   <Z 4 i   
  xe   H   
   P    WZ   j   {  kyh v lk
 _$ S4W N5 Z J,# j C# 4 yi % % 
   } Z  o k  *  xl    
          >Z  6 k    cyn      
         Z    k   "   	kxq     &
   
  
  "+Z  3 l  5  -zs  $  !
   F 	   XZ     l      yu    c    
 
        BZ 
    l   
   ۺyy 
     
z    
   
  Z   . m    }y| 
 t  hD
z 	 Z  L  =Z  ,  m 
  M   1w} 6K .
z 
%   !Q   [Z  * m    
y o0 ]
z I 35 Z v m 	 C  cy  x  W
z  	(   	 bZ 	n n x y n 
l
z c A $Z  n 5 w	x hu \C/
E R"6 M0B J&Z @! n 4 | /ry 2 >u
E Go I  JRZ Le nK!NwW	eC
Ep3xs[Dq  Zs  ny } Zx =  o
E?\0|Z nNy    4
E   $ - 8 6Z N 1 n _ ' i "z t      
E  x    Z  + n    y  L  	  
    Z  	u n  
ߜ  	gy  
  M	    
  Z   n w  u y r # j |	 ]  <  S   H 
Z  ; +_ m 1 6K ) 2x~  (  "t	        Z &  m  8q CJ Sx~@ 0 	 l Y   2Z   m 7 	  y W {   3	  *  @  Z Z  m  x ^ x~   Y h	     T d Z
  F l 
 . 
 " (y~  Z 5   3	   *?   #
   Z
 
7   l T * p wy|  $  	  ; 
 	 
 Z , l 
n  jy|   " 	ܧ	 + 
o 5 
 
         +"          $  '                                                                                 9 
Z 
8  l 
4  / iy| )      m	    g  Z  l    y|    &3	  
4  4 u +Z h# k Y  H y{ 4q 	 _   
 `Z
   k    ]  iyz  1y   	} ^   ݫ &b ܏Z
 %, k   yz 	   	}    % Z	 > j U  yz  	L   

	}  i 
( y  # j  3Z	 c# 5 j ]U , T~ $ryz O !
  H 	 D	} D  C 4 E Z	 G   i I   E  Ry{ @  >	} ?m =< >>Z D i 	I H4x| G
 H	} P U \bZ h i 	s xy{ {d 
w	} i ^5 TZ H  i 62S 6*{{ 
.L  %M	u ' !? *  [ % Z    h  	%    * y{ -    
.  }	u , v $ 
+ l  
( _  3Z   Lc h   
 8    (y|   ۈ !   	u      
 Z    h  _   	9 y|  
   	u  9 
{  D Z ' 	 g   5 	
  > y}   
> 0 7P 6	u 3 / 2 &@ 3 !Z 
0 	 n g (o P 	k y~ u I 	 M	u    ] KZ  g + Hxo  	 
? j  D Zh 1 g \ Lx 
 4	 >  ZY g   y  	 . 
6 0Z '; f ! 	 ry } >	  ~ Z}  fv on 
&xh Ad 		a   b `   PZV  * fL   G 0 yE ? 	SE L #	> U =; ] ; l ZB  	 fG  L  	0yN  U  
 `	_  In  
|  	,mZ  6v f  	2-  (ly  ">   	      Z
   g  <
  y    [	      Z   g  ۪  y  k  e	Y  IH  ?  Z<   g=  ?  jyB | D o 	J b \W T   e H Zr D ^ g| @ *	 6 6y % 3P  )	 "   Z	  g F y h "	   Z	  gm !C^ y] Q\ 	U F : .Z
4  h5 < @zJ \ 9	k } z 5Zz  h| } zx  '|w & 5P	z E 4] ] * q #eZ     h   "  Zz+  6  L	D  O  TR
 ZS  iV- T[C y^W  ]h %	Yz 0R K "Z
C $ i< 7 y~0 >& 	 	C
 
 KZ
  i 
  
dz}  
u   	;
)  
 $   	4H   
56Z   ,C j   $
    x{ 
   -  z 
)    j   "^    [ Z  Y w k  S 3  C z{   1  
 $ 
) 
 !  *  " " 	 &
 !^Z 
 ' !- k  )     +  !^x{  ,  !  +  "
)  %  #  # s   
 % ^ Z  % S   k  ) K "&  + D &nyz  1 4 )  5  +'
)  7  %  6 
  5 !Z  : 2 k  F 5 ! G -y{  8 $  /m !
)  4]  F  ;T 
  6G `Z  36  l  <)    H2 "yy  HD e  =S 
)  9^  ! Ag  ) Np jZ / W}  l 0 W 
 0 T 	۪yy / Q k ( O 
\ & Q  ) R  . T Z 1 V 
 l 0 Y  - Z yy ) X ! * U '9
\ - X # 5 [  : ^ Z ; `  l 9 _   5 Z 1[yx 1 U 6O 0 Q .
\ 4 R % 9 V !N ; ]  TZ : ay & l ; dl  ; da zw 7 ^[ + 3 YQ 
\ 5 V>  : S- - ? S! Z B X w m = ` b 5 c xv 2 a  3 X R
\ 6 N 
 9 J   = N ^Z ? Vz n m ; [` 
s 8 ]J 
xu 5 W9 e 2 R+ 	c
\ 3 P 	 5 Q 
 5 M 
vZ ; J  m ? J " A O 	xs @ Y C < ] /
w 7 \\ 6 / ^K  0] * bC &Z . `7" 
! m 8 Z%3  } B SE !tys G P
Z  $ E Lv y
w < M m 1 S$  - ^4 Z / bA a m 9 \O  B Wi xr I O 	? K I& }
w H D +  A E' "J : I  Z : O } m A O   G N !dyp H P %B C Vt )p
w > TX , : OD (,   = H5 Z C FZ  l G I1 H G L
 yo D O 	  ? R 
w > S c > V -w > X 6Z @ V 	1 l F Q ' I M' "
yn I Mh 	  F P 

w C V	 } L g  d  Z   . l  ^    
zl  f P T I 
x  If 
 / P 5 Z > P# z l  r# ߁   
Myl h   2 " L
x   0-  
7 5 9 M Z= [  l  6C b t k D g yj  B ^ 
B W k
x #C   ' ` G  w "H  	ZG  +$ kLG  
6:nN  
2yiW: ) Y =YZ "}
x  T0    P 
 # 7S Za' 
 kKp& Un{. 	RygJ  GM 
x    q %   b  IZ <   j 6  J aX yfq ZZ 
x 3)  r G 1  G Z  s  i Z V 
b   zg   F  
x   > n ; Z    
 i     ~,  (ze S  5 <   3
l . U *R %# '   Z 	  h    ' - 6$ vxe ( W8+ 	 NEP}
l 
KX6GFFC.  ZE,  + gBL<
}QCyf  Y5 9 T^ܫ
l E o^L / [X  
         ,"          $  '                                                                                  +Q dZN    fJ   |FTyg;+ \
l       V  Z   f   t^  xhG  Nj j %
l +4  24 G +Z ` # e N |   L   yk $ 0~ m _
le i 
r  2  gZ @ F u# d . Y C  : -uym 2~ <
`}x ,h} z܈Zi d 	  ' . yp ) A    
`!|  Zy8 cxr D
`m#>Yzh 3ZCG{  5 bR)  -1$|ytTS!~ <
`2Z bQExx1F9
` ^q *^  lZ
 $ b Y yzK  a
`i 0CZ # ae 
y| L3
`WE
R lZ 1 g a "Q  2'3 6+y 
* ._k1	 %[
YJ4% !CQ.@  ]t&T Z!i 
 a  
 $x 
 " 
Y9 +}] 
s AZ(  ad1 Z a1 y ; ~  
Y@} 	lc uZp ZgI  a{q< q3 y0 x	- 0 
Ya0 c 
;t8 9 K Zh x a 
 :  z 0y u 6
Y Jg / A &S  !Z	!   l a S x   P  T
Y     6 	 
	 t TZ    a N :    ux f  4 & 
X" E   Y 3 h Z   7 a 8 j  V{ %     4 ~ ;
X   G) 
 Z   ` a   '  yG  
X  
.p  	6  0ZvQ 'T a !   uy 
  * E
X ?  @    
 & Z  a v 7  -x  b K ,F 

X    0 29 MZ  `	 	 a p  Gk y 7` P   
X   ] 5 UN g  Z    a/ 3  &zl y b  Q
o (7  q,2Z IZ 6a a e 2<ML (~yC"Aj: 	 
o+D  8!  ?>Z  ` g >  w y= dP ^
o.v ZJ+ cZ u^} - `k/A 	۶ 4 z Z
oY G  Z _  [<ey 	Tk
o ; ` )	   qb  Z_:( - _ ^ )  5y t 	 B3s G R)
o +  " d      Z    _ o 
l u   !yK= z<!A B
o 2 	 <UA  w N   &Z ~ [  
 ^ w f  S w z  u 5 
 & dd } =    R?  LZ 1  ^ 
 l  . u Xy &!  }R
%   !   A
 KZ   !,  ] O   (l  z  'Y   5S
  4 +% E@ #Z /   ] U   . L 
Msy B V +d
 , Y B A ,^ l # 'k-(Z !| ] -q  :8y 0 F B Fw
 9 #b  	 
&Z  .6 \ 3 -# G  y I   X K < 
 J }v a B    8 k hZ 2 F  \ / D} 	 " `1 	sy  i0 r  ;} 
 # $ ? 4; J H5SZ 8 45,p \  &a$0  v   z  rP  @ * =&
 %   -'Zm   [ ! V  M A K  y} JG =='
 +4 o ! 
7  6  @  ޒZ D9 Z B   > _y{  /F v   Q  
 ^  	 f   %h  Z (f  	 Z  d  / j zx{ /x  I  }7
 Q 2  B % 
 0  !Z + / 2 Y 3 Q ^6 : ^ T-zy 7 N h% & 0 !3
    \  % z  + .2 x xZ ; )I  X D '[  C 5f yx : Jn t 5 Rr ~
 7 Fr  C $p  J g Z D [ ] W 3 "I V ) '; P۫yv - *2 BY 8 &+ I|
 @ -# F @ I % : Z Z 7 K <* W 6 1% G 7 &2 9{t 3 : > ( A CJ
 J . $]  3zZ =  V 9 " /  1Ryr 0 6o > Pb/$
 B V% 6 " !j 6  jZ D >p< U F Dr 9 ,zp 3 
: ? )
 C < 1 %>  .Z "  S C B Z V oym Y B& I <,~\
 < Z! 5 ` 2 /
kZ : ~ R Q ; f eyj b gs N Sq
 9 L 0 U" 7 bZ A ` Q P [1' ] Wr	yh ] I P /@/}
 : 6 - 
0 0 %&Z ? c! O N   R yf H &A 7 ' !
 ' & Q & ) f 8 5 ]Z O ? P N Z = [: S ) z1yc @  	z 0 
 *  .  ua 3 
 {Z 2 
 s L 0   -  oyb +  K )  t
 * 	  -  7 <  Z E )  K F % N =  x` 9    : # {
 = 9 e/ 7 A h-Q 0 @ i6Z - E U1 I 2 B M( 5 4 c"z_ 8   p  9  ]
 <  I <  G 4  OZ 1 
 W4 G 5  ^ 8  Xx^ 9  JR 9 1 @
 3 < H ' 6 Z  ) dZ #   cۅ E 0  cm 8 
 n9y] ; v < jK
 7 X	 +	 U  hZ 
 { D  rs  Uz\  :  3i
  1 ! 	 *[  ^Z  * B  64  2x] ). "
 
   Z 1 A    bx^
 |{ h 	fmZ mC ? p d
y_ 	YM Z
dd6\Z  a > 
|Z y`  C
  AZ  <  &(vyb 75 L3
s c*y p#( u Z z  ; @ xc 5 
s I   Z @ 9 
 yf ( 
s |P c 
         -"          $  '                                                                                 JmZ 3 8q Qeyh83k
s:CiFg  Z<Q   708}$zk#%
s44+Z# 6	    +yo)!7
s S {#v 	* 	sZ1 
. 5; H xqO N  
T
TL = 	T t d  
Zs  
U 4w 	y 
yt G 
Tt ] )7 
Z8 @ 3N[yvfFv
T#	3Z
5 2-$xz! <
T7Z
 2Kx|
TxvrZ_< 2SQy~J4
T    BZ  1  y  K z
T O  * ~Z # 11v6(yG.p%a
<
!8 Q#lZ4A 1K`ygf:z
<a 
d[g:Zd 1^]}TyF_0r
<  tQmZxQ 1Qo7~x#t
<8"Z  Z[ 1  
 e  Qx 0F6
</]&`?!Z i 1 S ( ay 0 R 'g T
< #   0: = SZB 
 2D   C+ 	y FK j PZ 
$ 
Z^E []? Y[Z TV 0 2XO h[N Vx_N  
_A 
7
$ !`, B (^  Z& Z 
\1 Y 2b+ e  xc b l
$X  .? Q 6 O 1Z !U 'o 2 X ! Y   {y Ye 
]KT
$ `2  _ 
 *] Z PY  2 ~\ 
 aB 7y pbJY  `
D
$  ^< Kaw  f UZ k  2 k j  Cj yq A Ik % 
$  H - . q x Z | U  2/ V  I ^&z `{ \  N
 V  T  Y ,Z e 6^ 2 m 2V  c 
(z J "O   8 
 
 8  K}  \s  Z O 
 2  9
| 	F -e 	y 1U  8
M 
a
 81 	 9  8 
Z
 9 
^ 1 L  ۾ c  y ]l   IA   O
 J( D V! g  U. Z Z
 KE Y  1 K\ B  Ln $ `y C    I
 c[ pe azZ
 Xf 0 i) 
 5x  x3 ?)
 "   'Z Z   0    [  Zy Ht s  -
      s Z  u$ 
 /  q]  UEy  +&p   `C
 =8
 H x 	  'Z z   . ( L C  4 9 +y + Kz   ^_ +
 `W y [c(  Y~ %Z W  - S) \ LO Ny  El '  A
 5%
  D 4~  R, +%  g; #tZ uI   + sX    m_ Yx  l^   m_ F
  hg    _t .J  ` 4Z   i 8  )   k X K  j  "y  m    q   
  q  N  n  
 # j  Z ! c  (  c   h {~ m 0 f  
  [ 	>  W   [ MZ  a	  '  h 	  j \y}  g  L  _  	  ]  
$F  ^  
4  ] ~ 
5LZ  V c ,q %  L G 	$&  C & 
 z|  B  .  D 	 
 L 	  SY   W= Z  V=  $   V^ ; # [ yy $ `  # ^ 3 %	  [    Sz  ]  Pw= 
ޙZ  Sxm  "  Y} 
  [ 
9zw  X  & W 	 ( \ $ bi  g Z  e     [   ' R ^zu - R   ' Y	   `[  `
~  ^!qZ   _2  $ `5   ^-ys  Z$  W!#	 & Z K . W . S nZ * L    $ Cv  # 9l xq  4V 	i   =$ 		 " H    G    A  Z  I  G  ) U  
4 1 T n 
ۦyn 0 E i 	@ ) : M k	 $ :  % = % 3Z ( +    / 1  2 >z yk - Bq   ' ;l I	 # 8Y  % ;M  & ;S Z ( <bw  0 @s : A1'yj = =6p < 5/=	 6 0% - 0!p # 1  mZ   1 * F  % 4q ?  / <e M  =zg 7 Ca [H ; @] f	 : 6Q e 4 *B XF , 6 ? Z ) ,    + & 2 &xe 7  * 9 *S	 9 $ 3 g , `Z & !y  ( &y 0 $0zc ? )=k J #Kl	 I S > V  5 [Z -c  )j *m	ya 0o 8v/E	 ;|| 6 8{j 0 1zU &Z '|@ !  %1 y .%yy_ :. F	 Mt L  C Z 8 wj 
 6f$ :T%y^ =G	 ;E	 :K <RI =[Z :gJ  ;{ @  \y] D 5 EZ	 C ;x$ 1  mZ 3  ` 
 9NA B:z] C  =	 3 .- 46Z ?z1  EY( D1""y[ A  >	 = 7  4 
Z 4	 
4  9	  <:x\ =yQ <	y	 9n  6] 5K4DZ 49C ۆ  3-@M 1&9z[ 0%9  5(= E	 8,I 
 91R   6:NZ 0BK  ,EZo (Cmy\ *En 3S^h	 <hR  =xU< :_$Z 7d*   0d6% %d2w\ a)= a"	 (d  1l 5nZ
 3q 0  *Rx\ %	 #	 %j '   ( qZ
 ( 
` ( 	 % 	y_ G  k 	   %C " *Z .j 	 *^ &I 'X Dya $	 k9 "2 	    5  Z 

  m/ v   G (5xa "\ 5 y4	 
* B#& z Z     $ 9 "V xd 
 0  
	 P @  Z
 ): ?
 &Bo  yf 1Ae R 9;h 	 ;'^ . ,>  
         ."          $  '                                                                                   VZ	m!  ; Wyg     3
_	 5  f  a 6  Z y~vzh j 2	%	 54 F4 =+Z #x4 ~VH .yjf7Od$N	 |X q tZ / x}yla\{

f} 
jZ "  4 '{   gxn `g


pk]Z &T; -L 7Qyp :XE ;[

BPIB  "G=  3oZE?  5G> -A J9 $xr N1  ! S'   G

 U  V  GSZO(O/P-UyuR+ P& 

N"N+O>ZQHcO=O)yvW^

^~VM7ZHD 8 yy(
G

 VZ& ( 1) 62x{2.B%q
HO!<X  Oc Zu   y}  {
HF ! _ =HZ  x\xi
HJ( j eZu vfXhoyN1dE
H2uUZ=
H tzA0#6z
H/
&io!Z  ^ME%x]ML
H
\KZNy  
h&5  >NHqZ! ; a S Jx 
  
  *
h
  9  4 Z @	  	T W 
 F 5 y K3
F	G
Q	` 7
h Y 	. a 6  e19Zif'pg! + y> x ?w1lY_
hz gV /p e +	~Zn 
 $     ;z b  
e
h  u   + 8 z 
YZ| >  
z +      x   G  
h   !      Z C  | D      yl  rz    B
`      d    +Z  6V ( 2q ) (xd  "Xn3 
` 0   `  C   Z     A ,  	x L   A  [
` $        3Z %   "   "  ާy /  c ?  4
` <  1 -   (  
Z 4  s >   9  My 0   1  
` 7  J 4   0  Z 3   <  )g ;  5y /  
3 &  
)
` -  	" 5    9  Z >  
 C  Z D  	y ?  p ?  )
` G S 
 Q .  S  Z S  
* T  U z X w U ݢ
< M ! L  L} Z N  Q q \ y i r o 
< g j \ )  [ S Z c v  i  8 m  x p& pM4
< g4z ] +) ] #lZ ` 
  a  ]2 Iy W9  T9 :
< U9  Y5 > _% Z d 
 \J W2z YM _
< fb gvܭ cgZ ]Y Z@ ^!x ` [ 
< U ! Q  R  /Z V ~ y ^ P  d )  >y g 
" j	 p# r3 w^5TZ |$, $-  y~  # @	 y y }BZ  k  [(  y} .~ 	  v | kuޝZ e  l oW  xyz    v	    {8N  vsZ  joP 	 at 
 `yGyx 	 ir0 
 |g	 
 ]%9  Z
A 	 S!&Z 
 |I2  mB5  dCe-yw 
 \ H$  [FB!	  `C /  k=  t;jZZ  u9  v: "   r= u zt  iA  R  _ A! 	  [*?f  \4<  f;:Z  rD>c  xMH6  tVO*zyr  nXR> ! i\SN7	 " f^W` " b^_kr " aTbiZ $ cM`b $ iB_Z ' l9aQxp ' n)lD ( pt1+	 + rx * pz * m Z ) i / ( g R & h 0xn ( i6Z , i/<	 - di  % . aL!T 0 a& MZ . f) . i    1 h  $ym 8 e,  0 < gH { 	 8 ga Q  4 hz , 1 2 j  Z 6 i  9 h  9 d Hym : d  8 b A	 7 \  5 Sz 
@ 8 Je  FZ : GM / g : J2 J a 8 L e yj 9 K
 ~ M 9 E  O	 7 D   5 A  	 0 <  aZ 0 :   2 7x    2 4`
 	Lyl 4 3I y 2 034 .	p . -K6 . *]0 4 -n &Z < . ! @ *  g ; & iyj 6     2   s	p 3 b 6  9 Z 7 H U 1 y  , zl - 	 4 	p :  <% 7 KZ 2 
 1 	 /  8ym - 2 5	p ;~  @R  <& zZ 6  <x  Ee vyo FU  d 8 F 	p % 8   (, )6jZ G@ 1 YX ( PN "yp ;1  ~ 0
  	p 3   7    -   Z '  ~ * ( d   7 G yp J @ H Wv @ 	a Ux 9 6 ? $ $"  sZ 0  ۍ (6 2 9> xs B{H v BJ C	a :G  /Hz  'Jl Z &L_  #KY d Cb 	yt 4s  '}[	a +!  6  ;_ Z 9N 
* 4R 6 7` 3zu ?o )X ? "	a 0      Z S 0 9 
 G 
Zyx <  5e 	a  5L t#E  J Z ) 9 L" ^{3 xy XBy  J  		a =>:  -p / g Z:E 
 84 Q 1h 	xz Y~ = XY- 	a :?y5   rl 9 VN 
Z@ 	9/` F'(T  (y{ & 5v a)U 4#	 zA. * e<[9 #9 L=fIn  Z 6d`c= 	 KIk@%y~S. 	:-	 ';: 8#z LJnmZ Xr5 0}
f 2y\2  	   ` 
         /"          $  '                                                                                 + =Z Cp    _  nD Ey To  } N	]{ zT M : !Z 0.X $ Y* (f i)| ,w X)   .. %I	/'4t   4 + 
+Z Q # / } 
  DC   { d7| tG	 nYf J+m Q ZZi gm  X] vy 1dK  XA 
A d< 	G O1    NZ y
A  =~ QyZ H|0 *Nx y8
A c 2" J.3HZ K 6m5 2 %4d-W 
 (,b$x )^!&S  B
AF 9 J+  Z  	!  0 % 	 < * Yy 2  
    
A    &Z  ߈ 3   9   y 0  x   ! j 
A 	  c  Y  G 1Z :  . 
  
y   I   
A    
  
 0Z1 F 1` 6@z  .   %
   
!A    	 P   
) 3 ZV I  K 	 C y P 
 l v
 s `  
 \VZ  ~    k  7  
5y  [  R
  _ l ( mZ   y        px  ip  
\  K  }>  Z 9  
9  4  
'  0  x 
0  / 1  6
 4 /> &I !Z	X  ic  \  	p  y 	 { Z   S
 
      LZ		  	    x   *v >  Z

  
 \  By  v  wv 
 s, 	 ~     Z     G    y T v - z6  `1IZ  V'  a!  b vx  M  3 Zv & # 
 +   1  Z ;   E y  I	.x  G
[  C
vv  = 9K ; RZ
 > ߰ D z D x~ 	 AB  Btv  IU 
 L9 J
Z L z U  `y}  d~t  _X =  Z  W/  Z+Z  Zb6O W$2 Sx(y| Gmq"` <s  5 <} CR	Z DN DtiE Ghy{ Q` RZ^ JQ6  >E  9CeoZ  =K EZI Mh  ޖyz Um P Xl & / Xk Y 
5 Sm  	 Lw  Z C|  n =z   ?u  Iyy Fn   Nc  RY = RU  Q_ TZ Tl j Vm )# Pi 5yy Lg  3 Ll  * On  " Qm   Sl Z Wo    [x _ [ 
yy Y r W . W   W   V  "Z [  
I _  a Zyx b ܎ c ݔ e  d  b $Z ]  Y } W zx W | V % Y s   [   ] #Z `  	 c  . e  yw d & e   4 b  	4 e  +b d  #Z a    Z    R  ryv M  H a H  E c B  Z B   C  l G  fyu G   G   G   ݓ J   ܸ N  Z J  H(  F4   zt E?  . DH   AO
8 DO IKHZ ME J=  E1! Xyr B- - D4 
z" F0 	# I) 	3 J, 	5}Z H? , @P $X >J !zq @6 
 > ?) 	" <~% 	& =v# 	 Ai! Z G`  IW I IR xr HO  LV L" RY    VY  U^  Z Uc   Vg  
T Uj  yo Pj   Hh  " @k   @t  	j @z  Z =|  	 8} s $ 7 Wnxl < 7 < #" 7 
Q 3
8 4!Z :2 >6 <u.yk  1^%0  'D!:" #$ \ (  +Z (  "~   Gyj   y "   
Z 
 j  
ۄyg  
  0
   `zZ  xe    27
 	H Z  uZ "- )/) q0yd _6uS/n
 0H& @;!s $C1 eZ B*B 	B @8yb 8B ,
 
 BZ   *yb @A ;F
 !-DZhe  "Z ! +yb 
 '*E 'L
/ $5 L
_Z d p 4  y 	)zb  ?  _.
k u 6-6 6 &0;'ZO!  -f; r } 2yyd u6 ?
k lx -  (K ZqLq 069* F`8ye $	 / "i
k  '\Y  _N  -RZ 0 m_Xyim+M
k g 1  u  ~Z _~ G7X8 \ylZ  sv
kPy 6y:,  Dc 6Z  R 2}  K (K  I"6yp ;<f G'n
k+ 2  :Z l %<{  "   xu o  Z # $ 
L ax$ 71 Z <; ۗy  _@   J zx [ ^ p  k 6 D
L s r I   %v ||  Z @  x X  h H h z~ p X  " sd
L j    /  {  ZN g  *[wm 6} 3)y\ {)x * i"
L w ~     Z ^ j>v s PT 9fyB L>   
LV     @   z ^ 	Z  	( 1 u M; I *S  2y_j  dH  
Lz \  H - R 2 \Z  x gt  & gC  {P jy  Au h/ @  jz
L  , Z ?  s  a k  y 'x  W 5[ Y  4,
T 
y *^ #:@  Z" r ; R  z  M3  D<
T  $? Mk M Zz2;qs
 fz >  
T   L E 
         0"          $  '                                                                                 2Zu pRTdQWRAx< , J
T O   }  L q  Z : 
 p ` z z %
T  4[ R + 5 h B ,Z N : #p      x  
T p  - (  cZ g J& o { X,  a M5 tz ( 0@  N m
d \ J{c U%g 7Z j o : /m /h M kty 7 M 5  
d {} ?   (Z 3#n =k =y   "' ) 
d " % 	"J 3Z} <5mz .-k$z!   C
d '  QZmYyf E
d   Z # {  
lUZ 	 Jߜm=۩;y4&
d  } . - 3 8(Z ' 8l  . y A
d#,*Z  +ql 	 #?1  X6Bz  c.n%
` !G U Z k    $'z|   
`
-
mZ
 
)j	 4?	 @cyw %]   =
`  # Bq OxZ Bj   5  ! Jyyu   es   T
`   &'   & CZ , _Bi 4 O
  9 0yr % 6 '/  - 56
` ' <07  5&  4!Z 6 h +v yo  
w  $ s
` 3 
   '  
hZ  gu	
ylA    ]
,  @  3  <Z 
 3f "b Exix!
,8?}ZRe   zg 	 6H c
, - 6 1rZ'c F! c xd ,s 7m
, .   Z b >zas

, 	 
 gZߣamz_I
,nXZHx`6y^ p  6	   {+yZ T6O^ 02 	(z\"u 	}FZ]Xrx]:w	/iZ/
\ޖy[M<	KM!ZZ]{]|		{Xq,aXZ:VSYHW)Wd5y\fs3q*4	u#v r, Zit(X^vY$y]RwI?	9E$
5ZJ
nW]x^ ;ܭ |݋	x  i:(ZNkV8/#y`+$.	x6~Ne+ZuU	v!qxbs&e~ 4	x 4 +~' #Z
/  T3  : tyeB Ot e	xZY dB ehD #Z
iQ SiO om< wygo! u D	x 	ݧ ܡ Z{Qx}xky%s 	x 2p @ EZx|- Pov5 tvA Rxm~=   E	C  # 
y 3 t 5Z
 t
 
,Oq& $hiI !xobK C_E	C]Q3^T \F Z	^J NaiQcys d eg	Cj&wZ	 M  Izu 	C  h Z  M'pyx+	C L m 
  Z2rL60x.Ey}Z  %O B!J	C   h    %  Z <Ka  $W z~   / 1	C p~  F5 gTZ  FJ  !ۑy $e&  4	1t ( E'K ! n(Z ^ )J } ( k .x ( 4 D79F	1 6  23n R5HZ ;7I 8( /+0x  &:6 #l/	1%&A "(N! K% }ZS^Hj _  vVy Z#)	1    AX mZvb=Hvg
Eh|y Y~5]	1l3^:Km0 PUZc`	cv~G
u t=; 
y2
 \LM fd	1zjq9{_OwZWG W `'d	"y&| %p .	=-6
`0`O'RZ)!G5 6bqy L  K\ L	=-p&qUZ FpCu~Wy  
 ! 	=sJ c|,e*t 5MZ t _F  " Nbdz   {6wQS	=[  Z  
 & F r" <H yiV  q~F Wf	= 9@  ,
 <e6xZ   U
k2E (_<z 7 "=x@ D  # 	= =s  p A  s )Z  P ? ;E ' W  nyVq_  	a 3 y  l F
Z  { `۠E ~  a \z ? ff " 74B	a      YNWZ  A`E  G[^  $\z  U	a 1
 !  F:vZ  K*"E Nsr6 1 a{3Cy  \ )   !"	a bW  Y; Z  ?E @Cbyk u	a  ;{ k Z G Fo $  U(  6y2  5	a 5 <r n *D( r 7JZ  @ +PF TA  Zy !e6 `w	a wu J2 " HZ  NF V#, )'z~5S 
4N	 JA* }#Q  1 Z  A | F g rG t xAy{ ^ t= 1 SN	  )J #  I7Z   i7IF . b
 ? 74 yz H Vw 9x	 ^+1 
         1"          $  '                                                                                *Z }F   .>zz 0 " : FH	 > 	  ; 'R $ 2Z 8@F 9g Cyx S7U  W$	  ?4K )  \5# * 
 y,+Z # / r#F  e!    *  $yu  6'  y>=	 , xD7 # {HY  qHwZ \"B7F R8> `D7yt  >3  ,2	  0/ ! ."\ B '
DZ O ?F , Dt 4Nyr nM a	 %  E c A QZ , w,4F  { m%yr 
4	 ,  l "  3Z  5F ) 
-Y$yo 9%! ` J	   _ 6Z AE ( [ Pcyn 
 	 5  e >L  fZ  +D [ aۯ  l)|ym `x S	 B  < \ \90Z   D    T i3xk  QGO  7G	g,Z < W ,GD x y1 i 6`xj 5 \.  L%	 % !` *   g 5 R6Z 7 UC $ 2| '  u :8xh r m $l T	 Ba= M YG 6OZ C^B4-yg +d )!+	 K) Nn 9 3wZ [}A } syf 3an K>	 D'$ ) =Z 5@  Q	 3kye Q / j 4S6	 g 0J I	& $!Z  x@ n 3Yzc bq vyg	 V OR   _Z< ?  
 WV  	(yb  :  W x }	 9 @t- klQ 	Zll > ,| ` U Axa ` p I 	  /b 
L1 ZFB 	J> 
PQ  ;d^  x` UxY UfE	 A5*- ! 6 x;1Zfb'= 	db " (q<  y] ;z%  4{l'v	 "P. *- $(Z &= .v   ,o< Kx^ k  m 
	 wB/  '}Z (pߘ= )[ b ,[ x] 0k  Q 9	 7 + *Z !xPz< /M 6tx] 5Kxo :B .
 = 3+ h +?Z 6<<  2 &0 (x] .l "p 2  
 0  -  - kZ . O< '! LH " Ry^ ~# @    c
   ' / 3 Z <  < 9  ,~ [x^ [w  ({
 *  Z ~`;  U $. Dy^ .	  9 
 B A E  H (Z I ; %K ( *O 5x_ +V 3 (\ *6
 "`" b  _Z T  ; L!  o M6  yb SO   z [l "  0
  {V  uN   F   &Z  A 
s; : 7~ : yd Bܩ I`
) H;x4  Z  5 ; (9  d *=
zyd (: tl 07Z
) 1:1i :<Z q= ;x<)92~xf 78&( )4;4
) )0>4 !1B+ /Ci#Z  .CQ ; 0>Q ! 	56b{xj 	9*] 81i
) 5 5
d: Z @; 
>n * 8zl H H3 l 82y
) }  2Dݹ k Q0|܊ V -dlsZ  }+I< (9A&=xo# #h  k ""
)lo=z (&  'C"H2Z |"=x< s&f )P:yq ,; l,N 
S4' #W^a$U 3& c 5Z  < ( ,<  ' $fSM$L  xvv y 2H 
S 2` '  y' Z j$dC <&^X 
@%f zx ho u u }  b
S =*8
 @ Z R '<T[x{  O
S!nHL $lZ  :<? !n 	Vx} j 
S  ` %   1 
 Z  ] 
* 	2><" 6(w6 .NxhT %Q\ !>
S go   [ (MS 6Z  <gI 	
z p
u	 
S  }m 
&Ta ^Z DM < =  G e+q bx _	
|>  n `# 	wZ 9}1<^tzLgx
|Vx		iYZ   
=  ^M0tyT6l/
| &37\!pu \Z tGC=@ P;yV> 
| 7 U
')Q< Z  K '=I8y *0
|#S G'7$Z  wS>m	F Ay 9+
7
|+GZ T 2MZ   S>  E~3   
=y   q.x
+[j6U0 *a'6Z e!> K aly\//b(q
q`nXf0Z ,'b>b 0W 105y ,	 *U
  b,& *:BO{
Z 
c
>{1 @x  >+
 =      Z  4 3*?N#r 	uyo WH  Q)v /
 Hd  ,K  W 
6_Z   H
2%? + j" (g W9  "2xu O o  
` q 
 2o g    _y    v  Z  8 Z  	.? P   ?|& y`) J  
, 8)  % Z  - r-  ۚ?  v6     kD= y M ViO5 H  OqW  .
 av^   Jrf)  ii Z go{ @ 6kr  M  pt  y / kuv/  A vz D
 7uh  	v  	 [{  
0Z   )@ M 5  . 3Jy u   
)    "
 p     8 p(  % )A Z  9 0  D@ ?      `y3h  L 
 > (  z t    e \  Z   V9 B@ zw   s  9x 0    r   V
     s    Q   Z  4   {?  W  " @E  {y g    5 n n
  l 7 	 O	q L   ]  Z   F  v?  - J  d z  'My  i  51 W 0 4P
 gm  *   #T  w  Z  ) ]t  > C  H V y _ "S: \  
 B T  	E  r 
  p Z   Vg K> 2 $/ 	 U 8  y g 81 _ -
 A   1U 
         2"          $  '                                                                                 }TZ  M  = x     6y = Jy  P .~A
 _ {w l {`1  N f F Z  F  <  ] 	^ F fy~ }    $
   44 ! {53 " ^,FZ  - kq$; A 5  U  'y| ]  ` 
 _    R   9 (/ tZ  $ -x 	/:   (  '  	yx ( 
  !  8
     & dU g = UY 
'Z  Q `V 	9 G j{ X . aa yx $ Q@ 
 . O 
 6 Y } ) c6    j
k  Z   lp#8 # c_j 2 L{  yu 0 /" "   }
   
  # !  ' 2Z  % ' 57 1 "L- 1 e$xq   _  !   M B
 d`Z 5
k 
 eyo   	 
 "  ' v  Z  
 4   ۜ 	  Xzn   t   
   }   	 \ Z ! 32 F  
yl  P <  S 
 ) \  m   Z  
2 1J 6Nyk .
  %
 %  !M V  O X  "Z  3 F 1  R  A $yk B   L 
 ## H 	% - F  < E vZ  (L E 
i0 yb a 
b~  xib  @u n 
 d qz q R   
cZ  d  e/ 0  	 :<  	Wyj :o0  V " h 
 E 
/  
ez Z  .} 	J  xi  , 
/g 7: Y 6
 5c O 0E 
% ; &P V !Z e s  X-zc  TC  xj [ #y Q
 C  @
 
 	 KZ D - y  	5yj. ~:9 	
 !@q . KiB  DQGN 
VZ  fQ -Y Ge^ #ylXb Njw 

4    G  Z  BQ -- g< ~k  zxm; 5? /
(4L -H9 	6r & 1Z  f6 '-  	Q !tD nyn0 d
I   +  1  Z  P- 0?Wy #-F-znI,l

) FW 2 ^Z ? Z.0 ' T |ym    1E e 
 J 5 +Z  -`/ 2 
 ;xn = JV T 
a JV' >kV ;*Z g #6$12 )ym N"o % 
c1ge Z  2UH7UymRt c
  tG ;YZ &W3fEyk	 ,	
 M	 Uv k&Z N5uq7yj`_
 n- 5v t.Z iHu8U[^(zBmY5xjJ^3p	g*K

X#4 IZ !9t
tzg 3b 7

= e *.0Z  ,  
;  Jyf#ܿM
#
k#Z 	db>Y,xd -a 
 /x
 1 ~z_ f @ 0	Z  Qx@ =  A  8yb -%~n	L = 4
ZG c 4sk  +	  #Z  
I" A 5 
    qxb  :D  ]
A -xV &fZ  u  T C
tC d(. y_ !3 ,o
EN l5HZ }E*z. ufx_  -Y 	 S
OFLZ&Z lH  ,y^,[C`E
k Q# *gz{3|f 5Z  ,I"M:$sw: x_ % 4  	
k  4 B  Z . K  M(K:y]2 ? *{
k  s q o P,Z  WBL^ Yiy_E~O 

kDCZ  nM:<	fXRxb
kl7?m` OZ  1?2O  6, 5  .fye  i %]  z !<
knw  T<S*~1:=4Z \RVBPv
 ye 
 x  
kv8 _ 8 Z - :^R4  2 byh 8  * m #
H .]< r y K] !f  ? }Z  D=Sl >w{ :kyk $- 4
H  I(v ! Fn 13KZ o
UDZwE0IynG96m\7/
H "&@ T !n  v- TZ   mf>V  'yk=xpC
H$+D}} Z  	nW|j qVl  8ys 2s  ~@ 74
He V>+w J Si  $Z _ YY - M[E M m[xu / c^ * AjFc 6
H vn= W|}$ XzM LZ   w[ @wq  n`yw  q& 
 J-.P
" 26C0<W 'VZ  Rj !\?r o J<syx l
dmD E 
n
" k ~} ^ 
 % 
BZ  
 	t^ p
 3) WQ OIy{ N~ o
% dC 
" T   IK   mZ  +A_I ABy}6
W-#
" 
*d S.5  *XtZ  % $"a  zj Y0fy OB ; I^f  
" ;  3 , CA 6OZ  _25b  n|(v  X"5x ,p   ~K 
"# e m  Z  Av -c L0     
x   J ! 	 
 v   {E  c 0Z  P ۧe A   6 	x 4, 
H S	 b 6	 X V  ? S   \ Z  J 	f z  
S x  y    
   
Q	 H    M >   5 n y Z  $ N )g  n  5 
  3ny. ) ~; "	    !   Z  M7 Rh     k px  \ ' I 	     	
Z  D i   G    ^ `y  z^   x S	  5  'p (  `E Z  x i hn5 1 / x & E . 5  {	 A mrM  = g3 + - 3@ Z   ,f ni (N n & '%y %B  5-  g(g 4p	 7 K/ + Q b9Je#k ^ BI Z  aCA  i Yf< [ E2F 
y 1*9 M 0!  	 Cn  U Z0
  l
? 	Z  wgN Xi n}( N?ox %ZD #x V   T	 
2H  t 
         3"          $  '                                                                                 ? BZ  o )_h   n  =y Pm%t  J3n G	 nD  %X O _ x@ Z  
 hG a / 	[z Q O.   ; $o	   
4" v ` 5K G J ,lZ  # ^ $&g  +    y  2y  `  6 '> 	 a C  y z
  l "h 
}Z  F O8 	9f ! ~    
x 6  
 m _ r	   =   ފ   Z  k g d ]  D \  y W j  O I 	 P 5 s \ :B 
 r Un Z    c  p 
h v Y z S N ' < K r	 A -J 
 ] /G ! z /: 
2Z   6# 5a  D -  S  
$x p b  ! ] yj   H	 L Nq   A 'q  g D 
k  Z  Tg t ` hl K  r u % `y k z  Q y 	 / +m   'ZY   D2 
Z  /+ ^ C ۍ U&~ 1z a W< S f 
 	 e 
 k ] W 
 V#! 
Z  Qv \ P  V y [4h - ^g 	 \Jv  W  N  sZ  D % [ C   1$ K 
6Vx SL / V %	 V]" !U Y;m  U a ! ,Z  b  	Y [ 
  
# T  R 0z P 
   N  	 Q  0 Y   d"  Z  n#  X l#  
 b' x V
2 F SG% 	 Tk% e U S R  iZ  J   iW @    5 	  [y .
  ] 3   	 B   Q  v U  Z  N  V B 	 7  y 4  /S 4  6	 3  0w 3P# & ;>	 !Z  Jv   tU S  r K  )y 3  }    q	    {  	 K`  jZ  C`  #T Xi  ! I3P[ 	sy /b  *Z[  
- )  J T   :l YZ  < T $$  ^ 50 :y 2I e ,F 
- 0t, ) 8R.  7c"7 Z  '*% ET +$ -&   y)   H  	
- , ` -, )  6~   1Z  0 R 'T v 	" K  ~y~ yT 
w
-ea 
 :Xw  ;`  Z  Q 
U U1N  J! =z{ .m_   

-Yt %  vZ  3 RU :  < xz -;} > a! 
-  	v ~ { Z Uo lV`  0Iy xy ]u,k h dM} 
  
 J_ g Q %* L b 
*Z X 66W 2U );xx " q
3  
 8[/ 	 3j   
1Z < 
X
  `E xv
 |

i |
 N

d]  O8

 w f;
 	ZZ  Ui Z %	  ByuS] I 
! 1 
c  	 ?$ Z  [e T[ L( 	  Z 8zs 1
  8 
  4
  !
 Z  N@( 3  ] _77 (Q Ma?5ys L3`*q
r# Z  ,h$_ R<u T< zr 6i y G /
" 
 
 ,Z 4
 
a   Q} )xr ^{G  @{ 4
 	jWi	Z c  W <zq ;p a ;2 
 K  ^>` i DZ f qvd] Zxp m\a% 5<b4
 C&u4 4,+ 
P#Z U f yyo~ 
f
 ,d -)a Z Rh $t #yo +<[ #
   V m '>Z  
v/2ipv(w(xm|:{LW
yh!oj Ym=Z  >~l.8MKymQhve&tgo~"r3n5Z `-7mH$*!yl0 SgV%2 Z <oF^fOuzlXcfeTgI67dZ spzl6gRbK]Z Hq/^yk}ge[X/I Z /2 r6=| .yj; %v !Gg  Z  Z   ks~ K% %yh|0gnZ)wTG3YZ :@7t=T
Joxyh^v\}/Z u|yh|%l)_CPdVZ A
rv56&07xg6/
&l!
6  iZ  

N Uv 	g 1TygJSX\c Ks Z  w 	   yzg  v7s$vt   Z zm  \xy] GQ yfH *(F =8sC Rg< lp4 MZ , yv%  v  zg Q .- 6 1) '~Z  !z   xf _ ~  m  f  aZ % U| ' D 8  ! ; _yh / @ 
U $9 H X{ 0D L } :P O  ` B[ FZ L^ <} S[ 6 QP 6Myg E@ 5 9, 4) 6 0 = ) G 'Z| L '~y O` (# P 3zyh O= I J M i N  Qg + Rw 6[Z Ow 2_u K6   (r FH  "Nykw BF   98F  .&w  '     # Z #< # (xl ,X +q} $[  N1 A@nZz 1I۾w &!F޻~ HD|yn hDC {5=}   yZ l  a Z [ xq ]  _yQ} `v hs vi  Z V ) C 5 = 3ys P )  "}     nZ CK  "cyw l } } 	 
Z   \yz A
ݞ `"} [  
| Z v 
 
sy| x 
6}Ze} 5Z Omi C_Z {;  C   &j l  &x3 -S 5= K%{ 4x( ,p +$FV#n 6AE Z #$7  T*LH Ux h ;  (' J?  o Z =  <IX ) < 2 2z  Q   S(L
 ܸ5  
         4"          $  '                                                                                 	ZU du    {bx D d  Q %(,3ko |Zk Q3g E c 1y
c Eo $"(O# 
3  1p 5H  A  
,uZ	R $",i   X  !y >
[ 
1qH (( <e   ( hw sZ	 e 0uSmn  27$ z oC 
 ? 
Si.ޘ[_Z
,Gs F K| * '} xF mT# : "G 
 j b FU 4Zp g
  bUt yG0 = X
*( 

k? > ![ PL 2Z$ S
5YX-ga^ $y  a ! [  >
O : |B a62\ Z 3(/  % r#x  Y  [y     M 
 = 
Z 2r IZ $ ' P 8 ۆ8a y$"dF~ 
q+    X   Z
! d ]*- O 2, 
y; 4 '&C 
  J   F S  = T` QZ
  
j 	n 0 1p ^ 6]y 7v /1 \ 	%
r # !Y$  > S]   .Z
1 X   
q '	 4z{  ]  
r v 7 . m  4Z   $pD) b x 8G 	? $ 
r.GQ E  `Zxc \e Jzt	P1
r SE
  cr o Z  a{& 	\ZA y /PM6
rmnx0~ m_ &
$ !!Z ' ` O `
yCn x\4_
r^< H 
 	ZZ   E 
z 	zr @D&  t' 

W   7 z n 2 	+ZW  T Hg>" y%04 DM4 
W ;  :P  fo Z w + W    sz  (8  A H 
W 	{ ,	 6sa 1Z -5 (
 o&Zs  " uF  }y C   ~
W 8x ] 	r1 %Z i  ?  `  T 
EyH   I? $
W  r7P  n ./ 
T 3. ۉZ ;k0 
G oY*   x  		 I ^q 
W z  (s   Z H r   ^ z
p o|  !
 !}!E 7 x5:  g@ *Z ^8  	6& l . 3   )Sz V " ! 	  
xR x  ti   Z~w^  2Z iG   8@  ^ I$ y TU>  
\ t
bX   {R   LxY Z n}m  v}   l   y c  g 
 p  ( k   U  Z >6  H =t   ]  7y V   )
 
  	3 p=v  	 @i_  Z ,}H  \ :x2  ( Tf$  5vz hQ  4 oC	  *
 v>  #& ~;    8  Z pK  5 Y|   H  0z Hc   _E   F
 O+    3   /  JZ ~,  

 W&   / E2  zy PX6  f~V j4 lq  d| T _z Z ^t  Xv R I x~ : Z 7  T > % ?^ L ` \ _ 
Z p   s x   uJ  x~ r8 C %n v ) 4 | 1N G4 v o + er #Z T I   H ;    F    yz L   \O & e h   g
^ d Z l MB vrr rsy~ d5 XIn& V, U,Y _AZ p q m	ny} p&_  d  *4 w# Ki31Z +<ey 7w
= h A9y|  (Q g| z" W3W o5Z @"-K 1,$ a!z}  E  l +M Q
  
 i   
Z  6,    M8 }e c 7; z{ G 1  H ,  i B b  ( z  ߄Z k   lM o 
 f ; S 
y{ q? g  oN   ^n    Z , B ^ = Z [$   ^~Z	 
 v  Px{  q c  -   !H D?  Z oU  1 wc  6; [tt. 	.zz =]B % ,c3 !D ,r, 
 W :)  M ( Z Z9 ZP% [dxx as bz* Kb +
REY =Z 0L NMp* `hyv ck W#}I >Vz $amx Z   8 Hf~zv PK V>0I ^? [  Ow CqRZ "
R   3y0yt /l6 L/I ``& [! Go rZ -a o Zp^zs #Z 4I E4q M^S F8wZ 4 $j " "yp     @I   +  9 k!Z 88 Xa + <G !v ~ym %  6I #+ % 'xTZ + ,j  *i:yl ,"$ '	. 
6z1IO7'Z 	'8!    !xj #D^ u  Z  	= jzh  
w 
   H h&Z. 7 9Yyh /$ 5 9ZCw3h,hxed Q[M_ ;+/6aZ$ 2 ( "iye
   | Za NI 	
9w yf.\ `E > : K2 Z&u% 
6X ޢ+6 
ayf 
: 
9   wZr [ 	QK 
zfN  ` I "j  !fr `Z p)R 5  3yf *6 " O   m   Z  d  	 	3 {zgV3S 0@ %HB !Zb
:Z h  }3 zzh:ݕR  c 
  Zt 5 pn    	pzj  
 /  c H  n <D T ( Za  .    &yj 	 4 %1 46 )S +:t %v #w\    ZQ   ]  	W  zn " G "  6 2Iz 	O	F !XZ: -
QU^ <;G B ) mzn =%  4% 	s6 35 ܫj 4O 