 
         *"          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

 
        +"          $  '                                                                                 \KW Z _b 3gyk^c yte 2(k6$>  ?s l  |>{22Z6 61gJ 
.`l}6E%Szv{Jb!2<c  J  |CM 
Z 
Yk % 	yzx <i".JW9   0jS @ Eo Io9hZ[V 
Vv ۑmM5 zy1U ' 9"   U8_K 
uS  Ze   	le zz   Z:~7 	 A   H{ IuF.D 
Z h=[ 16r 
0tk4=d6y{f K= / Xi 	&F	zY,!tp~Y%  Z 4]y CZddsPeEka 	Jz}_0]	~]_ 
J rdOmZ{C 
r 2 ;k%V9z} py Y bq	Wc6 &H X *H Z oU({^[  k \9z `z}Q]]mW7byk	 fu	 'gLf@e/Z  eg  
   ed kT`]z}[V .k  T 6	>\0 h ~'I +Kk o!Z lc[ c
 [qk M]8{~;hz /m	 t	 *i siunl\nZ  Nk(fGkuf`#
!z} <_ 	 a	EYdhac  [Z aU* SD 
nj mU :z}5U
PPJ 	 SL    AM -S- Z T^@ /R'j B Q    hz| BT 
0Y	V ,.N 6\ L23ZSP'(n	 qR "+j iQ4 sy{P# JM@ 	G  A = 0Z ]?  F.i BPvVzyIvU'C R	 %JO  Lw 
=HFZD) G 
i Loyw jJ]sA  	6 ,;|?L 
Z\w
fli h 	zw Hcm  ^ 	P"[BT i' G)Z <BF  5d1L 3]ggX ){s&Y " VFO  	P  @  J8
46ZJf33Vg( 5 zq1+P,Yu	Po+  )*6 %JtZ\'h2bf  6=zp D8k  C 	P
?%E>   ^fCE Z n GQrKIe PD Nym  JX+qoe	P^s G"K} H= ZK   z ';f +x50zk   4c~ *	P F#T 6   , u Zl Af q gX 7yj  P Xl 	C	Pl: } ?d 
KZa 
 !  i2Q) fzii  P  	) N  / -k@ $Z G   "[j@ zihJD ^: s`  "	)yd g-YO VM  ZBA t :	 qhH. 
zg.  &D *$'   4#	)
 
5< y+x ,Q $	Z 3 GVg  f 	{g 1' ~	)/VH N}"o# -Z-D d {(  yh K{ _.	)> 
ޏF u 6IQZg=h  bwh GTi
 M
K 	) @ 
O   D AZ   d #!a $^~ <zi+-Z   G
	
 Z  ! b.Y 2N 5ZP -  fE $a  
x S!yj s *\J 	
L0 K
RT0 m Z %4 mRb	 [ 3% zk-| d	
  An U  Z^ ۩- \br V~zn] 2>Q	
t.T<%
q Z@ @ 6 a `zo Pc	
$!rKZ<; 1E J 6ca
 
/yp) % Gu2!V	
+D T  *y   Z ; "[6) 0`,; .ys < q( :	*	}/HF )` Zy< !x0Z& a'He	iyt.Xka 
im`}  	*`6^   X  Z[.xf\ `p, yuq s7HG^v/v 9	*^ |" " (C  JO 4 3Z u 	L `//fyv	| 6KDt 0n	*i	&h[} !fOr  hZ GJefGX	ak9CKlyyb?C_&DC	* &TC <b=]j8Zl<~ oC	e`Ww?zy7k>APR	*N@%# E4BmM%Zr| ^#k 	Lc5nsyz mL U4	*J2_ NMQZ
 mn  O  K c .PFz{/# h-<	q bg+6}
Vp  1! 'Z	x! 4 v me Xy|!k 6 	q}tt"k*mZ' F TdKfo ])y} Pd  
  gb$	q PQ-@- ۝g G߆ZfV   h /  vy~n$3 >w 0	q}   W   ~ 
Z
)e  N7h  ) z~U  A  2fv	qg  k mM * I h,68Z
 
>r2 _	 )*i  { "y~ ;t  @ 
	q  z v [ cn Z	 X`{L ' Xj a V zYCk *[	 ^
 c3^6B >b<Z	Sl xTi  <}!x =nLSL	  ;UG/ n 4 tZ	 s /<<G	_h T N z  P UO[	 F c[  Wbq [l Z w (q+'5j _1#3z/$*d 7}#		 (> NH VZ  GafweMj S9<cmy ; 71],%]IT	 < ^Qy  i\#gqM
Z E ac t]%i [Ly ZS p\~<	oI	3 rZ P~sj c`z Td"64h1
& Xo= <sM6)lc+Z  Z  C `L(jM%z gUC4 t a x4
&)l+  t  #  | Z>@ 
 fk J  y.U 
& 3U 
S .
uTN Z ~97 g ./Ll91Q Ey w@O  WQR  
&w&gM9|   woD W X ql=Zf;f a?i j T _@1y|^C~a{ =
& =e i V}mZ 9n(uWjztz\y~  ~j Yz0"
&-9t@3vn3Q 5  l?-
Zfme$r -sc  l +u z}orn0 !
&  k&FiYXafa? yZ  aZ 8~bkphx z| 1 p~ {w
7Za|  
  	S%Z5  ls}zz7y, 0. 
7^w' 
        ,"          $  '                                                                                j Z _N#5y/jk~dj {x . `b!$c! 
7ol o9   .ef2ZY E61 T.vkXq%`zxIY!/W A
7WY \Z b"nk 2 tyu %"
7so :F Q NXDZPqL@\ۉlCc"yte	b;
7ucB
if 
h![
Ze9bZk cSytbBA!^%	 vV iSEkZ"
Z BcH f05l!g6uzsI;bz/ \k&M	PiY!m)X PU>Z b\}h~@kpC{s\ti[	 NZ LJT	*MaZ  Qv R~kX	uys0]]_ [[	W 	/hU`\.U?Z *V R\jAN gysMv S6	c Z -\|ZJWZ  W  	 ^[ i:[_ZyqV g^ 8 .R ^6	W^	(1-	a  
'{ MeS!Z g  vMh  k4l 5 Nyq7r\ 	iU )zZ .b 2Q;eVkZp
EyqI GW	~
5lq 	  \:Z I A+ pk }y	y8yplK/h 	~ e 2a_] M Z V[s 8;a	kl  Zxq}y 

'<'	~2L +/> H 6J[L2CZ +Z)(}g xb  "+l^ wc mzq}]X }T
 
	~ qqI[A9M> 
+Z  M8 ~X5<k[6 
RypFQ9  I7
	~!K8 dW< b 	o+_EZ ^Hp \\E5 	l;i`ChbxpVjAY|"pF 	~`kKbIYu \;b Z  W]-\ta*k >j0 zp u4o%{8T x6 9p2tl-)Z g'5 a#3k8Y#q)zpT% e"P&  c9P&fU& ^-y RZ Zc-c``+pj[- 	*yn I[0 b3*e e3  b/
$W)bZ  $O,, 
(N1 ܊jPO4ylS3 e_U- 	\.V)a7 	d9 Z )g3Yi-d jn-W 
Zzmow2x|2h>y( Q !t2xEZ z ~ 
b un'iDV5*yk" 9Z 
482+)n=#r  G 	  LL Z OaU] $ k nI JziV=y/9w4  Vm bS`bZ Im 
@ HDjMyhFU 	{ X_h\
k _Z . 
c .Z f_l WX^ ^i @gO<ye<Ld@O _ 5R nWU	jV#  Z  V0Y yZ7ci e: ze (jA 
$IkY4_s5QY ,w e<$"Z }# 2d$  i  X ,yc
q] f; _ Yde ;]  p_ BU .Z  QT j(XX 
iC ^D )$zd Q]  ,_  q_(ev -ް ag 0+ e6 Z /_$ %[ -Z .i 
 \ zc c h (_ H e - ;a #_[ #EZ  v\ ^^	 
i ` "Cxa ^u X 
 8T  !{ T$ 2rY&5Z m^&! - h" $h s > !yb]2   3 n"  / K& `1'   1  Z  v o>nKd _j ;XE zc gKy  Zr `j  R E41Z   ۜ ) 5gxZfyd/] 	 3  ++ ^z ' +t 	Z  I g Ie=vg  Iye    aS 
 RHfZ  %) 1 ! ?6Me'v/yg 	 2 
%(3U !> (^0 9 )*'  #- Z  ,x"( e (! zk  /t44   5   38Z  sH   WIc\Nym s3V yS	e\b ^ g@ }Lp yZ  %xw  ,
  
de; eyo Uyt% 
(	i 	u cCa 
Z m 	y  Zde/ ys  6 0pw& P^ 
!:gN  HZ  TI  a fQeYxw *nM D ` Wv fcK   2Z P7  
 	xfYy|+   %.KrX& N
 ^Z xm O Ef? iy $h  , 
*V( 0  j T DZ r7  }u g Pf 
ydis  oi,E DX ` 6kD= 1 /'Z  =
 
!Y4  kh  Snal ziy q CQe EH ?6   (FB 
   _ "Z iOt  Au; Gg  VaS^ za?] " \&[M E M,P Yc@D~ ۞ EO7 eZ  4VV?  4`bl g rmz " 
&) !E  9 v  Hf Z 6 R   %A:  'g  8I zyE6  ) '9!EE  _: si9 * v7%u6Z  k>F1 2T?f ).f s<"vy "^5   }H1r E j26 21 <H.#  Z  *AE %Vd] iT  z m~h YH  {V~# CY{ '"Z   --mK.W=d s/y 2R@MM QRY  	Rb&tm lZ  !qq&{We {mWy fhlf6L
Im4   }y  
P]vZ   zf (+  ct5udfOxV3z u Rx< *s&du# !Dvn  Lg $QmoZ  Ih -
dKkx U^"% :  ^/z&\ o
Z      [e62y  q 4  p |e Z Y|z #  {j Z Xj ;R$d  V
ny +[~ I\Jj	  X( &'UrY!Z   `#, C`!9ek_Y%z i f  4 M-st4	:t(+  _  # H; Z <  e 9 ke 7#y9Y 8 	  3 T)+ O*s Z +4+i W0od ))5 8 yz  ;  `A$	z_M\ m g YL 7 )kZ F}p !V e !{ 5|  ` )	 LxOBc  Z  f Hr* gr6TBd 9 b?2 y/HM   v.2S"	 d .V 3L  =Z 5DW3-"Z [B0Wa $~  [6 	 c`f zv5s6 
 (	 f    Z  |?@@I_ z|d L	gjB  x br Z  o& 
	 	 ]zz   $( 	gm.; T42D=  
        -"          $  '                                                                                 ^ E &Z  d[
(  Os %cY F( 8{t  't .	gg C`zL\ 2mQ -1Z u  p; A64 J  ..V 	 %nyr  ~j -!.urN # ?	g mdW . ) B  (ZWc9 -Uz #W aP $typ t-  ^A 	gB	 O } !$ Z - j#` #+[~ zTls xm]  " ] 	g'D  w GK
 88  Z Ta.( AA  U , Hn ym:2Iv ANNs 	"R Jf
Q+ 
fZ sw{  f0Sz 6zn  {^ /Ee, &g	y !uB 6  O A AZo(Lf  >  DV  8 	Dyo^6  v 	  [s ?=]8  3Z Z b_ <Xa zp  I r/  &	  uw &6M wZ(R `  ([ a  <yq$8 
K O
 	 g ~KZ _ 2m4 Z "*um  Kd\  \I, &ytp 
.3I6	  1( !7 's <)!Z0 	 X OT lXb  :zv\  k w	 G* e  n pZ U  K 
(Y+4 UX =3( 
byz =! S .kM) 
?
7MYB   nBWpP K Z	>B " > %pV H) 9x}pTC9 "I^  -
7hZ !zJ'  By *Z
BQ EAz W m>" & ez t DH  OF p
7 [* %+ i  6W%d~ 2qZw 8 "( r "JW  ~z   eP 
7<1;T  nO 5ZZY2Y$ WUW ]z[g`T 
7 ;Ldd N 9 l0 tZ
 vH  E u I XxbDgz }: h NN 
7 { 	 Fq ZmtzlN r Y -m/ yrpnHv 
 ]w\  %rmL)dZ FmV 5  mv3Yl*t)z 
P< " > G9 
SD  e1 UDwIZ [b[ E	y_O}
 e	n
# Z u^$ J{\	<bݢz ^%  {"
cl0 ^] b QVZL. N ] R/x
iR| R
 ST7)+R# ] wGDBZ 	6{),&^'4z44yC3A+%
!'K #_ )[  6 fxKZ #C
K;` > 6z)'R Z$ A
 M<
_  OZ (g2,A D\f`
 u(bz6PM݀ 4
.i
 A  
(vbZsn   H_  `z  MS8zd 
$re Z,t 9z  Z Gs pU]M_gYN y 	VP  $eOZ,3
 L_ 5b3N\V, VPQ$0Z % THH   6WCH<  _AUz@g 	"=m 
 >cr FT z(MQ2  <Z  U_ HYpM^ 6V~ 
@z  O /NA
X	 Tde+Dg<Z `#U$Z#^ *RW1z~ ? [?^ jcY
/k{!h _	  MZf^j [f(_lxxEyz  mcz 0p\+
o
 xV !F tw?v2
)sT6Zw - | U%_k~6!{v ~Z  :jG
 MYd ? 2  Y Zb' hٵ 
^a֌ zsH~
 m  H`XZ 4UJ ە *KE`QH*UyqO{   a 
w ~I ( biZ+E,/; ` 5Z$UylOKr@ OY{ 
 A`^st`TK b&q `Z JeP 0 d6e_ h	 /Fzi Wj 
%ff<!Q
-g	  H r ( e [0ZS# = 1` 
 og{eY&] 
=
 ; n.vo Zf 	Z OFP<sNF>` ZC  kzd ~CDq
G pM"(*V0WZ6a8 @r:' ` 7\za4 y8>
 . "mGjYYb Nbn +Z QT6	|W1"` [W /z_ A S 6NEW0
 -`' Z(gY!ng vZwbz (2`6`]_ 
z[*%`  D^b
 &ba6{ ZZV6ZN@jOm	a ZH SzYfSkm
 a! % UTVA]XZ l   r^`>2 ~yX}w  ) $ l !F
XTS^^L h J\^IZZprFI ` FyV,	]`{  6k]N1M)(
Z T  "  	Xw g`)\yU b+ r 
 liI	Ahz $ZP   G
ZA>hE   >a R/I{T?IR7]Mx 	 dWaۘ`#:Z
%Y@
Q`INn[yS Pq vY	^ }S  !D;Z.50$5 
_ r6. 7qzR5;6 T;4 #	  9*9 |<7*tj99
   6Z 7" 22)C_!(BV "{zQ  x	$uX 
 } Z
5  : '  ^ )
J yR*, ][ 0 )	. 1  14 ~ h p= .Z
 
L $$v0X_  ]cTb` 0zS kc *cn	 J	.=Si *  _)X 'V: gZ	QD  ,PSG !T]<XK7 ySO`F W e9  L	.Ibg4 af@ 
gJ ?Z  fl;' ?|& 5d_ > > 4zT  *]#	.{   :!Fo(G$ZL) { G,4( aM2:~zT}Bi_7 3 9	.R34mAy   ?dQL 
Z*
y P(b M zV&<]jV	. sa =l  Zk:  W 
`  xWX ;3`  F J
 32@? Z>C,JGw _	:>2 ?%`z[L
1%' 4t<23!5A?	, ([G # lG 3 ZMj=0 -  RCX$`yFy]n@D xV= s E8
p 1/ 0+# Z0%%  y9&; $^<(5 x`	;""oz7	: L,*#{s( /
& Z R|+ & ^{~,0 9yd 1 5UH^ e=;G) f R{ Z |X 'dO c\?@;yg +3|+ "YC(_ 3Q "'	52-9 	-dZ  4 $ V>\!]I  =yk	 vU  ZqF P[   p#V  hOZ MMU Kl ] 2G xo F wJ :QB\ߥ6 h Z ck
C  jB\zcg yu V b 
OQ W T  
        ."          $  '                                                                                SfZ SB 
$S
 k] oQy| S! J!]3  SjM @ocq 
 p]X 1Z  \q6 	6Lo	3 .] ~n  %yK p) !C8pJ Q q.  $r Rt6Z wSZ 
'  yF _ Mz]y~u 
1 J [  ($k|k  u2 'Z  ; tGaIv-ہ^  xW sz y O
w{  fv   v" wl{VZ \ l ` 	_8y I   @+;N  FVY}i  Y ~[ 
>Z  U1 /^  6y  Ltt0bdb 	& ?R\ ! ] WU \R( QZ  JL J X^-NVx<V  8H` jT 6 t_  x- Z t_e _ nT# Oz 8UD] ;' 	 6 
<Dd6D Z  kS q fo` ] Sz &A i  3% R3S  j +Z g'  ` A ^1_ y *o- X o 
6 n 1d %Qg' 5 ]W 
!Z "; 	 y ('_$% `z ,  : 2B  %?D  
  CZ DRD {.A r^ G? 
yLD {K 
^Qۀ \N Fx 	Z =86v] - / :z$G q O2V  9  ;Z   Y 90 \ r Pz$  . $ s (:C +GJ 6? YPL 2}Z   Uo(  V,l"F[ JV  qx :[2 M `#  _J  u]|z 	YZ-Z P  @E ^ `BPz ^F ;K  9pN^s_U
B  c'g Z  z Eb6ޖDL-	  U[ 4 =z  q/	 LE 3 m  "$%Z  y$ 
i MD"m[ 4 Iy R 'X c =jKScs  IN+ xH )$Z  pB+5KB 3\ hU *y 6vY"{ W   P   QZ  hi 	  S[V)c\cx '    RB E wY 
A   Z |^`a   
ܒ] @ ݑy) e 
 vC 0 "ME(N Z  TSE * Qa:Zk 1y{ w  fF[,( Ty   ~p(Z m y tZ &t]  { 4zvI4 o  += r#gb  C XZ Z  _ ; i\l 3zq k  bn8qy    U,JZ !J z" 	] l T|zk	X݌ n$ ܨ	  Bwdp shr 	Z  ^] mY0]-\ , WZ= yf E^9[h	 U G T U"	Z  
T#O T' \ $MW-\yc\2# pb3v 3	 9g25Qk1, tl1 $#Z   <n3 u7?] c'v: z_ x t8 Ovt2x	 J z%   md%Z  E  ]s9z\ c s^a	 *a d c= \Z  
`.3d_ u zZ ~ v 	z	    { 2Z  JIfw b V^DN*yY A O  P iS%G
*	h N0  5 .E/2m D*6Z J&.  S)5%^ qZ0-!yXf,
 0t S	h lc #p9oZ  jmyN|    mQe`_iDH	zY G}o(   ~ z 	huh n 	  P~Z Kۓ  vb tMuFz[ % #	h KA&d#JZ  vy1f =5>aTDTz\ iE? 3 !6%	h3 oa9  # W B&Z ~%Ka0 E1Y6r` Z @j/my_M{&  P:!b	h t
Ir THWU7  CG:Z  }cK&3N(;`Q8 Azb qQOKQmFA	XR_  xR~ MZ N _yRu 	i_ = W$thyfW{ -QX R	 . ]Tox`+  ]( Z   S  cKqr_   AF  yyi kF(% K&.	 NL!
  BJ# H,Z aK1  	B qM- 
J_ TJ%.ynL  6 mLMm 	0	 ~R'"uVx! !zU  nZ  FQ6wOQu5_  T xr e MXt8X	 7 }Y  k WlqRT)&Z  8R
  7 1=T 	_|T<xv[s bH_\	^i]+Y ' xJ\ Z  l)wrK^ 4[mz{&B;	 7 ! 'sQP^Z   1 W   `;
8y Jc< O J,,
?RO6  \2 T*Z.(LZ PY",Ed ` gT@zF$[@ 3
 ;rp^ K85~K' Z  [pW bBJ[`fr[ z -V"S r - U V
Y0W! Y 	۾   vQ[ C=Z T-K
 TH_g ` & HT)wyQ;G0Hy !
 =Pc\{Hd
Z  7/e5@eJL7`IkIy 9{C 4#O5#
En 2*a{6Z )L 3< )b"y-
!T  
  v$9d? .*Z  2 #{gg(Bu $boQy 2 n]*	W/ %+ GZ C
6I $j gC6,z;;; M)V	N(yD dhZ  !|"YZe ~+y  K 5L	V 
 +6
Z ^m'  $5Yci^'540yR(x* #-	| (l (/)Z JU|Y!d X{yM 3BG		 Io><&
Z  :&]  x:b-]	#yxDC"  Ic	80AaNXVt>1 J$Z M`m)la 	6^Fqy~D!%0>v	 0 B'H1 l<WZ  Z# Ra%y~ sm 4d UV5	"O, V# 
 ] 	 Z *e nd5
 b  ZNy}6WO8raM  	 +<\mbs,:Z  +  {ciy{ ,S"l fC0 S	e;<a@A V: 
Z 0#C
  c ^  +zzIo ~f :	  ]oR Z T Z  0 PtA`F]b^?   yy 1M?\HO> v"[	7 30 b/l 5z8.1-~Z 3 ~$ S= !
bD <yyoC  @  U	;  :w = Z  WDCeM
`U yy  g[	bC	AHh  5pOGm-Z D(_  O  a%Gpyx(nJ [	A'we u 
        /"          $  '                                                                                 Z B2nya 3R zx p=R-i0	A .2 # 5 AH1Z  x[* 6^ E1 .bJj%yy !U 3W ^	A>+C  BA	 Z vh$1 h- ` CM 	yy55@:Kt5:	A @p | 7RF(kjZ     7+ۂ`0R.c`zz ! +  I s	A:& > 	 p
GzZ dvEA _ bN;0(  zxc0RZP%(   n:& &(mE(f
5Z  XS/V~ 52/_866yw TH5| 	0E 2 <&AuA! EL 	 w @ DcnZ <oG H u_ wFozxnG M  QoyN) Lo Z  JK 	"!MG_S  zy W\ dW4e?T n  rRH B RZ qW p fYf _ = xZ! FyyHW9 Y ;S$7  ] T/X dY3v  \5 Z  `[:   WE^_ bWK	 yy }YKd 	-_Q6ee 1 d 
',a_!Z `[  } X ^ Yeyy_  k?3 
 ) { ] J| 
Z  c qHp&_ a\= 

xy [/z ` ۏ   I u	:Z  ws{  $v |`m=zy 3 C !=  . !O>  &? Z  ( 72# J}0 _ "? ! ayz n AC Z?  A (+z }EE$l 6R  .L& 2Z  $~R!A )( S  "j_Q
P  yy  Km ( G 1J   lQ  Tn IZ JV  Y, ^ X: nzz WsyS^ 	, O  J 0RV9U Z  rX ޚ O XS_|Z7Lyy Kg^e 
a ab
 J^  y[ Z ]q  c _ fyzcsj 2e;m poa }T ~IC(Z   5 43`y*+zz  " X  m@N    | 6cZ M I*_ 
t` V~+yy I 
F2 	m N$wy
c 	 ; [Z  :ܬa  ݆xz    um = <  2-)Z ,S#8~ tc( ` X *a 'Fzy`
 Wup m u 
A= .p 6Z   Y |b!&da  u  4zz S{|4s+m o# z  Z  lo{ a 0>B']\zx8. =k`m N[_Aw' bUw lZ  \ 9SRzyJ6` W;N) `yx  fnݼ/ܮv -    y *ZZ  pA x L@=` Oyy _( G j<v k_fZk>  lR Z 5Zodw#p _ p  
>yy Qfm(#W/3v dkH 5z s BB4,D($IZ UJ/  v  R `bW zx 1 ^  c v` & ST t ZE 3Z<t< _ ^B Rzy $IzOO( !v ]P  ;blM}'AZ Z s jwJ`[ Cxz [D7   D?zvG F S N_   N33ZuL5zr : N4 `  Q?Z1yzR-L  5O  
	 ]L,  1P@2S Y6Z fc"q.,q fQ%._\f!z| f : Roi~lv o q oUZbJp pOPf j`  dEv z}F [ Kb   N
IU$ 5 ^* Z  _ 
ێp V_ . Q  9y kRX WX U  P0T
Z IVRo [f  _ fbWyg4 bh   h h;
 !cY  Z  lY  0nrZ6za F mI /y  &( k!j D Q+   W 7=Z >m [=Fb ly a \?M 
3w	 dEZ \_Bl*db W0_z  B#6 [ # g  W
5OHrZ  G  l  & 0p` {y 1 2 8+. b}-  *=~ZK=	$k9Ua bU.y 2ZQp6O0 PL': I!I mZ s Kyk P Ps;`]NU
z  ^ | s hbl*l R ih:z  b?8Zi_5Rj [&|
`  V#z}R.
`N?{ .LE_ P5'WgZ Q]j CWlb]a%yz u+.$ &(HjI@ O  i 
jfZD_ i ^ _! _  `!}y>d4D  -b,	P  W 6{-J%&2&@(`Z  :"/h=] `yB]{ ED;	P1  -'<8 +&Zo})h g -  ^^ .,{cX&+ D  S 	P ^ !!t-#A  ^!	 Z f G$	@ga+] 4 ny s >	'WI	PQ"    PLZ3N  g Rl 6^X#yma)  1 ]
a/Y 		P2X2=\M/*. S F.2 6Z 9E83Vg9GA)] G GD "z HCF
 S+?I	P i=Is 	 J qEIFm8NK Z ZM ng  aRn)]ZgSzaU  j X`d	Q;Oy H fZJ ZqkfI^ f y f
xc	 > ] tmR5G[j  xZ Q} f  	Sm^hOW z} 
 W\  R H] 	d	jW
  PO  W G	 Zf+C; 'fdDv 5a^ ' H 4ayzqJ  *I #[	 Q K 
 QAf Ra OZ ` M 7 
fKC^TQ zy  Y  PYV	PtR ! U6 	\ , 
\CZpL] f c^- 6] ) Ad1PzwS5b8 % ]69 \	 > \2`ng_5Cc4 Z ]d3zga4_]Me9Hyt _+m9  5r4	Vu1} -+y0 0T/Z\-g B( f` $E$zsN`&4V  )3+ 56	 & C=L,=G7Xk$ x  Z = y> #hVAhOd 6  zr U{g	v u ^1 4gnZrJ  h FQ e+zpW  Gh; u	rkSP 1M Z  PiGZL#/a 2
 "{q  ScB8HDK2	 oIY 	 4 BZ[HD]Z ZH 	j O0K `\`jG'zp?z  K[<# "#	=+3oC
A  5 BMB -Z#A$jd 5> !_ HJA 	 CzpuXEK[L[	 'mUQ  SZqAe]nZ v 
ak  Z_Vn~yp uPi  ? P6R `
.NO6:* E3G  Q*7M Zvv7Z!l6Z _ Ho89 yq>C  
. VBc 
K+C
 
        0"          $  '                                                                                dJz Z BV! !lbi_Rk
 zq +nr    x
.U~ 9
 
9  w81uZOn6Vm lG 	._ = i %yrnrdm!C |b# 
 G
. M[_V|V IF 
Z [Bn@ _A | {zr UA  $PG@
.i;Jr 9I& XFVZmKo 7S	 b_  3Y
'ysoY4 WV {
. 2 S+~oN,( L$ Z EQ 	o]{_ e  
yt crf	 
/b? 
f +[#-  VV& 7
V) 	Z	Y2 y To b[L /^_a{W  6zt?d 0E U_
 &
fX!wP-  d 7P _Z	   SZ ob: 	e^ 3sd `yv < a  |X" 
fTW ` OU V<QZ
 oXT 	:o cZ\p z_czw (h  [ ]j 	
ffa  / Z[ 	Ze[dp@\u^ e[" :xw ^GR]J
f .Z	   LW
i|VZ 1@[w  o ^ cX(_f'~zy &d - CB[6
fzZF1 ak ' Jl!Zk io 
b#_ }Y-\{z[9a>
f \e2ub>e_Z Jb =o  h]i$&
yz ^d; G 7 E]
}_ pۋ !qa-E ߢ  c5oZ
an \ n_ fY{/y{\2  ` 
  
} \Ta  ` a
F  Z
 i^ 9n3\_[ Nyz Kc& - gq/
}F.Y+> [%w 6I  72Z
&#)m H0 "zb  _V4 zz, 55 
} H / ! #A PZ 6 x!TmG` , qzz SK, 3!|N
} 1  	 c+#[(-Z)2ފl W-.0 AaH6&Lz{9D!mi \O" 
} V,^8 Ssi> 	Z  p=vkr=b ;mE 	zz  cQkYX
Z 5 QRc 
C c QEkV:(Z 
 xU2 	5k A8R.3aP.*FyzP0 #  mxN.R  
ZN+6P+N   aV. mZJY/j4X-z` MW0g 2z{Y1d5P
Z Otj?V 
+  -j]
f\Z 9(eZ 
i * ha cLyy{ 	 S  , L {  
Z{U	!;  QdK  ^0lJ Zm*hj\ 
`  Pbg 
9yyeoi 	
Z ^kh .4]5S x  Z RhQ ogQ1&aQ  4zz 6;S4 4  Z7+
Z]# # _U 
  ( t[ 	 ZtW_f  U) 
` H TPyyf]Sc" 	R
Z Y _z xZzZ jZ Ope e"k`o : z{ Fl` 	KdMܥ
_4 cO\ 	 	[#Z_d 5*m  Ja  xyzsSz,T  r 
 3hKnc 0|a
 	Z uc"zdh
'an] 
(zx p:{ #jYmmO3
~d 6 5 *Y\  ,[A$tZ`  b  e 
 0`gw+yyg2-  Ta 

]nL[j + \ 
OZ G[bZ&` g /\& xzx i *] _pap
 a 
5>`i6_0Z z^ 
a c~Z `\,zwc  jsh. }
+d
lu]  Z9 	BZka aur9b f Sy >yx C.KK	 _ jV   B2C^963Z  .]a ' |E%TclXxF!5zv Zq  N K ~7		K   s Z%"`%  ub 0B#5yv a5	    
MV0Z m Gۏa !VbZ!*ys ?5Z  & p_	e 9>m  ujZWDa #?j b s52Oztc>p X	 :oQ|
  Z 0wa ,B6xcpD/ys N&2 !d	W K Wo 5 
 \[
ZuOo8a VF?b x<XzrJ4 56 A	R JAAoR `	 ]Z nvkawa  
wOyq 0pal`F	RTO ~~M/PsZNRb M
#Xb BEfypp>* o=  "	R ? 7~V4% ^4  Z Y:Xa*>o` 'u?^ .zp ^C 6HF0	R J Mx  'K xO!N` fZ R9  tb W.9`Wyq cUx ZY } 	R , dF .r ss }) +Z + } Kan	h
a nY&  yp ^QO[UZ?m	R MT4z 1 o E(Z V1 za -E_ [yq b  +	R4  l  p IZI a +  t^ 4 Fzq 79i,E	 
>Q 6b : H62-NQ3(gZ eZ "*` [ O_ s_`zr ua_/ 
  f	l )6m * y9n,Zt` 3 y N^ |/zs  &{p  }K 	 ~,% {{ۼ Zr Z ,k _ (jp`p ]zt +p
  E 'h	wa `" 	 j ff+$Z$n7^ WyE _ w Wryvb  WF\R 		 %L>:p) ! - 5Z s'3[^'|)a  )~ "zw 0 &13	%( i  .9 5 !H&Zi U\  c 8zy\
w k83 	 	 m !>+e o6 	Z  r&+_['Ka 2 ] uy{  
B	 % !2  J%
/4SZ  ,<2 Z I  Pa 6Pz~ T   [ I	 b e a Z `V''TYH/.5<` qD;p 
4ey l !RDX*dCd#W	 Iwp6 
   y CIZ V
5 
X @bz  h 	L m&o
	<g =C T  Z  W  \b  Sz @M* -	 Y 
@ Io2Z X 	fV d YXeqz ]4
 '  ! x	`B - % !  dZGU  ED8 
"d PRK $ya"4+m	 
53	 nq
$ 	,G w8$M}H   Z |>F  S &_3:dv1 	z j0 s V]!	M d c= # | Y/Z(VR M -I d  8 sIyrC	 0 uL0 ށ	 L1 4I{  G
l gZ ZH4 QIdI
  z J  %G	D;  . > .'Z*P b0 	>b V6y=
 [<s !	 ^ V8
2~>5 5 I -Z  O $N~J!c  G  ,y 6BLCM	 (C
C  uCH7ZL QM qM!  bISy.Hd qJ 	! 	kQW gh[ ۬Z ,X/cLyRsc NS y S 9Y
sW]|	!  ^
x : d ]  
        1"          $  '                                                                                sa7Z  |m I  {YbIz}* 	 }i	!hXMOs  $P
 1DZWY6RH\6  /a q.W %zQ3!@|S ?	! ^X  
}]TOdG^Z & rd G %mbZyi tz  ^d  T AF`I	!f@Vv   -FH 	| g N67Zy'V,E]* Xa o `.zAc%NcU t  	! qc eWf Z ^3f* ~Dfl}bTcy B_ .V\	]5`c F e1 - ,l`*	ZGjUB d 
/ic - Nc t6zO(g0X Vku 	&	 O j(!]kW Tm-p NZ F mAkElCZbvm Py g9p q@	_n   R 7 hq b/
ZR]X 	R? 8\m c`{dS d 	`{? ]"  \ Z 0 _Z=2eLb f 0z  zcF  I= _	d  1 l ePteZqt` 	 ; 6 ctO@y^ -P C$? 6	&1*_K  '  ) 
!Z v9"9ld 3h qz']@4	  H0 %  RZ/Q<Z K 
H9  JJ d$P-
y\  8 fd 	cl۔j ߉ T oh UZn7]n* oc  gG 	/z{hasB.f 	 jv 
^OIY4Z 4 77S .51\c%(2 9{x 7_ r <~kq	<* ^> 6*  KC2ZTF)4GS "oc L Mr  zuF@WSbw* 	1i
 l8Hs FZ &5|t 2~bqv* 
bys >_p whsU	Y( 0RC}i {0Z?$ W1   	a-!zpA#K d1] 	  `?n  %D%u CI` Z FW  ^/LWbP[ 	{n 3 Of V{)P{R  4X z_^(}Z5ezU5.Dl:
 3bus*W{m&i|Yh#  +  d,Ql5 & s1 mZ   d"4-/.U xa K  
1zj L)!U :Z t / 9 Z&
HW/5ZYEz , 4agei b_| ^xhX  ~ ~IT;s]97   I= Z{NN&,sw^b xj 	5yg i2Lp 2 iOwsZ [0 	F* ) M %cm{_$4zd < 4 Z +Mpa# aL   G
  ZWv)e0 c Jg ezdlKv_ e * #up  vZ -|` )]FdomOyd -^ 
  =Vi܊Q d 
S&  3 [)
Zvi& )' {% 5d 2c+yd~4 W@ ss7[ 	 pm.I Xs$  "> Z Zz `'py2ds[ {c q 
#3^:5 En 	-
  ;HL${Z; & }Gg  'd W Q qydSX)_ 
 Qhly Pi HZ ` ~%:V3d  QF 
ye ;TJ 7Y@j ]0 Y Z&  jU!
Z[ $ j| e x	{fMxa wk o " [ P SPo 3Z \ Yz#ac ^a} 0zg ^ 3V
  N 	 M crE
 A2F86;Z n K .y" O%fc  AM!:yh SD  O [= ~7 
3] 23 "Z 6! $>9c D -yi 6 nCb@1O >   C  6N Z W+ ۇ  &VcN
[yk q+F  @m &A 7 G 
 PZ ^Y* 6 f[  a X?Dym 5S  P	 L-  r 7LN
 O\`aZ  OU 0M  1P@6|aBR,/yp Q) &L o N!o4K P K :  NhZ  L< V1I$ >` }cDyq!@  Y ;% D :y a~:! b 6. Z  49 f];-taH Xzs O [ LM 5GQ A 	  7:ivZ  <5 6 X_ [ M:gytA bcD " D 17B gB& 
 Z!E   DC~` Z > .]zw = 6B
1"  AE 'r G ! kkH( xZ! aK# 8  R% R` QUzx}T	 
 R  X 'T7 H_{  g EZ!  }fTi 3_
W_ Y Ozx  UU ۅ RQ? ) 9N% QQZ! r [
F `[_ \^	mzy R e_   d A bec  dP, _Z! ~n M| _  9{{  
D1K,&  
6r s k`2b(Z! e 	"J  
  ` z{ ~_  +~
  s  F gu @ f[ Z! p_
 J =~ c`   y{ T0 *    k 1qEKZ! P  omb aay{ {   L:- t>t 
  e{Z!
 y  c M)nz{ +l 
 M s/  a; :E) %/ 5Z  % 3o !>)b c"y{ 
Y   Jg3  J Z![Z &i  {0D %a  E?	yzH\ 0K	 	  K 
K- V D! Z  6+܂ "7a : W?. f{{ IFrJL	 Hg  zAJ  '7rTZw.0   2.g O_ $^01y|06 4> F	 G3]0R| @2T hZ i %0 ' *5&^ U'Ic 4vzy s /+w>K#b	 > Cc    =l8zIZ  ";   DB@_Jt{{Mvk I N+ 	
MEaK& S N9 -Z gR&' X ^ UWZ hy| 1\'e 	 R4o"u 	+ 4 7x,t&x Z C q X  q h^sj+_z| . {n.y   q81j	Ajr&t   r(  ApuZm+e m} _ p
+$\y| 26n4  |n5L	A qt ,o F}t$~}* Z '/t	 
 " q _fx)y} <2 	 8 /	A~'t :  4 ; :ZgPs  }t"5 	 ` # #y}u#=d q   ު	A u1 )K 3
 cZ  tW
`
=	  y~ E+ K e	AKY R=	+ E 
cZ	%  # `	 BaV
z~6hg
 A 	!	A Q2TS5 / ! -Z $  
6!b E h ^  ?z} jPV+Ld	AA %   c+
Z{:
e  PD  ` 3Fz~A E B, 	W=LG-\-< b@ ۹Z^Z-\ FXa >;V  z~  V 
\	W  f. B s ynx 
        2"          $  '                                                                                UinMZm i0   ` -baf[z}Y  }Z3	W`HbMgE+   k'1%ZI|k_6c h	  /%b a %y}C.Y!MUO K	W 3L\$  & 6gg!Z e ^ .  X(1b
Z=z{y dQp 9 Kq]	W ix_ euV  F pF >ZXq: o@ kb  `Zy{ nTxE,[R 	W n I{ath  Z Sig7s   Y^TcGb,zy x[kY ;on	"Am>'j /g&	Z;b   `  /Fb : &f)F6zziVo9W0 y< &	" d;>!:6 ds y*F bZ i 	 Aa]Znc]x byx X*b
h"5	"l8 z a WGi7 cq!Z7a 	 -j* c4wzw~[ !} 	"|g'9u cL ZRV UO}b W 
(yv jh )CUn	" Pp  . r&[hq7KZ  iA    .hA  cZnAzsRqC - eH/ 6v	"~V`H1a<Qs ' +%Y !Z(c a "o4 c{ _zs^t	" |! uBQsXrZ mkT 7   9fg dOg3	yr l  ! r =hsۏ )lR ` ? d2Z` ^  gc  aJ $yqZg"[k P  E@i 	hH!*cF Z~ \bd 8 HbMch B{n ;mx d lL -i* 8 eW 6;ah|3ZNlr)H  OkZ "e qh'  zoviV !tn7  w @2sm aZ 0  5>x%dy zkn~" CL(0   5" f.=Zof Pf dL8zicuCp B/=   EF{ COH C W0= 
Z  hY ] RBd <Q 
zf [wj<d
I  j  noU(^Zdi 5  c  4e@cM*zdlh #&wyG   3 2 Z Ue/ *PdM) Dza*UFq+8  1d @  C7m
#=H 
Z G. 
]  S4\e%\B_Rya 	[A 
 	W#t Uk@Y  +8fi Z
_td0' >lu} c &ek =z]bJf  
r 4y: Z
 X6@   'uX!%eny{ 4y[8; 4 h  +a#    )   Z
pVM^|   
g =,lxYt||  i Gn  )X `L Z fg  e[  xW [j ܀)5!NV4 	UZPo   Inh 2f t bAyUB'^ 	) 5!\"\%K ;g - Z EGc Ud iu  xS Nj "3p){|  5 HLK-1(5$Z`l$4    89/   0dCT(KzR^m : 9j} ) OGg5  	;W NZ Bl Ld \ zQ O  )s t ;
~YZ
 F   mN z ReuzP 	 W @u&d)D3o VE  -Z
=s <)d J  #yR||:x -x   1s65Z
 Y .  & @ %ld["!2yS ! 	 E [ *%	h@ <  f; Z	/  W 
{b t #yU , Q M h@@& RY9 Z	 hDlN o  n-{`$&mr yW U3f  "FrR	   :Z  ; JZLZ	S
  *HL a [ J -yZR  \ 
 k(^S[
` VS Z	 |[ 0 w6ua  /x^  &V
!j  G  
9 GzwZDY 9  |6 7b /Cxci   eFE 9 O (^
 L<Q Z n  b 7; Kxj  d/   xz A PQ @FoZ 
 Mg*y 
  a5 
Pa  !6byo 
 |X  4~Wy[ 	 a  Z TX OC Ja  .yv k B66$8(2 1) {5 't   ! dZ dSLL x  t Ea
]x~ INq } f%B , 7 ^5 B v k  .Z E~W   EJ{ 
\b f' my 4- 	 g (L  LD7J4 Z OE g  z +b82bNz Ex    y	  C  fgq   iq\ CZH`    p
n  ba   y}) x W W +? h 6U 
 2i + ] #(Z  "D   4  }c u z ve  NVt ? 0  ! 5 Z, Zz?c   
G Wc  Fs z H 4S 9? i "8~X   a~ Z  f0a   JEf_a 9
De _z qP2  1\O? ~ e< k  q#yZ qD   \k 
bbqx\   %^ ?  ,gR  5q )wg|g 	5Z J3  5 )d  "z l@  2 ? z   o Qn@RgaZ  GW n . R3l(d(.6x ^X  ^  XQe
3 ,ps  ^ .Z Zlܐ   ,f dZ9 Jz	Zf e K 8 b?q # PZ ^Y   r AaTc ,Pd5zaO$ R zG%N i a 	 l @   7Z :
&   j 5d yb4y H<f+< #l #|{   L   %b ZZ     -KcpkC z wu S ?C4$ &#d- H{6 
^ };HZ Pz< d  X P<: cMBB݁{J R  p S_#q'  Ae Z SL S  ;Ssb p M__Q 
Zy  sHZ 7|/i	l  y,F qZ  k P ~$B a [$z	 3  K 5W	 =,Q $% 8+"u  Z  E
(
  }5_ D 	z1 T 3 \ 	 (,X 	r  CU61^SZ   nN  z :p@ u-_e*z d 3R +A2 4޿	 !zb    FZ , xY ^ h1c y  +)M6
	 :  68 6|Z  -C  w 8a1]4<z(iz  w.r 
i  /a(!F	Vy2 h @ca 5  ev-Z v
$ uZ !^ B k3p &y,S- S	 U &5D.%4Z  <6U t ,7$^=0y~ OQ.~  If+	gvs7r } n[ M 7X۟Z m{<- s ]/ b\  %4%zzyA 0 uH 	g ] gCp--Z;p 
 	       3"          $ 	 '                                                                                 6 Z  o 6 rU?c]\LDzt QYbF	gg] ox}0Z ? U6h p i  /C\ oJ%yq6!R V;j J	g EKz%L[ A ^ Z  VI, o7S^ V& yn 8 6Z$2VY:
	g 4VP  ` Qw>z0UgQZ d  " n wp _]|tD{jsrvf zBp,Op	gq.FvL aq^  Z 
gx nmfK}] L/ny yiar./8kl	  e
   [#F<S;1	sZ   UN  m 6 R`Rb/\YVoVH6yf {` 0 Y p &	vu|! p|  e v?riZ i" l 
unfy] j?vjyd%w.q 	 uCgeOceg!Ur&Z  >g\ 	 kwo*_/D.yd 
8X g S<	N\Cg c$tZ >sz{K j $-rI 	p_ N teydV* 89 ,	 IQ` h!f 
Z  %2   iI%a~(zd \+K,
).'6n	c4o1 B : (
 U m :"Z HD7^ l h X5h _V9p{bB@? &/= 	<,7T746?: Z  TC?> g]B@p^ ?;/ -zb a I<5@1 sv	 G2- ۝ T O2LKsR3Z  !Q2  g8Q5` k_V7B(zbYf5 #  4	 H3	c3 u3 Z k4J2 e0^  k- 3  7yb L jI+#@;-	  9.  	*  8*(6#9:'	3Z  9'? )W e =)"_WD.
_ ya vL0  lV-i	Z,	H.W%   YT^Z dQ	! dR= ^Sz`;QAP!	 TB  6^_j B:Z Wm  ? b`^IHCz_ *8 \ : i=Y		^K|	X  " Z
Z xWr a qV ^ I ]
y_i?l	jj  H 	l rzms(Z  WY  5 `L
=4(^uNLl  *y^ 
_T9 #0+b 	lJv  } 3 Zl , _ C 
_  1|Cy^ij Z 	l  ukyIFS
  
 KZ (`^ ^Ic` 0  Fz^ 9+v{b;y	l_^ > Es ZW   ] Ft a/5y_aV  	X4 	lx/[! >5 Z KL \XRy%l_ Kx 4z^  >
C5
rJ
G+	l X # 0 
u qQd Z M"jw 
 [ .'2 ](ry]0 
 8.8 m	l9,e;  ,:? ZH  ZiT# ^ =d 
Yx^Oqw,]o} n	< k^ . H8H  Z 47  Y $ =;)^qv9cz^ 7& 2 4 40	<4AM 8R  F;@Y  ZHXK X =NOg \ WPS@ px`T/"Q!+ 3B	< ?zNb 	5N"Z-BQ* $Z LV, 
  WpY* ,][) yc D}[* 
= `,	<jk.Sn1   ;e3 SZ~V8 V 0I8 
\ T E5xdnH2y N7 
(	< N S@PߑjXC :[C_ Z M]@ U`;[]b9u ye Z[e9u4X	<0  J1 (3&Z7l T 8s=u _ Dc!yiP3	 #ok> K  #yv1 ,v 6@Z 8 eL[. RU%b   !9zm P >B FQN
 #  ca ~JZ N 
 Q m-X ya|S+#ypCk O  i^` ^a?"J~  XI PZ 	]~ P@[ y` STt4 ys < V\ E^ 
 T XX3XZ *Xy  O ^ Yu saTqJyw  TD  y8Y  aEf ve 
U bb Z\0 N ^R 6` e
 0y|#lB&lV ! sm  b iqT"tZ ^x 
Z L %z [by D 	 G Aa ($  T Z} J  % 	Kb 	ay&  r  }LmEn 7u sZ	 yyV  HvGQbk 2 dz ^  y\Yph | dq 
  n Z	k  G lk
 b S r
-yxI6 <[{ 1Q Y |&'}! "  qZ	 }n  EXe   y    _  c 	f?Z	9  o C 0 
c 2eDz[ 	q eE  C_W! t  W(X Z	 7\#p} A (edBc /k Oz  lnd % t5   wU $P'GZ
 
  ? R  ae "z $ '65 F  H 	+sNM6ZA{YOP 2 4,ST (Z
!W"] <  5Tc dLL  zG [D% YF5 	?V]. X Kb^ Z
 af & :za leKcJ y 2^?8 2
 YX  (*\  Ph & ,|'M ޺Z
9 y 8Ik -[e\OM !czowEf  o-h. o Y F{  zb tZ
3y  6t e jz?x #  ks < TVy    )FX y|5Z
 srj 3 4  ~ *e a d 	"y  E o  lY* 
a`_ gna Z
_k u 1]0d  d_ z [}[ 	w* 
Q  %YdoZ	ji ܩ /  ݴh v1z	O 8  LV\5  . z FZ	 ,D8^Jf  * zN " B5"D a5 	  jG* NNQZ	
Nq & * M[ 4e(N4zdQ) +R  U# #_Z /_{  X ec]= ]Z	~oaAC (Y-]  Of P  yLRUPcR=a Nm f QGSaZ	  C  &  Ie0eU}ݞz wW0A  ? V}fV [ #  YZ	 WO %S	  e f ^P  XzOR fO  e M NUSoZ C[>A # s_f7^#z | Z@ 3 XZ5p[, (b 	$D f  ZAf ( "c d e2zUjpq v|YM Z   L[g	kx| * l, }>  CMZ}I 1 f yzoQ b    ^"K <w Z  8_- {|xHg  | ryz q y

Sh!#   Ww52 RTs6 ap.Zsj %#  o_!'hN IzzN
n? [6V4H~ P2Tye:*  CZ C2Iv LbBg O.8= yzj47 	 C$E  > :YmHmۡZ   Ay@     3y Uf51syz9f s 9W 	s.J"(x&?  
 
       4"          $ 
 '                                                                                 s#3oZ** /' We 0"'yz2K=	 !M
J  +YS
7 L0Z J
  6o  & M/`erQ&zz AI=  !\ ~ 8 \ P	,0 " /   ;"*ZD	3  Ahc g7z}57 H:	 cDP
Ua% v Z pco( N 8hFZc]Tey} i\D5 M EHh	 Pv r`Wh} D^7WZe>k  UHr. pe X Qc<yz$ ="v[ 	P  ]+N 5 T3X 	CZ  a^ S g.d ]c| 6z oeMa0pw'		Pw ! xGy& ^~>IgZK Q$  pxEye]<hz~|: p^@ 	P  VJxjR^U
& rag 5Z h e]	 C]Kse eb, jz~  e^cdskn	P Lb 2 w_ x^0uZ b
H G  jf ed!ez} `v  ) _D	PN]v H^ } > _J Z a s f + ~b! f ky| 9],V z6\	P 	S3 1 p cX (`a "Z gh  b  w td !{)ozz ;vy 	 | pj	Pg &df  JfEZl:  s e z~Dzy%" M 	K j	 ۚ mS&J Z O   -W]dXyt wV  H 'Z	K_^w `^  U ^RZ 8eL  1mG wd be  "zo0Qi .n?; 	K g;O*UGR6 Tx 3Z  dZ8)c b"d h  zk yf h\j	K cg% zN ^OZ 5  Hb f .lyiP Q l<_ 	K i 
 8%  J-.` -Z  W ;.	 3'c =  ye ^,?K	K  
  o}+X$"0Z  #7 L  h#Qb-+aya5h TH 9k$	* (l<rbC} @Fc 'Z F{j5R kGq4b WNg *z] ` =\at#hZ: 	* PquY  6 ]h!^vZ  V   bG Ducv0*zY m yu  h	* 	E- w 
   bZ '"  @+ f 0yX W0Q] =-3 O	* 4(e "!sSmL _Z d 
  
 
5cf  oyU y e w 2_	*GAI z SZ S  8J; %e &@R4]zV >>5 0 Bz +	* <yF #FW  0I 
 
Z  /O6 |  	Ze *j gzT   ')^	*%B U( ^zZ `XE  b:>" e l *iyU&E 7A+_ ]	  I/*vd8G 	Z  F \ 0 }i!d 2 \1
 yU p3:p3z?a	 (E T 9kO[ Z e X  p!k d +kfMyYM;d2"a WM` 30	 Pafc5zG-l <w $Z  ?!	 	o 8e !EE y\ 1 -
&O	 6
  V U<m"^Z     G $ d u&y_  G
 * rI  t	1 :< 
 NbC 
Z P v^ 
e  Ze% zf 3d.bF b	 ]o]j  .YzVT; 5Z $2b }   ydk,zl  p( 
 K \V<y2UB?  19N 1 J !8	 6_Zm!8T.  ;(62 %c! H 00 $ !OyqI3)9 W1)  # Y*-K 
'74k+?  -Z --39A   9% b!> 	7zy b\A  }@ x9( u 9 +E9% U F! ZkT  ~ ' [ `a  9 ]L  z4]  ]  _ ~h 4~ "w Z ; [ )b u Iz T(Nb t2h@D	 X v\I 
&[ZI / BF? 6c b@-0"y<S 	& P"1 ! y*C  bk+ W B 5 Z 3C 	]yHL 	Ya  Rg z , T jcVc Y	 a]   P k S 
	Z  * "+ [+. sca ]y [3   	6yP ;qs  Q9p iZ1 b Df N_
 Xy 
  		 b8_ n ' ^; 	 Z j  Vu)G e-/m+_ -y f, 6 c_/ 1b	U<7' e GF / ! Y3E|  kZc"?06>  Vf :@ y'E  9E 	 EE HJOT 	:Z  YW r bNX
cCfA 	y hd= \\@ۆ	KA  ??]  - F@Z UGw c^N :e 
 ^X Dy mae  Deiu 	  f^ 
eJ  &d>] BZ <dB 	gM] Vd  oS  	zloUC  %vS+}	2S 6K  YK 2W^t(Z\p "b 'xN 
 d  + qAyIg? ]E 	2  ~^LiLUE L yM  Z  %M2Jde!s zB z z8Gh\w1	2  13   ;BޚZJV W _X Jf!`\yO - 	2t	d  Kb rZ ]Rf&nc$f" D T# jzZI& K*{g	2 Q/ Y Q+)	DHN 5Z 1 O 3  FY*!e"da"ziA   Jj  	2h
(i> 
[ 9lf 	Z	{m    (g" { DHZd  	P }0 
Y|Z
J/1J,Z	 Xo ܩcݎf!Wz |PI  jJ ?	P_X/  d 	 +f 4Z
G\ Q 
Cf  ^zy_  w :	P <1y- Z
 JV&a^94g5dl  4z 2  +h#	Pu
  l  -VZ:<4x 4 IdA/z%/
O 08 		P.HX-8d ! 55 pZ  < COe lD ݳ{ ? @ ܶD@8z	P "F?  J;O/dZZaq  B T`~  dVNzl7O=  (5V% a	b?_&#
a r  
 p[` 
kZS- RVd pjZ #z} k __3`5	b 10] 
, > `d$SWi Z
 q"`  ' T q Gdnyy bk  k 	bo'~j" = *
fZ
ciMVv  Yd <1" {u-w{8 	b YBhA+ 	|]F|O^WH%Z *>IC 
 <-odC8Hyq 	@
Q 
w 1 \L	bpV*  aF 5 S j_{Znnu jm= /e 7 j LyoMi
j8  	b G2p2Wzn6d F  .Z gh~f% tvi!e i_ V 3{l xcL  e5Yj	bz3j$ gk!
 B bk)ZQl1bd fr7Q d  _ x?]{j}C  0}C 8	P K zFuxS? xj~ ۆZ ` v~?s)0e" u~c zg ]{P 
d	P '|" 	 g|  
        5"          $  '                                                                                ;~Z} 	 q Hf  $hNzfg A  n 	P (w@
~j Ec~- 	0Z - ~}6k~)/xf <;{ &{d Z ytRW!_m P	P  e 4 a e?qk~3Z 	 v 9 }V}mgBzb h@ > d	P' * X  ZeMsnAPg W y` lW.sHX	P j wJ6ZLe+ 
] + NWNhf\}{_ ]hn   }X}	-  9	   w%	 Zz; orN .f
 O5oay6x]zoL0 "y  '2	- ! )S pD zZ y :rph_izz^ biE  3i
	-hr gcdS - 6 cEZc	 #Pf g ] k Ny\pi C p7 S	- w ml n xZ x&sKtthi 	 Gt { y[ oy(8}(	-#  =  U 6$ZzX(   t- yl
 4JzZ!>;, kN 6r	- Rqb2nYV(P ELR* "%Z H 9 }j A
 y[ i /?	-  = 	- _ 9 >dZ BG Q |Ni
NxyZJ  r rZJ4 	O
۴wR(  xcS Z )U"[p  _h	 ]\[9 
zZ rWU	 C4V 
 3PskCbZ . ;  H?jh
G yZ mL 
 2 UEn|	8>$3* ?:`J 5 b ;31ZQ=)< "g U :L  zZn7~- 	 \?$( 4 D$'@ YZ T*1 	 4f<  zzZ N<J  &tOU	u@4W# -  i I 
(QZ+
 M - 	f y b.yYW0R 6 
	 G = ^iCj 6D\ Z  H` xOfU zZ T3XUY?	_\    UI]=  TN'ZGO5P gWDPe 4De ;mNg7*zZX#A BRX8  	 5XmH~['7 & _ Z ] 
b`>-Ec?e 
 cA ;z\ C db=:_	 LX	 B Q Qd
VMh ZT  g]>/d
cx^b7 K :%`~ L	`a. e:    L*g`> jZ g}fse -3d 'y_  cGya*	 
` ' +de?klBZ  l( w K Sd{$ek`=4^y`  m" 
52 c  2,2	# E   [o ZWH d N=A yyf;vv77 l	 LYEV + *}6Z Rm%B  +k
ezh 6W  ] 1H	< #$  O NbZ  ? b P vym  z) 	< g	d DB, % Z g75`D`o  zq d}3 "K3	<V55 Uz= -~ ~Y $ZF  !  @_0~  -` 0yuwBEF  S 		< . X
AoPE  >n QZ H ./*M` ;? yz c ?O3 E<Y0	< 08i 	 vD7~  ۳1Z, 	 gQ) _( ]yh#  fi ;	<Ik
 hg Z }W~
g_ ;J 	y + "%l< p	c P$Rg 
;  X1tOj6KZ ) B . x ;s %^;!Bz B 
 H wP 	c Z` }OS x@%&Z  06N ,G b \<1V +z '7bxh,Aq, 	w	c E} S?H0$SZ wfN h  |2^	Ey t  
 U B 	c  +  ZZ }Z _
<C0z oF x! 	c - :2z 	1 aZ++d /5#!6^Td01z -&4!	c {H  V 3e O*DZM  [ >R V^0 Vzq kb_Cp][	n} ({Z 	&Z  <sx _mx `>hw *Uz }ar _(_s 	n+f|C )sq 
}w}[Zt{X  0 3_F|& Iz{A V l_ 	nq ^W] X) V  Zr V@& SV_rU
 
-y  U 6vsX  1o	n a^5 'e !fKgc  ^Z g 
{`>irR` lnz {v 	 L<{ 	n I8 ~ c 5Zt >y& 
`5c'y]
n 	e|	n vi ߛrvjF1 
Z : bh$bp (x ) 	 	 P	n ] s\  > -ZW[ `I   FbY8I zkT [9+F	c<_6Cg2  lL (Z fk  "nv8f( abT 	yd  k	cm l L n	Z Wu~ Q P 	oa/zWD v 	c n	WEl% 4dމZLYE R
@Ka VV% hy A P[]A	c`_ 	 ` qhd,{Zf  {ib rSr{R~  V U	c:&V=(k o 5ZhO3rl*Ec EE#z5 C  w"M	c ; (n   V'zp[&ZN ( | 0+93f)z : ?'  ( E4	9j(
k,#   $ Z*S,݇g A}+z 4( (,E	9+&1o  y6S57Z V2w  ={-Ef%zF#*  D ~%<	9\* b ?.!   |K-Z@q'&0!S 	4j U q4z{%L+N	 #	9 Hy   jZ CkSZhv%  zx FD4c Z54^	9L  .So jZ  gh f 6zuf;Nܣ N 	9 L9v? 8z Z * FGfe 7 { Yyr jvETt	 
  |W&]^Z j	 0 y, :d=#~yp BF   3 EN 5	 =#,,-C$u L1? !Z. 9F<+c ) 2zn  s(qE.&\	 eG'=  v U(dW*L-!Z >.7 	 EB>b	Mcyl YC q wo'b=	,9a ANA G H/ $ZQW  a KhR zi&I}C"D 	 R=L9 	 6n@7kZ <  3 5A5aAy Gzg  H@`  >" 	I>v2E 
jD 6' rNY.LZ5U%G V<T !-b q.P    HyfJJ C 
	+?8 i@ <@ 
Z z=- | @G%a   QB^I zd Ch3 
6 Abv	B^ = "De ItۋZOzC  NR~6 %` H QyeI  %hB 
	  @h? 
        6"          $  '                                                                                	B Z 0 ElDOO` |DA 
yd P GQs	 A]eR 
 LUc\ aYY0ZWV@ 6{ ^sOP /`JE&1zcZN1\ !h Qf_  R	6	8    <b 
9Z <ka ?8I3 
yb F `>g	  8   CS}5b
Z |O  < RP`J^tzc ,f8 
 Ln/ P	upe 
s 0&S] ZE<XA  ea F@ zc 4/c3   L }	 Lee V r Z <#1  #.ah6ye i? 
0  y%'@	5N! * 3T  f 5 k0#  qZl8 2A _ , C$ ozg<A_  Dy 	 qKG f $RS  V <Z bU+ 
dP7F_yR=W zh ' Z; _ `1n+	`%"  `[ 
 sYlZaQ: Mk S` vHzjo#% x 	 1  ~
pG L Z_ Z  tX
   v#c
Pa| ym . 	  
,T!26f		 a 
2)  & (d i"+ZtAc 
 z R 
` zq   iQ 
	 $T/a  u
 Z b#TzLx_ ^ Z uC zs K@9u	H 
 RP ۶ X [. D HZ A `R q   X] 
zx   
[   A 	H0/Oal { As* Z = Y{D 
t] db  y} LPOG ` N	H #E ) <fHV5N 3PZ d X ) fcC "^ww  y w    ax  	H}V 6 Q 7     XZc	P  0d _  Y 	xzW  WQ 	H 9V S [$j  WZ <w  s{_f y =\\ < `a	Hh
  ,m K boZpH m ` m o#ytt;C @ sHO 	 s tsCv  v2 5 y  
']Z  w w5:y!4V` 0 4 	*y 6 #H 	   ? =ZS  1 < a %*=z F~o 	 MI
 -  Z fA>lP?b o g z y K"0	 c  
  PVZ K gO   \cy 8 d <  		 t T
 |Z UV,;o  $b R}^ 43z 3V52}Iz,A	 ~?w? $  "w   o Z Y  N  r ;cIJyz v *   q i	yh( A s=  | Zaa  * De  pz~B~ )>	 Qh 	^	 v}rR   Z 8 4Pf)y q%s % X_X	EK 4T   K/ZlFI m @
 g T 	1g
zGB!  h 2	 R VR5M1- 4 X$' $Z  m' !8Y @g - "R z j Zq;	_  	 }6FL 	4`ZX2h 
 S
7 d ?B{V  iy 	 4l  q 	۽ t3 zZ @]4 &L e 8 0P_ z E U1\+g G	 : +r  { *$  Z  u c }Jbw_z )s  X4n
9t=71S u736SZ "<.WDw%b H !@z  G ?C }
 QEn  L MZ ` HQ A|bp;m&z : 2 A{
Ew @ @   |=Z=` <a  K <zz=y <Hk
 O #R 8 O&Z M? 0GNEa#S 2zu U MWb
OYq2\cz	ZWq$ZXM/w _ TDk6`# 9Y>D0Syr2Z8& nV-#!
 S2 [gYU  d2Z l ` qYa" b lym a )3WZ
R 6RU%ST	UZQY	 g b!w ]yiJw j W
 Lg+ni #k eZ 6g@cE:b! (dSyf Aeygd0
 wbk e^Zm Z c^!  jaY` \r-gzb)o  6i
%1
uc'7b"  k`> vZdyi4nb  m y`Cmn#
 
Nq  / u	 Ev EZ cVr  ` jj
b ghg l{^ g  :k ۊ
li߇Y  n 
Y  lZp?kokR 0b M e1z\uXb(F\` 
X IZ.@2d 5Z jnY Mt @b}ry[ g 4 #Y+
	XN63aP 2   1Va)
Z7tYU"o	W   a S X RyZ{Wr Q	 % M*PVH:PZ Ok=CQMiacXyY Ra]
"T] 	z_q Fc1
2dgZ(_ 8/]k .aF`"UzZ Qd"i" 	w /" &r kZ'#ba)| 	c{Z 3c{T/	fW
  " h
(|k5Zy3 -s5*ZdZ#yYSz   #u	 )J
q ~
YZc{<o;3dCfIy\iiBo3	P q 
 p0gE  Z SQ  % 4kicpy]   	 9I&8	P5+n F<2C  -uC9 $ZJA ^QI6c tXLy_`JnH3aE//	PN`HcP ydRRZ _F %(U/[4cUO4y` c  + l#	Pem  p  	 
 [z>oZ@4T YV ]d  {Iyy`TIm7U]f  e& 	P hHzkq3rS Zz"X 6q%d2) yb . ܐp8Jr	Pu> k; ij3|Zm,y 8Mo- 
c r3zCycOx:|? ] ^A@G8	 r cZ ]B [WHc ] #0{g Hi 3nn 5u r -
 v- $z}:N ZP7{  3M1 e,6*4yg9vE. uU] 	~_?_ P9p]/ 
ZdWCoO eHJ yh 9FyJJ  LK 
 ~< [Z m 
 w<hXjyim   s   L M
 
3   xZm6DsT[ 
*g n\ 
0{l:oK'=R k  XE': 2Ya6,OC}  .dZvsv %ST !/hZF  DzmBbf  Z W 
   {W q ZR! s , h  0p ym]Zx 7 y C *:3 
nr >U zZ 7=$ 82% f}  0' yo Q*6% < 9 CB     VG  
 
       7"          $ 
 '                                                                                 OZw;X $ 
 9\0% Gf 3 X^Ayod_Q f] C / rk 
O{z) { z= 0]Z ; s   6lqF/e  p &Lyr g\qz !ssF~ UC w > zx& ;w?Z v r D wo f ujxqgn I hj CkS-yg% } b+ OZ / 1g!mQg JfmY 
\yt G pjSVfMCd
  K5d;qCbPZ meW 	T h `f]hyvfi 	 d"q` [ "   SV ZV 9 Y/ .Yf |_7 6yw * Pf=t1 =pE6 'Y qN ! 8 RL kP  }Z N  	F w MqhwM6zz hIL 
 u(FNZ\Rw MeV 1 a^S TZ5TK?
6 J6R> (g \4Cy~Jg(<k f  \tRN
  qI uZ Q#z Bc`+&Wgi.x h, - a,X.3 T2 Q W P3ZFS8 z ZA 8g  aL'yAaM,/ ^= 	6o [#2V8Y( RjY 
"JZ j[ T 3] |f 2a 
y f* @ju  l: H !p 
 sZ 6v 3 
m q g >g/y[ 
 $Y bI V b_   f  5c}5 Z  a_?  {_^ 
kf _F z  ]  n^# I `C  [dy  !!dn Z e  3bF 
ufcP  y g  l IboV )  uI 5b 3tZ kR)  j "gas<  y tG^|/Ox\ I Nw B ? nTs 	_d` dZ okTO " nL f hLl y _W   Zh 
IVq'  6,Xi   `Ha yZj<  -o ofXq 
z hR K S I D  5O^ ! :j# Z x&: ] 2qw#f 	  r! z q( Q ]tr.  s+  u  r'/Z2l@ 52 i- 4xf  e` v +zS #f IRc    Q  = P #Q Z   D   d r *q Jy ? 
	 H.   ? 9	Le V P,S# * $LVC !Z !LY 
  i0\ jd OX zKRY  `I 9 UZ@ 4 9  ^"0 hZ .+[  L" 	pe N *z  1 |_   $   8 zZ u    0 $wf~4%z > BG
 5M ' 	,i w$ +   N" 	 &Z *8  |m 
e |8 { Y$?7h  	 u# D y  Z >N -~ }c `z z ޲  H_F	yc:  u x  GZ 	N } ^ 0,[ c  >G ycY ) o 	y  fG M B  o!% Z >  E{ Jea2 
z I7 ! t@12	y'5 "' - {3$ZB!z G+ 	 @a  CVz{Cg  G 		y  PAvW \ Z
R hZ
  YNrxOY_%a #XE) z  U(W),	y ^C* `d۳ m8]\Z
 AkX w D] 
` *f(yl  e"m E	y 8|n %qu  #q8 "Z
  o fu_pa  s) z  s  uc	  2v  a dx b 14'16cZ
 
 /"s   %b 9zi!Oz ]y  
 K EyU 	 	 m]~  e t 'Z
nryqs a i uV 0y~ ykx7 	 sO@  lKp+Z
 ~ yF \q   v)bnzy{  4in u ,n)	wC  w^y  ~suYqZoso\mjb  oq&zxZt+{	   	Z  /Jn &46bp	0pyu P1& B^!	wG ^ ]_ } zMZT nl T zeb  g{yrbc  Mjc
O s o!jt}W I y	vZ  0k ~~c tvXyq +leoPFm
O}Dx @p EZZIj ==,e PFHzov   4s

O >kof5 $ qX  Z .8iR
e 5 ~U-9yn  Z+67 c1
O ;' w <2C"GVy zZ/.ch . 3Xxfr\7zl! f )
O01\I   maMZ 	TbogSpf - Og ylYZX?gWgDۚ
O P t,u W{D@!Z
 m }, sf ar6i2fxj50zjj, /  l!`
OXq ;t 	};Z
e H Q Eh 	pyj[x*
u mR67"2t |)4Z
 n:"d hp* h 
zzi ] 6t$
uu`
  F[BZ	=;c  }i W W	{iA"
 N ! p
u   <, !2`Z	 & y bpLkn.jr@`zh J~
z
up K/uZ	a 
j"]lyhIT 7{y "
u :erJ#(l ;0j 5Z * (4`Z-@*k s+ #"zf # k)_ d
u 	 [ 
1 ! .Z ? _ Fi ElZye> 
 H)~ A
Iu 
Vpk  sz MZ I^/N Sl A{ 	ze }W~FS4
I -J%f  ("0~>3Z 'LW1 ] M yc5S5kl<zc uE+  6 {L1
IwJ{N hxO   uQ ZvRsV4%\  rZ 4k &3wZ4yb}]M+~[  #
I v|US  yQ F|Oq xZIR [#OgliK y` fG azF0
I\EdA 
q B=.ZS7QbZ 5C n J4%y`FB5v 2 J
I -  VN-p L+v Z$.L 'Ybul,{osv% 2y`": zl#;O	[22#  ,J xOZG/> X r
 pm"y`2 3g E7 5	6-<6 $	@  ZN (W.1c9  p t ,y_  YQ	 n  "  CwB}ZoxR V pU n$kiz^Mc Gg" _	j#g%  
b% Zi\"UdP\  m ^ @ 
y^a(]Y_/	5_3 a3 mf1gZf2 T Rf5 *oYh82x`l: y k: 
	N|i61 ~h58 6+i8.vZSk@|%ZSo 6lF 
!%nBiCH  8y`Kj=hi:  	 Wi=p l?jk= *Zi9kRrl8m 7o8Qxb^n7I 
@i4	aQg3m4S  s2ztZq,Qn)) o! 'o* ze9q3  V sA 	a qL ]sJ  
        8"          $  '                                                                                 t=j Z p1 Qn+n-y 8o! m3A !ygjL$ thrk _	ajz $
r )la  !)m 
0$Zh 6wO h "/n!j &Zzi2Nr !rds  R	axrZ Bj" ;d $GZ YcD IM:e 	mg yl 
 fc 	Ofc` 		anw f I	  Z   L R [ov
Eyp x  BW J	aXMSM rWM ZYK  RKELV apY
" zuo
gz u ;   c tn
o Z  ZJ *.+n;U6yx  
1! l'n! 4N  e yyZ	EH s oD# y{B
B	H !M 
 d ts
%-i TZ ]
 
RFU
_nbS
O #z \ j 	_=U  F   % BlZWI5D FL 
In F H!y&G gH  $DK AR  BUD 	 Z O}  iB)Wms Z  z EY } +bX6[U\ 2d   o` 	(]"CZXZ  ~A hi[V n GYady^e  ~
h  j1{h	 
}b
 Z t_tR>!^^  m 2 \ y  \"^&{  f1  l3r  <l,TZ  n) c= "|p-{ 	_lzm.y d&  SX8 {Rf OT@ {a 	Z t;^~
P qn Lt&  
zc] 
{=j )   P5f 3Z A )9  8\"nIL
  y W  r 0 {	  L   
hZr|"7 n) n r yuzv` 

{ 4z
 

}5 	Z [_ ݿ5Dn` y w ? yV{p  GUT D @ hHDZBM C4 "ZP m ca_y<]; N9T[ K Pl `Y6 b &Z [k 5
1'GS4yn 55 
+y 2	 #a: KG 	 Te 	D HX_ZS $  :0 K l @ %GsHzo^I&  iM" K  MVY+E > }a7" OZ  4 S.9yl  D!Q y  S $ d0  K  p   _l 
\] SZN , 2I$4 [k !M  yCM  f 'Dw K Y: 8 6 q B SZ SJ +M? $)k J$ 3z  J* 5OR"Z ,xK _Ca, $  a  KV\  Z |XH% )  A.) j{H>  y SL  =ZW_ kK WY@, Y qKQ' <GS Z 1+>*(  !9 j #< 	z '\0B޽ \?< "B lC/ F O%!G  Z M_ &i5j"&j  . z i  lB| 9o  M 9Z^  6% N
 qi:  
z ;z&9!a e #Z 2B^n 	5K-S!& $Z P 
!
# @a   /g 9 ! " z}   [SBS\  d#@    VZ F/  "  ` H z{
 
 VT ^B } "V AK>n ۛ Q$ ,Z t [ _! ;/8h \0Wx +yx;u  ^ BY   !1 Jr Z+i3 !C   _ Z ZT: zs -M BN Pk PR  pf`W 0d<z]a 6PZ g j /&n\ %[  p
 !=yrRr  92pkwm)  l =pTZ1 'wM  v z^]s $yoF u+ *y6kl#
y
Xvq .` /wZ H bDDE QznU `(Wd sk .DI 	q R. f`Q _Z GX= b  }>. 
_t,  {lL ,d r i4 k16<  1 	d z* n Z  $% /
 w 8 !6z\ iH 0uzl5X & L "!k  V  F )!  J pf Z GBV Z  N[  zl %~f 
P-  	 g & 
E	Z  qn 
<` [ } 3 =ylG oN f[  3 +  
 S  ] u 5Z \ z W \~	 ] d zn . L 
 9 Ec   zZ  1  g ^ ' ,zodz 	6] ?y 1 '  ' 
! i )  SZ  2u  v 4I~+f U_  P%( zo t4c ~q@U  sB   |} q)u~(Z  /luV w  Mwy_!xeyp0{L(O  {:
ۂ ~69 :v> 	  gMZ  ^]Pda/
`  iUvyr U_BsU/  \)8u =h10\Kc>
Z   wTMn MNZ] _	g\0zs h /Z  0U*	:RgSm6  EXr2 } V?a c)3Z Ne"v wae   x_   o[>ytmyC1yi
	: d f\uP4;M 0Z   c yZ`zSzv ud	w UrR	:W- w i
 @ew/Z X q` : A8yw6? 2 j	: lO WX|Ic!CZ   s1k_ `U<zx  HzR	:
ps R q S(g05aZ  3 l ~*qa?"zyT7  ) vK	: G-[ m 1Z  ql`>a ' |zx Y  M"	a
 V ?| NcpZ  Q Z+a?zx] !	Iuhe U lZ  jlw a Q nzy
E	 
r&\[ISPAZ   zP%o
 7Vy4b{p_4yy  oi+ V ," #	)d 6 
 Z hF|uZ ]9Vn
3^ac * |H]
yw7Y[Wh`[	 Tfaymnmu Z  Q
tC
 nT6cjfxw J Nmg on"-	c5l igz {eZ sld&  Zevc $ [YbX3yvGsb` s_P

 / ]+Ya `\PZ  e
g Dxa}b"x "xt 2-e3DP5

L-0 H*U${2Z Z .L;L  A:c"B4f)yr*G= 4MN?

 T_<zaXqn;,ZZ  _FSWgb% i yr ziF'dx

 Y  Q"ovMZ  #N 	 U  b$Zj:Dyo'] 	Ga 

 Uv  >XM TZ L	TjP	f b%vX9 znV9< Ir

= 	1 BBc6$KR.Z R] %c  ] |! b$kZ 0zl e  ~: 

	+|  )r Z h  h ~H c" yjKR  HV Ro 	Sd 2S .e6 hZ qp lxk" b =B^o {gY Y 	dX tQ  
        9"          $  '                                                                                f ,M 	Z S X 7b _  zee  i W	 6uk j 
Mn uu@ 
/Z  	6|c/c  &kyb  !sg M	  ? A  U^DZ IA^S efUz_MG0E ? 	 CDV;  Z  8"4%F-Nc#a7 !y^ Aq<z  e<p<	 NaM9t   EA< RdG@Z  5ZC  < +MjE ! MbhK5z] bQT   m:X% d	 {8S. DO   fSQe |Z b]V?*lW -c"V 6xZ SRE13*H'z	 ; 
!  Wr5H ]?8uZ ~&9 B )6b"b41Rzx\ + 8)  !0\	 ,'ur % & * /  [Z =9
ss 
G b! IWQyZtk  ?	 y ~btgZ  PN.F>c_C	yZA  [G	O qW=  eZ u \"~ a mNyZs;+ $ V 6N	 i92w (  gR "EZ  =+ x2. ` 0e y[ 2i  J5#C	>#3 , ?M!4 g' OZ p/M 9 	a  :9 y^ 	4L 4}6 	 xA xFKޡ Z6,D bZ   C 7D GL` " P y` B$U{ 2Q0	 [:I  (>Ah .C>Z  > I?  OCS b_%MEzeGJ 3  {EO 
	 #VIN)H?KF a 5 ZJC 
3Z  GB )G8> "` dTF&{  xi LEF	 (L K  x]  qeZ  g    `  zn    -,S 
7	!? Bx% 
D |r)p ܋Z  5p.@ݡ y2  	"`  u5 	zsc68q5a 	 T2 
 ^E/;4F/Z  }V3 F ) `1` \,szx MvN( > c C)a	[:-P t:;.   @'&Z @5 	 A 
4a x<G+LyQ#  XS  	[ X(  
Ya Z Z  W U  "Y` s ]y ] &	[qZ i x _ k@[Z ,
 \8 ݡ` 8 ;LxK] Sc
 	[ k i
*ou , pD 
YZ  l d	$vUJd` T "y *Xr\(	[[ s 5W}WCQZ |q\	C  Ve $` *m
3yQt 5z _" ,	[K%$F-, 
  @A	  +Z  24N a ]4& x h JS{8y 	[ :#QP B  c| y^ Z  
 mO F W H
 b4N 	y <[  ;h 	p; uz  '< | %Z $Y Qcy &b anc[ 'x  DY ~[" !	 uj^(A (2 _.D rCd0 Z  8(k3 *% P o:& Tb[`m; 
Az  k/ $! E g 2z	0gie 
5 xo; !- x w
 $Z S~
 	! 	  (a 4 y}g W}U 	 y5	 
	~F_. SZ  oVQS 5Xb;h& 	z PRr  sv	Zxw d EA ۔ , ' Z ? 
N  ~ c e 0 
zs    !	 c ' 	1s&  B  Z  ^  	F
 d` y mt   &	 2 `
 066WZ  /B `7B %gL
  !Bz N  6 #FV 	;X  %  Z  %  -vn rf DE y = 5 NGM  	 ^  Q  v i>^ +Z  'C E \ ) fuq,(Azs3+ V <=. {	`G-5t4XN)  K!J$ 	`Z FbgnD 	e XF zSIzLB 	 Q [6	K/fq bZ    . 6f(0y > ' E!	d [ jl ^ f E9(Z Z$J8Co 	> ^g drE zZtg X _ ~U"%y 	Z  B8bw 
M#E@Ji)9"h 
Qz J e m X,&X e\ 	n#JBZ    b 1 5
g 1g4V *zI  m*7  D 5K = 5 |Z y  {&fh	,zm~ 6aM 1  $(
 ! | G. ]Z  C]e q mw$ if o#
y6R "O-H  # c* "%1t &:Z  i d41Z>,{<e5M$y/xj 0  ۏ 	. "$: m 	yoZ ` T [N"U doE8<cyzLv 9WW _Jw f h Z hl>h  _ `j yvmG ,Yo 
*Y	ko  5  n
 3i)LZ ?[e 
"~KfG  w`s%0zs  p Re_	WjF[IU :MCL Z =cc5? N Z_  ,]  zp i~*5: 6:b 	Y  (p#Go( Z  e ^an`g1yl  s6 o mzY 	 {~ NKF`tl  `o?Z g}u R} `C 7zjpy v? 	  k8  e' o\ 5XZ  i SPS 4::*^o #zh    $	 
 b L p ?Z 
5 o  3 &^ N##,zfa3%  +\=%
 .	n o B
D2  Q \ DI Z   T? s9rw] ( 8. Zyd G<R H?  	n  l@U  u? \Ev Z \P  d Hc \TgydN  ^ 	n v }"x~P
  m7QU 
Z  ^4[%"I 4^_ foj 
4zd  i+ #	n * hz   r 2 EoZ  I !   /]^5/zc ) 3V 6	n W?
( MJ!yo `O1Z   T>}^O\s^ U=ge0yd LinWYZc 
	n FJF  o 0(R<Z  [   Z 
&ye EW  D	 <   
rCZ  5- y 
"xEZ 	>"_yfo3" ?:5	 Z( -L 
40$ >5 Z y9 f  o?WZ 9F-xf |O 9cU	Vd _~SV B @ RZ X w-[ = Z  O[ayg &X_O ^* ߧ	  _Bh^Z \ \[ Z  c3 biZ o 4oc_zg  t+Ns*	o c:k gKdZ  $jfU mgdZ Hk5ygEq) 7v	 hIt1|m6I k.Z  { 9gi%  g!>Z *m Iye  {qc	  \  uTD znqEZ  ; Zs:
\w9/[ *{Byf  Z~Hk {B"
?39(<g >&uZ )3/`A^ 7L	yf <gMFrI
? }A UB 
        :"          $  '                                                                                KPZ  ] iS ; _Q@\Q5Ipye  *BR  uAIS
? "gWe
* 3 b   g~/Z =Al6x Y0_  @&yb*!~ } U
? j KsOga.~ PZ  _ 5uL .i^-dzb  =_K 	4K`
?VdM_` * IYk 
GQQZ NMvM tWQF^ n R[VVz_y<ZT P RXU+
?  hXXfuiYZZ :_[Z  9 c\ 6d_K^paalz^ bcadzc
[b 5 RZ fOOYZ ;LA  G18-]  D'6zZ0G'1W L+'
  EN1!uN. g /|O)  Z   V&Q_(]	_.4 yY 1 S- 
EB*%
e .9' y q 3(/*.fZ $5,
 |!70\,;yWh 7F w 8N߿
 =8L>Ee c G:kZ K3N35J1>>\  *fO6b  zU XtY8$`6R
 
 _1  
]/Z;$`*5Z _) R \X(\! M%0yT [ ~G* + J6E
4Qf2 dXy (  V"PZ ,S z L\ LB<yS l3<,  =f
 << ~6I-Z   ,# _ 0sZ6X: 
xQ W@z   Fq
Q n uX ޘ t\+UZ d`C Ccj 
R\ Jo yQ Rpz  t 
 msb r` t Z  `{/ 	 a|yQ\ Sk 	zR |NN 
UAL
'J 	 ( L=a8 	5 ti3Z  N&]  ) ZN "\xU^ xSn	  : 
  eB (   
YZ   "n b8\ mQ yyT x Fk;   Y5j
C
  $.3 . O4d x>[ܛZ @$ ݌ r@/ \ 4M zV ^O\6 pV 	
bCrb:;F 1 DH Z  =Z8 )\ 7] bU* 
xW 7 7X0_/_-y
 X \+U 	,  vR2? H5&hZ  2U 4 s	04_ri3+XxZ L8B #} B 9Q 
K6 +h;'O $ D `Z `VK?1O\ _&SEy] *&Q ;!G
 }CXPK]#TZ  4 5UI- .mDRcݛ] RJMܥy` f IL_ @IU
xHb	 
 Da V >GQ3Z  	WI 1nW~;\ }f ye:f^K> W
  h( FJ+8Q ?C;=Z  w CL`JYKk#[klA3yj iA5XQEF,
;Ms$) /Py     ^2O Z   >F 4 e Q:T \/a0 	vyo,b- 
O 6S4 _
d DDS1 
D=  F =: Z  A^ 6 ihI9 	\ ] $yu ys "(w 
Td (? P " N 	Z   g 0 ( \+9+ gx{ u : 
 (\ 
YN 	 kj i	 Bu &Z jNw  Q C\ b 
xRc22    /s2\
 h y* 6C/  .-) %Z u D !   7]w9y  n<G 
 c.P
#e-/k  bZ  .`J6
_4R ]kg/ 
xi2& )=q>
!\}J;  Hfۈ >mZ P = 7 WzYD\'H0 x E " =  
6=S@< jM:Z { A5F22	\*7y V.=
8:  
3 UC(  JS 0c{K  6jZ {aD/p  <$$&\ 3%z!\y@0#R   J h>$*.
3V$M 9 Dl$ ,s ;t$4Z o}q#2zc& \ :T*<x  1K. G/
3& G+["
G-7O8 ) nZ  ZD YIaE  ] vb< =xa3cc* 
3f$ h!  r:f hZ c`"8 	nUt]' ] /]/!zuc3k-  
3 $p9 7v	*  v (Z  qJ.Fk6\g 
0yb 'EX!
3, @S  bxTkY!)Z  	<V&  %Oq\VJ
y^K 	5N7 m	X$bx7 ji	Z r \u{\ oTwaG_$W 	=xS )RNO iP [;Z  _8XWy
\(
%xH
"kI	W >i M] /d&q
  qZ 
Ul F\,zy6c aQ(1	1C,(7 M#"~Zt  jZ lZ]   j]); y]&^& y  f#m#	p%
l$  $d#XBZ -h_# gb  !d]a n1 TyR} b ۦ	H| @~Z ;Y *Y}
	]yp 	yodu ' I r 	H{ 
} YapeuZ M^	@u=4W  ]'S& z( V2 Zp *7	a6ni	@32 o|)}Z tC"2p  _ 6fl yrWc$ 	Zg95	TmT Ill6  ^= jr	Z lb3  RsC ~^ "x&xy~
  \G 		K[(Ph; Z IPJvLS ^3mR[PzSa
C` 	78Y *e
	ATn  RbYZ  PCA] ; n MyxCx ITe 	<ML
C(T 
'% WA5TZ  .M4= CE*]#VA#=y|  \; &Y'	L 8I_A.:J.Z   71:<\ Cz{y C  ; EW  3 
6
    aJZ "_+^  \v>Xyw5' T)
 5W, | . t &Z  P5( { )K/x0[ .+ysl   b
 -W r; $ ( ", :Z KRv  %A  4lZ-Z> 51yrXHB !,-}[FS %#WgP: 
 yOr  %JI :Z 4 U % Z O	 yo{/r yW xZ* 8W uB @ p 'qe 
Z OKu ! vX Z jt s lymFp> &h p`A )W o^ M Ro3% % qm %Z  %>lp 3CIm  [ Ofri %;zl y y% }d ]  f &   " \Z  '3,   W0 1\(2 
"?yi <$ "3"  5i | -SzH` $ M"}X !Z }I  A  {@ ]I|] \zi ~o  0w N0  m, Z }9  
 B j]
NSzh<u   x{ \     9Z { / p ]
 tkyh}jrNe k O  g!c/99}eJ  ~Z  | i\I na^/^m]w yg j`B  =ichrhc1 iY 6e X ynL.Z cw:% CU" !Z^ \
Y bygx=2 | p  x Tc/Sd E o Z  _vL/
mP_ A rW zf; JG V^Lrl\ P[] Jf    qsےZ b b s6u ^ yhrZ   ( \a>A$o 
        ;"          $  '                                                                                  P Z  U ^
 CZEN^ y>9- yg  m* >pY\ e  
  /Z   6    0<[&yi
 ! (#y i\ <dSS  6fD jZ  Q%sex] {F zi NcoK \ 8CRA mT	,lQmLaZ  W VM  {i\5yj x u&k 	  rIfC\Wkl C \\|| r  rZ  QC -2 Y]  e&!yjQ7*&50 r  W5]w> JLsBZ  G vR aW>-]?6zl :1 @(' CQ!  (Bw  | hEd;Z q9J\Bo / Jf]  iM 1ymX+ f .l  s \fM "R3EZ   `u
Hw*+\o<Ozo  Y!ە  _#m߽ NWQ  W kAgZ <2F	  P M] ozp_&l' }Ip  p 7a&fK, OXZ -/ b *
[  s zs   4+nS6^ /< 2 ~ ixe)
+"Z  ~r  
  \ [ +siyv.{ %  -i B?^$R!  *] ` Z  e!~ kj5  Y7n2 Gyx ocyp.w  @ 0 qI  /jf ޚJ`}^TZ  j \ V  *atsY6in
#z{  :k  mjn HUk v h   eZ >dR rmfy[ x6 y~ 2D^f ] sC:N|^( 5 	 {3Z  K*I  Z#Z u y r m QX*
s} Qsu+# 8MrZ  B`y JG y 6\ I Fx@M az
  \k P/ 7Z 0Qݤ sB\Rix 9\\ h}b T 1]L WeZ  C{ $Y?] }uzJT  % S<E%q b[E<&VZ _ Zx.4 24^ t<;+z N _ #ST$  ZQ  d zx 3fZ   @fh! /&] moJgzHk( Xj gFR| R#  Z  \j]"-G%] Dܾz wM" .Y rbj0 D k
}
]Z  r9  $  ig_ l<&y   g  x Za! 8 M   { fdW1Z  <}F& (t #] cLJ"3y}!1h5 @y, y)D  $x K)E2-!
 2Q  EZ  W9' ri<_  '2yx :F  ~ 3`>Md =nJ= 
 5 %Z +) O <U_`   geyu Y; . 	: XCzW*4  "91Z  YXQ* |_ vxp u SH*	:2? 51s K'Z k 5, 6 F^ u(ym   :O$ 2G	: ] H U6! bWZ.=  ' %<Z    !'-q A^ ) LA 
yj k z	=	: ( jE  $8 
9hZ  $ 
/ ^ 4 
` aM'ye 8rl 
a St) $	:/CA ے # Z  q 50 71f ^ `c yd 9_   tYU2 '	: uG}  X `N:  +KZ   !2U1  \ *$yb  1C * <}
	 '7 B / .e 
0 a1' 	6xZ b"h/3  9 &,\  
!gxb h| S w6
 
8	(R  zGd 4jn
 =Z   n  4d!a[R Ixb O<   e 	 ,
 T \
   p Z +\6 " [ - |   ,za! _  &l 	 * } 1j24
bZ 3mj8 |0Z.A zf $.( z(-+  	-%  3Z 		 ^ 7Z  3 F.9* 6Z_ C' 0zh ".'45^ !	Zg;1  _@  m\ D 3Z  pJ :  tR7wZH[#xm`'JSc,Ww	 'k, 1sr/ L!Mr-?  
Z Zk# 
<jqk Z 9 Lq#!szs$ Rr%HfHo	i gCSe: SZ ec
$k>`
[:O^	 
7zw X	 QS
~	GSeSSZ=PF Z  pP `? 
Q  [>O,ny}G~I 
6qzA"  2,	tD'E(e  8N-k"2!U6 Z kYZ==@ 
Z]87Yw Z, yOuW%ZS%4	W'E   c#~lSZ #7dAZJZ 4z ;' 	<y۶	p#s  wZ o$)_B z 
3 X07 My ZBn
	  D  Z +rD  $M [ u*y(rU  ')
,t5 "| 3BOj1)Z z:"EI ;   Y ;*hzD= s RH:&
,g?|&N W
 
Z AtGfwZg0  ytM _{E
, LS1`[ Z  r`H  %'2 YD(GyN>Z 3* 
,g L@iW<M , 4c 
MZ  4I A X Q =yY =>[ 
, ^S B[ 'aO 50Z  } 1;* 4?J^Q7<*Z H\L_#5y;R*   L 

,=~,d4e B8 #Z (?^|Ku=< 5Y b W3 " 
x 0c)Nk D
@ H  :x` O@r 0Z !  m :M  [2z X   =   '
@^ aZF b2- Z /` iOQ ![ Fos & 	rx8rxQ 
@ { j jI BZ =  $Q&74:\|2 5*y8 ,8  /#
@	  r-2   g l&Z @8R| @ q] =  x
;Lf B &
@ K	Q! k]td Z  
 nk +S$VGp\.5u jzn Byx 6Xzu
@ix n 
%}}) TtZ # U []t ]_ zJp  8Sc 7
E ob  {\ R 1Z   K7V:R
^ j\ !y ! ~G\  2+>V%5
E;PV - sU  	$~T Z R R  ,W /0S6 aUTSxicN"  @'J 
EtZJAJ _gK Z ~I}Y	D ^ mA wy  "?k1/C
E 'BB  % MU=ckj9/Z  6M Z 8^n<]z. [k< S  I<
EA<9, J3 - MOb/rqZ Yq3G[Rt9 "_ @Qr> {Uv@@{> )
E 5  1n /F6_-.Z  :3)f %\ > d$V!Ma-( Oz ;W= " Q M
E? L5 	*DZ g5{],w 3a -y1;  c/ s
& [3[B=  H cZ S ]d\5_ ^ |z WW-  R
& UW =X  
         "          $  '                                                                                  aWZ !Q^J: 1a 4I{
P~] 
3
& f	;b M8S /Z  { F6_rC
0K`KG1i 
&z HIN!'oOS _
& aDl Z v*aZ    Z_ w0 ` 4nzM 8c [ 
nH 
&:.	
2$ 	@ 0 Z  YB@_[L& V` c4L
 y  ;KN &
& 
pT ~  ] ^Xd Z gS 5_ k]& M_8I0y '=.  [A$ 
g	==R	 1t  w n Z  
 e_   -q_S_6z >g:1#	m '	d !G  m !
 Z &( c^ e"*^ '/ z<7,|73	374 1=( !8L6H 
 xZ @N

^BRM T_ AU^y<E[7ۄ 8GW ߊ	WPHH> 
X)	L4 7 WS$ fZ   U&^Z)] .]# z`.w h[3	bZ25 3 e0h 
0  r2Z  Bt-I =^ l@ 	^8 fe{~ @f+ ?]fZ6/	 oY2uO 	) ku? "fZ  o ]Ih	^bM y}d  Nj	Os { 
EWrB _XlZ d" k] W_(b ^[Py|Z  ^ d	 cF ffo h 	&Z h7]v&i^i\^M k Y 

zz B s 5 z!	(2{ ppZ =^pa 	] PO e_
DywsD 7    J	Q(
X 5 j \ 3Z  [*M] +_$ # _ n< yv `vp{5K	6 q=`G9|Z  b 4^6^ N^FfOzu 9 sn84 V nsq/
	~~  u | h Z |\q^ eK ` 22yqvk!C< 	 G
F,X+xv   Z h   ;^bC`\)zm  ?7 U	 $}m  f G&Z L4_  L4_ 3}U+zkaIP# Q)' 	 " > S| As{Z   BWk_ 9A_ q
?izg H *'i^*R	,[{  <<% a@P1Z  DL`  H!^J7ܡzeSB 3]<	 
c' Nng @CZ   
!`2|P_ w7Fzc .he$ 	 n&K 2oVB3Z  )
a  S# #M_ K+3z^ i o5P5 4-		h</c$~ aO(!  oR 8Z  J9R[a DV6_ d~zZt{'/)	 -Q 6 +-z q0kZ  9|a Q> qb[CzW ; J9 qO	| MC k TJNz g MQ uZ aT b ^X` C ~\hzVfsl	| 2~H*w.wpO` ^Z  NJzL&a 2G5-` IF yS <B _G?*?2	|J6  .P q %CZ  #!b /c#(O  9_ &yP# | 	|    ]@ "mjZ  .gb6
^ C{9
X2zL V8
;
"_	|  6De*F	3CZ  Ana C^ _"LGyL h F	|tE BZ? Z  3Fa 3] G yH N 
h
	5 C   M gx0p1!h6Z   C)L 	/`
18&L[K	-!xxH  !!d 	 ^ ~ o  I	5 /
" N $ 	K U; NZ s`T [  ( OyFvzk
 	5  |k E 
Z r5 Y_  )S i[ 9
yE #
'
 RS"	5,v  A    eX$ YZ {e_  [$v yE	,!y   t1v 	5 o ,  + 4 Z  S .n_S6Z (Zo 	1yGR% 
'W  @	v!	5 ]  p m \  XuIZ i ~ ^ 2 	 [ ^zG [	  v 9 (\ I 
<Z   v:u#^[ vyI  )'*$U Q IQl <{ W3@
HZ  W `
(^^ T\~1yL c   O hHU'! E4] xZ  _=,>^=] P',7yQ H 6h
^
2B 
 (z _="4h yZ  &f] ,\` :IzU  b }-y   QY#NZ  T1]  (#^ 8yZ gA<\@ ۿ xI@p  -uK1 aRjZ  w<~ Z] *_ 
*z` ?]   .\3y ` ! zZ @<s\ 3 e  _  6yg 9 ) Z m!)	 )C25 
N 3i P 
`)Z  iQ>"] M* \ yo 0, E	!  P/( e 8q- Z A) \ HXD [a 6xvqQ![
 " "M 	 c&C 14Es ] F;#C Z  4 ;C v\QG-Z . O-) 
Py _5' s= 	\D Z 'Ir 	EVZ    <4 \ t2> [ +	bLz	}$  Lc~| 	HdT 	'=   57Z  I,4p[
9	 +
[ A6 #ay?  {c]8  	  9 L ` &@ 4CCZ  	 FC [ % |B M^@CizB   <) V	$q`6#e6 
8  rZ y9T[}N= ^ ]B y <D? % ;[ 		$ S*1@- UDSl_< Z  .#D)< Z[ C!   \e&0 bx ! 5 B& 
	$f:Lp kQS% 
m L Z {(9 	$t[B'7 4[ PO k51zC<,G; #	$ |  3     Z Z@t Z 	qZ y  ` 	$z) n 6 }N5A	Z I YZ Y -Y  uއy *+ c^ 
	$ Z ]Ya  + Z \Z X\  _ 	y  D 9	O!B  m Bh:Z ct( Z ` ( 
]!y5 2 diX 5	O~HMw -#3L $ 6td 
!Z  Ak 7Y XC^
tO \yiR" C%W	O 1~ 	 #F_Kj Z  L Y 9 _w+yy { T-qb +9k^ 	O3c`۫f ?U 
YJg Z VBY 3 
]) y 5 ; 	O!  
' }  ]Z  h$|) X 21Wr \ A,z  K
} Q
O	OZZ1<e
 	6_p{/Z ylG%X}f  !K]
I{ot  Hz,vsDi  	O [ #mO)u% gFk Z  =\ W )94.[
g%TP 	y   C[	G2  [ @FYZ 3T_4 V 0 d
 [ -Uoy++F#  n9A 	 C \;I1 B5P { 
        "          $  '                                                                                ,3P }Z  8G V>8,Z v?%n zd+=  JI:	&	  2< 	 B tLJ^/QZ Q 6U Bu^ 0a[oM&z~y% ! z~  W	 $zV,, ,K}r bZ ltZUm [h& y b[B_Wg	 ^N 
  zI 	g GRZ  5 WG T CT]e;Eyx6@ p  7u 	#>}:Ai [ I;> Z W7)0S '8 K_Zr? yB	C< g	UL4  
6 | y%7UZ  m ]3 *S w'-@cn 6y Q o 1 	$ '	 !U "+b  sZ =KqS  :
 bI VD  zxm[&1Xh 	P UHk  Z    S     d  O .{)l# ۗhz	;s~^ J ?9I` TA{kZ 50  *S < 4- )c BB{'M 
  V 	 U g  .j 43I Z 2  @S]R pb  fy  }*D96/	 b: 
2ij )" W"yZ 46.  S u0 a
{4  R  T A 		e>Et4s   sft Z )JSdS3= `  *= ]y~ l T0A>a 
J C J 	  N%nLSJH Z  Io3 S?gO  OaS{| WY  'YG }
J	 _ q m +h
 Z 6>S8mzab*wr &zzPjkm &"d 	
JY(tN 5 2I 3Z Y:GW*lTF#c kD/ 
 yxp:]B 
D!
J Jw O e#
9Q [Z 
8 HEV>S$DaubTEkE 
yu.Nn  g=[kRi 
JUN`rKZ DVM[ <Z  }P\iT WZb' ,_Z3 yu i_ Dp`
Jun] 7 h] 3*']]% Z WVI;T/ OWK b ,\=yr%`*-^
V[ `aX &I R 
%Z  kL 4U;B4apk7 +zq - <# ) 
 &}   !kZ 0 f  \V  a[yo!./ 	 pD!b| 
&nB,P .QZ C 0GW J4` u ; zzp ;P<E 
 <2k   As .K*Z  iS X2U5` CVtzn  sXW 	P  [I>
	[CyZ:t 
P t W, Z jY"GZ2[  "` h`!! 3ozn g/c
5 'f  -
 0h> ${"i Ci  )Z  dl [ ,Ec/^,dzl  e 
 m 0c"
zbK  dT 	  Af# Z e+] M  j%( _ } o zl+qT]Km 

 Zi2 kBoF@ Z  s enGL ^AfD_Sf6 ]zj 2 mr  /3oG
 
j# Ac h [^Z +d a jnv `  vzju(   ~ s({ 1
 x (r6,j(q	?.q o 
%ZZ   +lC!(cp> <a  zi  b
 > z MHrZ  %=)  e lQ4  ah=CzhHr=? Y6s6  
 r.P Jbx(~ D} Z  
azg%ga uO yf>EZe^P
 q _|9Z  QGLi : b
szei  v I k:
;~PXW0C  zT6Z  *O&/l=0&_` M3@!zzdPG XQ DP TEi\GZ   6c5  o hG `#oPoKycrQ   :mI Gg= F i4   9r5~Z 6y@Zq  1sZDOa lf~yc` LbQ Zqp0$N_a RZ  r cs 3[d ,ey` fguzuQ^5\    S,sZ }~.>v y:6c  &w1y`Un'm ^!4 lD 5~ <LHZ   c\x7;fNccf=y_ 9w]dhiMR{%B:1  5&&XP$'
PZ '3Uz  D
a{Q>tx^D[G Y dd|%j)ohs  ]<Z NM}w8Kb . SM&!z[LO1^%Q2%Z2? 
 d6`Nh9 eZ  d:  !c:bg9q+zZi7H6U U e6 t2P%]7(W8 "4 TuS8 tZ y(S=jTE3b GYPHzY2REXFD5% 5+aIFzhKjKWZ  'mKmNbq=oUyX 2 y^t fM%)>gP rus kc l`Z _[WZ NXrb  ^zW:aHe g% + psn|s(ir6Z  ! i
kW_ bbWyW B S R)T"5  VX 3v_1Z)Z _="  d  bi| UzVoVs * x3> B t c._  	Z  9J}a  hG[ 	zW
/4 
a?<<  nX-  cc ubݿZ ` G 9g 
bto7yVor4  Iov 
 ! g?a 2` BZ  kbZweg.b 8h ;xX   h !f"af 'j" 
F p &,rf5Z  jr 	4u D zX +c#eyX * K"`   ,v(z x1*/PI3  7_4 <Z 2)xHe =! 	y[|xW
 :>$B 8 	_' B O"Z  Mg: x i>e`Vy]  xY ' * y*
q BW _ *FZ :h  I s  !d i py^#- //B
  ]b |]bs[h s%Z  ua*t$H DF54e "6\5Uzb n8 ,z HH`$%
fTe  Z    kazZ /cK [^=V e  TG&yf/SV;} $O]L  ;  
 5hs 2q Qyk (Z  MI6 	R:Cue] U 
ޮyj5= !*
} S xN zZ  , 
 a fym;r  <[  C
AC/1   N. 
@Z  l 7 (A

e K  !yys W2hGe5
 n  - j!  $8\!Z R  < GFZ"+ esf&jyw  d%  oW" 
 WK!H%L j [O%K Z Z&!f&  eLj& 	y{q ^G
}8 ۰ zH 6 nh!!}Z  gc#8  s'f)Cz~ z'p 	< ^a% 
N$,O" ! a fZ  Mt ~"e z&zup%wj$ 	
h q": 1|#6c
{! /1Z  m/% !bx!Qd  Y
  LzU%@ OU
K I +TJZ GKV
.O 5f *Wy 2ucFt 
5" L4 l9x7 fZ  \ * cMmwd lV ux gX]  sY
5:RQ ?\Ne} 
        "          $  '                                                                                7UZ b   tl 8fy	y  g +
5 ` I	 :?Z/>Z q H	6tR0d` y\ &y .h	!8q	} g
5TPvI i  o#  `	~xZ DPi	L 1e R)Vy ZY& f ` "
53hj&  o6 	 =q  Z  4 k  Ib	^clW	x N m]uJ
5T 
~eY,ftZ tx  , nQId 3|y6g
7N2d	 @ C  /LZ `S Q -d L l6y8V1 [ 6l) (	q8" jB=O }df; Z C4 1*d1 x 9= /=%	E;H`8 YY 8]Z <86?x c bF7pyP|۰d 
u	 |t D 2t zU9 Z  2$&>y8c h\ 
z gA 1V~	B  X  A AZ  	. 
 H6XF 
ac \r;y9f_ 
* 9_2 6=	 <ZZ  3Wb^ )V yf "Z   yl  ~uM3 c > 6 z / YNB 
-o 	e yf "\ _\r QGk R Z  ] [i | |f< 	ca yi]k  >_ 	a 0q J]@ H EX Z  S! ,QT 
Zd !1Ld y AHy7E }	 ?t e rg9 gaW4 
Z  @E5m   /8\e :+8! z|+ 86> G_O6  |	"d5 (0{ ty1 53L2i 4Z  
u4 *
M8w #e2g%9 yx5O7c  G3/ 	5 uLI; Jk? 	{Z * /C 4=<G= c b;M xw44Rt 8@ $5T@
	 >RF "  IO v  RLZ OZF Ib: cxj* zzss] : yK 	  vq }|o rl Z ~^ 6  EY c 
, xq v( 
4I4B 	E!  N% 	2Pk%Z dO 4GvMQ 5b> uL   +zq 5Kq # Ik 
 	 WH. #L   S Z  _ Z   yb@^b 6c vyo 6f 9f 	 S ObN   n` JfZ  * r P  y#D ;bnv_Tܘynn~ ` Wh 	~e+a7 
  Z JZ  \T# -uS\ 	Sb  X yoYto.Ui 		 hJ~  @hpy <HoZ  >" 
v?  "a Q: 3}zo J : 5 : .< -Y	*FD $ Mn  ! IQ  RZ 9T Z [c bb; 	zq e  h 	 Bgu qc,h n' Z  hz!   ?  b zZ | 
"ys3  ߟ  	:u  [dN ( g  Z w  Q'l c   m tyv  	   	BF An  X Z  1 mMQ <S
 	,b . e' 5 yy?kG   7SV 1	 a29 6T    
.( %Z n/ !I F  Wc J 
b x|$z  
	  )  v  Z  >,22D g | $ ^y  	 7  
9  Z  ۄ
Z  ` &+B p #4y 94  CcB6 	%^(  Ha  
Z  D>Rw o #  y 8v&
x
 b(    
. 0*-6Z  &
 0  b@&kx0!y i    k  & o[
f@  -\\  _ 
Lwx[Z p- 1 E?g Xy| 0
 "o 
VXL?/Z  @*( c *:<g>z  @V KG
@HN  @ \a8cZ &9wu  :.f  *4z-xm+v ` )sW
  00 > <   0B0DZ   B.!=6ecA1Qy  Ik'SI!
EE@   HV YS^
iZ ZU &Y@	e H)Y5*yW7  T7
 8oO%6M}zLp{ c N
Z  YU y+\cd U _)ۊy  KV
?L
R
  WK { U#[~-b,DZ h9rQ  gAd!`D'(y*[@  \:
oa2Kba)! l`& lZ X'+~X(8qd  Z&+y 6]#6dlS`2
 h ik( V^p'"^ysm Z  2 pu 7wc8v#*xu)C q4 Z
l@iG F UjIwZ LlJrNYe  }[sy"f7h
 q bt`>g {yZ  E rzv,g]afq 
z @ ^`EeL
+0oF" ' xN, B\/Z u"g  sO f 7 *yQy}@&r Lb)t
 b nsR5mXJ3RDA*Z  4 [A'"=_lC grxJxx `NKo
9B # _ 2 !LFZ Q   P v! f]?xrgoK 
^ 1 D 

mQiAf#Uܼ q$` 
Z  nXcObg [-w oyn  $bBlOC
 8nE6 q D af+YzfgwZ _ 	 B   
hG6kziUzY  ! 0 
x(Gn0 & +Tn58Z v474#? T+lg 
C  #{dAI XT ,
 v;ztZ U	g >
|iFLG;x^ x 
he=| wI  C(IZ ]K4 ݹ "<g ?N;HzZX~18[%H
h ,/"XE*ezTdN2Z  o5g#4aAh$/zUQ-U2w<
h[L9  !Z<rJ5Z e4+$. ,#4h $ 5zSMA, $Q
h u" ! 39% >o SF?Z  	 AO*lV@>h TOxO  EqVX~U
hDnu BUZCPWZ Q5 w1
g)@ xMf
28 
hzl$XT<!| Z  H+g = "xL 3 L;Sm3R
 1Q 8BPZ ] vM !   Y 
uei\!NyK K  
2 |9  6
S1Z.
85 
%" k> 	!0Z E R 7FQ e !E4 zJ\E)9O
p( (o}u2%Z @@[ 	  
IPdSFyL E?   pH;|
&K۵ q@  6 ."rZ ;	  	  c 1\yM	[?v
p
 a*R(rZ  *6 4>)c
>'yQ{< q;
<1c>.W 6 -DMS/Z Ex&+ 
 !mA !a @]x ~xSD;Z NU 	
 VO WyWY` R Z =N<V   
OOSca "S 
!yV 2XX 	Q	=E  
[f4&ۃZ RY9   %1 _ 7yZM  	t:hP }  
        "          $  '                                                                                1_E Z  6 4g@] 
k^F` kg y_ hL  2j(	 y 	r "    ~E/Z  3 6 m1' 0cKK'yb2Q ! SU  u	-d ylX 8I 	Z jog| 1%$ b *l 
yi <xtb-	 pK 5 n8	0E[  MZ  ? 
L  S"9^ba >;05}yn =mK0] D $QA 	&SJ }W [9 V 'h	, 
xZ u:$  o F` n	 zsQ p  g	{ ( [  %tv= Z R!   K6 ,d9 
6xz 7v 1  (;	{ ? ", 	J:  l e Z [M  , v &f w/# yR	 @ S r1  	{ UB  nN, gD W "Z _ c ) .eB y @	 ۼ Z	{  ,^ &Za1   Ld 8{Z 0 7  ZOz8$ /f {G;5 yP<  @D 	{ 7 eQL 	]~ 7 n Z  [u3  7 pm 
7fLT y <y-5 *%D% 6$	{g% 3 L * )g** "Z   _   tNUE 
e )oz ?  ; W n 	{x0' mH
 , Uh Z V  4I  e << z  h> 2Q &	 /}p N  BB Z 37    	agE 
x  eS{	   b h J+ 	Z dn  7 " ah zs y	o2 -' R	 |S7 ( S;o
 5| wx4 4/Z  ug *  ?A%#4f'  y O+K  g c)G";	8cn Evg 	5F|Z 7  G  _'N d {'S yg4 H 0@ 
	P_D [ FJ 
 U Z  ^ 6 ^]{Sd ? [[ hxU];
 5 4Ug*a	q) x v- r-"Z ni+ 4 g-- eh5z WpoC  . yR* 	 { BRZ= XY %NZ   \4 M(5f   +z  ^x#^ 	 . ]_7 	   Vo y|Z  A} t  s } gneky 3h '(]|	 t5 B{  |Q Z  r`w [/ Ag mjW ty C{w/k{\  	 t*  o [tqz 4Z  DX 
   o@g z D 
Z  5	OB c [RRn Z6,&PZ  8m    z 
"gY3Fy%5 K(~ 	-a	 & $ H H!  T  CZ  !  ! )%Uf'	 z )  E"/*	;0g .D/'  7F(Z `> " F.} e % |Yy=/	߾  @ 
` J
PE T3B 
 Z hK) #U e   \ mz 9ZIaS)
`L| 9  dIgHZ hB06 $  9	d (#6Rz8E pj@  1
` UB6amLB.  H %Z  VD!K $YW` Uc Cp zQ%p  .8[
` `INe . ^)X9 M0k Z 5q 5 & #<lb 2N=i ?oz  &3sD'-
`$zeR*(
ۀ 3-tZ ]3 'O=3a  M
y ;`9X 3k9
`i c
 VR/Z  b[C R ) Fgbh^z c~ p n`F
Q
 
cB c 0bW6Z Kb/0% * b4 &bj!z|"u yz3L 
k
 ~v{? rm"v KGjp sZ i #iR , Zja e  uyt d 1iHff
;oV 	B~   $ qZ  Nx .DrvG 4behgzp Ld E] /h 
%jqf9} 
dZ  w %w /[2c J qB 0zj)S  d	zR
 f 4    
M LsZ  p - 1 7z- 6b }>1ozd 6
'O{v!
  u'j  z.$ 3"9 kZ K 2 jiid I R( 'y_ HTw
  .g,U L fy0}y
Z    fi  4 | SclSۉxZ_ z   mo
q  1?  ~ 4DZ  Q 6l ^d MK$-yW  Q \o]=
q~gQ l2iv lZ D 8@g4
+yT \$=6j  F]2
 ( _ n "o z 4 Z W :' f;4 /yO
f?#{M U
doxZ ak^ M
^TxZ  ZAy ; lX4f T5zM P8(Q<$
FY=޷ j>; uzA\Z  YaFf <  Of }NsZ7yL"^p*dO5 

|N4|cV p _q Z xM\7s = W e %i[-}yJKkN)2
} n 5 3  *Z xL" >xd f `zJgm Hm n
ai!MvX   IEX EZ  F 9 @	3e .0?xK 2
p0UR
/i 
 2	V5Z  %'6
  < A +1 Zd 9++eyK y(4  ,*2
j.+^c 62\  ;iZ  ND C &K   c R3 ayM 'qY1^b
 .D[ SH
s&e+n5Z  ' 4 D A +zb#yO 
   + "
d(w T  h
amZ H#/ E < :e pb  Pa0zQ <8g ,{  
 Nky}E>EZ   ݿ G ? YbyU VrH :)
R" ;6,U FZ ^ H AD!_ .>sxYlT  ]F 
 7 ]{7WE V Z   \P# I:h3_  Zty 5}y^  ,|z$M
 f`   )a-  *kZ h 
 J g9 ^ xb69W  8kX ?
2M
  E[
 SZ  &/ K~ ] *!8 yh+i* a
 #-
 / W w/  ,%  Z    /  M # 4 \~=9yo 7>  P @ ?
u7	% 
 ,. =Z x
og Mg 
>Y X@h
> !yvi
C2qe 6
 `
 .$B`%/f
!.Z  I6mZ  O N $sw*U5z{ 
01 

Wle 
  | > 	#'Z Q  O  	(S 9yRo/ `D 
 8 N۫mJ4 C  	_Z  *0>  P?RF y :uP 9\

f  I8f $^`lZ WX  P ][ SNd}y\)yjF5 Nf 3
 )Y0sG6 q78 /Z  a |6&! Pwp=l!qX )E  
 _z F B%zM>	Z
 `0 > Zu'E J F|'Z  - D1q 	 Q /D WXe]yq  $gr 1=<n}Np x Ibl 
qZ  /F P_{ VW :Hn vy +[ ']+  ~J1~ 
        "          $  '                                                                                DTF)Z  Oj  Q E Hz  9XGVz 7 J  43M( pP	M rS) 
Q 3dSC .Z  RS6 ORh O 0Y OW@ '*yZS!YB  t S> 	 2J_?k>Z H7#  O 0X L+K  z ,u(,6  T %?: ?aL j 	 6ZZYE O 9 uV" " !3 u{*5*<   3G x  q?e  Ma  Y% Z _kl - Nh]DtNU#[) y K`-c hCq\]Q-  JDIq   '  ,5rZz$#a  M # ,U#  k''  6y]+5 2;,7 (Y w+/P "8s,/  *./3D Z L+65   LU<,V# 1-@# y k>T @;   z8d  Xp= 
gg4E"Z 0J$ |  K UE$ 	jU#D%yJ(  P) 
ER)XT*  `s]. }Zg.*5 Jgk) (U# =Ng 
{  C\rTh IpM#s   O*6W-Z # ^3  7 H  e:  V#3l@y x:| 
*Y ].  6!3;  A ) X% "Z  H 
Z# %\ 	yR\nBH(*"  ZK7v l= &75.  Z + 	 E > "_Y"`(%R z M*Y  ).\,\ 2 * | `2F-ZW]2 D v^c dX# QICyvH% ?D}   C -?&>s 6;-: Z Q=,/ 
 BC%iY#K@ z SL AY<&w[  ' Q^ 5zzi14XZ33| * A j1 	#UX% S0 {T+  }t( 	Q Z LpDu6BKh Z # f_Z @;aXY# N y x J %`N  OA 
  +QWAZ Y ; ? sNS wY!sPEnxmS 	H fZ czkL " l ZiF =Pg. Z" CFm~ zu	CJxk
 D.p 	 1 !lDmS%(Z  i 
 4~ ; m Wc59Y |R\U,6z  [ 	$ q Z 
[^X 6 .[ 	 Q ^T
ZcXcN :d Z   `szI^Sf D 
  s hXn Z ;_{ 	 8th|Z]f ܀{~ Gb * <Xk
6k4( q cv 
 K]rCZ8X_)# 7 `/" M[ 4 d8yzzKpRjn |P 
  3}lq73 
Z  iT 6Gj~"e[k 	3>zy Ym=L 5d.rP/-
6sZm $ Rqf !ti CZyN  5 y  Y[ [ozuFe3    U` 

gms1 ` 
Z *  5SE\  z	 
zr e 4Y
  _  S ph .dxZJn  4 > d_  ]0i
j`zqv'D   xA 
teKr4kID b | RHA7 	Z;O,- 47^) \ / b#  zp;[WaQ  1
 f K 6_ t|J.N\%Z  V 
!L 4 ; W U]7X%zl VG  Y X
K^. +_  ^ Z^[= 3 \ \ k[ yk-YuM\^ o
 un   6 }/ YZ E  4 HvgQ\=yj OC'T  *\B5

.gv I`0 
 G 6bZg}GX 4 < 0 	\ | qzixCVh 3v 	
.
 S K'{px/ = 6Z q  0D 5C&^ !zh  ) { 
hr
U| " tY" z1tZXQ  5 Z6 \ 1W$!szf&/ 9# 
 F	-qR +['# Z I |.,j 520[ "<*h zg p H('CU.&
 # c2 s  z.&JZ  }( _ 6 -*]9-yg /-O t -
 </D 5 V = Z 
G- 6L@6_ [E]  1wzg $ 
3U'U	!
 b  s H RYjaZ NF  7  
-ayh (  T <
cvK "   8
ZOc 7  1_  a ]_ {۔yhS5@ 
c qq5 $0~.}?Z y-  G 8 .^)5"zh h^<  a<
c"1AM WN8%  > J! cZ* 9 5.  ]   $+{yi6Y ;  2
c w/ 2(4}"z #   Z <  9 Z 	 5 yk D+a[
c6  Q ?pxZu : } CZ  :szk:88 \S 
c z ާ@] N4_S TZ F d h :#Z  T! ym  "x*
c " - { m_$$)Z _2 r : UO W  0C
<azn 	- C co (
`[5v 3 \n **Z Y" : 	O
 V f zq (Hg
` *,>  W #.
=|J6Z 1T
 	 9 < ?jU/yr  	 
t  
Sq
` * 
 x(4 ܿ 0041ݓZ51 : 2;( T ?2Pzu =@4 ?a  
` _G?2 GJB~tJ 3 SZ A-Q   9 =dU6U!Y)Iyx W2\ 	 Y8
`M/{ -@A 	&\ j;=4Z>+14 : 8 I b 
+U . OY#yyQ
n  R 	 
`  Uwq X  v[ `Z L?^ 9aeUf 	 y| mf]  XjTu
M+m I  aq  ,vhsZ[x~ 8 	ܺV  {y}U
^
v 0
M i  6_`%  Z 2y n 8 < y.Wz~%|  H -
M   oPGg dZ # 7  r-3Xo<	T 5x=I: ,BJTd${
MZ Z]!X
 JJ  Zz4u @ 7Sw*X	l)
Zy.8j) Ul) c
MNp'N  
1r*p.ZTp4 P 79rs> PX"zJ,zXxT
 mY\
M|vh\ 7 !e 	mZ,qJ 7<d Y M z,kV1dO
^ r uk{G  ~o3  JZ*`Sd 6+  
Z t  y~ ) ( 2f L  6.
^  X .EB %FJ%E  !8Z	&, U 6 j 3{ Y `'N  z} Za@ wkP 
^	l   YZ  [ `8! -Z	   	  6 K p! q :Z; iy}`L ' 
^, ۢ 0 #
K  X ~s BZ
 5 sl   6 0]  	Z R 	z{= 7 ) v3G 
^D
 W  - P$ . ]Z
 R > '  6 ;8 	X ?-& yy2CX 
G 
^e Q 0 he  6 LxJ/Z
 mE+ &4 6 OG\ !uY "AC   czyW 2L6  I L_%  
^5 9y  	J y R hZ
 C[ 6 X> [Y >$ zwP*i  `( X
h) d 
s:  :\ T mZ  y 6 ! { ?Y F bnyw a @y< & k!  
] &R, s 
        "          $  '                                                                                \ !M=R |Z  OTIz   6  9YN  0Y VO zxv HSEP   S5 
\ IW"~ 	 ^YC 
 + 5YT .Z
 UU(  6 7@Y 0Za
 'Gyu{ 6c/h ! P_9r  |
 < :`-    dj  M  Ut N Z
 
w  6DYx ![ y+{ yw a{0 >  5 S~" F
 Vy ^ .p' 
   !g6 Z
 &i	  7 xb ~[!  \zw +  ( &  * v 
 m g   b Z*"	 yZ ^# 7?]G\   yx Po W f f
6 w, N s3j   2YyZ = l@ 7 p ,[  Q \.6~{zG  2-IH (h
yAPV "8lW  ` 3T Zt Q8   7N[ WQz|8V6 V	-
  Xy` Zy ZK  6y@6 ]*# z~ M)۾ p Vr+
 e8)j+(  Q@-# oZW1N ( 6_1V \X0 xd R/ 'hN0
 N0H]L/01 N. Z  pN0 - 6O7 \R9 zgV3 *% V,t6
 S,3Y j U4)  U8"Z  kW7  6 m W1[ V,z3sY* N^( 
 6c(L  s a*- I3^+ Z J_(  5]d( l] N j& 4y  ,l"Sv(.1F  l5 2  Z4 5 P o6<a^!  c5Iy W4u "M2s.`G6@ KG lUjJ ZB^ 5lk _]! ! 8y z     O . (' by)5Xr:s4\ZHq * 4usF #T^$Z s y [  j  L. 
 <kP]B6h{QZ[" P 4* b  ^#"R
  yq0'R .90. } ?3   I3* V>Z  qX  4 g U <]!R U DzV  ( Z. M^vf 5 q`  c_mZ  #]o$ 4 Xcv^  bV
zz,Y"`/_5M]eAe0X]$Z H /U4L 4  EV5/\  ,Y,9z \# t] z^ ^  ;]Z[M 3 8u\w^ ZP]
xz Slc8 ieg*d
^_e	P[. 5ZtT\>  4cMR}^kGWz &h1 i_  Y < d^"I 'e2Z&Ze? 4c>	m  1^ d2+z ! Kj)V  u.  .z8* [vC:Z !lU ZhbG 5l]""_pF>3y~x55  6 - K '; O$ h {1! z|  IZ }  5 V OOc`   nz| u uE   xjq V la@  PqZ  8 5 q '~}a  - nyy~
v|f
<)!W $Z (  6 %+`  !/^yw 6 >b
 ER5 &HXz   1N*Z , &;\ . 6 Z $Cf 5`! p Iczs f OTdD ? RB11
 
 S8$6i U1./ ]9,%Z "eB!S 6 & 3mD W`! D 9{=&zp C '5  7
?.D F	  Z -^F7 7 ' r)Fb# d Fzm | "G l W O3CC  
  GA
 \Am kCa  ,Z rA 7  :tAa! ? _uD\yk g uvG l qxG
 N \E  GD   =F  Z DK E 7  NH
  b" 1 TDzh I VqDRU J YdFJ		 1 Y_Eyj 	 RaDL  / <jB= 6Z 'r@r0h 7  {<&b#  '?k!yf  (JB   T >}	  yT/ wP   6xL Z IrG 8  Uc?<b%  ZZ8X{zc & ]_5v5 + Xq4(	 ( M/	W $ D, " B-Z  F0r 8  K-c% 
 M'ya 
 D$D  5x&	  )%x 
 '  )OZ (?~g 8 $Pc% !-#z_ #;
 (V	 0[  3b; /ngZ  ,x  - 8 	 )z 6c#  y  1y^ t' l "	 (d 6  :` g >\ yZ ;[  8  =b d$ ' =jF-z\ * 1o  #l	Q )lU @n% Gt  
Z 8}O  _ 8  td" n۝z[ }A߭ 
x |	Q 	     a=Z  C 7 ) e    yZ      	Q jE P :& VZ :J 7 H<d!  EU+?yZ  Pb"6I  'zx2	Q    )   "| m|  Z R 7  ?
d  /AzZ 6J Om S	QPZ N'_ SPR uZ[a 7   _@ Sd! 
 a G yZq  b~N	Qp#ނO 49  ;Z>U[ 6O	d" Qz\K2F  	QQ p] I  Z ZH g 5 7< c! 2  Ax^7g  C (T 5b)  3k
 *JZ_9  # 5 >  c   z`     $  s 27  E 2 G  :ZM
o 5U  b BV$  4yc gM  
 TG   EJ   $ %W E   +_  wZ
g4  4{ d >ze v  	 3 2 #DZ
  3e}  dsm ?yii? u    "  } n&
  4Z  4 2 
Z  +e"#xl}, vL2 , 
3 (d 3 k  4 WZ 'A<9 2 ' .gG  We ! sI 5 zq  JiK NRQlMOCW*A@Q 2FE Z >L= k  1 O9 ܘd ,mL:dyuJ:?B8`h/8 8  7 9<  
Z
6	A{ E 1u E  	cG]zy $lG4K ~	N  e; NM  `	K   Z	?#V 0'f/#3b ! I 5x,% 	,n; H$n [;!  5% 3 3"Z	 o 8K 0 0b >
 
` 7A 4 	y@ a  <fT S2 *. ? i  Z  q / e  `4->By=M 4 Xo ] R]  aZ 1Gg / q a  4zz  y~o  v A}  Csz 1x  #xdBZ  |N /   { a> ""  yF2CH68 w .b  %X !8Z     P / L 	 a W [ z  6   F 2y  4 e{  }  } I  &Z 	   . R    ?a ~ 
  y A _W 'J ۘ >O   `S 0Z X W  - Z ~ c  
 x f , ^F  %?  -:  0
_ dZ{  . e q z  
 D^  v 0 g 6 -  /Z -- &P . U !f  fy b  K >AIrDM8TZ  + . > =Lg E UHy * (_^  ?^!n  B]-4  -b Q fabZ h h	} . @ h
 $h jez pr w  yg Kwxl 
        "          $  '                                                                                 dqjxZ W hj . 8 ?d{ 3h # <a 
z & &bS 	 5 g5 	 6 k|( 
	 p 
 t. .Zu< 6 . z 1g ) 	'by 4+ ! &  } Y  L T $ > Z L u  . ey #h S' y $ B I
 
i 2 
< !  Z "w  - %, ۃg 0 Ay Q3I 
 '';m  FAM  R 
C- U < @@ nZ ?b  - @R @f  B y 8 +B  	 >4D e	9 *GJ  lO    T ZZ  %[]  - 4 5ZT  ,Xf W 5BW_  6}z e 2Qm 2L Y ;Tn (	9 A M[o "D 1 X\h   > SWY  Z h 1Ti  -   U e tZ y . _ H K b 	9 mc   Y
a o F 0\
 Z d U   - s L c ~ $H Mz y )G9  \ 1A  	9 4 ;; D   @7     A4p ~Z ;29 6 -  >.' !b F G,> y~ a P)q  e !W 	9 T 3b  : 9oq = + /{B Z -   3 - @  
b U  Ty{ ]  ) S T 6	9 >  3y (   	) % / E "Z - >    , 5 C  d 1 G  
zw / N
 4 [ 8 Ki
 	9 I :S { [ ,]  6 f +j  Z d 3z   , R 4 } d ; 1  
	ys - 4   1 B  ^ 	 ? R " x ; Y   ( ^ Z * _  + O `_]e x ^50  yp  SAU   b ;;  g	 : 3   - 
5` = @Z ? I  + ' Lc Xb  /Ozm " OV = fd	 M al&" '\ N =hW 5G G g 4qZ 3fq+
 * f   #fd 
d-    wl  
c&  
 7 f T	 N i  W l O W 5p' hZ H AuN 7W )   #~S !d. {gg 	 /	 
  i[   X  s 4Y9 dZ O _ ( _ ,`"  +d S 9^ 9yf 2 +^v  + 	 b S 	 c Z f b P  c b jZ  i u ! (  *p h  oe ) E{ P zc 5 Q? W  4 K`  |	 , +y  y n[   l $Zx  4( ' 	 j, 5:e % p`{ ,Oyc / c]W $
 ) ` 0 	 (b '    "b   	b a Zg   &o  d m wyb  ch 6 1_ 	 Da  Ri   H~f\Z &c|) &gWޏdm! <xap r'~ q	p6  mgKB Fna`Z ae % f\ &d }  lS   y_ +nP KpR	fpYUnbK km.  Z >ly 
 % O o !e G 0i 2y` 5`q 5 -Z`  -	 *sYM  $ ']@  ! /b7 W  @Z D d2  % Rh/ ce Ip*-  z^ *|"     	  l    Z  '   % Nu } f Iz z` -(  , ۹
4 !v& dm 1  4  Z  3 $ 8f ;iDy_ 0i   Q )  
4Gr
 V  BU; |^8=Q Z +5Z  $ 9g e +@ z` %FE  )\G 1C
4 YH6W5L{  /RM b%Z U) !E $)W  Efq[ qzc "e ~ En 
4 Gq& % 7q[ TnVZ !i) / %cG eI] zcU  9S 
4 d[;  Yeq j +b Z YP  %vS }e!YY zf[j(  } 
4 O f s .   BiZ   L-8 & {f Y_yg *; oc	
a g  /| 2Y+6Z  Om%0t & R6&f /ku!yiJ~ tMNp
ac/h#p-&{wqZ  S ' Jg qsKpyi sJ  * Hb '
a G 	t> [  Z i"p ( jFsh ;;zk W8 Hh
a s_?@[.HZ 2id (B9g
I#xl  G / '`d
a q  tw# HK  ]Z 6[ -v *Z"6g1ym O L(  k"&
a  =2u  ^ '  +?Z EG *e g Iym 
 y/
{ 'dr : 8 (Z  ) }P + bPEhNiۺyn eߨ &{lu
{ 8y; (v& w/MZ  kEK , 
Lg.7(xm^>j~P
{|QKG59 UZ   - '+ |g %B' 7+ym M2 86HW9 h2
{d=)2w:"/ Z " - v g `*]+ylO1	J1^
{P4\? cAZ n- .v{grSyle	kW)%
{J=gqB=#J5?Z X5k /|d8 g{d5Q zh Jxa+U ;b 
{f zdm tZ  wp 0  vg sQ4ygt"wC(
Q~54*yZ {&# 1s iq G zft 2x"
Qs,A-m;wMFZ R7 2 Dh )NCyd 

Q S8 , ="rZ  "RL 4  rlh  LOyd u  )>
Q   nh7  *IZ ~ 5V"ahy 5i*uFyc D3" TY>h
Q"G UO % >V4Z  % [Y4 6MO+i!x6 #ycju  I Uj "
Q  u [@vZ  g 7 *xk 9ycep '1@ 
KX ` o.}i (Q Z 1O 8	5yܪi do3$	*xef6)  "?, (
.E// D2% JM6( Z ~i=T 9Oj!0hixh 7tz RY d
S w igbZZ T Z 6b 	# : 6 E3i" 5yk0!-D#$
Bj:   3  /S Z KUM 1 ; 7 j 2} xo   1OQ
z hT k [&X Z "+ 
 <. j! >?: 
YyscH#Qb
V#Zi;5e)iZ   a =8T &sk"L  yw1
WS  q 8	  h~ X ^N.Z 7 p*bq. > M6Alh$;K By}
q;  2s>i   6.	(H .id Q %R Z9!"Z  _#` 6 ?? dGqi" oz T	T'LoR Sy-Z  b @  l Ai 0 b z  0 B ,	;}d\xAFZ v2 AS +i+
y 2I=		D w3GL,# HZ  {SHo 
 AU_ i ESy:}x DP 
 }Of	X R.0Q  V6mZ/Z S[f  &W AZGD 	!zh! /\C  ^y~ k`LH tiZ\	  {xa*L bZPB I$Z  05w Bi)\ Rg"t&# x["  N iK	j Ls c f]#  u0 [Z  U4 #Z Bt.   h!:# UyB  9 x	)t -^ 
        "          $  '                                                                                 ] Q_lZ   SMF C  6HV&i" J Iy 	N 	V, 	 	 ]8. X UdE W t(.[Z  [ V6 D 1%i! 2'uy  
 !w  y	+xX 2;7 R a+  Z  +  D  G6]i ?lz A
 l D
<	 K   b\V
O9]LZ c  E  myii[y. z n ?>S	} ; 1QL cd^Z kVH2 FW@Xd3hnEQzG2  
KW O aV  Z4Z  Y  GT ,h O2 6myJQi  2_X(  <a "J  i    ^ yZ  '>  H r i}  z3 F B' Y w5 f - /Z  [ Y H g $j > \
 uz yh` g CM' - G/: Q H]* j q # dZ  *7 " I hJ~$i h Z"x D kA 
 A } FS  E  AB$ tZ u KK   I Z i  g yj.) i5 5} s: 3 Ld )N cf "Z   yq   I 4 <kZp i  x;) y  . ]  5  yJ] { \r 7 Vc Z  ce  J sv )j! = i{ 
,y}  q:  e 
_ Ra ܔ hX^  /Y xZ 
Yo  K&_ cj! 8h
 y|l	 Kkp  e_}gH g_1 `y\' !Z A=^  KUoe Yj"g ? zz2 g; e n v_$Xb'" c 54 y7eh 4Z  f  +( K+i  
#wi! pq   yyv 
  ^u< a_  Aq    p  W  t  Z   y  d J i  ' %j ;  D zw    r  Ox  K_ ' )m  J Al   _s  ݇Z  r { H 	 J e 'z    k$ > (s c Ayy  Ln w ?  k ^ _ * n  q N \u  

 m 0  ~Z  q  b  7 J O  
i! #S yy 
;  
1 [  T t   0 g   [ i d 
$jZ   rw $ 4$ J  hvf 5[j  qo ,yzy kB 
$% gf  T = >h`  ( M m   u_ 

Z     I  G k  
}yy q r 
< >iX T o   -   Z  % . q I b T; ޸l  l 9yz  d   F\W 
jT  &N 
  G^ 
 s+K Z  Tg  H U 'l u / z{  B< 
R  O@$ T  -C2  F? L jGCi Z  2zK8u 
 H 

Q! !kT 2z}LW 5 DC -T !D= $ T%E ! kEk  DZ  C  H pDp ki >QI z~ #F  !<%   T 2/M k UI-%  |4= Z  >R)  H @gk h {=r Fy (@^v ; dJ ۲ 'R TS R Z U7  H ?_! i fqg By wh  chv  `j  & }p * o \w	   Z  dz   H y+  i vG ~ y yi   ~t  13  L 6s  %# 
/: " %Z  P:~. !c I~Q  biD ;y  >8 4   A    Z  } I I hQ| j |" yz  | 4 JS }  {} 
t |  Z  [	0  J (E l yI z "Y b xW[ Z nZ  Pz9 K '\m  z  0. 65  	.   /G&6Z  FE0 M M&j I
!{ ? b 2!b p,3p7cZ ; NC"Zk FK1>\z DSB< QVMM KSLB	z HNC LNR; Z  S[4 \J Q Yc  j Npc Oy ] Ym }VJ GRtt gKZ  I_: RK!kS.z:[)2\ Ia VNeN  PdT Q[Z  QT- U LIL
6iBL41yUR1(xV>$"T58 u 2O  YpW4sZ  h`e$ & V SFi2>j *h3 y|%j1
Fu6	-p~<Hx? {f>Z  CjW;f X ^_W2 Ni M_\# ۙyy nX g|R F9	-O1M<oS9.Z  #W*) Z WVi gLzu LfH XK
	-tS	 /[
e p <Z wl#] \Aj-k>h Tc,*yr *V+'6/ : M.2	- L=5)BiGM"I:Y Z /V2 _  *5N gh %GI .yn TPKB qDM ^	- 0G /  
$6 \'% Z . a}.g+$zi-4;>)	-T5Od]!Z =pV b%g,yfUz 	- "e Z r=(^ d/3zh  Jt: syc8 _<'(N	}Y 5$ 4X*Z L#  fQ f{$	y_9(.rz	}!-6Z ;# g6@De$y6z]
 
	}2 _(>2MLZ ;	O iN.Ryfi=^5yZn>lU@l|	}75O0;;:4Z  I k Qd V,yZ   #Z  Ab.	}  rl# 7 q-% 2 Qi4Z [	4 lS +eIqQ#xW9V ~_ 	}  bfqv  k  qK3iZ   |vb m |*}fdZ|F&yZw5 p4}	 `j e d  h!Z   t0 # n /~Hdze 
+~MDxY x7 u 
	^Us:Es*y0PxT^Z  0}A> o W ~e  i^yZ  w]	 KdO		d4b\r(U  tL Z Jo| l  " oi 3ie  fd ;5z\ jH#-3 v%8$	n!   y^ 7`% Z N 	C pG f6e 
y_& R 	Y	4?SN(Z q a3Z l4  q3(  h2 ߄yc/   )
	 #BG)3{S2OZ b*2 r h 3&lh0 	Z yhR~ I 7
 C } [ y$K]_(3Z G)k& rUD$h V R zl' eJ 1[w 
6I
V . Q{  %} .5k!AZ \ T rX"gy[0 yr H\Ax  WH"
7QCmU7V YU= *Z Tdd   s YRZi   US
yx  \Q   Vj /
sN ۅ`z[ \	 Z 4  s h bq# x} "Y"\T
 X   ]^ c RZ f!  sd gb2 {x
 @a7 
 ^	 4
 [06 [6  `/Z   a &y s,`% !g]   hz 1] 
X; ^	 
,]
  \ YZ;ZZ ?_ s dZh tg y1 >k#  ij)P 	
L j4=  rBo  Y }S^Z   f? s svh  dkw  My ne qO u
Ln7 k!x S 
        "          $  '                                                                                U AjR cZ  j 2 r  c6f  ]#Fyz  \I@ B N^c3 
L^]1 Z1+ 	GX .Z  4]  6 r |f  12h F j!'}y  hh"D!  (d#I k
L aH ~nc  Id  Z c   r ao  	g f  y 9 h  w h -
L j Y  m  
` " p  N zZ  t  7 rC y og: } z   
U
L &!Lo  (U8  /EZ   n}6^   r Q|99 h 1 [7% y' 8h w <  <
Y B ,D) ^ :FZ  Js r r K+h   uI6Oz mHm2er jG (
Y kC "D m@W  ~ 0 oAvZ  z mHo r  mH~  i! U dr@ y p= 7siC 
Y.gF 
= %lB X `o= 	Z    l:  q Z j9Q =h"  n< z g t@!  # vB 
Y ^q>X 	 Pn;N 
] iu: 	]Z  }; 	 q ~A6 h" 4 A y a =   \ : u
Y # t<  X@  <F iZ g ;uK  q [QM j# MGz y % _8Z )b k r-P5
Y  (B3 g ,) + 2 "Z  6   q |9\ i$ z= z ~< G 5
Y B%.d W	2  I 8Z  " :   q ];j$ E}6 
0x L2  p0 -
' 2܌  y8mݽ + 9-?Z  . 5  q  0 zDp$  q+ y pc+  , G
' -   .H  10Z  ' 6 p   w5hFo$ ) -2Dz : S.Zd ! 0P2
' "4& e!3  5 8/4Z  L2+F p u9#q$  _6j z  `2   h%/nk
'   h2 ; ^6] b8Z  }Z5c o  -2*#p$  .Ly - 3~q < 9Z
' 9 v=z ) rE  vOcݗZ    oPI o hFCm% n=A&z  z%<;1  :B?
'  ICJ^  PB\ 
 R:mkZ  U4f* n  [4Fm% ( _?:y , YHJ. % QI]	 " IJWk ( FO> 1 FO*$2Z 3 DF4 m 0 E95un% * H,,z  lK+$C  KKE   	  AGD  8 LD<   TE?#Z NJE l IP4k% IRz  ;SK ' X"	  ] ]G \Z )_ k Egl#  ai+z{ * lj : FoT	 ,~  Z jY%m# i zx 6Y P  EN 	 5 7L  P O J LN )Z "K<
 hI !]l"J 2zt L	J6 DQ s-	 XS% 3 @R!( x !R KZ  U g Z Vym" 
[Wyq _v aF	_  u _  rd Z i  e nd'0j# 	_H zo]h mzc] ۵	u i% ? 5f x # bQZ S` d gaHl! EbHyjb g  	uk/pt .wZ p# c _l  }Jpzgb 1	us6 /] #&Z %$n!l b o cm \MBzfW}9v  <	u3LN4 =&8 Z  <W a z a: l  6 zb( 96P !A{	uV
TI\  ~ R~^  Z    `zl Y ya_C  i 	u  ^&BIT3 Z 2 :R RD _ a X m mi{ok ya  -		0 2x n ^o/)  3M6Z  P90 _ hRY$'m]*!z`>[+   vIZ( z	0{Y$U2 pUY Q[wZ  j\_ ^ Ym X9 ry`Y  ,_ZZ4	0 H[
	 {g`> [k@Z  )s$a ^p"Yki CJx_b#Y<`*	0a*sX]% { XR w'Z  L E ^ I"[k EK	xaM- dkM  	0O   S 4 ^WLZ GZ~, ^a6k "vi 1xc'q   ('sq!_ "	0 ew   S   ^GZ  {H _ 9`M
nkS
 3yf T   U 	 $S S   P   ) P  FZ  n S   _ oV8i Yۨzi M1Y ^  S W$  $	V8{ :Z<D  tb3/Z <f&[  ( _ X a  j  ]6 zm ]? Ac	 nh!> srl .lZ  >Z WTg G `t_ 
kX*zq |W6* ]3	 ^X )c G^X  "P  Z I5  `FG j H0M 2yu  lBND   :b  ]	  7_n ]9D  "; xZ  q:   `  1:  i Y q;  yz  ]=    NE  +	  ]I  * $ KH   = G  Z  b F  G `  L . i  Y y  {M g _ 3 	  ^} W |	  t= Z  0 ;k  Q `  - i  "Z z  +`p F V Y <l  (	g @Vk 5y B:v 4#  H$ *Z  ? )}  #* ` Ra(   i G?Oj  x GX4 6 Zo
  	g iJm	  0 d~C
   @W EZ     ` ?3v i {s` Gz P{ 
 F N	g sv })9 D  =Z    _(8  ph!V:y M Kv4		g lzi  {u, @ v_?:Z  ` bZG  ^ > Jmr h  pT 
4z  l&(  
 KM 	g - +-A 
 ^ NZ %e { -Z{ 4Z  t O\ 
5	 ] Q pc< +h! $ p.  #x  }s5   _  	g 	 3w. | . h 	 Ov 	kZ  _ vC  \ Y 
i  fg  H _|  %z 0 Y  
 T8 |
   V7 Wg ]= ^Z  f - [ ;q kh  Ky. '{ Hzb-  5uR 
  p  m $oN Z  s<  
- Z uuo  h `w x Hy _r  	 !xl  
   fF G b  b- gZ  d= " Xh3x 34hn 5y q -9  so $
  =uU   CuI  ! ,uB Z   s%( . W i)  i  ^'  yY( Y* K
  W.   O4    H7 ~Z    %F7 T U  M7 I*h  	U9 ]ߓzY; Z= 
 ^A   b@   d: Z   c0  S  `# Pg 
 $\ z  `  
c %
d jb `	 Z  c i Q c .Eg XyM1Qj6E
a].ux%!<Z L Piy	 ##
 h
  0Zl  N% kj  y $ J zV
h	 I|s 5ui KZJ m M2 zi. }y:  L 
X	  Y ^ Z .?Z_ Kihn1YztGY
C z=
 / 6   9/Z   
<&~ J @!iT XzTM?l
(Y)Z9Z )D H 420am  %z  
($ [3rU9;iZ=0 F{qR:mJOzn& zV 
        	"          $  '                                                                                tfZ2 DC "k!K |z}Q_; U ZCVfM-ZH6 CSZ1_m-^F\'z}i~  !tv  |~i g 
]~'e ZqM ! A^" )m&V
 0y{\? 4 l 8@ | :p {$ 9
 r] 8Z	m 6q @q 2zk  u#E /{x )qB( . e[S -Xr +jS '1U_ %>Z
 	[" " ? a k e6 zvgL eJ =^eU f^  XiM Zm1 9 =o( +l mA 6Kzuhj 2ft (^f
U "Df:  ui=Zl3  <l   jm{tnR7q! ^u'y)Us)Z
f& ;Z)<mkZ3zqfCujLޞ^fEJ[c;RC`=-MZ_I   : aP k  bP8yp jO4 mLg^ mE  pA  yE*bZ S` 9 \|wl! Uzn ,>|)1 2y5^ 5`3 =6* @"Z 9  8 0/(o! />zl 5TY 7Gh	^ /~p $K$~, #	.]Z )8' 7 -; "m  .: 
Jzk ,95 `   'P9 &ge  HH ܞ 7P 9ݦ <L hZ cF  6 ? =m! ? yi aB  DE#9e 
 GKV  fSr= YwZ b{ 5 n|4m! xlyh $rlP5 )pJCe  x*F&  F4 &=4Z |04+E 5 s30#tn# m,1 zg %i%' 2g#Oe @d!   Gc F 
 Ae Z 2j M 4 +t zm! 5 bzh I ^e U {ae L  A  >R MݢZ D4 4 J5bl" OHzh OV!  M[	e L_(M G`[ @_XZ 4\  3 0` Uln! 8e Hzg Co Ewu 8oG *} (#Z 1w3 2 8Z)5|m! 4L$,yg &R 5$P b n  p u 6 y 6 
{'Z q 2 j`m" jezi r!R  +w? /|P  6- k\ 8  Z 2  1 ) dn  'uyi $]q ]V< i x3 ,{kZ 9u 1 @l
m! Bjayj Gv< M  U [r< anfZ 	 bN

H 0  \F0~  !n! ST222yl Po-6 P('.   N#A%  KqA!% Ob DZ YU  0  YQ  wm  
 RUS zm  Ga   Gp9#  MzMQ n PzK  Ox@ Z Ky8   0   E.  n!  A  zm  <H <۟
 9k 4QS .YZ - /   ,D!o!   '2*yo  3 %&&
  6  E`!W I+Z K77
 /  TYO3p!  jRxW2yo $ T8 ) gX0
 5 ] 6w G < /l I a &Z - ~z !f / MW  [n" 6?6 <zo 5=  EG =
  YTH  h^O  nh+Z cs4IV . Fx>n! ,yE"zp -x=3  $ Iv.!
  xr&	i ? g'n i X*Z t Q,\ . U W2vm" 	 Kc9Z{pl<zjE  
s`[zZ<cZ  ~o3 . " )4o# yp"my1K	M	: [q2 . i 6Z = Ut0 . ^ z'n" \ m!yp H Z n , J v	  ~G6 MF &A|Z   B% /  3K pn - XOUyyo / qHK5 # p< G	 	 R0	 %. . 4  yZ> m / B tn  +> ;xo & _9  E ;	 P IV G X v : |c%Z . JhE /  e^mbzp  =aqf / b	 Dfs o -Z, /6n  2	yno<(Al "'	  |4Z  # / + 0p   )=zn 
 	Sd
rZN 0 m ۷zm;	Sq%+Z1 1   8k # V?yn = {M
 R X	S H qX3 ' OQr  9N_ 1Z -Ug" 1 %bk  (m*ayn = 4mw6 H 4dt3)	S ( W)sO"Ne ZXW 2mWlK8yp* #i	S   ,	$ * 7N3
 % -7Z  
9 3= k/N zp<m [DES	SLl- N2KO^ZH.c 3;j2zrl2y9	SC,qH
. >E
	Z ' QB f 4 ] F<j XLyt  S) 0V-' V@5m UQ4< .X]*Z  ]\^)#A 5 S ^fW	 i s -mX yv I mmE l- p ? 
~  H QZ +  5  ;$j R YVyx k l-
 b s
C   D op   __J 0   ML 1Z BV  v 6  Gm gk " VZ <x| 9 a  E X
 y B 7m   ( ]e  ~[b 1Z_  6j  jn L )z~ h :   4] %  # ?T .  6 8K :  %% ; 4I = 4lZ 2 3O T 5 6  (T  ,j V  #z Y    \ @     *` 	  4f  $ 3j 
tZ & (d
 2  7  Z	  ljR[ *yW
m 	e
 r ` 
q  # =\ 
Z J dC 
F 7 A P= 
Yi   M 
y  T   #7M    R	   j   n Z  r) ( 7 ! s&/ h 1 U) Ez 6   &* 
   (S G 	7   = e 
=Z #7  
"V 7  )' 3%h ' 3, 5x D d- 
-i I r0 
$ 5 L8 !  %I  3 
 ,r Z 	 :) 	H 6 0 	f  E~ z < j.  M C} X h V    0  #r0^  Z]6j  6  jed
 ߴz W  :f` 1{ yC Z cy 
 5 ' @ Gd y\ y M
t 
 0	2X+#
d >  tR5 #Z  5	 qR c<!~ yyWp"(: 1z?0 6B	27R< . KP %7l !8ZU 71  E 4 <  bOvH y+^;  b 	2B5\D   J0 {":K &Z  9X  4Ec icR % -y hMc L  x  r	2R8 ntj 	R F* Z yLi  3  ^39 
ewK z <SF  JF 	2  \o?   / @8    *9 EZ #)> (  2b1;c >8& Yz 8  
* g/  	2 m/ )
o6 	0$Z  
& 1 fp!` ^zHP c#	2 f +-Z 3X F:ZD  0 .P8 X_,V y @7U /   9M 		  5JB * U >N m KT TZ LU  /  KXS ^ uNZ9 1y [O  { 
f8x e	  k) i) C 
        
"          $  '                                                                                e26 XZ 6d> 
 . vcL h _ qib  ny A pp  " @uQ  	 4 "x	 W i}A  vQ -Z ng~| 6 - yg  1m`wN  'yz@ K ! - }A   l	 l~_   l} * X 2| 3 Zup X  ,^ r _ "J x  z j9
   .= t:	 d 6"x I q  0 \ 

  Z   , [   y_ ZF f ߵx U\   r 	" f: + ' W6 4Z b lW  + h 
l? 
_ 8^u y ` r 3
8 
  /G  I + ZR  *  +i_ > 6<xc 2 /X (
8 tV[ "T ?\  | VeX Z $S   * 
Sb  ^ Vy 	WENv
8^@Y /<mF n%Dh Z -^Hk% ( ) dH)_ XL{ S9  Vn 5 ޤ
8 Y ` d T &$ fZ 1  ( &J 	_ :|9 yX  
z
8 &   g    	oZ a   (Z ja e Z{{ xe )
 &L' 5
8  S6 3 a!*-e"Z`(  's[? `]U=p   {y[Q+paP0^
8pUW VZN9ZZqX 'TY3aK[
nxra[Ga`|
 i!ܷ pݔ }qZq ? 't ?av} yng
 Z 7
h  }z C . Z 4|  & 'nr <a  crg yhMe 1  1] 
e"U q&b}#Rc C4-X o4Z
De +v & xs
#b {  yc z  s 
g
p U1q VToZ
HmX &nan y^  
i 7l  `# &y
\> 	d/ [t\q Z
W>x ܹ &kMv c|myYm  u
 +G '| 2RZh b 'dqX uhcO^P( s{TL_RS _t]k w
j^ 9 z6 Zb $ #Z
3 ' 5cz9,yOUB$ee?' 
\;* :E[ 2Zs. '}PboJzLU+`?
n:kB%}Q<DZ 
HbIvD ( /QqP  /c Pq` V+yIfx sZI
Un rQ= R_Z
3cB (}lT!bfzE[RW
 X  \sPSmZ
O  $
0 (T]  bGo 2~yCZfs r6<oTN .N
VF0%Q #hI!H .J gZ	 8  )md bdM yBy[0j 
S E 89 &LZ | B *$ (haUY"x@T, p.r۱
Y
$V*Zc1 * O3d a-Z4y@ %_
#8hYiZ * + G:c 7~3y>j0
6/ "i &CZ FFL! , B9 xc !,[y@% A#X
 "'_  +' ) +Z $ 2	a -  ,1c  #yA 
  O  $
 ' EB. - <I>&p %IA^Z K:D - S/hob  Y* yA 	^0 e2
 
 	l. t 9 x&  G!Z $! 6 .& c )  yC V*  L {, 	0
[ i .3 % G8. <6Z>0 / ;x@'Je 
 IYD!zE ' 9ME  5 +K@
[ 0 M=L N>P@5ZXB\ 0  dGpd B 6}OxyH ` CT; ] 8NS
[ ? *C
  !=  P:Z  29x 1  $<<bf   -QD'yL 2 E_M J X_]
[ I XXV ' BHht  *:l Z  3C 2 1 <nc D H	yO N &Z*b A 1c&
[ ' @g   Tt 	 U
yQZ .	, 3 j6~d "M2&xS D A(d E (Og"8
[ . 6`)   9c  @[Z   <Uk 3  $X!ed "  Y(KByX !X*
  Y" 
 ` me  g t  *i Z  ' @f  4 ) De# d * &j+ Uy^ 'f<' &Xe
 +P . U Wv ' !`I'.Z   h! 5 mc! l 	ya jj  g, 
  hT 4  e2  `' 	 1Z   ]+ 
 6 Y" 
d  (Y) *6yf 7Z 6 I_ 3K
 R b
 ) * SdF  " AcO  
 Z  b2   7c!  
c d4 
Fxl -fPo 
 >hB 
l
 f< 	( `d   g3 Z    j 
 8   jb de 4yqe z  n0 ^
 ! [t   ~u8  vqS Z   St ^ 9  3zH 	d  &~c yx :{ p  l 
 UaCi i^N gbZ  !d a :  h  d Jlt y~Xu C'	 /5f 	 Z4` T *Z  R #` : %  f 75 zb\M	 2  S c)j -eZ  o ?# ;  Uf  ^/ ly b _hVR w` 	X  8&  Y@#
5Z __m <Hmf ! :fMy < 9] }3	 .vSj% 0*. x7'EZ  ,>Kj =D @e (-8=x QD56:	D F l Pss% [,4kZ _r75@ >H,Af` 7$
y ~$   .	  6W a ]G q / Z  1 O   ?ZJ !  fe dXcFzj]+ zbM	 Og oj2 Ak>Z   k<~ ? f qOef ~} x 9 
. H{ 		~Z 2ysO/\V Z  X,< 	= @Z h!Q fx>_ax h     	aT  ^Q D    "Z  %". A 3h  5yr -oHiC$	S^H !"bD\I  NfQ:  Z a0Bi A>{( k ] yh_ Nu	  W
 cZ 9 + 1 l B  C h   y n . 	 S SF  	1  f2 Z Z   CNLoE fhna= z%A  9.
_ =	^  ~.
  M @:
  /J4Z +f'n  DMA h;R `z-O< 1{F<  6l	^ $%  / > _ %m	 !^Z  l d E )l 2h?* y^'%( l 	&
+! 8	^>v 	_P  Z! ?Z  6 &c*  FZsM h i nyIn~o Dk 	^VF 	ۀPv Ih T`i Z  TkL 	 G ~ IbgB}y%6, 	^2! I. ). JZ  IB)  H>AUg  / ]VzoZ,

/ xy	^ >%
 /;" 61) 0NZ I & J*r_s !d dl(1  qy m. kDe5	^rI=q"_k b  Z   LI S# md d3'[ (z ,3f &/ 	@	F#7zD-s #iG9~ gZ >- , M6 d   6!Bz,a81s%U4J$y	F \3iL  c/} O 
        "          $  '                                                                                &s} fZ eV 	 OD> "b" 1: 	{ HaD 	FC ^X -Z 5 &6 Q!. 1a!*
  'z23	" 6  	FO4I 1K  {Q1iZ  5~J 	 Sz> 0a Jw x2Z|  hT	F57s   
 } KZ  Uۚc:; ߵy W 	F   l
sC 48FZ   
 W k c S A
z ?re . QuC	V ul ) u  Wu  
Z e!u  Z%+Oc v*L6Lyy/29~.f)	V
 /"w Kq4   e@ Z Q`N  \P]Vx c;\X x} [R)  X  4]M 	V  <aE   9hI= { s fd^  Z  
 p[}  O _ a	 d pt  Qy|z>s 	
 P oz ފ	V  z @ [ [t q E W_ 
dZ .  a 
 C
! 
b! 9 
 y| V Z v  a ~ 
z	V Jx  " 
  pZ  Q  d Q`" Q 'uy #y|  L)bz (  +P 5	V  b2E3 	3 U FD} *R 4 ^A 
#Z  1 `:   e ( ?F2k   `" '8) ) +z{^!  ~ G *	V * J  d qG 
K q O% Z  _ .C 	 h O I"^l 
G`$ G nk_ 
z| ? U^Gd  (52 
	 -  	;& 
ݖ  S  Z  ) h   k > y V]# ` m= 
yz  }2    H	 w ~\  B !d| U *]Y# Z  II  m w )N K[   om yy ^ \ - 2 # 	 %   &? < 28 4 S ?Y 4Z  Q # + o 9 # #[ + 
2  yy 0 9?7  % A QJVr	 T /L p;w (Z   $C{ q  *8+:[ Y eZ{w 0! #1	 (\z& . . / "AZ  :  t ]u 	[!  
 yu  ? 8 w 		 Z-5 a L"  S  O qZ  U + 2 v EDd \% /d ys "yq4 % f@ 	 -w - 'z 6 9 #}Z  R!* 3 x gf<` 5[& j -yq ]	 
$ Mfe !
	 I:@  C LBG  ?wp ;Z  J  { < [# | zp 4[8 	^ RSS 	 Xp 3  S d  M 0 rZ  G =  ~ <qk  K]! 8dNS yl E}g1c O az  2	 k   A@&   s4Z y "[=zj V ) n 	 |x+V  s"DQ $9bZ  %
  1S, [fd2cygy6Lx6.s	 %k c[!T % kZ  &  ['31[  :ezeX2v	| .eXD eH Z  q> Y  KF [\ Yeyam.z~I۱	U#HH 
,3Z  )d  >wZ] Av9z` 7 (	 % 	 h FZ  ^
y]Y"	0	6 4
 / ,xw&ZZ  ./>!  g x`az[lx@S}=`	Mg_vkZ ~e \ _yY|y{2	 on 2}Z  :{5G  2  }[>  n` xV    b 	z< mw{) F } a Z |  = z   awyUpQm(	
  n    u! .- 6Z  	.I1  }+V'Wa 
r12!yRm; vn@
t9;Kv2j'Z W!   M&Db  kT2hzQee;IB{n8_
g-
+s_"zh&RZ p2y dj4u@a?]"yOn\
fg ~
e	 G_`za2
Z =j-  (<l ya _^$  yP XS'  N  T1  
[> U  sac Xgp 
Z mtK ,^  nU 6ub\in7 2:xOWf (xd, "=
 la'6   Skf 
U Z c7   $5+ b J BzO 2~9  p 
?  f q   Z +  *9b h yQ a .   # 
?X8y{rR.Z    e nc ~ 3zS > 
GA ER 
?xCX2z7d? *Z  $N  gY _c | 
\ *yV S[ 6 ] 3q
?b )k "  Z    7 e 9 >VzY yn^w
?H1P[Z  ,_V!  ` _H
e edPux\ 8i
lq
?f(~a)b/ dZ   e<fX  # eIKd fH3y_ e0`hf	K
?k.d|Z   4_  ! e $nyb LF)'p
@Q(D5N`.s4kn)*Z w#Z y d ~! yg 'I .
@2=n9cAwKZ ZFO  WQT e[\l OzjhaZ ~]  
@Y} OR   IE CZ 3' /4f a=  yn SOm `QY
@vLsNEaUW9Z >Zl @V)dPOgypcE*zz>
@A,K$]943Z w57 ,Ie q*$	xu[Q LU !
@DwGJ?HdlZ  e/`?zw7U* (
F n  W4 |!Z Y! ދ a< Df YD.zyU<x`3
F~:K6W3  Z N ' wB f!InKy|?}Kl
FU GL 
?
Z 4Mg! :MQ2f"I>5y~V-Z$
F[!X!   1P'Z GI fO IU ve!Q9 @x`
 6h }Y
Fg i6rwZ  |  
#e  my۴p
F V D Z   0<  @ G{@e K Tx . ud 5s
 
ucf gm RZZ  +M<0  .Vee "bvy aZ1__$  6i
m r /g  %n !`Z *  c  i.9g <yO!T1^ A
.~()=)  0W7X LZ 1o 	 b$,u  f._ Dy46;[
	@C!zoF@'#zB`Z Bb>bm Ol9H  d <)  x C H
 d'I
H !E  u :DZ  3 :dcAGy7K 	S %Z
78
 Nj$/  ah6 / 9Qc0jZ  8& 6!dD  sy TRq Z1#
C ibu6{  mV r] Z  , o    oe!   --y  & 0 <	h	 
 =p sqZ =L d"=y 
3 ,Fru	rQO7K 
        "          $  '                                                                                J^#cZ I? ]!f% }z L| 4  ~ A  	 G b$  ' D S l[n -|Z 
 (6 oW0 &1e&^&G %(z^(| '" ' * 	 * ) L ) vY +Z c -  c 0Bd"l  2y<; 1P <&B ,d	 2 ( 6 ' . 0 $Z  O l, "'  f .$_  ۪c  T 3H  ߣy 4& r I3$ 	 n6
E  B  K % wLf NZ    EWi   &gk /c; zBDS ~ &&  T	w @/= 
 5 b  ^M[ Z  	6   n;  +)b yE&6Py ?D)2wv>),	wF7 "e }4  {32 Z 6  y :!,b rF1z 7X:(cc5	w  Jh&   U Z < siyw Gd 3z
`*Kބ	w6,K[4ksZ 	;7 b! V  y pj_	wC Dk bi	|Z  A[>  gNS} FbXm yZ#I (S.5	wLF33XR>5 X*kA4
#Z  ND6  uFE b Il ,zVK1 jH+	woEIP/CPZ { W/[Eb  Z9o 
x[Ds VwfAU (	UCz? E|A; xcAZ A|H=V=:La E9 z 0 M@  QL ;	U OPF O@dPS*x Z  Z) 2 cBKHbR^	z IlP i_	UZ\%uEo4s*a2 4Z p + Its #b qR z 57  UK
	U e G  p    Z  e  s mw0a:

  z)m
^ | 	U  y4	Q LP[ XZ   xZfܞ! [Y
  zb Z z as  . ?gq 	U gk> ls   DkiK IZ  l zi 4 # M g8 bb y k y}  xm  9ni	 @ 7k  	 ' k   A p  #,Z  m r3&  rp
5b  ln-y|  |oB$ d wq!i 	 O Vr#L 5 b 3u! n v$6Z  Ot*( o&"b jzz % =kDU { n 	  l g  bZ  t e+ j] ]c l xz .i" ej	  	nv  "t2  /y'Z  v }c- z{c yZxz v>H y 5qW	 1 ]nac :s_eE {S`GZ  [SIE. H ld L23yy oT6H \m.	 k !e %r [ M}o l!I H 5[v o ^Z  /Ks 0 %Obd G[J 
zz `7 ' ^2 	 _3 t b4 ;1 yc1Z  9\+M2 S#  c 'X  zz cb   d^  ۉ	 \
  (T l YWLZ  H bar4 J Tci  c c ?`Y x} j `r Wb	 Gc [^C W#xZ  T%q7  
R(wc s M2
y} X G<= o X=A 0V	 i4A6} }[-O/ +&LZ  $'!s: Y&  Xb s&a Dx a%s  WK K	 XW 	P Z$q 
 W)pW 
Z  Oq'N 
R< V](1` a nf,* 
x -0  /< i	 \f2M 
 .86W j '$5X? 
sZ  L(3P ? w.4D e` 037- y }E1/ 
 c},4 
	 K-= 
p =/B 
~ ;5< Z  B;4@ 4B OB.1 ` \U+ 
z g0+ 
 j7? 
 e7  ^3 
.w Q/ 6Z  > 1X 1)E ( {7N 	'xa %7 
!y B7O 
  kEZ 	
 |o U h=  Jp Z  7\I G 5R( 	b : 	z < G @ 
m
 GO 
S M[ F Pj Z  J ۅJ ; 	/c ,%1S y  I  #0E 
 3`1  X M:  5 n d9	 J Z  iW [AN T pa 5 ay f   
 &    &h P ( Z  $H,BQ ":6a )f  2gy /r!U ( '_w  "X
 Iw  >  /#Z  'LuT =#l` CGXx 2gz f`
  Gdt !v 
u Z  L W ) t_ %C  y~ ) N
    $ D/ 
  "ZD m s^ 'Z G Z  < ^ 
6/ y|    /  
 R O 0 u g   'Z ;  ]m)_m)yy o6 B3
  ?)<"
 Z  ` ` ayu'l}
$\55 / Z ~' )c( 
(a" yq}" ܐ
*cZ dfvac^ymWlX!
YIiSn< IZ Dr_iKR[aU. =ziWQB'4 E75;C4EF+Z J 9#nkP" `T yfuW2WtyYj kX*K]4bpTZ din]vf`Y_yb[{5z^P) _%ij r$Z u4pq8,`m3'z_k-lg%] `fftk
im"Z khts]cakby_inz nx~kq$whl 4(Z jl-5RwrpH,paerw?$#z]dnu f ) c'f*}iZ iIyhaj:vCy\ln_dpSxmk@,a] ]Z f .ި|o/6bkDx]cj`$sxkbJof9jZ i 
*g `i Ry^m nl xk@V{f@ydo
Z c !a 2`f 6yan -nW%xg>!%aN K_pZ yfxkxnap  ybgz \ hx]T kM uZ Z n_0 dfB -ag* %yfm   ۪l Oxe yc~ g1. Z k j 2ag, 	yii<5 	o@ pF/ RjI fK Z dF= 	dI 	b}dKG zm~c? 1!f+6Uf /f%
%i,!CZ g+= ?f# ah 9yqi k i' 4k/ ~m2 +Z l21c.Nb[+\{tZ1r|^CqncNTw^e6b_pZ pXf}Xxb] xxzbqcnxdrff&Z ef ciyz~k	}gc :/Ef 6j)0qZ lV&jF!ah= ay}enb`_re gj'Z j!0f'ga 
d6#y~xa]  t`n 	yReXj4pVZ o mL ebj  yoi k x~g ) PRg$  vfB $