          "          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

         "          $  '                                                                                 
$g Z 9 
 
 
- z
 V z Q
" ?
!5 8 

  YU
 j
	Z

  Io
 
`
-5
#kz.
!  > Fg
 " 8 
o1
6 0I
  /gZ  	
"(&
#^!
. 	
'  y 1 s
/ j>
0R 8  
. ` D 
-9o
.Z F
2  V
5 {
.
638z
5 ? XS
6~  8
;Gt
=q 2 Vj
< ۰ZY
=/O&
? 
. Go
@ z 
<>
<n 8 0/
@ 8 . $
E
GZ ! 
CB H C 
@ 5
.
A|z 
C 8@ U 
D 8
C
 -
E: F b9~
CL /Z
?6
>X 0
/ a]
A" '%z
D!>Z~
F  	 Zp
FX 	x
CW
>oZ SV
?  !
B7
/
C{ 2#
A > , >
AV_	
E_   
HT 	 ^ 
CZ
>5  
A0 ۠
0 n
HBy
L? '
C$ i	 gF
= 
>
B Z mc
F x
B
0D
C  y ir
D 
U=  a
F	
E  F4
B   
C?Z~
Em /
E -
/ ? J{
@$6z{
=2? 3 
A0 (:	 k 
G"Bz
G   f
C; Z g 
B6g
B:
0
A] z c<
C [>
A	
?  zi
@ }
@Z
> r K eQ~
= 

1M
?wz
A  > EA
B ߺ	 
@m
; 4|
: Z F A{
<x`z
>Uu
1 # }
=g !z _ ~
;T>S~
6	 Q|
6? # e }
6yu
6GZ~
:   Dz
> 
0w
: yt
1 +&> ~gw
- 6p	}
.w3&%
4 < )d en
6 "Z n
2 {
-
2 SFy
- z +x
2[I?x
4%	 ?	|
1 
w O D}
-
4`
,lZ  
,t  V 
+g
1c|
)z Qv
*[ ? l z
*	~
,aJ
, 	މ @
,  ;Zy
)^x}
'  
1 p`
( :y
(y>
(  	 ha
,  p
*|
&0Z X-
% 5 5
*Z
1p
. z + 
+ E? @ H
& 	Z
"M(  |
# 5 a |
%_4,ZM
&5* /
& 
#;
1 d |
+ {t}
/; ?
* M	 e3
! 
! FL}
*J Z |I|
/ U 

0s
1
) z~ RD
' Q> v|
*K
	x
.? 
 ;-y
3 
_ 0~
4Zi~
3t 1 {
3 

0 _ g|
0 ^y~V}
2c>  
4 
	 Y 
1`}
0K ~
2 
Z X}
6M  _y
7
0v
5# 	zz Kv
4 ^=y
7	:}
7  EJ
6F 
U3|
5%Zu
5 4 TNs
5 
5
/ ={
4+zx
6#? \(|
6 
 	 M 6v
2 .yu
0{  y
3 Z ; }
7wy{
7
0  z
2 wzu { x
3#7?x
2	 y
1 
 x,y
1 w
/~Zv
/ 	 Tcv
4 
0w
4Mܟ{uFy
/  x> uax
(0 	 $iy
(l:~
,g N?
0 ^Z }
0gw
0k
1 .u
3 
1{r D <y
0 >|
*	 ( {
+ * [ x
.y
2}Z   p
2p  c 
.P#
0
)3zq z
( 5= i1x
,-;	x
,$|
+ ! gJ|
-/  @Z |
,NK~
, P G
0 ZN
* {o v
(o?
&	 ?/
)L 	` {
0tz
-Z 2}
'R  5 1
";
/~
 zn  
& ~> O 
.	|
/Z  |
,  Y 
'Z
# 3
#} 
0 f#
&{m}
(=~
& 	 ^H
% T(
%P~
( Z YW
* N u
(J
/4
"6{l KL
  L? y
2)	|
!o6d ;0
$x 
. 8 0
%%Z
%q!\ ' 
$  o
0 O 
  g3zk~
7>  }
m $	 V ~
!"@
# a
!N 	Z j$
H

/ 
j q{k ja
 ?,
!	
! @ q
" ۯ +
!Z~
  7 )x
 
/  |
yl F '
-? &
H E	  
~

 a <Z Q}
# \~

/ 
( 
.{k M
3> 0

	 V ~
%9 s |
!0j{
6Zn~
; 0

! 	&
.J
$!{k 
%k  ? p
" m	, 
#
 }
% q_-{
'qZ |
#E9~
 B 
/  0z
#7 rzl{
(0=r~
+[	 ~
'   z
"$ {
#,Z
  o
)] ۇ  %
,z
.*~
(v*{lny
%Q > tx
(5 	x
,j z
+& W~
)OZ
 
)`v|
,7
.wx
/Oyl nx
/?>w
. 		 v
0C Ow
1B	z
/. Z
 v
, .f&p
,6
-1q
-1SynGw
08 '?  {
2 e!	Vu
2L   }i
-  j
(! qZ
38q
& nv
-e 
/w
4<1zn tt
5@Yzp
/~	Ubn
* Y qj
,&e
'p 
}ZICf
$ 

l
%gF
/_8s
+ ۔yn n
* %?)i
)r	 h
&
  k
%  
9m
'dmZo
) i
*f 0
.e
+ [zo>h
+? Q o
( #	glo
' 2j
'  i
(  Z Fo
-Wp
.~
.
sj
.P 
,>zoj c
* 6>%f
*A2	tQl
0 ( p
2{ " ^r
10 Z fn
/s  l
/i ~
.l
2x&zpm
4 > l
4 k	kUi
0'Rl
1 q
2 Zfo
2 l
/}
/j
1s Szr o
7F?6t
:	ks s
; m
9 Pn
6Z ro
5 q
5W~
/ xr
9;zr un
:? ]l
9 +	ko
8Fp
8c m,o
: ZZ~p
:u
7T M~
/ w
5 zs) t
8$> ,i
;)	k mf
= 6$  o
< 	3gv
<*ZT w
< # u
@ }
/ags
@G {s w
@C 3?  w
<	k W>t
91 
3o
:  = m
@{ RZd$r
D>x
? ? }
/ w
9 
Gzsr
;
U?o
@E  	k vs
B F w
@ܹ R6u
>jZ q
> 
 L qq
@}
.]v
@zt8|
< 5? |
;	Xx
?z C t
G 	 )u
FZ @z
A " J~
= }
0 R4|
>? ytw
@	>Xy
BX 
	X ~
C- ~e~
@') x
:a 5MZ !s
: 4  u
B+W|
0 <z
F #zt !|
E  > = n|
@p $	X]~
=*p  
>   {~
Ad_Z|
> b.{
;4 
i~
1  
8 !&zu|
7?  g
6/ 
w	X ' |
7[^Cy
:nt}
>6 
Z  
=qݡ|
9!
~
0{
4x 'zu f}
67 S? <
8Z	X}
4  [
0R k}
2Z| ~
1[   i}
2 L}
0 |
/{u~
-> O
, H	X Z }
-m|
.  
/ Z 	 E
/ 8$sYM{
*d4@|
0 zw
% 5zv   z
&,?
*$V	F  ]
( 	! h
< L	|
Z 5z
 	2 l|
# |
0h~
&{w~
$ > f}
 f	F  }

n~
  z}
 	[Z ?y
 w
g|
0 1jx
 zw  1{
\@y
	F |
  : 
 .8
Z  |
 J qv
|
0r
Uzx t
 '? ^fw
P	F{
 y
 ) tw
6 zZv
x
d 
}
. rny
n !yx%y
H2>w
 66	F 2Ev
 .fu
P%.ou
p!CZ  s
  c 
t
}
.aw
zy  z
 ? $ =u
 #	F_s
^ t
  = u
 2Zs
! rq
!{ |
/ ]9o
yxo
? w
 
n	F gjy
!{ s
%o         "          $  '                                                                                m
" Z Gun
 (u
d{
/5u
  zz @st

 u?u
 h	7x
 1du
 ] r
DZp
 ' Bs
 T}
. ) ~x
 {y{
= y
3 	7 L t
W1Yr
6  r
 /Z f=q
&1v
$!|
- !w
b  zz `Sx
 n=y
	7v
 c Vpu
 pv
!Z5{
 k  9k~
 w{
/k{
4{ywu
! ? "1q
' 	7 	r
(a}z
)V 
( 
ۢZ $ Ux
(({u
*=|
. x
0p {z 0 {
0>T
-	7 X~
*X $ R{
-
x
0DZx
0 4 KL{
/ z|
-{
/yz}
. 	)? ,I
0 m	7~
/	|
1    -2w
4J /rZUu
66mw
4  0}
. Tz
2 '8zy {
1b!>k{
/O 	+ ~
.   C
2 c]o
6LZ 
5   |
0;{
-yht
-z{ \r
2 
> 5|
7+a	+
5#g
0 	 0"|
- ZZy
0bp~
4G ۝{
- 62
5 z{
6n?t}
5 v `	+ "N|
6K ~}
7p
7Z 5
5% k~
1k|
-f
1'z{ 
4N L?  %
27	+nn
0A 
2   ! 
9Zs
:% ^|
4 -N|
. 0 z
/i6{|
.$2@
6 	(V	+ C
<$ "N|
: }|
7
 Z
 7;
6! 
6w}
.3
6  z} 0H
8w 	a?j
;	+r
8   
67 
7Z
h
72m 
8f 
"{
. 
 
;1{}bf
<? 
: ߗ	+  
7hmf
8 ,
; Z
 - 
=]ot
=j|
/
< 	z} / 
<! P?
<	w
A $ #,
A |
=KZ
e
9 q   #
:j }
/V
?ykz}]
B*> 	 
>+ 
6w	
;W3XU
;) 
>8 "Z
 (
A  Qu
A }
/ 
> z~ 
 v
;l>`e
;*	 0
@   ~
DU  Qp~
BZ	
? 
  
=) 1|
1{
>z~|uw
> 	? &
>7 	
?bjq
A  ~ #~
B 
+Z	3y
Bae}
Bc }
1 
B, 
Ly~~
=>T~
7	 ~
:6 ~
A\u{
CZ |
A H  =|
A ]|
1g_|
AN )z} a{
? 
B> ! |
<	lmy
9(o 
v
: 
5 . v
94\Zz
;*|
? 	#g|
1 <~
A  y~|
< 7?my
<> n	 69w
> ?x
>b^y
: l Z Ez
7` s{
;Y/|
1|
?z} 91~
? 
v>
<F
	Q
: h ~
=C  >
A$AZ_
A݃ 
; ~
1 4 |
5y~u
4{= V
8U #	 % 
;Zk
<Y{{
8d Z 	|
8T oz
5}
1
5V z} v
6# h?J
8z	n
:  P7
9 '

7%Z(
4D 	4 {
4. 59}
0x
3,z|3
6$> 
9  !	 . 

: F{f
7 
5~ Z   
3 v}
2}
1y *~
5 z} 
8V>P
7	 Q
5  l
4e~
5Z
5S v b
7d U|
1
7ܬy}J3
3 t@ G
1q 
R
3N`#
7: ]
6 lZ D 
2
2u~
1 I9
6 ;z}  
9?(_
6 y
2+ 6  }
0 A_
2Z  
3  c
5"~
2
03z|  
, 5> w
/Q  -|
3[$t
4p !3 %p
11  cZ
0zj
0 j}
1 w
0Y z{ 
2e>
1 WV
. y
,J!R
0 Z 
. 
,
}
16d
+6By} 
 
0G ߾@ o 
2 y
.  
+  l 
/Zob
3 
4 ,
2 *
0 {zr
-4>
-W  }k
-H q
0VJ
2 Z sd
0j h
.V}
28
-{ z{  -
+  %?
+Y2G
.6 ?p
2 
. j h
/%Z
-!u _F
,  ~
1 { 
. NK{y
.> 
1 > R
.X
+ w
, Z 
.Jg
0I%~
1
+ 	zz 
,1 1>|
1^2p^~
4 
} <}
0: ۽>~
*WZp|
' 8 p{
( 
1 Ez
-tzyz
.? zx
- [ V 5z
+q}
- 
}
. ZZ : x
+ pkw
*~
1 
 w
* Izz  r
./>mm
0
 ?q
, 
V ~v
(0dbu
-6Zr
/# 0E A5p
) &}
/l
%y!yyDl
(~ 
 ? vhn
,  #o
,7o
*   m
( 
Z !n
'%wq
% ~
0 Ban
& yx / 
i
)zM?zj
*+ C8l
# 	  k
l
!kZ 6 n
% 
ۗ  j
&hm}
1vd
!!zy ld
 @ n;l
 q
$ m
#  h
 Z  g
i
j }
1 l
 Uzz tl
!>`o
!   q
  7n
k
p  dZ l
 .E p Pk
6{
/i
1{y iji
 '> | j
$"i
   h
k  k f
Zle
 {i
 }
0 5i
Hy{d
@ b
  d
 nd
`
F 
Z _
 .e
{
/Ck
  ۳yy h
 #? <d
-`

U    _
 
 Rb
Ze
	w  H9c
 >{
/ X XX
`hz{nP? . JE 0  C;5 $ 0   Z P,8*z
. \$1 
,zz   6>
k2 	( m " 5j Z#
   +
 w
- U2
4yz2<
	? C
P 	u	 Z !O
1Z
 t`
Z Z  c
,i
3+x
- eKo
" 
y{ w
$>}
%	 8 }
& 
 cw
)p
,_Z ! m
+ 	 o
(Qx
- s
+)4y{  
u
,5 @ t
( &	 *<p
&l
&   o
& ZZ /q
'p
)p Mx
, n
-R zz ^k
3?l
2)	 {uj
.k 6 { hk
*Z3p
,*8Z N(u
4 	#  v
= y
-t
? zz : r
< ;? Lq
7'	q
2O> ' tt
. 
 x
1[Z {
4[   t
5l x
- p
3 Ryy !<t
2
s?z
/ 8	 ~
/  J~
37~
3Z z
3V 	i s {
5w
-
4zz 
2M 0?  
4,	Qy
4 nXv
3 
 z
-Z~
, ]	
1 &y
- z
6zz 
3N? < ~
- 
	Q |
,  Z z
)' 
y
(V 5RZ y
' 4 1=|
,+y
-
/  #zz 
+  ? P
' @	Q&
% 
*b 
 j
-Zz
- x
-O 
y
,  l
+1Jzz
*@ u=
. 
	Q  {
2{
0 P 
+ 6Z &
)#
)	y
-   R
+ zy ]
*Q@ ~
'g	Q 
%  
,  
2-Z
2  
1 `z
- 5k
3yy,
2 ? 
0# 	a	Q ^
.
+e 
-# Z  a
/N$M
.y4<y
. {I
,o 
5zy  
*,@
,p$	 R 
/c !/ "
/c n
+Z = 
(I 
[ k
+ y
- 

-yx  
* ? 
) ~	 
*%
,  
/ 	Z	 Ag
1
8
0 y
- 
/T yy e
,]?
,<	 }
,7   8
,@
-Z
 s*
+ T  
. (z
-~
3`zy M 
5k 
3?  
2	q
- + M
/ 5 )
2?Z

32 
7 
y
- \
6 !zzz 
02>j
0c 6X	 
1 	.I *2
2=%Y

3!`Z w
6 
 ~ L
8.{
.
49zy {Z
4Y > d 
5>	
/ b
1  { m
3 MHZe
4} < 
2b C}
,  
0?zxo
/*? " Q
8 	 )
?U
:[         "          $  '                                                                                 
2 Z l
.
   
/{
-
3[ 
yy 
7+ p> (<
9	)
6  
1w U L
.MZ
/f }Y
5} G{
. \
9yy
9Z> _
4 	 r \
0 1"[{
06 ? |
5p 	/Z  
8&6\
8!|
.  H
:d  yx }
=b?z
=K	
< \ =
<L g
8
Z
l
5,  ]
8Q m|
. 
?s){x~
A   > }Uz
< +	 )[z
5^
5p `-
9 ێZ
 >
<1e
:x|
. F 
9 
{x Q 2
7 >L
4f	 $ 
0b  c 
0?G
1Z
  H
0L 
 o 
.]|
.l
,Hyx
, 	> 7
1 F	
2.	z
0  {[
(v /1Z
~
$6
' | 0|
- ob
, '=zz X
0!@
0 
 aE
+}  8
%tO
#bZ @
' 
 H 0
- #|
.M
/Szz & 
,8 	> b 
%|M
H
$4] 	 W
'H 	 t 
(Zi
)g
( ې}
/ {1
)z{
+]r?k
- C
 mQ
. 
- 
+  Z hU
+ U J
-v|
/
.8zz K+
* 
9@ !
#
S
' ' 
.   6 #
2Z:
1  
.k 
-}
. Q 
,6z{7
0`20> A
2 (j
 [ 
/"UW
.{ 
/ Z [&
5
6~
.k
4" z{ `N
4 Z?
3
 
4   LQ
5 C
4Z
0> 68~
- V}
. 
2z|o
6O> "

9 y
 + '~
7hITy
7  z
7m Z G 
6kF
:0`~
0 `
;8 

z} S 
9jJ?[
8
){
8 	 ],x
7t|
5|Z
: 	 x XP
? u}
/
>:*z~
7  *? FT~
4G 6c
)-~
7?3c~
>) 8D|
@ "Z {
;3 ~w
8V ~
/  
= y~  
Bc?tJ|
@c
)  }
:L  5 m|
8 SG7~
9^Z h
<C 
 D 
>,~
/J
;z} u
8Q 
	? Cu
>l  O
)s{
Ao
> \ ?B
;K Z}
;TH,{
=  
0 9W|
?c <{~
<>s
8  
) +O
8 
;jc}
:Z %z
6 4 }
3 ~
1dZ
6 z~ 
: 
?   e~
? u
)kK{
;(* w
4 5 2 z
44eZuQ~
8d* +~
; 
#e~
/ 9}
7 zv|
4 %?|
7) a
+ ;N}
:F }
:&WO
;z Z 4a}
:V j{
4+|
0pu
/'  { (`u
/ 
r>z{
6a

+d|
9A  ?{
7~ 
 }
3IIZao~
3f~
3 
}
0  W|
8 y~aLz
8x@ w
8e "
+ ' w
4;gM|
5dU ?
8 
Z 1{
7v~pv
4e}
0u
2 
z~ 2=y
6{ s?~
;B
+{k
=+  ,c
; {
6%Z`v
3  4 dt
7 	5T}
0hz
;,Bz~X~
<$> O}
8 !
+z
9z MM~{
<}
= Z I~
; L[{
7k~
1 {
:W z~  ~
<rU?V`
?

+ g
>- 
 (~
:o~{
:f Z  z
:~ 
 &M|
= m~
0}
=5ܕz}u
< N> )t
9 
 	
<Fe6
= D  "
; dZo
8Z
6  m~
0 e
5 
4z|
8?M
8
 8~
5 3 E|
2eO
1RZ 
4R 
  
5"}
1Zp
03iz| 
.  5? "
--
 h
+|$ 1
-E !& )I
+:   TZ
*Y~
+w 	d}
2 .t
*' y{
(
?lg
,  
  !
/e uU{
,KV
x
&[Z 
~u
% s
%g2~
1Nt
'zyz^y
' ? 0|
)
 Ew
+p
( 
  l
% {ZOn
% p
( ~
0  n
(zy]l
(N? _k
' 	
  (Ql
)yQyk
)ld
%. Z %`
"LJf
$-}
0jn
& ]zv "m
(J ?ch
'`1
 U0e
"6n j
" .q
'R%ZOu
(!Z{s
% 
 d~
0 Ao
#/yvHp
(@7s
% $	  x
  n;U|
 {
! Z !z
'Gh{
*}
1 {
)` zv 0b|
&g<=}}
%MT	 
)  2
,2 ۚ
-Zu
+(  (
-E }
0]
.]ytbM
/  @ 
2 4	
1HV
0  
0_ 
8Z .
2 |T
19}
0Y
1 
)zr 
 
/ ?X}
3
n		z
5 
 v
20!ew
06Z |
1& 
0S (P|
8&}
0xz
9.!zq Dw
7e  @ .w
3	w
2>2t
4  *s
6 ZOt
3hv
/  |
0  s
-F zor
.1C?](p
3.,	 q
2( 
	- r
1KCZz
0Z~|
2g ۏ  s
7G}
0_k
7zo5l
0 y?  q
* 	9ks
, t
3  ,<r
5Zr
0K vq
, 	}
0 3r
1NUzmt
0k? w
,g 	9 3w
*/ 0v
/w
1  *Z *v
,B 	.q
*.6|
1uRl
+ 1{l m
/ 
'>p
-"#	9rp
-3  	q
/]   Mr
4Ztt
5B\u
4v |
1  p
2T{lwl
3>n
6 	9 *q
5zzq
5 m
2 
Z 1bg
6   k
:}
0 8t
@ ۾{j 6w
; ?p
2>	9l
0N 	 0p
6 
my
?o}Zq{
@   #{
< 3{
1z
7sazjy
7  ? v
9g .	9 	 :o
=|l
?jk
=]  Z ! k
; qm
9 b{
0k
; +yk -f
<6?e
9w2	9 b
8 ) :\`
5B "_
2 Z Md
3  >l
3 {
0
q
1v/ziq
+/ > ;q
% qTs
0{x
  7}
 Z

%
- Kz
0 %
 zk  

,>
;% p
  & 
 k
xZ%
r  9 
I{
0}

%zk w
	' ? ICq
y  l
 al
	  Ll
) =Zi
h
#  )|
/ Jo
'$ ylAx
'?
%X )H C
&_ 5  
)Z30
-
 *BZ 2
. #  
.! |
1
0Q 
zm !z
5& 6> - m
7 
4l6 ,
0  I 
-WSZ
0W} 
0| }
0 R1
,J{l
&
? `
# h Xp
) 
1
2 Z \
/v D|(
-K
0
2o 	uzo S
< @ y
I$
P  m I
N;  (
HlwZ
EBz 7i
E= 
0 @ G
G&ozp
Fs? &$
H n S 
H
D&  
: 5'Z e
4l4y
4+
1 `
7 #zs lV
6,  ?
1\ 4
/\  r
-*  
({Z
! x h
"c 
0 m
)f?zt%
. ? ]
+  8
$K
 N_
" fZ O :
*v
.P
0 9
+ zu c 
+ 0?
.R # 
0  x 
3 ~
1Z  I
0| u |?
2 K
0
6zx
6 
@ d
5 L 
8:m
;  
n yv
? Z #K
@#t
? 4
/ tg
?N 5y| >
Ee,>
M  $w a@
O ! Z 
K! N
GZ P 
En Cr q q
B 
0m
?z} : 
@ ?  
Brz
A[  9
9  
7 Z
7Ap 
4 =
1 F
3Y 3z 
0F>f
*  ^
&h p +,
%3
%  Z U
$ Do P
!
0
M Qz |/
 %? l
s
' ` 
 *  b
 	}Zo
n G 
d 
k
/  

 !0yu
2@ - 4
O 6T 
# .X
%\ 
# !TZ 6
)  tm 
.W)
0\
5 	y K
< @ 0#
>:|
=   ?x
<  My
@MZ}
E 
l "}
>q R
0 lx
1m{p
,	@ u m
0   ?l
. Cgo
&C         "          $  '                                                                                 S q
!: Z  n
kan

/ < 4n
G z  m
 l@j
 j
	  l
x Q j

Z lf
 	j <a
 @
0 0`
(z a
 d R? Md
 	N Xub
=0[
6 *X
 /Z p\
=&Pi_
!
. q ]
  y z .\
 j?hb
$ ] f
$z g  a
"gol[
&	Z F D^
-k i  `
1 s
.w`
-.z \
){ @ ]
' R 	`
( {h
+  Dl
. یZ 5i
05hf
0 + z
/ <e
, 
{ GQg
)P>i
+ h
/  [m
3!r
.Z  q
# 
'g  &l
 l
.ej
z h i
! 	A  |i
!@NVl
Z	v 5 Go
 
v  l
/
Z^e
6g d
 1

. 	l
'`y s
"!? yu
)E 		 1q
,  k
(?ik
$Z 3m
   f 46o
<
.n
rz "k
  ? ^m
~a		p
u  r
 
 ~ 
v
qZM
:f [ 
 ۠
.  ]}
 
z>y
f@ 3 H~
w I		  
g
d 
| Z 
V`f
e
-q
{  
:H> 
		!
 F
C   &6
Z
ye !
 ,
, Py
6zo
!2R?  
' (		 s
)"db
'  P 
"O 	Z u e
# XeP
+ 
- - h
/# z  
.@q@;
'/		 
%}   
%t
'Z
( e 5
)  
,
,{9
- Y  @ <
+  g		 
*7
, $
/ 	Z 9m
03mf
/w_
. ^0
/ 

z E  
/E?w
1	_ > 
/  e B
.Dk/
0hZ 4 f
6c  ge  
8M
-8
5}{ 	 
0 
*? 
0 6O	_z
33x
6T ) -
6  "Z
6b eF
;   

. J
? z 
=q?
:	  .	_ oU
9 	 n
;Z
?Z \-
C f @
EE
._
H
{ J 
K% 
V@ ` ?
SY	_F
Xܑ  
Y T h 
XZ^
X}Ge T
[ 

. u
`xEzq
d
?
c, 	_ @
a%
_z
`M Z vg
\Bf 
]r
/
`E { io
`g 
? j
ZI	_
TE' YX
T 5 2
W4Z
U+f 91
Q #}
/ K e
Qp {p
Q 0?  
N 
p	 V 
KZ
Mb h
L Z o
NPuf
L3
0 	
H { {k
G~@
G+	w
J&   \ru
M 5~
NiZw
K   Ye E
G9 
1x
H0z{y
K7u? Sz
H 	 0 }
G|
IQ 9
L Z   Y
J^seQ`
H
1 
K4 
zx 7
Mt?s
IV	 
E)  Y~
I'~
N%JZ 
N 
4e P)
I 5f
2n
F,axww
G $.? L
G !
	^
G! Lu}
J   L}
L Z}
Le}
H
2 Fix
D zr y
D_?_z
E	 Xy
B  
 w
?"Ly
>@7Z8y
= e 5 v
Aލ
2zxq
Dy܌zr up
AF 5? U s
>4	Ou
<Cv
==  ?es
? ^Zp
>zd~k
9 j
3 Fj
2 8zn!n
3A6r
9 K 	 Xp
< 
@Ts
7\w
5  Z 
w
9Z sd 5r
9"
3Io
5 3ezls
-_ 6@  x
+-	V{
1%
1 !G & 
1 sZZi
.c ~
. 
3 S{
/zkRz
/-@ p
/ 	 %
-
*t?}
' Z G}
& b|
#
2db{
"s zh 

"p @
#	0J
N z
# 
 
v
#ZPy
{an}
 
0
2 Ez
@|gFws
2@r
 	 r
t5zr
 o
n 
Z 	m
5hatfm
E<
0 q
 Jzf 81o
Aj
1	tg
 6 k
 /#~r
#%ZQ~s
& !` l
'  
2_i
'	X{e^r
)W? z
+z P	s
/eJz
.Sz
/[ Z /
0n_/~
1	-
1
4 {c  
5 ?>\c
8	s 
<   
C۲f~
DaZ V
E ^ 	V
D]
2_
H~ycm  
K+ 	@ 
O* A	s
QGm
S  
Sk LZM
Uj]B
W' 
2
V Bza
S?*
R
e	sl
R
  "
Nd0N
I?6Z
F 0\ {
EO&
3Or
B!za 
>u  ? }
<	sV
:DO l
8  J
2Z{
-4[w
-P 
3 x{
, za
0\@b~
4  K	sw
3 	hKq
21Z=w
7 Z~
8 ۠Z
50:
3g|
3zaw
3L ? u
5	<^x
4@x
0: 
 {
//Zt}
5Y
7 
2  
4 6aza
/? 
/ 	< m
0 
0 i{
* Z 
v
" -X
y
6
2
 1za  
G (	?I
"8	<~
 2     {
x z
qZi8|

W}
  

1 '~

G^za|
? wy

_ 	<  u
 q
?=p
 Zs
xcVtv

2 {
 zc Jz
(?v
	< Ks
L  (zt
 {
&jZ
1 
T {
3 	1
1Sx
3bzc{
6 ? 
6 ,	<
:r
A   }
Fm  Z +v
IR t
H(
2 
t
Gh +zd  xs
M`6?r
V2	<[s
X )7  u
Q"t
L Z q
M  R 85p
QC
3o
O:Uye hn
K @ ?eo
K 	h
L$L *Z
K   
L
G ZH
E(PfF
G 
3 JYC
D &yg E
@<z?Q
=7  J	 6u_
> 
g
?m
9IZ 	~t
2. 
O 	 =
0]~
3
36zi g
7 @  
5 (	
/W 
+D  " 
) ^Z
,9N 
,  I
3 -
,L zj
(%? ^
$ )5	 7
& 6	 
+4
( *Z Q
$' #>M 
  
3
! ~  -zl )
(- Z? L
+	
+ W 	
&   
$yrZ
%+L H\
&f 
1 G 
) 8jym
'>
?  
%' 	  
% 
)  
,J Z a+
-X 
?J 
z
,
2 *w
' zp ^5x
$= 5>z
%}
& ~ =g
!J ,
Z/
  J `R
  
2 p
)zr
 A L$
 l 

H& C 
 5!Z H '
 x5H
+
1 G 
" #zs I 
( ?
)R A  t
,u  X 
1  

2}Z I 
2 G b
3 
1 T
9Gzv  6
: > =
3 
-b
. ( {
3 Z  J
;G p
?F
2 l
8 zx % V
//@b
)2\ B
(  ; 
) A
+BZ  i?
+ E x 
)}R
1 
$yz Z 
!: @ ]
!> L

j  
B _ ^
 qZ! '
z#E D
 3
0 3
R 5z{ ;
0-A .O
  $ q+
 !  S
 Z 
VZ! |<
C UC S

0 ,
z  
 
@ o
T 
* s 
  f 
Z" 
,~C ] 
b 

/ 
e\z D
j@? ~ :
!v 
 
$K a 2
&G3 > 	
0n Z" 
:% 	BB %
?
0 9
? Mz 
@d &> _
A C
C  
G 
, ^ 3
K~Z# c
LA 
K 
G
1 j 
H y { J
E2? C~
F; 6p  
Ir. .

J}% } ~
G !jZ# }
C/ @ }
D?
1 F {
J { Pz
L ,? x
MK Lt
N  )o
L3 	 Bm
ITZ$ <sl
Gq ? $k
I 
f
2 /Fl
Iy #o
B He@ u
?  Uu
<B n
8"         "          $  '                                                                                  g
4C vZ$ xh
..? p
)
1  y
 Q z  $z
^@ vv
z ] Xs
   ut
L v
Z$ g v
 
>  y
 B
1 -z
z Iy
 
+? x
| 
 "x
0 !{
	 6 2
 /Z$ OO
#7&h= /3
% C !
0 
&@  x _~
)oqA 	~
*u 
- k g 
0Ln{
2dZ$ { r
5= = u <k
5 8n
0i
4E(z i j
1 ?  {h
1
tc
3+ K 0`
7   a
7 ۄZ$c
3< f
.\ 
U
0  d
/ z 	^
0$? Y[
0   _
0% 	 c
4c
4 Z$  c
0| ; 0`
--S
0a
1Xy y d
4L @ A:f
4 '9k
0Q	7 j ^n
0>   gp
/
.Z$p
0U6; R 'n
0 1
1 rq
2'ezx
5!@ )|
7   	, y 9u
8zq
7l] v
5' 	Z$  q}
2= :@y
4g)
0 5s
9I z  w
=E ? |
:.P	,}
5 j  ~
6t 
. '
5Z#
8*:  
:" 
ۍ
1 QU
<hgzr
95? k 
7 )	, \
5x[
6z E 
7o 
Z# v 5
6;:4
3_
1 / &
/ {  p
1#?@
5|	, 
5
   
3S l
3~Z#
1 L:  
-   ,
2r
16z
9 2N@ l 
= (	, 

:"M
: s  m 
? Z# -
F:"
H
1 J 
E z ?]
BMA
@	,  B
?p 
 S
@ vu
=Z" 
7 : t D
3
1
81z
>% @ y 
;5	,
6S.
4 	 r 
6l Z"q
4O;
/  <
1 z 
, { 
/)(?
1  	l Y 
2N  *M
1MTT
2(Z! G 
7  Q; F
;C!
1C
<z ) 
62 *8@ d A
2 63	l:
63  ?
> 
) | 
??"Z!H
8 ;
1 
2 a 
1 zu
2tZ@
3P 
	l w
/ y
.0%
, Z  g

+b ;
(
2
' z I 
% a@ N
%	l|
'q 1 
$s  %
#Z B
<  
 n
1 5
$"z}
#@ $
 	l C B

^
! 
Z U 
#<H
w
1t
 z P 
@x
R	l
 ' G 
 5u
4Z
  +< ; 
2 #q
03
 {
 z @ 1 
# d	 
(}Y
&\  
") 	Z 0
 k=T
"+
0 g
% { D b}
) Q{?h
(#;	 %
)t  L 
,m
0MyZ
0p == N 
/p
1
.W|z
0 d@ M	
24 	
4.
8 : < ~
8Z?{
65`=
5%
0 & 
6q {
;9`@q
?	  
?t  
?>~
:%Z {
9 	4=  ,~
<5u
2x
A,~z G
CS 
$<A # o
A!	z
= R|
9"  ( 
:)Z
C=
F	 
1 " |
B  z}~
=e?X
>  	  ~
B/ ~
C4<}|
B rZ  
E 8>_
Gn޵
2w
G܂z}  
B^ @
=	h
AG 
GD 
 
H[Zt
G> 
E e
1 # R
B }1y{
DL@ l
I 	 " 
Je8
C ,
@ Z 2 
CC 6?
J"7
2
J 
3:zz 8&
B/ 6"?
A-	
G % +R
MA !=C
KF fZn#
H. 
? L
F ~
3
Fkzxn
G~? 2
I] 	 
I7l
I, 
Ew 
Z  k
D ?]z
H
3 
I |u  
LD?ru
LJ	 4
I*  $
H
H_Z
HQ ? (Z
F 
4
F!{zur`
E ? h
E 		6
GhX\
FP  g
E 
 Z
FNN?R
G  
3L
D zs  
AZ?R
?1	~
D: 6  
C /8`
>%Z 
: !?  ~
;9 
4j
?[Rzq v
D @ +T
E  B	
A?S 
;  1
< Z 
B"[?
J9 

4 /
J 	zo\y
@@k_v
;  	 x
<- }
?ۑk
A LZ 
D ? x
Ez
5at
@Bznox
= A  |
>	\}
Cx|
C   {
CZh|
@g? {
> 
5 /;z
>jzl~y
@g@ Qx
E 
		 +y
H ky
A/x
:; 6Z {
: 0z?$
=+&
4j
? B !yk 
B 
 @}
D~	r3~
A / 
= 

;}ZZ
@?
?` 
5 ?
<zyiY
;z6@i
> ,	  
=k	e_
;9 
: Z 
>}?~
<a
4 
9 zg j
9 \@z
;	 a
>W  
;0 -
:	tZ
51 	? 4
2 	
4x
4*L{e
7 @ 	
8 		
5 l^
5 ^ 
7z Z :
7c-?x
26
5
/Q 1yc  
2G(?
8&"2	]
<?  
:
8=Z*
4 ? $[
2
5
8&Uzc 
< 
? 
<( 	
9{ O
6  
5 Zj
3?
5b 2
6 
;) z`
=?
:  	
7  
6C
6tZ
:z v? t
;t#
5
9Vz_
6 ? 
8 $	y
9z
6E  0
6 Z
7H? 
:< 

4 v
8h +kz_
4^6@ d
1= 3	 	
3L )Q=
4P" 
2  Z 
.]   ?
. 
6
3 Nz] 
1 @  
, 	My
+;? 
/ 
 `
0Z?
,v?
% 

6 }
! K{^ }
'e@o
0 >	M)
4zޥ)
4+_#
2 
oZ u|
19?+}
0G
4 {
2# 	y^ u
5% @It
6	M Nw
9p 
 z
:3 
y
<mGZ w
= ?t
=~  -
5u
<v{^t
@Q4@ r
D5 
(	M *t
B5Eu
;4)w
=) *Z x
?#C?+w
A 
5[s
C  (z_ s
C \Y@w
B	M |
A T 	 |
A)w
AlZ dr
Br (> bs
@ 
6y
;4nz` |
8 
@y
4
 
	M_y
8B~
= 0  	
A 
ݵZ
>>^|
6}
6 {}
1 
za~
1.@5
4	
7 v 
6#
4Z
2C > r
/$
4
+vyb 
* A  
0J	
4 
4 
&@ 
i
/*  5Z:
+5> W
*, 
+
5 T
+S #zd"
+ A
)  A	 6
'$ 

(
) 0  Z 
*~ >
'
67
' Uyg /E
+E @ 
)	
$ #
G e O
% Z
-c#> 
. 
4 
 
'zh
$ @  
'@ ]	 : 
-5 
.] 
.L 
Z /
) 	>
'?X
5
&] yj ,h
) @H
+Z	
*  VN
*m 
Z[
,=MZ
,  #> 28
& 3
5
!B5yl
!-CA A/
$ $ + <
) !1
' f + 
'K Z # |
&`>
%
4  
$ xn H 
 x  @
&{  q
) 
  9E
+= 
&:Z 	
 
 
> [O
U 
5
'uyp
/D *? fY
, Zs
#iCY
  " Rg
 Z 
$/>
&
2 W*
  8zs 3 	
sA
p ? 
"0  @ s
! 5
kZ  
 t> B 
   

4
!? zt  P
 
2aA s 
 6e
. 
 % l
 
!bZ
b y>
 6
3 i-
 
yv 	
&@
 4 C |
A 
 $]

y QZ Z,
 > .
p
3
yy T
 @ R A
 !
{ @ 
g          "          $  '                                                                                 n 
`aZ
+> * R
2 
2 x 
  y{
pX@ 
"  
 	
IJ
N 
Z .
 	> 

@
1_
 y} |^
 @ {

  0 yE
o 6 B
/Z
&? c 
~ !
1 \  
  zs
y? H 
  n Z
yc}
{  ]{
 Z z ~
3 ?^
#h{
1 
}
' 8y  x
% @yt
$Xt
& y v
/ 	v
8dێZ5t
<F ? s
;, 
H
0 
o
8{k
6  A wi
8  1Um
;o
=  h l
@ Z Ok
G@Mn
La
1 A q
K z d q
I @7o
F\6 ) vn
G 	' | o
G/cq
H.Z  Ps
HL 6@ t
K1K
2{
K'{ }
LN 
"@  |
K  x
K~w
I  www
G Z'v
E@w
J  O
2 M{
N+ 
z Ib|
Fx@z
?t w
;  Vs
?
nkm
? [Z H q
=4 ,A ` <q
:ۭ
2^m
:_hz - f
6 :@  c
1>Cj
-5  6m
/   j
.8 Zob
%gWA_
# }
2 b
# z`
%2A@k[
! 
 -W
 
 W
 W
  	Z [
D 3B (Z
,
3U
 6y mU

 2? @[
(m^
$  " L d
   d a
@ZHZ
B 9 R
d /
1  kR
zRW
s@  GW
| 0  R
znR
U
 Z  W
d CV
%
1rW
! z Z
% @^
#:]
 V  u]
  9b
Zj
 gD \n
 
O
1 +l
zi
;@ V h
  dl
bp
g  }s
q 
Z \ hw
 M `Dz

/  ^w
 uz v bu
 ^*?Rt
!6@w
" 	3 t {
%5*
*k#Z
-D 
 E y 
,(  
0
,5z:
, ? d 
. :
3
:  c ^ 
=m 	Z ;
;)F
7}X
1 O 
41 	
Lz !y
9@
E 9 
M6 ܽ H
J0
C:Z   k
=u 9G J
? 
0}
COz 
 I
E 
@ Z 1
> j
7O 
8#  _ j
? Z^
APH
9 
0 w 
0  -zh
0!A
5  
6 '
05+
* 4Z uH
' +eI 
)#
1
* !
y e_
& 
 Q@   -_
l3
 M(
"  h
%Zr
J  
 F
1  
 8{y
? Oz
= a x
  M
9

` ݚZ O~
 0KYt
Y
0;n
 rz lp
 i@t
su

  stu
 9 7q
Zt|o
% aM `Gm
$ 
0 Dm
yhj
R  eA 3e
!  ] &c
!^a
$a ^
" $Z z Z
 ^4wNY
5
/ 3\
 ,y  e
"$[@p
$!#w
 b  b zUz
K qy
AZF{
 2 
O xj}
g 	
/z
{r
f 
t@ lql
j  8n
 r
$ Y cMp
(, Z Lf
,PzPa
7 
/ 1-a
A ܀y O >`
Bs@\"_
=	 e
8	 N X o
4K  	@q
.aZ {q
* Q y t
%L k
/H{
;z }
 @ yy~
 	z
>s
A  vBl
 Zj
4Rp
# 
"
- v
"R 3'yrv
!t6<@Np
$ - .	 hh
, %, e
/!Tlb
0  zZ j,_
/% #R r +]
)~
/U
$xz{ CR
#) 7@ Q R
%W	V
#  PZ
 C | lX
 Z?W
%>!S W
' ~
/ =Y
%  RyyX\
$X@{Z
*v 	 Y
-n <W
. W
, Z
 e Y
+ T]
*}
/#[
-v yxNZ
0 @ Z[
4	`
3_  i
1   r
0
Zz
3ZU w
3 ~
. 
5zv u"
6&AB
81	 
8
6
6/d(F
5 &Z& 
5< X!U
[
:* L ~
/R
>{ kztx
A 3?
@[_	=
Al	
?

@ TZ K
A  pU
@ 80
0
< yq
9 A
;0	=-`
>>!
?Rۢ	o
= EZ
e
:-VZ
7~
/ 
7zp
67@Fz
5 9*	=p
56 `?k
2 2 i
/$;Z
Im
.Vr
/d~
0vq
./ym l
,}An1k
,F !
	='n
+[ K(o
' #/n
% 6Z	[n
*0Wq
4' ~
/ >t
9J!yl$ y
5n @%J}
/	=t
/ Z> y
4\ Vu
< Z	y
? #:WP
? ~
/ L
;
  zi
7D \@~
7mZ	=Oj|
:	~
;j
.
; +Z 
: ۛWp
= 2~
/Q+
>C +yhK
>S  iA>
;	?#
:
=	(t
>sZ
?W	
=~
0
= NyfK/
< A_
>*	?  
@[ 
>W A
=lqZ B
<-W 
< 6
0c
@1{e4
C(8@ Q
EE "D	?
Bi  
@
<yZ 7 
= Wu 
< _
07
? ]{c Q
A?H
E	g	?
DA L
?  3
;cIZ /
;W  ^
? k
2  
Eybv
G߸@ 
D 		?
@ 
>
 
@8rZLr
@LnW
A ` 
1
@ Rza X
C@ ;
D&	?L
C  !
@( dY
? Z0
? V 6
C
2 (
E+4z` 
C /6x?E
D3,	? P
FN)m
G8 "`3
E  Zax
A VH
?\
2 >
C Uz^  
G @n
B	* < 
<N C b 
9k|
:Z =x
= V ) u
>,
1jp
88z] tp
5^ @  q
:Q	* r
?ޓo
: Fl
2o fZm
1CVp
3  C~
22p
8 z[ p~l
6ZA Ii
4 
	*%;j
4j  ull
6k
6?Z h
2+ V 
 Kg
-+ $
1i
0#Vy\ n
9 @  q
: o(	*:gl
25v <e
/U 43 1d
1*ZOi
1#FV  xm
1<  
2 fp
/ %y[t
3
ZA t
9d 	* ut
?bV Os
A| 0o
>oZ `"p
5,Wq
0~
3Io
3 ry\tm
7 	
@l
7% '	*p
6 y .gu
3 # 	 t
3ݚZp
2W )m
2 
2  *s
2y\ Ky
1,@  w
-7 	 0 9u
)oP6s
) w
*B 
Z y
(Wv{
 ~
1u
~ y] s
+AKKu
C	|x
 { Kay
1& :x
4Z =Hv
 53W v
  ,}
2 zv
$z]9u
/!? 
Ow
x  V	Yz
)x
-Yv
, Z  x
(7Wx
(G~
1 }
( az^  Fy
*w
@m
$	 ? b
W i X
?~T

>Z   }P
`GW gN
 ~
1wM
-y^O
 @'Q
u d	+V
 X
  aY
w Z ^
>X;f
W}
1 Vco
 z`[q
Ao
[	 Mpm
  ?s
M|
Z  
 #TX
B3}
1<J
5{` 
 -h@ u
 k$	{
!!= 
%  r 
' / Z W
)ruY b
&I }
0 w2
(  %yb 0}
,A 6}
0K 		 n_
7 	<
:YTj
; 2 Z j
< Zx+
;J}
1M
A ߴzd4
C8 9A|
A!  S	dz
>j 
I n}
> : @ 9
?
Z 
9c MZ L9
+ }
1 0 
  Yyf
 6A 
Z 	  
 ~
: m{
- Z '{
$ [2{
"g  }
1d 6w
$  zh j
 2k@;_
6	  
W
 . S
 	% 6M
j!Z  M
{  [ trP
A Y|
/  ET
 zlxX
(  G?Z
,P a	 `W
+ z-LV
(D Y
+ iZ  9^
1(\u\h
1{
0 p
+ 	zm , s
+ @uy
0Z	 oz
5  Cy
/Q            "          $  '                                                                                w
)]Z  . q
(A ] o
'` |
0p
&zqx
' mAaz
) 	Xt
(;  :j
' h{'h
' Z Xp
%,	^w
) X|
0 |
0 ys |
7\
B 1|
;p	 , {
8/ 0z
56x
< 0*Z F }
D7 &_ 
Eb!|
0
D yv 71
F' @ 
J5	 jv
L * r
J[  XGo
H (Z q
I`q
OV |
1 ^Yw
Q Pzz}
N(@
H  	 ~
Hk   Q
NCd
R  ۣZ i
O aM
L1J}
1
K
 y}]
L @
L	
K q
G   
F Z  X'
JA+a 6
K n}
1  
IAyx
DK@ G
D 6	 
Fo	c
Js 
G .Z  V
C  6b
@1n|
1 
C 'y ~ 
EQ "A
F 	n
D l   
@ 
A<Z 
Ac Y
C L|
2 ;
B7y
@N@ 84
=  v	 7 *
?US
B 
 g
C Z  
?Qhd=?
?}ۿ~
2  {
@! Vy  
A~(A \l
B=	  "
@8     
;! g6
7tZ O
=! Xe 
B }
3
@WyPO
< HA cn
= 		 9y
C s
C S   l
>2 	wZ  eb
:f
9,b
4 x(
<7 6x )
@2@
@h(	 ?A
; " w w
4 
8\ Z  ' 
B g * V
CC
2,$
:
yb
1 @ [
1 ?	t
9
<  
8Z  H
4i F
4 b
5 :
:| z 
9"A
4  &	  
0 

/7
0 Z  
1 hj\
/L
3K
.`z v 
1 ;A WZ
/W	v
-. C
' i 

%Z U
) ]k ,
/  
3 h 
->zZ
'4)A 

$V 66	 H 
' 3og
.*#s
1 #Z  & 
/g  m
*f (
2~
& Gy f
) ? n+
1GL	 
5~  (
6 
k  F
4"Z G
2Z o 
1 ]
2
1
ey%v
2 A  
5 M	 R Q
7
7 T 
6l Z   
9 "p
;F
2 K 
9 Bz 
45A
1	 ?
5 
 H
:	 
8Z 
6P 
9r `*
8 
3
;w y>
;  @ 	
<n 	
:'P
6 5r K
7 4Z  
<+tt}
>P  #
3 )
:x !y k
3V K@|l}
,	 y
)M   ow
& Cnx
Z  v
 u o y
  O
3ry%y  At A k  }	e{m  RtZ ݸZ v'v}o) 	D
0 hV mzAer@Ff
 + 
 	 Qj

v n
1@Z
j
 Z  Jd
- mx J Nd

0h
n
y j
 p@  h
 	 f
 9e
 
8  f
<$Z g
A4hz k
m 5
0 M
k
 ,ykf
$tA Qc
 i !-	 vg
   lk
 l
 LZ  l
y { )o
~
0o
_ { l
E vB Yf
	Df
   k
 	j Vp
Z v
| I|
# 
/ 3 `|
%6izDt
$A%n
" 	 X l
" #EYp
# , r
!S \Z  s
k~zu
<n~
/  `x
y 
Cz Yu
PAs
	 q
 H xn
  "n
&Z fq
*0 

 ot
+ !~
/ pq
%3zco
# 6^A q
' .7	 e s
.%S&r
3>!i o
6k  Z  x -o
3\8o
+}
0 Xcq
*X !z _ t
, H@Rs
.	"t
2+  F,w
5Wex
5Z  v
4
 > t
3~
0q
98z = o
A ?s
DA	 G-z
BO~
B   |
DZ ly
H|wyz
K (~
/ ^}
Lg z 	
L A
N	 i
N4 p C 
L|v
L*Z  8b
N i c o~
Pd}
/~
QKz~ O3~
U 	A  |
W1o	x
T6 8 r
RD / Em
R&9Z i
U! ^k
S9  ~
1 _m
Sy{zo
RrA k
U^ p		 kg
U {h
Tn
XdZ  <w
Y. {x
U=}
1 s
R e  zy m
N B q
Nz}		i{
U'Z:
\ 	ۯ  ]
Z:Z zy
R *tx
L ~
1 e y
M zv~
PA M*
P 1		  
Ma
L # \
M: EZ  N
L!/
LL}
1o I
J <zs 
I$A!
F			 
CV 
C) / Vz
@6Z  {
AP0 ^ 
D'?~
3
A!zrX
?3  A 
@< 		 ]~
<%gg 
6 3  
5Z  *
;D<
?
L}
3  }
<M zp ~
7 m@ @
3 ^ q		 
1 	F 
/W
2cZ t
5Rۤ.g
4t}
3
1Qzo  }
,{ 	jA Na
$ 
	w
 m  
#C I
(vZ 
(
!  ~
2J
 
Wym 
A
	"
   3

 	'w
	 <Z {
& -b G]
 6~
3 
2ylL
V([@x j
/"V	 H
 j 

9 
 Z 
  )
 ~
2 (S
 b{j
A
 	 
 
 *
  ^ 
cZ  a
) a-
h~
1
'dzh 
([ ߡA
#rr	
    
   
!uZ N
%q| <
% 

1 
! 5Wzh
@  
 )	 } 

! 6 
 d  Z  
 }
v
1 >$
S +zg  l
!6rA|
":3H	W}
#t )c
'i "c
,s Z n
0   
. 
1 4
+PVyf
+xA t
- 	 , 
/Bz
1s 6
4 Z  W e
0 !x
'~
0 V
$W zf ' <
&	@z
+iZ	 
/ 
t ; 
1V%uB
0XZ  _
0  
4?
0 
6sxf $
7  @  
6	 
7Fd
;R  
9@ :Z 
4g
6   
0 
> 6zf 
CA
@q(h	 3?
:t 	5 
924D6
<*Z 
>h #N P 
=m 
0<
;s {g h 
= 	X@  
@	^
>U -
A  - 
ChZ _
?$z 
: 

2 8
=h  jzhs
C]
A
C  U	 S
?? S
>4 8
B 5~Z  b
Cw   k
@
2
?fvyi I
BH  A &
E	*
Ga_ 4)
E 	  
AwZ M
? 

> 
2 h 
A r{if
AxA  g
C
 !	* j 
C=v
B% 
@ 4Z   
@5=e
C, 
1
A $	zi ch
?A !
@
@ R	*N{
?  0`{
@} ~
@Z 
A u x(
>$ 
3 #R|
<Heylw
<@ ~ w
@ 	* lu
>7s
; F
s
< 
zZ  / =v
; _`u
:ܻ
3 o
:> {l J h
>B[g
=]	* jm
<  G r
<?}wws
:Z   n
:"  d
;M
2  }a
8zn i
4^ @ =q
7E	*o
=v^i
= ' 0Ze
9p Z /d
5#jb
4 3
2 4Za
4 5znd
7-AX{k
6X$	D 2 j
1 !< Th
. mPf
0[Z  Q i
5 r W Jk
7 [~
3y]j
3*zq f
0H A S e
3	DRe
7/ 1d
4B 
 @
d
+GZ ca
&
b
'x A
2 Ed
-u߼xsf
0BRe
- 	D #b
# `
 8b
% Z  ^Ea
, . 	0_
'~
2]
m  6zt 9X_
o Be
s	D#qj
      i
$ f
$clZ mGg
 [  j
" ~
1 F dk
! -ytTi
v2 @  h
  6	D  n
&.Vw
-Z% {
0 !lZ  N{
-p  zl
)?~
1p
+ 
yv "
- 2A
06I	D-
/ 	 C
+ 	
)bYZ d
)   ?[
+! 
~
1 o
& zv
"`A W7
$E k	D 
+۲_
+         !"          $  '                                                                                
%j )Z  2
fL]
"
2 
( yw  w
' AAH?
$D	b <
  
 R 
"Cg
#fZ 
"  e.
!J1
1
"dzx
' 

A A?
* N	b
%0V|
  X 6  :
" 00Z 
*&
.s !
1#
+  zzo
&Au
#'	b 9
%  
(ah
(Z  
(@  ' B
- j
0q5
.Y@zy _
' A  
  	b;
! 
' X %.
+& یZ qP
+f
( 
1 J
' zz
+A{
. 	b Uyn
+d $c
'(3V
% O Z  2OM
(% :G
.Y
1=H
0 zz 	;O
, AY
':	bSc
) e
1 q 3a
6M.PZ F`
5
6 i
1p 1z
0 O t
/ -'z{jv
0"A  p
4   	w U j
8  ri
7X~ 1l
3@ Z  ' n
1o n
3D>~
0j
5g y{ OTi
6\ 	@ o
3e	wzs
0 
 6Xp
/ 
m
2Z s
8  dzw
9 
ۭ
1 x
8%z{u
8 @ AAo
8- 	w j
8~pl
9  p
;> Z  ;t
9,@0xy
6ul~
1 z
8 z{ 0 z
:7A{
=	w  }
?t 
 !}
@W w
@oCZ  r
@  N
p
: ,~
1r
5T6z{w
:w 
2@ _~z
C (	w|
E("~F}
A  	  @Z}
> Z D|
<S|{
< <~
2 8{{
; y{|
8"Au|
9=	w D6}
:B  Gz
:{
7Z  ]}
7@ , S r
: }
2bu
=y| 
< A  
:K	w`
6F N
3!  N 
4Z 
6V *
8 
8~
2 q
8 z}
9s*A
6V 	 iV
6/ 	
4T?
2  	Z  Vh
5  Bn
<
3
;  y| N
3 )A
06	s
23 5E
6 ** 8 %
4#	Z 
24  H	
6w 
 
2 p 
: d0y~
:B ( 
4 
3	 q 
4T
7ZR l
< 

Z  UL
; 
7D
3 
4{ 
ay} )
4i%@ A
:n	 M a
?Qܽ  
;|  P
8dZ m
8 X  An
;L 	x~
3
<"z}}
>A Q
A z	 > X
DN
F#~ >0
B' Z  - (
=%\D
:7x
3 t
A z} 
GB{
HhM	 KM
C &(
=N5> 
:4Z   
>|+w Z
Ep#
4
G	 z|#
G  4Ac 
H 	}
DC
@ f x _
>  Z  u
= @3
=W@
4 
? y| "
@?@ )
B	} 
Ap 
;)H
7^Z  f
:( 
= 
4 
?Xz}
< lA O
3	}
0d 
1 6 
4 Z S
5f k
3  
3 
5x} 
4WiA  
0#	} v
1 -
5"
5 J $WZ ;z
0. 
4As~
/5
4x
0Q,y| 
5 ${A 
7|!&	} |
8# b+~
7   
8 eMZ  
4 
4 
3 [
5y|@
7vA 
; 	} !
=Y 
:ot < '
8< 
Z   
8  .
>
4#
@H Tz} x
; @-
7_	rp
8l 4 s
=   
BGZ  f
B  
= Q
3 @
:$z}a
9r|@ 
<% 	r
>a&y
>z {
A' 
Z  c J
B 

@!q
3 u 
9 2z}  ?
3 6BA|
6.3	r
: %C 
:e!O+
9 qZ  k
; $ {
<!
4 ty
;z} z o
9 5A 
6 	r x}
2;{
5 C ?~
:z  Z 
87M
1A,
3 |
- y~  ~
3@ 
:	r 6
6^ R Z
0O^I
-	Z  {
0  $|
5 
4h}
3zgz} 
1 @  ~
0}	r @~
.5P  |
-  4z
-.Z ~
-EJ
-3 
5 )
1T zz
1`B_s
.~ 12	r a!q
,h 6v
./{
0 &>Z  C |
/ 	!v
+( 
3.Bq
- q{ q
4r Aft
5o	i;v
18~ +
s
-s 
  9p
-Z  	o
1 #q
3 A
3  p
4 Dzl
0;A k
/d 	i ! n
2v
7ۦ _s
9 Z  Ql
7j
5U
3n
3 z Ep
1  Ar
/	ieq
. 	 8^m
/ 	\k
.7Z sm
/ } po
/e 	
3 Yn
.;*z8l
.eA i
1 			i ` \j
1qk
,/N  gn
(e 6Z  E zo
'0o
('J
4 Hn
*l 	!z  o
/  Cm
/	i  ym
+ c o n
(:p
(5Z o
+% 7  n
,h  
4lj
(yg
' 	]A gZj
)k j	io
,	jr
)  r
*q Z  Vm
.Z۞/m
0*
3 Vo
. y~ t
()UAv
'K	U J^u
& 
 ; q
(zq
*iZ  u
)  . =|
) 	~
3[8~
'aPy~ x
&B A = s
)F	Uvzs
'  x
$ 	 N{
#Z y
"-) =v
# 6
3 x
#V21y}
$\(kA
# "V	U u
$U  o|
&w
% pZ  {
# 
 4

3'
 dy~ z
U !A d v
	Uz
 Gi|
 	 Z x
 Z st
`V w

 ~
2 w z
yzux
߃A v
` 
T	U ^t
!8r
u ko
 
lZ  q
*ds
!]~
2q
(J Jz{ l
-  A 3j
.	Umo
,  q u
+  Qt
+ qZ up
0:o =}r
4 '~
2 t
0J*zzEv
)S6WA Tt
' 3T	U C 0p
) )fr
+" .v
+6  Z  j v
( wyyu
&;~
1 r
( Yzx u)t
+As
*	D s
& 
< r
$%s
&mZ  w
,% 
  tv
.> ~
2s
/Cyyt
1\ 7A tv
1 \	Dmz
3rP5x
8"  zr
9 :Z  Gt
7gw
5.~
1 sw
3! zw D ^s
.	Abp
1	D _s
6  N y
8 z
4E,Z  !v
.  ~+u
- }
2{
1yv 
3 zA d}
0(/	Dv
*65  :u
( 4^ }
,B*Z  
0#`
/ 
 ~
2 g|
-b  &zvBx
-ybAwy
. 	D v
3 
X $
1`#
+O  gZ  ~
, 	$ [|
4}
2
7hyu @X
4 

@ % *
. 	DU}
- 4
4m < 
8\Z 
7 3 
4 
2  
7xbyt
=
@ V
: 	7 VX
6) E
5
7 	dZ  G
7r
9~
3
=} 
czr 
>K A Oq
;	7
9 LQ
: %} # U
;4Z 
?  5B /
Bz ,3~
2
A$zs
>X!A w
9 
 F	7  
= v
B , 
EM Z  w 
DJ
A
3 
C8 Uyr l:
DA
@	7 !
=L  l 
< 
AZ 
G 
o 
HZ ܟ
4Y
H\yr
G 	A O
GB 
I	7 
E 
F h o
F Z  } 
B+y.
=  B~
4 [Z
@ 
zt 9 

IA
OE	7 :Q
L  C \
Ff^
CZ  
B " M
D*3~
4 
C6yt r 

E< -A  
H$	4@
JJ!G 
I  v r
F Z 
E	`C
Ec 
5^i
DB "ztOA
AA 
A V	4  3
D8 
F@|
D b Z  N
? B
>y~
4?
A) zu
D 
A r @
B 	4 B
> 
A 
 
BZ 
?/!
; 
5  $
;a 	(zv

:	AO
8 
h	4 P 
5 )
7  
; `Z 1[
;  > b
6s
4e
2 	zx ]a
-' 	1A
+A6	4!0
/  . 6
._ % ?
-!vZ 
/(  /
2 J
4  _
0 zy
-@B 
+ V	4
+)!
+ =
+1 `Z 
- I
/
5 [ F
/ Gz{  
*\@
+#	4 &
2E ۪ C
79   	       ""          $ 	 '                                                                                
4Z 
0 	 
1L 
4 C*
5Ry}
5 x ?@ 3
. 	Q iX
(F
' C u
*` 
Z  0
.
19
3 Ra
2@ z} f ]
0/
@
+	Q ]
$ 08  
#w6
$q0]Z  = 
%e 
& 
#!
3
# {
$P A h 
"=	Q

 	 t
 <  .Z 
(
, 
4 
, Zz *
$@A:
  	:	Q Z^
 	O f
'Y
1ۢZ  lY
1C ` ]
+B
4b
(y ^
' A \ x
) }	Q|
+M 
.   v
0Z `B
/  _
- e
3 l 
)z{
*c@  
+q 	Q a
/ 8 
0? 
, .*Z  
* 6
*1
3L
- 'y d
, "*B {
* 	
, 
-  C
.Z 
- U6
- I
3 ;
)zK
&A # 
%6 p	 X 
& .
%}
 D 
" Z  
" 
'ۼ
2 = 
* z _
*A
'O	
' 	 hR
&y  
#)Z 
%e = 
*  k
3 T
,zC
- :B l
-+ 	 n
+
)C  &
( ,Z 
)}`
,T+
2 22
1 6y m W
3E2A
/j)	 ? 
+t 	" b 
) x
,. Z  i
/ 	 ` 
1K
2
0nz   1
/v B _
/&D	
1y
.  aP
.0  Z 
1O
4 G 
3 )<
6n *z6
61'Bu
5	 ^i
3&  Q
4C
7Z  uX
= 
V : %
<5
2~
:z &
8) 
*A K 
9 	
;   
= 	` d 
:0Z 
:C Q \
; 
3 h 
>7z
=)u@
8 6	 U3
;4 
@b*\
A8 #0Z  lx
>  
= +
4>
A  Rz jq
EH Bq
BR	h
; "Q
; n 
A'Z 
J UU
J  	e
3 : >
?
ztc
8|@ 
= 	 5 ^
L Kk
N 
E eZ   
?G9
>
3
Bj ;z 7 
FBw
M	
L  PM
Dd  
A Z t
C * CR
D 
4
Cz
A2A ]m
B -	
C&^
A5E (
; 
4Z 
>[+f]
B#
4 
@> !{ 	  
8- EA_e
3	 
8 
 H 
:p
;2Z  b
9  O 
8TO
4
5fz 
/ @ J1
1 	
2C~
6 n Tn
: Z 
8}C
2 \ 
3 6O
1n Fz5
11gB
0	 58
.
 
~
+#X
-Z  
0 Q 

2
5m]~
2z} 
3N SB 
 \
3 R	Mf
5 
3 
 & 
0$Z b
,W4 ;
, 	5
4 D
0,{|
4S$@
3 	!&	 @'
0 b~
12V
5[ OZ  &9
7 
7
4N

5  {{ J~
8 rA[
8	n
3   /
1 

1=Z L{
73w
; 
.
5  y
:\Fzzh
67A 
 
4F r	 - 
62k
9w }
; BZ  $ ~
7x
5Q
3 7}
6 
+zy 82|
:  A
<	
7 1 FX
4 ~
5Z V{
;T 
z <L|
: !A
4&z
12zy`z
/ 1 6bA cz
3? 
.g	z
8%mwy
;!g Ev
; 
 Z  s
=.9]s
<r
3&x
61 %yw   i~
. F@|
+t	  u
3 
 9 q
;Szl
;Z  uq
6 V 7 y
1tm
4
0dzu ~
4 B 6T{
7T  	z
9rJ~|
:- 	 3uy
7} Z y
3My
2| 
5 7g|
1 qzth
5Bn
8U 	 g
7 \}
2xy
2tZ  2v
3 Q 	{
6
4Q
9i{t 
6 e@ b~
4 1	Wuu
36 x
26 / & 
3v&aZ 
7}! X
6 
 
5 I~
4yzr
3A
7O 
r	 9H
8] z
9a
9 	Z  	T
7 
5;
5r}
2F yr &G
4 
]B}
73	j
9~   B
: ۘ
:7Z l
7  &
8 

6  M
6zrf
6@ 
6M 
	 * 
6 {
6 
7 
0Z  /

8	v~}
7{
4 O}
6 
&yp /4}
6  YA
9.		
=  _d}
< /#{
96Z |
5 " 1 <
5 
'g
4u
9!zqxH{
;   B vx
9\ 	y
7Mlp{
9m S{
8j Z   }
76z
4$
5 
w
5L zo  uu
; \Bqu
<"o	 w
= 
 0 t
9v
7Z  x
8 
ۖ ?v
80
5v
;bzq 1x
< 
@A 9@{
=-	y
:w
6  ;ju
5" TZ =s
92xvs
9  
4 8`v
; >zohy
;Ay
;M	 Cw
:  u
9gYy
4MZ y
1% , x
4l6
5ow
;p2Azq x
=z ({B  ~v
4"U	nx
.  w
1  . y
6Z y
6 Bw
5	 

5 8v
7 eyqz
58#A y
0 		 37y
/ u
0fp
0J Z  6Ln
, Rs
+
5zZx
- ; zr '\y
+] l@u
*;	p
* ,Kn
/  	 k
0oZ g
-a f
)x 
5  Ph
( Hzrm
+@ q
/ 
	   n
0xu{k
. m
-l  xZ  <m
0_`k
5
5 )h
2 	*yt Q9e
.> 6YAg
/,3{	j
3 ) L\j
5 "Qk
3 Z k
5   Kzn
6 

5o
9<mzuRl
9 &B .Ui
< 
	> i
?Ij
;m #&k
: Z   Kn
<F1p
=#
4 m
: 9{u @ o
= dAs
@~	> 
 w
@ 
I D q
>k
;B;Z  Km
?F 
 9 s
?# 7
5u
?zvq
>t A GEo
=
 	>1n
=Ao
<  EFr
=| .Z   Po
BTj
B   
5 IWm
= 
 yx s
9@A)s
7'	> %Jm
8 	5 & k
84rp
:*Z  $s
7 #i 2 xq
3  
5p
1  zx  t
3? `A Y u
5	>v
6XX  u
4  U{
/hgZ 
,' .
/ 
5 LI
5q  p{y(
1A
)  	> 
#b " 
&
[
+ Y RZ  :o
. 
,
5
) oyz <i
%z 
@ - -
!t	A
 Q u
    
 UrZ  
 6
 

5   
 -nz|h
`B 
 	 N 
z
%V @ wv
 4Z  {q
5k-l
,e
5f
 $3z| 0,d
 !Cb
 Z	b_
 	 Va`
	
 - _
	Z z]
A Y
 
3 w 
Z
hy}9^
 B Apd? 	  ,h'|h4 	h 
Z  ~ i
 ގ j
O܏~
2 qf
2 :y| *c
fB h
D	 j  Z"i
IZf
<Z  b
$ e nw^
 0~
2 H_
z~  ]
	  B X
( 0	 gV
 Y
   y^
y gZ  ]
L"y,Z

z3V~
1 gqX
- 6
{ v\
-C a
'$ a
, !; g a

 kd

Z  (f
%  o f
( -~
0l
#%y # p
o A op
  q
"6 % vr
&I 
 os
* Z  Cx
,?r $ |
. 
}
1 v
4Y y~
6Y@}
7y 	 ~l
8  RO
;I 0
<R Z  
> 
 L
B~
1
Ch$y~ XO
D A e 
Fd
H @
I? 	 Z 
H CVZ 
J./ I 
L @~
3 
Kz $
F1B 8 
F 6 z^
Jw /

M% 
L !qZ  q
Iy  w [
DD~
2 7
Dk y 
Fi 	:A ,
GLp
F u  ~
?  Y
;DSZ 
8!   th
6 ~
3 V &
4jy
3A vO
6   
8 ۙ 
4w