          8"          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

         9"          $  '                                                                                 ) t/ Z + s/ C * q, [ ( o* { ( p, v ' q.    ) s, y + s* 2 , u+ @Z ) n' 	 ( j" m\ & n ^z % t \u ' t" f   ) n ( ( 
k   ( pkZ * 
u~= ( p \] ' k z ( k %u ) p    * r  , q
} B , 
n~ Z , l~  | + 	m ] + l { , f
 ,u * d  6   ' e	2
 % l  (H & n "6Z ) h   + c ] +e
 z *g
v %c
 %_ E ']  +\ Z +[ e *Z ] *U hz *S @t *V  ([ ۧ 'W
 1 %R Z #O  $N Y[ %K z &M
 t %Q  %U
  &P  v %L Z $I  $J p] "P   y "T	  v $U  $Q *n #L 6' "P 3>Z !U ) $V  "[ &S! z $Qv !N    M"U M% !M(Z  M-  9  O.  \  Q+  z R&u M$  J$   P( ? V. IZ R1 ' N+ [ K( z N'Lv Q' T' W'^ V)  Z S' K R$  \ U z Z"@u \$   W$ U S'Z S5m S 4>[ U *y V#Iu V  W 	 VG YZ Z> \] [Nz ]v ^ ^
N [
 X wZ \ `\ a{ ]
_u [
L `
 e
 f
WZ d
 b
^\ a
z d
au j
 k
 h
p i
Z l
 k
%"[ k
4qy k
5!u n
, n
# m
  l
 /Z 
p
 
q
\ s
y t v r}	( p: l mZ 
p	 s] sz v
Au sX	( p
 
p	   	s Z 	u  	q  \ 	o ,z q 9u 	o A	( o E6 
o L| 
p
 VZ p ^6 
o e] o l9z l r"Zv f u3.	( ` y5 d -r h $Z i ! d  ?] b z a Pu a 	( d  c  a ^Z _  b ] c	y `u _b	( d߮ h"۾ gZ d b]b y|b v  e! ;	W h   i!  j" Z  h  Tf ^` z{_  ub! 	Wd    e 1 f 6`Z  h .j %\e! !c{ya&  otc% <	Wi l 0h DZa" ^" ^d  Aywi ui 	Wf :c Oe  sZe' pg( O^j  ztj }te 	Wc" e$ f ~Zf {{e v_g# r,ysj  ovh f	Wi _Fg ]
f ]Zc [/c O6^e E0<zpf @&vc >!	We : i 5rj - Zf (ya !u_a zob vf u	]f 0e \ 	ZY 0^u^e^zme
u\	]T4W}Z^ZXU4^REykRuS	]N[I  E~ Z HpR  Jd^IW-{jBJ6v C81	] G#' N" N Z I D
~^ F*{h KHv M^6	] 	Li 	Kn 	NsVZ 	Os Lu
] 
Muzg 
Rwu 	Xvۍ	] Xt 
Su 
MtZ 
Isn 
Mp0^ Rp9zd Squ Or  	> 
Ro 
R
l S
i1Z R
h Q
k G] 
P
k zc 
P
ft R
b+	> T
_6X U
[2 T[(Z T ^"w Xa \ W]yb UXu XT	> U
S QVV USZ \M \Gw] W
Hz` WM,u VO	> XJ	 \B ^AޔZ ZAL U=<\ S8Ly` S9v U;	> VA| QH GPYZ E\ Ej\ B	{Nza =v >P	> ;G 3( +	5Z &
3 *	 *1\ - ,#z_ , D t ( W 	 '
 l. '   *   +Z /  0 AZ 3 z_ 9 u =   4	 ;  
l ; W  <# Z C2 ܯ EA ݐ[ HR y_ Ie u Fs 0	 E~  D  H &Z  M  O
 -Y  O
 }y_  N
 u  N
 ,	 L
  N
| '  R
v Z S
n &k P
\ 4Y Q
G 4z` #V
1  +u $Y
 #	 %^
   'd
   / &k  Z $n
    !l
 |Z d
 za `
 v _
 m=	 c
 b d
 Z  c S Z  b N  b F  bZ i @zc k
 :  v g	 6  	 c 0   e *  j !Z f C ` [ ^   Lzc b  
u g^ f d	 g  fZ l  / n  ]Z h  #ze c  3u fu5 le  , oW  $} qI  !Z  p;  U m0  [ k
%  Lyg h
u b
 ^    ]
 i \
 Z  X
  V
	 {Z P

  5yj M
 /v Q
  X
  X
  ] S
 .Z  "N
!  $O
& [  S
/  zj V
6  yw Z
A  a
N  e
U . e
V tZ  b
X  d
_  +[ fiM{m hq  
u ez    Y2z U  69 Y .MZ! b %U d
 !NZ ]  m{q W &v V  \  ^ 4 
Z Z! \  
^ 7[ a zs [ :v Q X T  
a  j ۠Z! 
d  X FZ W zv 
\ u a  b   b  b Z! b  b M[ c zy b u _   d   f   a  0Z" 
]  6 a # /\ 
g * &My| h  - !u i" /   
k% , f m$ &   h$ # _Z"  f' ' e f* + [ i' . y l# * fu 	k! &    i# &  f$ % O j% #  Z" 
s& !   s' "h] 
h) #z c) ! =v h*  c n,  o- l, Z" j& c k'  h]   i+  y  i0  u  h.x j+ m(  l+   	#Z"j.  & e-   .\ 
b,  6z   e*0v  i* 'P  k- !  f/           :"          $  '                                                                                 `, Z" e* [~ m. ] p0y k0"u  g, 
 !d+  *b/  C  *_2 XZ" 
 $`0 
|  b*  ]  e&y f*sv  g-a  f,(  "f(  !e%|Z"  d$J{  `! c]   _   zb  .vf# f%   b$ J  _ Z" _ " }z 
 a )v]  d )  Rz  
c #,t  b 6  a 29 ` (zb #  "UZ" c ( y d 1] c 5y 
b
 7	u 
^ 8 [ <  Z\ ?_
 DZ"\ MzxY U] Z Ly  [ :v ] @ _ b  \ ]3  @X  Z!  KU
 w * Y
 (t\ 3]
 H+y 0[
 ;u & R
 ;  (O
 J  +S
 B 	 )X
 .Z!  !Z
 (  3v  X
 +  \  	T
 0   5x  V
 8t  Z
 : % 	X
 ,*R " Q
 65  $P
 3oZ!  'S
)u  $V
"]  R
 z " R
 
u & T
 ( T
n # T
$   S
Z! " T
Du $ P
\ ! P
y  M
"u L
 
   L
  6 P
 t #X
 ZZ  # Y
 t ! 	T
 [   N
 y ! M
  Qw " R
    % T    ( P h )  K Z  & M  Ys & O [ + 	S z - 	S   Jv . 	P   - 	P   ( R 
   !Q
 'Z   K  5er #J4[\ (L*z *M
#`u * J  ) K  * NX +P
Z  1NMq 2K
\ 0HVz -Nu ,Q . PX 2 L 8F Z 7G	p 0N+\ (Sz %N
Au )F> ,G	 *N
 )RSZ 0Qp 5LYZ 7Mz 4Pau .O (P &Sx +UZ 0Sio 5S$[ 5O4cz 4N5=t /O,E +R$ %P  #P 9Z &Nn -M
Z 2Ky 5Iv 4M .O> (O %LZ &Hm ,I Z 5K z~ :Q `u :V "M 5V / -R < 'Q GZ %Q Pm &Q [Z (R gy| +R su /P } .O ? ,P  + U Z (Y Cl '\ Z *\" zy *]" "*v .Z 3  /X 5 /\ - .c $Z /f !/l .`  ZY ,X yw %W tv _  d  "b  +\ vZ /\ k .a [ )c zs %] ^t ![   ] v $` o *] iZ -\ cj /  \ ]Z - \ Rzq ) \ Ev &Z 8; $Z / !W &  W "
Z ![ Qj &^ Y ) [ yp ) [ u ' ^  %_J $X1  S6eZ   X.i % _!%[ ) b!dyn - ` lv . ]= , ^" ' _"/ !  _CZ _i !_[ %`!Myl &a t &` %\k #\ $^!Z  b%ri b&8Z  b!zl  c~v  c !` %  b" &c"Z #b!h #b"Z  b!2zj h$u h$ h"> g 	 g!tZ  f /g g6Z h0_yi j&u j"! f"  b" c5Z hg   i[  ezi ^u \ _B c/ `	LZ a |f d"[ d$gyh d#v f g3 f baZ ce d5\ fMzh d!v _! \a \ 
^ Z ^ 0e 
\ [ Z-zi [6v \1 \' [" \ Z Yd T}[ Rzh Tv R3  O  N  QSZ  Pd  K
[  A;zi CuJۆLߡIqFZ  Hfc M'[ O.zi NvJFCH6Z  Lc 
P HZ 
Lzj GvA+W?6XD2E)ZB"b?
 ZAyjB
u=
4==i="Z=a<Y:{l5
Mv23=59zZ<0`8/Y5Jzl6	u;={;7]Z8`<YA
  T{lC  tE
 % ?F * G  $ (E
 # 5ZB
 3 3_C
 C *QYE  F #xmG  @  vK
 >  M
 I /K
 Q }F R &ZE M ^I O =VM
 ]  zoK  jwL j;O  ` 
O ^ L mZJ |ܻ^J xtWJ
 jzqK
 fuM
 u'I
 D
 |xG
 zZK
 h{]P
 F(YM
 KuzrK
 vI
 K
 T
 4 Z
tZV
 &\Q
 4WzR
 4zsT
 k+vS
#Q
 P
 _ Q
 xZQ
 Z\Q
 *eXR
 /ztS
 PcvT
 ^ V
 OZ
 @sW
 BZO
 D[O
 :WX
 'zv]
 ܟu\  Y U VZT+[S  VU 5zyW  vUISR  S	 PZR [T WT #jz{V
  3vV
  5V,W $wY
 !Z\
  >Z^	 W\
 8y{Y v\ a
 c
 Q` Z\ Z\ vW] Pz}^ Wu^  [  Z %Y
 Z] Y\ WZ zY ZvY Z Z [ cZ[ YZ! W[$ -y\& t^%  Z  2DY 6/`$ .XZc- %XXa4 !BW_4  ^za1 ud. 	d. 
`4 '_7 Zc5 Xf2 7Xe7 z^; Kw[8 	`5 Kh8 j8 ۘZd6 Wa7 ,Wc5 zg2 uf. 	g. i1 m4 	Z o3 W m-  SY g(  y d%   u i!  	 q#  
 o$   	k$  0Z j   6V k   /X k  &by h  !v f    	 f # h e   e  fZ d   kV d & Z d % z "j  nu (q   (	 )p *  )j - s +j # &Z /p  U 6s	  `Y Lo  z  rk
 %u  l  Z	 , o   : p
 w 9 o
 Z   yn ZT Yq eZ Hu
  z Gv
 
 v Qr
  v	D bm    lp $     _t (  Z  =v
 & T p
 - .Yk
 9 6yo
 ; 1u { , '[	D M  !  u           ;"          $  '                                                                                 K h
Z t d
  NS p k '[ = Cw B  yw K up \ 	DZil  | `n  9o  UZg y
S  ` jY e ryp |  [uo
 x (	Dkf y usc  e a `Z 3f $,R $ cD[  [z  Y
u  Y
 !	D q y] %  S[ 4  Z
  ZZ   eR #^ C[ u]  z O W,Yu  U 
6r	D  W 	2< a P^   (}  ^  "FZY  Q W Z BZ
 z  [	v g Z	u  XI  X  ]Z v |_lP  4_  [ Y  z R  v S  #	u  9T  S PP  q EK -Z ` N G{O #P SaZJ N y]F A urhF 5 	uD $ E  ~ 2 (D Z r HDO  DHtZ n #F z 1EuD \	uG *I6H3zZ  
E)N M !E  "Z h F   { V  J u K	uJmL 'L ZM JM  ?M^   Z a MYz  Qh6u  V|
	u  zV ` `W , RZ|Z 
 P[	L  ZS
Z 3 kKz f |GUu  {K	  aR m 5U  a 5 S ZT " VKS ' XS #zU Jw  T	 
	 S ?T  ~ RW	   EU
 'rZ j "Q 5WJ 5N
 4yY O
 +zR
 #ruR  	 X   BZ  ^ UQ
 Z MI TJ +M ZW (`yo]  ,vnV '  	Q !  cS  U  Z 1ZII N _GZ S by ? a	'v ^0	  Y  T  )ROZ = :QI ^ DQYZ l FNz d =Mbv I 'N	 # K IrL	xZ  S
+H  U$X : 0N
4:z} [ ?K
5<u h LM	,P	 a WP~$ M YS{  9 ST .Z 4 LVH = HXY N JXy| _ MTu g IQ	 c AQ@ V /T ? WZ $XG YGY  ]zy `   |t 
b :	 ]  *Y k 2] $Z 0` 'G #d -Y g 6zy h F
t e S	 ` W/ - \ Ut ; ] XZ ? ^ b1F 7 
c pY & e ~
{v f !v b 2	\ 5] - a $Z  e !!F % d  LY ) c {u ) '` tlv # *a f	  (e g  +e e  :b
 [eZ / Jb P
E ? Ud KY K \f Fzq P `f B}w U _a F	 N Wa I < I` Gۯ * <a FiZ  2e GE  ,g GZ # )f Iyp 0 &a Jv 9 $_ O,	 9 $b S 2 "f V % h VZ  i RHE  d JY  ` Fxo  b Fv * h E	 5 #i A ? %b ;1_ A $_ 56iZ 9  f 0/D ) p -%Z  q ,!fyl k * hu 
f "<	 f  j 4 i 	EZ g D gZ eEzj 
fuh	hinZ 	 oaD  o[ " mzh % $nlt  o{	  q}  
q  n!nZ   i iC  	j"\  o zg  r wu  q"	  q!  	p!	  oZi/sCf6Zf0[ye  l'&u r+!	  w$ p  wm  r!Z  h#yB  g&oZ  i'yd  l$v  m#i	R  l"#  k%  k$	UZ 
i#B i [ j#Izc i%w g'q	Rh%i$cj%?Zj&kBh$\i!*yajvj 	R 	e"D  d#  g" Z  m#A  
n'C]j$-Zz_d6ue1	Ri'm"j% ~Zm&Al!u]hz`gui!	Rjjk"?Zg A _
]  _`z^  gu m}	Ri"xdEeZeP@e\f z^f uf 	d zd c $Z_ /u@a 2   .\f 0uz^l *v i +	 a 6A Y
 2 V ")*Z[ ,"@b ) ^c $y^_ )uZ (*	Y  Y &_[ ;Z` A?b 6}]` )z^[ %duZ #  +	`  uf 	^ 0bZQ *?H#\K Fy^oQ v8T	Pr I'   A'UZ > @?@2[FIz_ Hu  F 	 B+? F(VB5ZVF 3>K  *j\ 8 5Pb#z`  Wj u ;Y  W 2W P Y,Z /[> [
 M@\Z 7zbZt Y=7U
K JG @Z #K> PRsT\ 'RfzdMuu?G4FGf /FZ Fj> wF
[H
dyeWJv&K  pMN  hR>Z  $M'%= > VE
4\ D
4yhIL
 A+vFU J#V  S
  M
|ZO
=V
jY[
yjX
  fuT
#R
T
v X
Z X
3=Z[]zm~c  G ܇vg
 V fe
 :  $a
 R  a  Zc  '=[g  [Vg  ,zpd  v`# D [ [k Y 
LZW
  =T
 [V	X 
#*yqX 3v 1Q 5 4H -  K $S	 !ZwQ  F=eK 	[  N Izu V t ;X  KQ   
H gC ZBG =1QM [rU
  zvQ$t NI N N M  ZrI
 v  < G
 cZ I
 yzO
 cvO
 M  xK
 "M
 `hZlO
 <{O
 ZO
 _%z| O
 5v O
 c \L
 2&O
 6=V
 .zZY
 ,%p<U  X!KZQ
  fy~S
 'vX
   [Z
1[
UZ \
5<^
R6Z_
M  z_
 NtyZ
  Vy  { Xb ]ہZ c|; e
f Zb x_  u^ux 
^( +^* ']$@Z  %_(-; ) a)20Y 
b,tya+v\* d\+  
 `) p b$  0ZZ^  6;["2  /[\'% &[y`& !v^ E lZ^VW^   	W!b RZ \  S:] ZY  yU UvR R Q  Q 0 MZS E :Y X JZX j TyT  uS  @V	  wX	  cY  Z\  E:a  TYe	  ye
 u c	 k ^  W   	V Z 
U  9 S  .iY N
  6z L
 1 v O
 'w S  !U
   