 "        " "          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

 "       " "          $  '                                                                                z  
Z.:_  cS  [|y ` ]" Z   q 	i zSU [qZ.e- p 
  yx-gz$ F   7j\@5 "Z Z.P   zy"c.v   & 6Kc 	1+?'rZ.&!   l } yzx LF=# yY 	    S v -o K Z.H H n8& X 	Oyya
A"EyA   e{  
ہ+Z. Z  T "{x i" Z 
}   *(Ms  Z. [  ? b!k ' o zx p  #
C	 % 	 N 3,) 86nZ. ^ 2U  
( "2{yA  o$  	i  xy Z., G |x  @#{	 X t R.
0MZ- 1 |
 ۽: 
Dzx5" u#  
p	 (f- M 	Z-   cf  {yZ j 3."	y   % ]4sZ-    	)  5P3v{xcW 
)"H) "	 jK  L  ;! Z- Qz1e +_ Kzx " C)F	 W g $mZ- {g f%p|y a 
#  o	:N h IZ-Hq x {x |Vq"Jj	#  g Z- 5 
  Vd t_'1{y ( 5=!  P 4	y6+!R 
#g  : 	 Z-  W AE zx Wg;"y 	 zu Fv _7Z-u| 
Q)(zx "
  n	tJ2  4zDGZ-$VJ)  
wI? {z#*	 : ChY iXNZ- ?  ~6zx [ #  *$z	4- eW 5X T:\,nZ, B$ [   (C- 
 zxT|l#  	}\ o 3e[Z,Hj  y  |zy  #  _}	 hZ ޥ 2b1Z, :Z uSO {zs(" -	 f5==  
Z- _ g 6yyLr d#m  a	Z
c 
!!a2Z-:V6  3 	->M ${z9!"ZC 
 +	`  \LnZ,T   /<8 I{y / "<	zq 5}K2Z, h)<f 
ۨ  Vz{!<R 	   3 ZZ, Z 	 :Xle9zz. = 
"`	h, .q 	$  Z,  S ? 19  6r{{Lr//# 
%	   !H h BZ, O R$ zz\ $'{	 g$    k Z,@ T  7zzcg"  1 	 X 0\ Z,|  D$ {z = 
# 
	R 
 ^ #VZ, fJ  	  {{ /\# ' 6	 B+0 <_&~ !Z, O  W"UI ! 
z| P 
`" YQ	8  <PZ,4 
 N  	t{| #  	\  Y  \  xZ,6 2# 
]> <sz|z L$F	ZW&!cr'9 Z-?  y
	 ^> z|Q:#' <	ٟ)NM-,4ChY6 ޭ O1Z-`w'	Q
!c Zz|pn:y#EmV	d% :?
 3
)SZ-TQ@v/ N,z}Nu w" g 	Y 
 #;4y{ۑZ-Zi9$ٗC[
4  {} / $k D	L߫ xA l
P(Z-*	. QQ{}8, # a Y	)  z$G[I*Z-
6< 2S
);z|O "" 0 	q aol% i@ Z-8	d%4{}k" \	 - i $ aZ-TF{}+z %# '*	 h b! 
TZ-:"@uz|" 	h !qFv *e (Z-&X )_':(T B 5|}4$CN*u	 2 #K  y {% Z- 	\cZ)Vz|3[#  	  ( & | ^ Z- 
! s -C{{ " !C	 Xx q?' DZ- M: ] ,{{ $#3 D	 e  vn <Z,   z{\%#&,4	q4  +g #Z-i  - <	e \{{6"t+ 
G	S /  E 
?Z-j U$W Czz ue ]# 	m1 $w r! LZ-    {{ B# .	' L  ;gZ-   U[ D xk{y )+ " L	8 	c"X) 3p 5Z-6-!$z t   {y  9 # /	 Rs J*7WZ- 7 d b &<ayy #) p	t1  b ]Z-   S1 qU zx.  z# 	  nA  q Z,p   9zx O 	$> 3	3''Q  ! 
 Z-Q  1R6?O 
.{x? y%f# )l!%	b  3  ~Z-6   H{xABP e# A2 	+ KD  s Z-  8 kw$ ]N 
ۆ{w W$x"	n 	a ] >@{Z-t 2 
 U ^zw 6>.# o r	1 +   Q	 Z-  7
*+L 0Izw  6$/	 &w 
! ; \Z- )a-G t & %Gzw F" X 	   I D "       " 
"          $  '                                                                                 h5 Z-  I0d {wm  #Oa	 < PM  MlZ- W?  b_{v ~# n  	 L ^I C\ Z-0A 	 {v^Y j" X^_.<	 7L6 < 1:D'~Z, g! XE  b t  xs{v>$  	c p\5 Z,_ 	e@ {  Kzw k 
U# o	 3 1-  r' AwZ, Xs   {w[# 3A j	H+ 
J Ah# 
Z, ZYp 
 ^{g a){x >.  " i#	 ^ N- + R  6jZ-2x^  (  "FzwO y!* 
	; W  Z, XE $  yx ; F#   	2 B . Z, t f {x*q# s	   #  |KZ, X)  ~{x  ($ S 	J , m   Z,Q)}[  5 -x
 3{x YT)$ O "	G  ~#& 6Z, K & j }<yxC + #l b	Va $   
Z,E 	 j  p|x qݫ# w_ 9	 v'  FGZ,4  y M>v{w< x Q#  	 	N d<_  Z, z%l T| 7 ps  &zw 75! 74	 8F 
+*  &#aQ Z,I   0H|w  " JU  n	 E5$ B  {Z, _1 PI  T! 	A{w R"?k	 
 Q &^Z-J S -   )`zw - " [~j	 B% tv yu  Z- ^#m: 	bzw#"$'	A  4 5^t,Z, o $ y(F  c[ {v O# Y	 8o ;  FM _Z- b/ ~{w o  #JD	 7  7޾ Z- + O  R\ Z{y ]$ km  $	 ]gt< 2: Z-` E  
{x  2^#	 &  
 dW!j F2Z- w { 6 y- ^.%{y> Z !$ < 	 /	a T Z- "9.ye L P|z 9 \# &6	 Z = S 8sZ- IP Q om ۣ cy7zyT   y"Z 	K  PZ- -  W 
  	2y{ 
x" qc	 Qm ) S*   SxZ-d d 	16}zz2
 /T$fx %	 a?!Z N  
*Z-   Y4  d Uo )zy +$ fe	 + &Z DZ-@,  X OI{zO<Z"& 	 T  s  _  Z- 	 z\ 1 	 zz uB\$	sa 	GU 
}
Z-6\  0O 	  0z{/$# (  
6	  0 W-& R PY !Z- C U =ST yz  a a$?S	*M I  lQZ-%
 D 
   	{z ;%# i  .	  >[ JV  [Z- >2 &+P? m{yg 
"lRA	P bwt  ? *!Z-~ ]    L zz b# N  	 -W6G 1Z-O (".:   gz{R $g	 7- 
  NH
Z- < _ ` y  w1{z 6# @{ )	 $= *uT 
۞Z-u. Qao&v  zz a 
~# `::	 	4 g  
  z Z- (    V	FzyM#r   I	k 	S"] *Z-  6. )3)Rzz q^ 
"%  ; 	 1E N  
  Z-& O ? {zL"H 
c	mf D9  Z- Iq  3 $n=zz x #  e -	 o x 
 ' Z-;] 	 ;; {z!$sst 	 &i 	u CtY
Z- {M w  (( 5{{ 2  4," V  !*	#( m  2 Z-F"eF w 
p zz4z#V 4 1	 xz   -8Z- i2 

  HL Jx{z , #  [U	n-Z -J 9 bZ-3  YvO Kzz el$ %a	 h  L]Z,    1 w uyz} p %#  4	G5)x 
,	 $G #Z-  P    c {z  # 
k	 S9  Y *cA#Z,   }pyzw @' $ ) b	Q: ܃ t_ JZ, hC & 7 z[ {z i\#p	 j  a 5kZ, I   /Ez{  	# bd1  	 <4" } 3n k9 5Z, |W-_$ -6 	!yz "   -#w	  4 rZ, \  5#@^{y # j	 t= 9 ( g] ߙZ, H4 zz 6#]{	 :  
 ){G	Z,  	 |=I D^z{ o $ ka >	 Zd$+b M Z, 1f6M  .zy  S%#!/	   ; ^ eZ, 
>  d  \!%{z` 
 i# Od 	 } S4 Z, 0]d4O  ~zz 0 ##	 OV 	 < K^Z,  & }c  4I{{   (#N m	_\j Z,  l 
o  0{z u 6$ #i0	   & MW! =9 RZ,p C 4`- 
{BDzzsf B#J 
	 {I "       " "          $  '                                                                                  
Z, N (  f 	z{ &CG# :x`	 0 \]  /bZ,: i c 
zzmt$8 
	 ' q E  V 
Z,  * )_  ! {{ H5# @.	~x 6 ]< 1hfX'Z,c3 !R  t {{P$  	 q  *~ 	 (  	Z, ws %s+u ^{{ L\ 
#	rC & s` ۃZ,o~7  ? INz{k_# & 5 l	   PF  En 
Z, s:}Zj zz sX  $[	l+  ]p 
+ C6kZ,2|  ( }  "Sz{  }$ ,  	  [  Z, .\ +|pq {{w 
N#
	 V o Y CZ,;{ 9   ޷  zz *o# X< 	}	 [-
0N Z, l zBs7  {{ 
m 
7$ &	Y  8+   i Z,)Hz % h 	5 w 3zzS)# # "	 !Mb   +|G Z, { =x{h-Oz{ 7d 		# c 	p @    L
.Z,x  S =]ܒ{zLݤ#> 	+	 s ;Vd  Z, . 	w BQ{z TK 	X$  XL	s  7 
Q Y hZ,/Vv ?Y   B &{z:4# 4	 {C +> 
g#d(  Z, Sm u oR1zz D 
# r  p	& v  ,Z,M9t  6 V uzy)"z ݁	 K| ܰ IKZ, YQ s u )Lz{ 
  $ E Y	 z l 4Z,Jrv v ?v Fzy F$P c  #	 hw 3 m5e3,Z, 48 	$'q W k  r {{ 7 $ $ 	%l <p 
 0Wj UZ-5p9  e5 wzx Oy(#	 af  e )Z-   no .  UB {x  $ &}	E  ) Wd  Z- $Wnt   qx  zx Z.Q$z	 1R 
W @ 7!"2Z-  6m ! .%{y f !# F= 2	L a wwZ- LSlC  Rm \{y E$5	4 
 # v Z- A j 3ۤ5"{z 0 	l$ wgO  	 3/w  q, IZ- GXi7 $[ 	1yy & x#	 
%    'GZ-  Ih Z#\0 W6wzz9 /d# q &	 C/!Sp  B P~  Z- ) gI 
"zy  ;d$!{	  % @ Z. ^ f z7 $bL{y ]# q{ 	 0VcA   r 	Z- pe3. 
{z + y "	 W 
H l  DZ- - *d }Wj	c '6nzy_ .# F 6	 U0!'c !Z-   Xb[ zz V  .k#X	 	   } ]UZ-3 a dd " 	{zk i# z `	]oJ| ?Z. 1 7z`.   izy x #$:	 ^$ ^ q/ [Z- v_ :l B {{> e  #  p 		 ,46 1 
2Z- _ o (7^"  Y  lzz ~ "$ It	 ,  RLm1Z-C \ w$ v\:zz$ f I	 7 	* $ ۤZ- |  Y6\   zy g#T;	
 4 -\ 
!Z-k Z v  Oz{# 'L 
 Q	 ` 0D$    *Z. t 60Y3> g )~{z D.
  "#Q 	 	 e 51Z-; ^X $e [ >zz2$ ,, z	 m `	 N Z- V /AW1R /~ 
2z{ %Ft #4*	/ | %v* ) mvZ- U 4Z  Y#zz#   
"	 c  k   
Z- 1	 GTQ'  5zy &c 4F$*	p #9 <u 
  B0Z-,S ;O ~ ^ & |{z#  /	 >  g 
6Z- '% 
R] q {z 5k $ 4'	> ` t Ge k RDZ-%Q 1 
 N U&zx$ 3 F	 % 61 3l <Z- 0D OK/ {y JnD %,$ 7b4r	5 9X 	,
 M?#Z- N 
   -  qj{y#  R	 *YG  Z- Ka M 0au zy Ps # BK	: Q U 1 
Z-L   $ {x5# i 
	 ;#"Dk} dZ- Yi K 2+B Tczx 4i # 4X	"m. 3: $ I"5Z-s-iJ  
$ / A zwD $ ,w 
	 V9 ' Y0 Z- NnM uH .]5 {x Z $  6	
 ] %  p߱Z-G  
 M	{xl# 		 \T  !:ij Z- 6t 
F 9:{xJ| $  8	  4 > Z-1E n 
6[ ]$..{x 
%#~ !@	 Rd  F $< M Z- 
h D 
{v. x# & J#"	x # 
b S W*Z,OMC 0o 	x a9y{v ]`"# 	 -kK  
P  Z-Z A Bzv 
!# C | e	   d yZ-o
H@  
 HO# /zx =6#n 02	 p 
&  {I!p  \Z-O| P? , Uzv  O% \  	  q 	O "       " "          $  '                                                                                 ZCZ-o>Y 	 -\ &{x p#F " Y	 
j 

 NZ-  1 < G BEo{x   % _# c rt	? 6\ 	/ =0Z-R;   gQ r{wM$   -	 
X 
6 +Z1n'Z-  !: ] n  ^wzy w G# U 	ct   )G+ Z-/k9x " i 
[zx l_
$R 	 M  J x߼Z-   7 Z  :zx w N$ =^Z	f0 	8 "X Z-6Q a %f {x . y% 	 $9 
 V .u+I6\Z-  25 I (("Y{y B) 
 }% 0%  	M  %^r Z- 
>34#   6Y 
zz OT#^	   J Y Z- P 
2 : ޜGczz  `$ .;W x	>+W  >i Z- 1eu16  .I {{ H)$	  
  >  V{fZ-  
)0 4|5V3{z
 	*# ?P "	 
 _  Hj 	Z- E"G. 8 
Zzz > !#	  
| 6 

OZ- R  I- =Rܪz{ ݑ% MZ 	 *.1 t T >^ Z- =,*O 
{{ 7 O X$|	 3 
 : *M1Z- %r =* P2 
I&g|{" 4# SaO 4	 -N+h  # ,Y  Z- 0M)A || 1 m 2#~	 U 2 Q VZ-  C( ZJ< T 3{{{w ># Ib ݥ	 +n_ܥ5   
P Z- & &'  Sy{ F  $$d	 x 
( _[| PZ-= 	)% ZW  Gz|T k$ 2e #	 $35 7 
,Z- / 1`$Z$,    'z{ Y #	 Q  h( 	TZ- A" Me  9zz2 n `% c (	 !/ ' Z- D Rm!yL % {| g =$<(	 6` 	 `>3 L	Z- a  <s3  ^	{|!  X$ [ 
q	 /@
,t   	2pZ- ^  6&.1 n 
%+{z i !$E 1	  	 QS" e Z-z  -t  +V{| \   $ L 	 F 6   Z- l   ۏ x {{ [?K#Q	D  Ce  *7Z-W   )o  ,%z|i# %> 
	 ] AU?   

Z- f 0 X 
6yz| O3/#H&	 !R >tb  ; BZ-8 v   4q  G{}+$ '+ r	 d c  . 
Z- Z - 3s gz{ AJaF# 	 6 @v) h *pkZ-   8d 
 V w{|$  	 _  S9  Z- H8	4  
*{{ L] .$ 6	z 0 Cs '5 ;"!Z-s c 9T j W ((z{|$    h	 P  t 
fZ, I"!?:J 	{{ Lf $ "+	Z  s Ov d H6Z," B  L FEoz|5$  
6	 H rY U  Z, RAy 8  {z Spd # 1U\	<   , =l 	6 Ic2Z,9(R ) 
" @ s  m|{|" ? z	 N $ , 
Z, ZRQ 
 %H :{{ St # ;xXj	  k %_ 
 7 ۬Z,  F  Oz{s# z -	 PE  		Z, a\ 
 "
~ 4z{ D{ # -. 0	S Vw  7 *0Z,6	 3A G ){z"$   	 _D L5 Z, Vi   -?b {{ .t 
$ (d	 Gu  @ HEZ,(c  K V yz$ [ 

	 _:e = Z, Eqt | D: iq{y n 	$ (	 f 2  H d Z,{ ) 
' _  5X{z/4H# ;h 	*	 SF#4 :  Z, 5u, $ ]y" zy h 
q# 4='	~   V  }-Z,
 g   \yyF(#  	 D[ M
Uw ;Z, %w  9vF  zz W~ 
~# A 3	   ]  0Z, ~  O>s{y@$$2 	4W	 8b 5* ',$b #Z, "x 
  'lzy C| 
$ O 8lV	.  H S Z, b 
b B2 zyM%} 	 .l P 4<F A Z+ (s  5
zy ;| $$ J S&	i1   K NWZ+1 G5 
 3A  XzzH$ 	 7qC "$ V3-  5Z+ #i 
- ;b$d {z & 
 $ G y 	2 D  = Z+H ! @ 9X4 zz0#Y 	 9t
 H +pl
*Z, #`s 	 > 
{z
 $ ;  B	  i ?xZ,b 	C >b {y 
,%g :	 7x 	 )5VZ+ Ub 1 9 "6Y.{y  %$ 4 !7	 8 n 
 E+
Z+u` 
 ?p zy )i$A 8 	 ,t 	 /]
?Z,=b 
t * N-t[yz  +$ @ U	R A)  FIZ,r  ?w3 zz E$  G  	 oh 
 $zzNZ,*d 	 4 o e/z{  
6# E 04	&  !z KV4  DZ,}9B  5 ;{z `3$#  	 	kF  &95