 =         $"          $   '                                                                                
; Configuration setup.cfg file prepared at Rockland for [MR1000RDL-EM SN472].

; Any line that starts with a semicolon, ";", is a comment and is ignored by 
; software. Likewise, everything to the right of a semicolon is ignored.
; Use this feature to leave notes and to indicate that you have made changes 
; to this file. Indicate the date (YYYY-MM-DD), your name and a brief 
; description of your changes.

;
; 	Version History
;  -------------------
;  2022-03-07 AB: New P chan coeff0 = 9.40
;  2022-03-07 AB: Edited pressure coefficients to zero at RSI by subtracting 0.78 from coeff. 0   




; The [root] section determines the data acquisition parameters.
[root]
;maxFileDuration = 3600 ;in seconds
;maxFileSize = 1 ; in MB


; -----------------
; This section presents the address [matrix] of your instrument which determines
; the order of the channels acquired.

[matrix]

row01   =	0	0	1	2	5	7	8	9   15	
row02   =	32	40	1	2	5	7	8	9	15
row03   =	41	42	1	2	5	7	8	9	15
row04   =	4	6	1	2	5	7	8	9	15
row05   =	10	11	1	2	5	7	8	9	15
row06   =	12	0	1	2	5	7	8	9	15
row07   =	0	144	1	2	5	7	8	9	15
row08   =	0	0	1	2	5	7	8	9	15


; --------------------
;This section identifies your instrument. Only the vehicle is important.
[instrument_info]
vehicle = slocum_glider	        ; Horizontal_Profiling
model   = MR1000RDL-EM   		; the actual model
sn      = 472           	    ; the serial number of the instrument

; --------------------
; The next section is optional and can be expanded. Do not use the parameter "id = ".
[cruise_info]
operator    = CPROOF
project     = ASOMS
ship        = TBD
leg         = August Field Test
location    = Saanich Inlet


; --------------------
; The [channel] sections below are used to convert your data into physical units. 
; This will be used by the data processing software whether your use Zissou Essentials,
; Zissou Premium or the Odas Matlab Library. 
; Please maintain the conventions below as the names are used for data processing.
; A list of typical channel addresses (id) and their names and functions
; is at the end of this file.
;
; Each channel section consists of a part that is unique to your instrument.
; It does not need to be changed. Some channels have a second part which is sensor
; dependent (shear probes, FP07 thermistors, etc.) and must be updated whenever 
; you change a probe. 


; On your real-time instrument, some average values are displayed. To
; force or suppress a channel average from being display, setup
; display = true or display = false in the channel. 
; The units used for display are specified by the field unit = [unit_symbols].
; Keep it short for best display. 

; The ground reference channel.
[channel]
; instrument dependent parameters
id      = 0   ; the channel address, 0 to 254.  Listed in the [matrix] section.
name    = Gnd ; the name it will have in the mat-file.
type    = raw ; the algorithm used to convert raw data into physical units.
;coef0   = 0   ; the coefficients required for conversion. None in this case.

; --------------
; The piezo-vibration sensors
[channel]
; instrument dependent parameters
id      = 1
name    = Ax
type    = piezo

[channel]
; instrument dependent parameters
id      = 2
name    = Ay
type    = piezo

; -----------------
; The thermistor channels
; without pre-emphasis
[channel]
; instrument dependent parameters
id          = 4
name        = T1
type        = therm
adc_fs  	= 4.096
adc_bits	= 16
a       	= -8.0
b       	= 0.99914
G       	= 6.0
E_B     	= 0.68260
; sensor dependent parameters
SN      	= T3146		; update with your sensor's serial number
beta_1  	= 3070.41
beta_2  	= 304897.58
T_0     	= 284.506
cal_date    	= 2025-08-05 
units       = [C]

; with pre-emphasis
[channel]
; instrument dependent parameter
id          = 5
name        = T1_dT1
type        = therm
diff_gain   = 0.913

; without pre-emphasis
[channel]
id      = 6
name    = T2
type    = therm
; instrument dependent parameters
adc_fs  = 4.096
adc_bits= 16
a       = -6.3
b       = 0.99936
G       = 6.0
E_B     = 0.68260
; sensor dependent parameters. To be changed by user.
SN      = T3155
beta_1  = 3067.72
beta_2  = 287307.59
T_0     = 285.515
cal_date= 2025-08-05
units = [C]

; with pre-emphasis
[channel]
id          = 7
name        = T2_dT2
type        = therm
diff_gain   = 0.911

; -----------------
; The shear probe channels
[channel]
id          = 8
name        = sh1
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.941
; sensor dependent parameters. To be changed by user.
sens        = 0.11
SN          = M3323
cal_date    = 2025-07-08

[channel]
id          = 9
name        = sh2
type        = shear
; instrument dependent parameters
adc_fs      = 4.096
adc_bits    = 16
diff_gain   = 0.962
; sensor dependent parameters. To be changed by user.
sens        = 0.1108
SN          = M3324
cal_date    = 2025-07-08

; -----------------
; The pressure transducer
; without pre-emphasis
[channel]
id          = 10
name        = P
type        = poly
; instrument dependent parameters
coef0       = 9.40          ;offset reading to zero. 10.18(coef0) - 0.78(p.ch. reading)= 9.40
coef1       = 0.066786
coef2       = 3.8540e-8
cal_date    = 2023-05-08
units       = [dBar]

; with pre-emphasis
[channel]
id          = 11
name        = P_dP
type        = poly
; instrument dependent parameters
diff_gain   = 20.51

; pressure transducer voltage
[channel]
id      = 12
name    = PV
type    = poly
; instrument dependent parameters
coef0   = 4.096
coef1   = 1.25e-4
; units   = [V]

[channel]
id=15
name=EMC_Cur
type=voltage
; instrument dependent parameters
adc_fs=4.096
adc_bits=16


; -----------------
; Battery voltage or power supply voltage
[channel]
; instrument dependent parameters
id          = 32
name        = V_Bat
type        = voltage
G           = 0.1
adc_fs      = 4.096
adc_bits    = 16
units       = [V]

; -----------------
; The ADIS precision inclinometer with built in thermometer
[channel]
; instrument dependent parameters
id      = 40
name    = Incl_Y
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = 0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 41
name    = Incl_X
type    = inclxy
; sensor dependent parameters
coef0   = 0
coef1   = -0.025
units   = [deg]

[channel]
; instrument dependent parameters
id      = 42
name    = Incl_T
type    = inclt
; sensor dependent parameters
coef0   = 624
coef1   = -0.47
units   = [C]

[channel]
; instrument dependent parameters
id          = 144
name        = U_EM
type        = aem1g_d
; sensor dependent parameters
a           = -25.98644
b           = 0.01139756
SN          = 056
cal_date    = 2023-03-02
;units      = [m/s]

; ------------------
; This is a list of typical channels (addresses) and their signals
; Only some of these channels will be in any particular instrument
;  id    Name    - rate - Description
; -------------------------------------------------------------------
;  0     Gnd     - slow - Reference ground
;  1     Ax      - fast - horizontal acceleration in the direction of the pressure port or ON/OFF magnet
;  2     Ay      - fast - horizontal acceleration orthogonal to the direction of the pressure port
;  4     T1      - slow - Temperature from Thermistor 1 without pre-emphasis
;  5     T1_dT1  - fast - Temperature from Thermistor 1 with pre-emphasis
;  6     T2      - slow - Temperature from Thermistor 1 without pre-emphasis
;  7     T2_dT2  - fast - Temperature from Thermistor 1 with pre-emphasis
;  8     sh1     - fast - velocity derivative from shear probe 1
;  9     sh2     - fast - velocity derivative from shear probe 2
; 10     P       - slow - pressure signal without pre-emphasis
; 11     P_dP    - slow - pressure signal with pre-emphasis
; 12     PV      - slow - voltage on pressure transducer
; 15     EMC_Cur - fast - EMC current sensor
; 32     V_Bat   - slow - Battery or power supply voltage
; 40     Incl_Y  - slow - Inclinometer, rotation around the y-axis
; 41     Incl_X  - slow - Inclinometer, rotation around the x-axis
; 42     Incl_T  - slow - Inclinometer, its temperature 
; 144    U_EM_d  - slow - JAC Electromagnetic Velocity Digital output
; 255    sp_char - slow - special Character that always returns 32752D or 7FF0H and 
;                         is used to test the integrity of communication.

; End of setup configuration file.

 =        %"          $  '                                                                                ( ;OFZ lV )Y0h\j{djy[NDXY
,   __\
B@! d
  #d d  ,Z  Bf 6O DmE 82 0NJr" "(Qzfl
Q" DsKhJ   r  k	V  <oG,yl[ Z 4 dq ' L^I 1MY^"  zhz V
Gk DmU
 C   M
X8{*DpJaC 
kZ ]LJmU6۳0fQ<0 
(zj   mD] K D  E9"	2 ]4{ :5
 C l8
r 7Z <
 >hm<
3 P"1 v; 3{m 	<h: PD&C Q	2  tD
  q8@x j P2 D; -Z M6 _ h7 *X1 >7 6/{q 3
 3\D 3)	24"j8Z  @ @uZ  G xN 	92 lK4 zt -F
V 	[DB] =	2I U Z\l 7y T$nj DZ nQ9 d I `h @#3 iT M )gyx wV =SD k[ $	2 *YuV
P
IlZ  F
QV f<
$5Q=fy|  C E Owx	2 zS ;sD pZ  1
 
mP2 gz 3	'E+ 5f Y 4Q d{ &*^ o#>Z  "M   S((Y a3 1  ]2z 03 <F && 5Y 	6 U gHZ  vd	 * c8>1 D^
z J85 D 

1 x
- H!
[Z  
~ a < 
+*E0 5q
Sz 
 <!
svE qZ%
w$ +
b Q,
B Is+
(Z  41

 !}6
,F2 G 6
%{  {/
BTE >-
bz)
h % 	#%
M 4u s"
$5?Z  @!
h,4 R2
#2 ]
c z\
9 E 

C e 
5 7UkZ  O
H`  &,!0 
z 
'{E H
>

K
 Uf _ H`Z  ,FU$  R. { z :
 E

? 
V
D MZ  
+ %* z ~
u s, 2
{ 
E )Op 0
X:  a "CZ  f)-3/.:K5, R@j -{ G {7p$D O!
2  6 =- 0  #HZ u` 72 
n F+ W
h %{ 
L
  QE ' 
, $ q uB
tgHZ   7 ,a)lf{ 5E KL5 $  L .XZ ' q;s"? &  z  z :JE  W k+BcZ  )X@ n&/r1{v9;>6nF  yM. 9y%l!H %  
 JZ  Kd	E
<C 	* -? ({ K   E ?6rXy  <#>Z lP| oK Q+zEDg m R V  BO  Z  ;  P r	6, | W y ,hV E *[X `4 Pb
|%] P\
mZ T
BvUnJ  i, i 5V%
{ \E8l/ ^660K&Z  qs'!Z 8 a _);_
}XT{en
 ^E x
`BX '|~9R%} } Z  ?I
XI_D
T m)y 
b { q
R	 F!
D9X
B  
LT d
VZ 
[e "*
dOE' g_F
z{X
}E0 fd
rY
X3
6r
g8Z  P]
^.k w'7Ez} E %9 S 5?S   k g- (z  s6Z [V. u1rN '&[ _!{ L  nD @8  W 
P X  
$K
% Z d z
" 9w
 1&:/J -yzk vVj L.EC 5m 9T 
 >! 
 QZ  E6 "x}X
X ߝ+* j
E x{~i ny
ODk$~
%zsg(Q 
? F :I 'E 
 EZ  :t
 & 9

_# - S
) u{|q <MEM " :T' c) j
[ Qu
MZ  '

a+^3qB6R- =4 2z|dZ, ,(E,"_	6k y DTEofR
Z 3^m"c
u-6 Ym){|v3 ER E	'GW O   @c "Z r  ;0 q'. 4P
; ={~rgm
'J :xF|s
gq <	
Dn
 ed
, "Z  j3/  $6 z V( Fwo 	 
! c|F Z ) Q `~ -p 2-O<({ ,I 5DR3	TC*: k%Q"=  Z  0V 4i+v 2,?W XSz*( d E   Cb	:(.h J.
K3 M3M! Z \JRv J J <
l-  L3 >~{BL .Ep5M D	K
 :݇l>
 0
S $Z *
 F`o6
V 8/<Hw Cz-T _ZEau  6	0u
 j [{   T g Z  9_& dy
) H. \q
0/ pDz
 QE0 K&U	jqlzY n4  c[ ^49y=o <+Z  @< G# 2K = )
3 2 {

#0 ifFa 
Z 	 @
:I [P a
M I 6 kSZ   r & f
 h2) k{ 9x DM

8 	 &	
A  o 
d
`; CWj
J5ܪZ y:
7

[. 	  1{ 
(z F *
l }_	 y Ir T ;# mMV 1Z A  * Q_P   ,z j  &E   r 8
Y Y} 
?N +#& 3Z  s5 F, c $h{ hTX E 
 .
Y p
3  N 
a ! 6t
eZ  !
/	 	 n* 
~! kA<{ Un F  %
Y f"~h &I L -
! .YZ  r z
/
7  * 
&-  B +Jz 6+wL "2D 7&	
Y >  ?)t0 % 
Py Z  V_
 '   : <   '^| B! F #U M H	
Y Y` D[ 
:uC l ( 
x: 5
Z k
4 J 	 
O /2g og-e 56E{  <L R.]Erw^  >%Q
Y o 4!2  Z JV TZ  $ 0 4Z B 9n Mz  =-? *F  'C 1j
Y ,H O + kF 7 OiG /)Z   _o j8

"+ Jzn
EB V۔F 
) Vo
 .Eu
$ <'6
 jZ 1 ^ * Un K7z'6  Y{ ~/a ;D ";{k *Pn  paa mTKZ  [s3 ' }$ L
	 R N{}U Y0EB *
 6

j /hP
 &0
G !gZ c

  Q. Z
c 7
NX {yD
 5E
  ;T
 Gv
 w  j} AZ k ~5m
 Uf ^{t  _Z
 QD =
? 0 G 
r ,c 
kf
?Z  a5 |;   :Z{o4
. F 
   9 # H ,Y KMZ  
m !D <
D U
  !zi G5 4	%D  %'
{ .n ]!<  C.r7Fe D6  wC F1Z ^
' 'PK T !  d  h{e \Y qE ~
	-/n c
3d KjdU Z QbO Q I L Lf s ^"{b =K yBE 3   M
nu@/
A >{$	 uV mZ  okKD mDX  L O   a {_  <Q& Ez
F in
V    1 =        &"          $  '                                                                                 =G
& WZ  9 P ^    rI

F xz\P

E)

_  n 
D | P
 h4 _ e,Z  J~
. Q6e c_ t2EH m{ (t{Z "4E &4  ~nx ` #m B q 
2 Z 
  2l_u
 F, E
 zX 
 [D { #On .  \:  
 a Z h
 t 	
@
< 	zW`
 *E    $& $d 97 $1r +'Z  <3u {2 9[4- I{Y  9:
 *FD
K 7BFL&\ O ; P ] / : TN $ Z =N* <n %Rf * 3R'6zYK 	3hEC 
) >"<
] * ;
;j pZ  D&6  _ R8l 33@- &z\ I-  RD8Id]Dz "B_ o 8 DZ  <F G
# T C@J z`U \DW)az ,d$k  ^P  f[
c .bZ  _
& M q KiZ EDj bx{bgu qE 9IXe ] 8r A  '"M 
T nZ xm Z9 	t zf X L=d'E 
vt  5bK :4w "
bi @+
 W#^Z 1
 }  % \  Ei= &Hzi  U  Em7 
9K x 'Z!D Z  }HR"7 {m Ei E EUj1QK T}- 
V Ir  LN
LZ D
8	 _
Yu 5M$ 
k  zpn
r !Fe4
l
 ;(K 
X  $ "w
= P 
4" *Z r
P  * 
N"
{t>NE 6-:cK>k $ E4b D5WZ  bY /,[ t D$ ^>y > zw  ,   DM& K,g[ # &~y Z k
q i 
" ($ {
9izy 
GV DR
D
 # 
@TH
G-
V ހZ  
XtE

GZ&{W
7 {}
A 
E 
>
[8
 C
n 1
tl  ,q
{K>Z jd
; W
 %h&  F8 {}5[AEmS*
 k

   #  O	
` 3!Z 
C 93 
< 5'O 4-z}5{ N$F +  6!
	 = ,F q e V@Z 7 >c gE V%u( O{~ Z BZ ,@G m ?
j J 
 #
h kZ S / 8 ' 0&W  ۲z} X @ yEU 
 "   `y
r Z  
)]
$snF

 |}\
 7E 9~|
 | ('
  )
Z g
 }
 2$  
$ z 1i{}
" 6fEsJ

 >/	u
 1% (!GH }^ E HZ  ;   &k -{{J <!F   $   	B e Ze 8(D* Z M//  ) &}%) zz (1pEI  p	8| (-  2v M
L4 $Z Sg
 Gf|q (&v {w 
 ,E
 (	 ,uz o 8d~	v @Z  R 
  f)n^ 2	zu  #YG #/	t l H6?
 90t| &Z pl !!kFC % m) bO8 ezt	lZ Erp 2l	 /l b @p
4  
T Z 
]8 ^^`
T},$
: zrv 
 	VE ,c
(	 
h
u j Z aZ 5R
 %Kv U/S=D0 
{o 
E <[	 5o zh mW0Z  @NT !/FB a{m !   E  A		 B :i -;06Z  7
E1
8{'./
2v"{j  
 E d
	 W
>FnF
b7\Z 1 $
dcL'
;. % 57 {iLE  =FOj5	 N _J
?
_m9.
tZ #sFۖ +8iߜ.  GxzfgEGF	7
-Q 
T 6+
=Z  8
PH7#z 9D. QzfbS]E>EKz	76` l E/2 ^{5fZ n 2+:')`o6V/="
w2ze^ Y$
X)F '
Q"~r -7,
'   0
|P 8
]WZ  -H+$\ . b'f ?zc HYv E 1BT r %0p [ *
S  (S6 HZ dL/Mc+h0 {"zc+ iF- )r , 
 A 
C m 
 Z  
u
 4 5
d` 4p!9{cB
E -4A r^yH # U -  -.eq Z c K8 o
 ?1 
,: ({e &$
r 5EME
C3rHeK*d '{|#

  Z  ^+< 1
 Y.i{fb	E  & qr #
0 &{
   2F] Z  EtL '@
cf 
0 Qa {h j qF X p t ) xt[  " _Z  f[D  " x- Bz
 zyl,o O VF n  U) o  i6z sZ  m \ qoG :5
 t1
] ?zn  #^ E ?& &*A>
/ 4  v 5 p L +Z  	! #K XV / c {ra xF~Eb  d 8L % _Z  F F
9 N }= 1q tzv  F \ 5e <  y o*  H v ܦZ  t	 jS@M u4  I 8z{ `_  F  c 
M L 
L[w $:
g:;Z 
HvW  z 3 3 l7{ 	
} 1 JF 1	 [0 eV k #T
 3Z   M
6 J5[ k
m --0 &
2 d$w{ 
V^  E 
mv ~ $
\n  6
)R  Pm Z 9! ^ 
' x0 t m
*: 7z V*L
5 =F  ,
6 8  7
D Ho {F
~A RouF
[ uZ  ?
 <b J>

3 3&?~ C z %@e E [ 2JY  	^{ u#t
   o
 |Z  H Tf  c0 	 
c sSy  ~
b	 DF
 ,
 FN _ D
g GQ A< BZ 4 X xi  H =262 Q\%6Az 
XS .lE  uZ{Y%T /X!}!)[ = JkZ   
5fo (_4 ^bxz =D]G
&dF6 ' 
~ 40Z X _rJ2  vr1k Ez1q $ۊE1M
 S7$9 )T(U ~
Y 8 Z p vZ
Z 30#
{ z ! >0E qJp +k
Z qp
h J |a !Z  c my3  
/l {NIg 0E\;6 Z6 0 C/'*o  &YP
I !~Z  %
 N _}n YI. [zk
  FD2 8? H v;GSoBQKZ H b ]1ij |/  gOa { *~ \F8" 
  gD }.
 | LI
 /Z  j
T. 
 
 /^ **n Uz -_F
x 
F*R}9  ]St 7 eK X  <
P\ [Z  ?4
 ~l6
@ M0cD a%{ O) 	E  Pu` Sr
k /.  
S> S6  6B
2 w1'Z 
  'kG 
  !9 &_
&  pz6
M }EBR
~ A "&   u7a z 	2` Z b 1  
+ q7 p
Vb r+{ 
&
M eNE /

 Z
4 O
 Z*
  I uZ   l M+ | # 4 + E
{ gQfM AE: 'g{K @~  ]+ =        '"          $  '                                                                                  q `QZ D#h  x 	Qn r4 [n ;v{>r; >F;T* p _[? ]VF! 9ub T,HZ 6!
	 U6<I
* 12\4 7({w *">G[(
 
9 k S`` aZ %z Fw O43W
 1z~2B
 FU~{
p	i /U  W v   GP1. Z  H Z} 3?1 zy d _ E] Kx	j 
C{ G.Z Ic Fp  S3rg?| fzx = !FE
:FK f
>!J  ? Z  .A{
XC %)1  6{tn
?3Fm) %);= "" m. & >!O AZ  Xc o `f<.a, {p: ]F {j 4t*}"
{D	Z K

M Dc
1 
0zo 9a~qE okvQz? j/ cZ Ol
 $
0
$>u{n l
+vFc
) r 
*  0
3 .
#e
@ 0oZ   !

P ^p

f +

 #{l 

D 'MEv

V 5Oo =4 6iC5 /+oje #iZ  s8 F : X ) .  5Hzk 4 BE ^ T5 r z>g  Z %C<fM) 	P%"{kVP
 F 6I
lA
	 f=
	h . g!:
 q (Z 7]K% 51  G* oZ<?zkcvF ) %o R  8G _ FZ  X ^ cq m 8?, <(p .zm e XG ^ 9  `X $5 4 4;Xa
A +5[Z   x
 
,n O
 $. F
q I zm D1
1 5 @ E Fd
# F
J tkZ
 hx *
( OZ  
M ud 
, {", 
l Jzps C}F8k OO !
" &m . E w 6u FޛZ  gF
 =: DoT
 "-SQ >{s;Gx @F  )A O F  9^O =  GC (FZ  ]
 3 $ 
' Yr) ~
l2 8{t .

# E

 GpO+

A b 	: N
 P#" r!Z  8
	 2 
 ? 6 I(^
 -zw ~s $F pg !O B  7 ; 9
n UZ  2 Fo. ~, wo {{ J  y[E 7G
\` /O |i 8G
?$ ( )

 Z  ) 'Os $'  #HF ۶{} s #jG yZ =O n Z  Pn " uN VZ  5? Sg Fp GMd {BeU HF & zO   eo >   Z  )   _  ;w 61Vz gG6~EU)/1; % >
  %!U
P $ s OZ  
A # QX  .m. {A-  F  4L  r
DF K{ 
h O% ,k JZ  p %  0T @  \ x {  -	 xE
 k I) 
  $+B Z  ? L # Po8

 { 
* F  ^    6 3a  hZ  &A
_ ^"p Dx H	|Q1 sF ' $W 7/ 6> 00 R 
_ "&Z _
  !r l
] * m&i1
h{Ey5
 o !d b 
 
6 Z 
M (\ 3K
 '@>I  
{U{ 0	wF h; 7	,># 2v`p N`  D EZ  Jd JK
H 8#
 ({ V
	
  	xF
[\	 
l +P g
G\ 4kA
 .Z 
 A( B
o  D
7{n
 G 
<	 rU:
 j0G\-O FD6Z   -91 
p(#:"
{ , zF +3	sn  ~
Im( Z )
4f 
G" % 
- $yy` 0>FL  h	 P x
Q t (
 N!O c9Z Z9f ۙ 6 z '1 ]Z{u y3	 N FE  	A 	<
 
HT 6H<tW BZ x
% /{
 $x
>  z C 
k `F
 	 J n J C6 = 	( Z Wzz   + 0
o6W%
v3
{Z%)GE K"
d|< ym

5 Z  a 
e#  D
6#N
}U| `
F w
]
dU
`y~Q- TL>}Z b9,h 8y
  % N Z
#{ '$a`F 
d }1F w 4!.{  +Z *
"'
z
\E
d{ s*dSDZ[N Z 	
H:SX+Q({   5E]T
4
d) 
W*wS#  45 Z Wv 	 9/<) #(.V
A
g. x{
Y
R -F &3;	$ ;
d wG 5|ydf Y7 Z   +T:<Czq
,`K{YUFUIG
 &om ZgZ  (,*c  ( t
 W 	{=e
RDJ(d
 
 y ff h g
P ~f
6# Z  .b
` j U `
~%b
?#{  o
VF ^ 
%
n
4
 5z
u +Z m
#
t $
\ 	 'zY3
IE'
I%
 M
VK p$m
d 
^hiZ &
D' 'u
&O% tg
p~zz 4e
H lx
  orIk
J
 ܟZ [
 +}
% 
8Ezt 
5EP 2
Nk
 ]%
b n4/
r|?,
+BZ O>

% 
@{o 
^hF  
%/Cpz #+J(3Z 1 4C  5n>-L%2Gk$zi Z!F ~o C :~L m 3
K ? 
6xZ -}
Z
x
m'~ v
aM{dHp
0Ga TN M XyWZ Ah u wt )o{`Rmh F 2"y  	B ; F  kZ  jR!v@*~%o
 [{Y] b
% F *`
+e ;T
$   X $2
3P* _
_Z  ^
{ H
S2&* V6_{U-.E	 g2 %~ ,
e|!C4| S $ Z  ?>0  ;+!iL {Q ` +E ?e  { ^i (& 4 z{ P  *QZ  
 
! 8 
+
) >!zL I
E O۔D 
 m
iB!
V d$ = 2  k9
 Z   1Y - w!f 8+ $PzJm
}e GyG "3
 "s z6
$ }C
Y 9'Z   D: N  S<N 
+35
 AizE5> /0aF V>w 6
zH </J \&u MAb	 V!Z = } iE S, Q  rzC S2 vPE K P
 H+  QT Nfjp BNZ   P
h.
4zB
KF s 
iC
 b
 c 
[ ,X
Z  }8
fq)
m.$
zA 
?`F 1#
 b 	 <OZ  y  >2R . z{A%% F5l
y >=.f  G !6MM W1SZ   I L' nA~ b!. 4  z@ l(H F ^D _
y
 
  {
( |Z   2

u L . e hC Bz@ Vu\ mE  
n
y 25
 | s
 e?k
 U ۋZ ;
!    b^Ri .  , zB<#1 H \ __ Xq
y -gtm C l
. ^0 =        ("          $  '                                                                                 +AVH YXZ  zDd rC" $0A }yD R)PE 	 uJ 
ySG b _ ,q  S,*Z  I 6 u 2/ bZ~F (zF_ "^F4 f 
y |0' bFP y Z   >
/  vv
 C/ M( wzI Y*D NF | Lh
y!H `,r  " i6Z   r
u)
Pz p/ p '
8 BzK M]7 CF  Y
 O 8 z )? 
6 G'Z  <
 3 8`Pl / Jw  (zOv JF g
Sh 7@
Y D  NL k 4k@ YZ c' O 
 Q

  y)1
9 6zRd+ l3Gz  y)
 ~gB w" A W  U/ oZ 9  
  ]V XO/ 
5 {W p  kF g7F 
$
 B1J  #) 
My Z  K

, 
?
O;. w[{[ryܒF` +
r
 H
;rl 1
% kxpZ NK".-
dX}z` ug}F Ju}
 @S 8
rE }yvZ D Kf/d
/vpze 
Uu'F 
jQ5F	 4`4 H+GT+ i#Z DC\  # -6 / U{k],HzG1
fE	` 2
  E
^NN g
L_OZ  ]"
s 3 3qZ2|J2Azo{VE
	
݅ -V-Vu
Z E
2SA j P>\I3y>)Pzv D| F 
	  /
N e 
4!NPmZ 'C!J29  z|DyF "C 	  a$h	)47o 
5Z &, oD$@4 2 [* z NV* /Fv qZ	o
 ,L
 5U
$k_  C!
@IZ e
TQt
]z77T
X8gz 
:|FE @

g8	 .4Gv  ]*rcoZ K 
@
I_; NT
Qy :\
=p%F >
1^	 Q><  b .X H`LZ  s PKtpF 4w}_y8) "yz 
 :_'F #W{	 
"ha
wJ
4Y/
=!Z  5
7x2Q}36-9e 9N 
.zGM- %F	Oe7S!-	vVN} O4zzo  MxtZ Yv2V"~; _5z 
kGR c%	}
:Q N]
I	2N;iZ  U^q)g~V;p
p۸xQlbVE!` i	#R
 G
:e5?
gZ < 7
c  3
 :0z,JF Uh)"G	e/z y@\@MTZ g[- 9hN : :[17{
 (-6E N
/V	 
% Y!g+ `Z  n %7:9 (27AO;  A/Y|,{7 8FbQ	Ge  V[^=t@?QZ ""x_M:\ @NzU=0&F .Wvgt	 y=ule5BTqz ;qJZ )NQ#-
t8C
$[	z0
@E  Te
	J`	 cU
f!  P
	7Mg  \C
9gZ  \7+
~$  
eY5
o	{FK
~G8
%{/Z	 %[
Lg6 Nko
0i
Bq'
Z b
M!%&p
	~s s2
u{ 
^-Fd
I	 2 7
>	cr9c O q9Z  4a r\m& OE9m)2 o%_2yT  }	E <+	J {6 :< r |Z  dOz' .>18z ja"Z6F g 3=w	J ESpU kp XZ  R},' j+V1 #5z A8o(| F Ul	J{8 2 u-% , Z6Z  T1( 
L( 23
V"| ]
" zF C
B	J B
cw 
} D]
Z  
 :+
$( FU
} =2 fhp
uH {  i
k  GF _fL
Z  	J A9
F 1 W 6
6@
9=pZ 2 G
E& )ۦ( 5E
L df2 H
E @{ 3 ]
@a F eZs
A	J q
= J Z
* pHF
= TZ  N>I #0'd31 A z jj ]F  &	J "  e aM0v | I5DZ z@*'26O2 2K'3&zaF)dG " n%
y  Muj
 Z  vA #,& O T  77HZzXE LZ'
a
{ 
& 3
 Z  
 &' 5 KH <z o aSE6krt~< (bx|Cp0*Z  U% E3u6 &z
G 
u  Q Z

.

:x  Z  84&$1

5 

(Sz I
5F D49 * A~ (#: * >p> 
 Z 	  "]_


 
85 ;)+yS.F )M   8H? iYi KZ @E!  4 
7t w ?{SJF )
,l] |5 6,Z  	D_a UG/
<p{ IHF*7W` d M ScxV	Z  V
~^ _ 
io{9| zUbtGR%  45"+w
 +Z  4 B
*#Z
 6 3  z~ >Ewmknv  PfZ %[& u7 $ hN}z:
Eg >!K
'*la܄Z SS s65 u6{~ 
G  $
6Z.
wii (
k	
3Z 
ZE
C_4(
c5{{.
FkS+
G-a 6
ji +:
m0"?
]!3Z x F
E5 K
-f5Lm$z{KtH!FG2U Ea HLXqI KZ   K6I
D5] ,E
[{y FFqQaTYW P RB_)Z ?:ߠ *KD5 80Q
R zwNF= ^EFWa AyABZ  Aw, 
LBK42@n{u ;G_5a&0mh+ s-T 46 8Z F 
UQ25 .Qt6yzr MM.Fu	O<Q%aK gR!aQ$ n`	R3Z ! SL fL5#AM6zoi8ZF 1~Na 1%@WU g4 sZ m
	e5) 4
Wyl
QۗGi
of
 )
A /
1Z  9j c~!91e{itcF- (w;lEB
q,Z  @


0X"2yh_ 0?F60N &. !Z  rJ_b->|c Qm_Fcv}^e % .`Z N  ,{b<F 
I6
vJ
0lQa
:
Z  
-z2
\*r z` / F DU[ aH +&wQZ 
%a3
:* GP
=<z`C]
+ VE} K
 V 9 0<.6 "u6a 7(1iZ  5'  4==
!*!<
N z_ ;
kG >9
HN`,} X
e [a>Z  :# } 
~ F)  
 @y` = nGT.
/p: =Tf ۅZ c i '\
 *0 )mz` E -  f Ljuj
%X$ =        )"          $  '                                                                                 
5OZ  39f
s
 ?1 yzc OUG 1 z X\p!  F8 M3 +Z /6?w2. d(zg
"bF
a   U #
N Bj
L 
 Z  ' C
" |E0^gjQzk {E tl
.+ |ZtZ  cqy ~!0 C  9{s o.3
EHGDG 1s L 33Z  {? '. nOmyx  G r YG & -] F RZ  )  )*1U  6{ 
 3G a
 *#G   8gG" < BN  1S
HZ    = @c*sz uGXQ*G 
 L},  Z   Z
A y1
&D(
_Qz '
ܜG %
8h}ݽG Z
G aa
+  jZ  @  
 *  Wqy :.9G 8='xG r\?H s	L
{ %4MWpZ  k~
 jz- n3z k;&G "

5,= t
)4  +a 
  #Z  .k  1'o ) ~e
S
_{ !yF vJ	M= ks[^'Q vKuZ  ) 1 + xm6

 7d1 WE \{ &:F Z=9 HNݣ W
0 ^9
BZ   8 Mz N1 Iz a
-F j
>= a
  
L+
EOZ  
7   +H/  }wy 
S~G DY= 1
$- A
4  P=5Z U
,  o^$W1 Kz! { VA/ 9G  ba= m

e! z C
k&
{wZ  
c {hO. ~d{ QG .MX	 aD&  T   Z   mM 8RFb/m{ x!G X
\	 
Y2 H2
 q
K==Z ! ; $g/  {A8G Eb	 &'l O
t: 
| 
!NZ  O/
2 
66*0C
 .z }fc%F  )!#	(S ?  *t
fZ   
/ AH
{ 2X
YF  Vc	 ^M < H  k Z  s 8[h2 ۜ{ !$G _sFm	  v C  LZ H? L 8 GOP4  b0{&{8F ~	   
t 
_-ovZ O & >^ {)l2 	 
K1z N N6F &i7n/k
 3x
&
 @!^ j NZ  Y*L |& a43 7v~{ 4Ou!F 1j7T
 H[C=}!V|&
|Z  m 	e \z4 z;rzk4Ej ?yT
 
 
	Ea ,+yZ kn-At2 Qd{0mDWF e
   w =bHh;kZ Ra
 eM
g23Mqiz	t|EX2G L/
L.61,
E04 dV'Z  m;!* g5Nr
jz 
 }%G Z
y
  oEi(
u_
^Z  Swf$%$4s3{T	Gzk` 3 Mz^ Orol" Z 
]Y?
'824 ;
Q1| Q
yF4
<^T
DJ
Tj[\Z r}- yl 1  h{(i
z HLm  /Yj	{v, ;5s6Z  yoN'2cVv(90 Np"{| cK |G  j* 	W6y7 Z  
& a3
z2 t 
^ 1zu   XKG| M
R Q Am ' 6 cZ  x Z۱  HR2K 
 0*zo f$ eF   Mc Nl$ E 0 }Z  h	
 #+ .3 U2z;|i 1XXRF $~-{" 
 Vt 
	 #S 4 Y
0Z  F
qg*  
 6G6 T
:3G{d 
l)G|"*?t 2NE
IdlZ ^D
`8  K
 .6 V
|l%^z^ j
~DG 	t
v8Q<'nd FGZ  >
&;25"QT|Z  L<EG9A Qhd> +  +W )
#DL9Z p
do
o4 kG
uP{V G
0gG %b} T 7$e3v;+o& ]l Z  
U L
Rxn5H("{S5F )zx N4Xw
K*#N Aw'  Z  ~E *>@7 4F{M c.G  pr@iX?# Z uD @
7 p  nzK^ g
	XH
#
4F( 
O =l
jZ 7
x)] PH
n7p
]{GU
T;F
U>
@N $S
rZGfY ]jZ  Oe~ZTkz:7kpzDlG Lc%h %R{4c>54/J-,Z  S
$# # 7 $
;s "zBYy(
F=".
&3
w5
"  W2jZ  A4p&SP68 9 ~z?:
	G =
" >H
XR 7EZ
)Gjj
$vZ )m
R8 O uh
d8 0]@3|=
RWCF "pIrWAX 9e A1/Z  (! , 
 6 e
,2/{<  
8Gw~
=>V
?U j
9:"

+3aZ 	
 5	 
7-y8  
*;$|;
I!G
} <>  >
5E.MU?Z  k  _
q"6
M{:G > "#  W UZ l߫76z{: hFn> >hO $ 9+oZ A1  ;y8CCBz9Q
/GIg
> rh6<fm?&R
|5FZ   KV7 ST16e6^z; q
.G  ey%>F{
N!? [tGA G hwKZ VF;c6 (My; 
Ga]r>  D r 6[U`Z  rP 6Ww i77Ifz= P?={G Aq  ,  
BZ  ;  6 Ez@ !
Fg
+ 
/Z 	"Z  Ls) 
J5  (zC)]/G  :
6 30%j& f!Z  .| \!6FJM4UzHb +?PG i EEGL 6!E$<A n@qMZ G*
#*4 NzL 	xG Iz_  \ h5%OZ _!4Y&w
g4
${R ,	
6G 
k *
L xC!  D:Z  "M'
`2! {X u	EG"
C	
 \4	- ~
N6ha
1xZ  <
v
') =
v!3 m =
 xy_j>H 
_
9   B (Q
oZ  qV
* D9v506zhbjG 7N
G\

5b
 J ,W}Z  @9"wV+ &Z4 v0(ZznH q)W
[ nRc ;   =        *"          $  '                                                                                ) 0?Z  {  ,  3 Mo dzv (F `:@ |
} D	cR7 _~X+Z  T Uhe6c,k23 g b
r 6(z L!"XG &+  |
} ?
 U  .Z +B , 4A &3 @ En{ p&G  DH
 IU?! =AZ  KQ+ ] 3O]
ޘz K
$`F Q ,=
V	 mA
i  K
< * F
WZ 5
* N.4 z	8z  GG }$N!	 I{  "@ >~Z  % .Aj Cv*9\\)%4 
4'a[5z <t3G 
L*	u '" B  X Z  (!#I2+yXG	  < K6y
o
Z  
B&  .1tzv{iܜG t o	^ݔ	  \
[ z		*OmNZ 5t%=
12dBB
WNz5E
R
vGuD
X	 2C 4K I $ZUZ  b" BdR2czj L[
&F $6R
 5	 L
.n4 ON
8 +m T
=#Z X
EQ 7Y
J 3Z
C[z F W
9GRU
6I	 R
1 P
LnJO
 	Z xL .HZ2HkdzsDG\ U=;	  48ݰ A5"I1\Z  \-a 1 r63o <b{ LdGa	Z{2qk1 >q~;Z   %o,4Z*{\O
4IG
Qx	X_#>lck3p5Z %~,vO$A5}kx {lboO Ge6x	x L k Z J"m
/
/523
1{4
[G 9
K%AA
	 M
c Z_/	*Z jn		hqri5 ^!D{Z
 FO9^
? %XeoirBi
 )Z n dt
Es\6 ht
Cz _j
2 
G 5V
_%yGCutBn	
R E7*!Z C
'21[@6=6(A?.;z`C%9H@D;!.% u<T~ I p<!/ >kyZ '? A87-	|%$kF %"% #V)Hd,v Y) ;Z +	|2
 7p*6
" /ۦ{3
 F 1
" e% 3
:5
[4
r|Z  xr3
L LQr7
U 689
 {s16 >GE/(= m%>.J	 41
U 73 5( bZ {:6
?  i<zl3 p46 @,WX 0zC+3 ~6G\ 63?# C/a;b )&*9z  !rX2n `Z  \-MK?D)7 '7o.?W4{6h ;F05a 0  ,%jB:0 Z 3W0
\*6 ^-{r1QsH6
Gda!6
1
>b8	#]<= 4Z CB\7X@Hz~?AZG  HaZaN
Y
S
P%PY
Z Z/eQV\ *6JUS	R{z WbnNGW
.ainI
l6Hh5
0+',Z 17!~I
8; i7%R
0rzxFM
 .G:E
b
adFkO5wNZ >?9e} 3]8F 8W3{vgZC0	HUC 	8(]'/M_5t`Z jF3 >W27 Z]
Mzt g UWbF DID /As,]@HO.?Z V7
[z V-
o8  'NzrW"	 Gc !-x\&l, *_6Z   *2 	*}(O7s'>"%zpv'; yFh *Dh+V&4d~KKZ h 
US6Y "R zo Rn
\ HG p O
 Bh%h
 =Zt Z ?-= ۯ. jF 1*7 
e #zmq* 9GV  [}/W 59p /&S  Z  8({o
KG 	

 .k LF0Z X*dXkZ 604 $3Q{n)G "V ,F Z ^i-2 3ySznoF qVn|sH[Dg"[  c

%
(U15 
JK{mo
 Go V@ 'm )RZ .  M,s1*znL,! 0|GK 4TV8 ^H8v3Z  }- ' 0&h'zmb y5uG	m4TV3* "#A  Z J40  Ezo %'FxV 6<5XZ  88 #
0 	0 {oWK<Gk"4>qy|a^*cZ  8.Ak1r zn7

!Gys4
?4 
,D  ,/ &kTZ u =6 /v6zpfF~H 5%4  k24m 2<&?5*3T
,Z # k#v .- {q5
<6uF 
i4 Zc A%  c[Z N 
 @ %/ `S yzs },GkQ 4l
"wP
eKY
p\Z 
Ym~=
\9.ek.
k_&{v
:4 H  04C4 7  Q6 "S 7 )1Z  2-r| k

* -   
,{w`

pG&4 _< @G
O; "W oQ37Z   > 5y]g -- ${z >G !	H > 5  2 f O A Y
8Z +Z  
 @ 	v 3
 
+I7Y
df 2K{{ U< F z
  u  5H
0Z  *t 3 + k4P  {~K1;8 G7 P|  u/

 qt' /jZ Mt DqMp0< 1-} D?{f(N JGN9 #. +6  @	[* Z 0
 =smH
B 1-+
0 (6b{ ? .F #'
 :% P: -!B wW  Ia?
Z  % j.
p./ Xe
 zz
w G
 u| 
d  gA
/ /
X (lZ Mc
1  CfEa0`  r.GRM /zF uF<s 	W= q'
 /7
 *
Z Z b !v A$, ]gb {|}f G # "2=

 
v&l#    '& 'Z vlM ^
6
E* L #z TiC 1/H. 
  6=oe
 0^G 1&gwG( +!Z )cc G vZ  pB, h+}UM z	`{r hG
B a=#V ` qM. d  y 5 _Z  ^o.

 UL;g `	-~ G	'z-  ^VF? N=!{ 4a b YJ= fZ  FZ <MOH 1+ y *z  ^)G g_= a +u!s^s
Q 6Z ;J.4)O 6
;m { H
dG  
O _R p
L-,
N6  p1Z 7I	'E
<
N!+ *
z zz 9
&m G } d_ t % n+L B  7?7 'Z  
a ? w <,J  <=| W 4wG =

4 R
_  
W P ! ( _
 0ۅZ   utF N߷: ~
 j) -l/ {-
}H =
XP_ T6
: ,eX UN[
 =        +"          $  '                                                                                 * <Z 5 :6 g5\ 4	1   ?a{S A G 8p t_ l/  _L R5+{Z r '6e1 4 122	k 
) { t
 "rGE
  _ 

C Ji   {` 6Z   a^ >+ >
9v 1@. PO'h ={   #H :^_ 6  i 0 ,* U Z  y $'  / d	
[ތz 
v	OH +
m 
R	;mhA:kfZ 2ty# U05w/(Z}z
$H R
L 	 A-
Hz a "&
b 
>-`Z l'<  M(/!Q5| 
3G "
-*)	5
H" ~
0  lZ  xMRmG/ N
zVH   !	 &
4Z%Wt$Z  
V 
t^/  {"VܤGau	 iD[IAtAZ 	f 9 `+a/	SA?z%OMtQG$ p%M	 V.
.}#CZ  ~\	V(,K
	F{ 
"T&EG  5
,<4. (~34 .P+v  
=&K#Z  C@
D6 b
H- 
GH{} 
vf+Fl
gt?8. 
&[  =;~w-Z  'F  V
{>U.f)p|{"WNDH +7crQl.H ?ݾlUܨ Od~wZ  nh
AWVZb/0Zfb
D w{y s
ktYGJ
*r.w 
%a zf&sZ (arC
 5/ 2
8	z{w x^
m
r1H +t=


A.`Z
p#6q[3  7z5Z  F, ]$
p
 $R/5
{_ {t N H
 * G ^<. l\8D
 |(
KZ  e
zGf	  
y$- 9
`w{r 
~H~.FL 16?*  8-202R
Z 	4	 8L?/ GE&{o Y
G jb
Q _ Xn FL:Z  4 E4CP/ DFEzkAN
 G-[
(YK  ) s`
Y\_

	 36b?V Z  JkHt2] >m
7% 6,1  pd
h.={h c
%3G gyT!   a4 09F K%NgZ  r   G  0 w3) !{d n< +QG : %  {7i ? 6 u5 L
  'u LZ  qC f90 1
ۃ{` w S
G]
7  AI
  6
2P (kE
jZ  .`
))&`
d 1 Z,E
/z\q ,Gt.)f ;m<BW
&f
,Z 1Le
8_
 S
J00 L6
V0{Wv
Q6GG
? /
!&.@!g= NZ To+2 
60>	*|R*<
0G,
\&]
.

y3 u
`d Z YE !  *E0N
.; d{Nrt xG\> nWv  
& 6
3 NpZ :D #=? 04?{H9HH. y  6D	AZ 3p b0 +f	. }
	){D+G@R. B 
6 
. 0
+O ;'@Z   #
M h! a3
]  _/A
X e{AL
B $G `2X
+ ~vaa
* a:e
B k /c
 vZ UR
 [95
(? . f :
0^ 2{= ? 
4 	G 
: {Oy
;!  kk
(O_l%J@Z  Av	 j E#~	.d;{:4O{w_H aW
# e{Ol K
Em) .
WP 
_ Z ,
\ / P
P Yr. U
0 2{9'S 3 G  cO\P W;
 G, < r6Z  ' t22  : a I(c," O"){8h S vH $tM!N O
&   
)=  
.Z O
MC
)6$+z8 7p?G gzOA|u ( wF= &{iZ .
Z
-
۷[
PG* vOd
S&Ez; o
XRTH (b
nDyO ,0
"1 6
M&WB
r9wZ  d
dm am
e?) 
zUz< 8*
AG /
O
 =

T
 n
|zZ  X]
*! s6(  E3_z? 87)G$1O="
sS_  Pkvg Z hw=* Kn)OeJzEYv)G % 3N!
 LOk 7X<DG +bA9Z  i9d7 Cq})(upp !M{I sk81 .HxPO d
oo+t {  
j `\ k Z \	 P
 w* <"
 v{MX $
 uH S
> 
Py
5    ]
 kW}
  Z  L\
1 ^; /*"R '{S 
F5^HA4e
s w
[*?
#L :y Z %
x1N
~3( ] O
{Z
	-&G 
w( {
 @)
/
0R8-01Z $F+< Q
.
)0)y z`T1H [>

f.G n0\UZ  gR
jBy
.( r
Dzd c
"GVT
2E
cB  J  C R
DZ %`
	M %H^.A ) BR
P 
zi HP~J =lG vwYm 1$6d
 4d ,a
 L5QyKz Q,RZ s(M> +$L
}
[ F ) b $zn  9H !  9\J _% I : 1uZ k T4'] H) uw {r bJ{# 1
H&' ECG- 	 YV
 ބw
E| XZ o
8  cQ
+RAI !yuDR
. H  Qg
EK>d
n !j,L
[R TK e1
 EZ  iI& Ot+.
 m*r#H
S 8 A zw 9e
- vGmw
  , 
 " Q
""q 
3Z  J %5 w? -,a ${ze#A *!G(
-  5 E\'   "D  *I ,e3 *Z  Yv< *4z
 -|
uv #Ny~V~
=s Hx~ 9sw 	]bbM^Z $M
LoV ۻ.^& z(] &GT. _Gvlg? O<
ZdZ j	<
oB).L;z[ ~Hr_
  R_P /0;5ccM $VmtU Z aits /apF $1u/gA 6ez(`V- 7.G]%A g%Y- ! D!CIYW  Eb xY Z T 	 OHw/ > =z,;n GXF d ys<T> n  #b~ j
B 3 |vZ  o
 zknp
 1 <p
Ug zV m
 4lHc
R .OCV
f L
+KVZ  QF)x^
	1vj
H k{As
Ht
/O[Sg
cZjJ
x !-
tJZ ]
gdZ
Z	1 
BYy0f#
H/HB*{6O|3E0T =9&(AL!Z B
k  UX$B
v *O1 C : zE, ZHJ #PO |O 	 ERLj SZ iD$ 'G= E1
7
*F 	Bz4
7 H #2
 _OU-
 +_J N [I Z 84lE0 !{HP*[YO ^r|=L3Z  Q b/ {#W@H 3 _&o+9-6**1Z e c+ +'>".  zy $!fH !6j+ _ IKsFZ dL SU -  ;{ /_}H _9l
+9\>O 9QUGۏZ Er_ߣb}.mC_
g{ aH vaf^Q+8WF
U?{t / =        ,"          $  '                                                                                 yS,< F5Z 1`% ; 2-p K. 3	;
  5]{J
d rHg O
   h+M  2HMx WM+AZ  kG
O6S $TD]2/wEJ){p Jm"uH%JM + "D
  C ;
WO
2
w
Z @..
h j1
=/D7eU { = Gb=^+4 (HD" #Z -
){^y.9
/	/  E:yy| 28G+yN[-_t',5
A' *7
U Z J 3 p-X .]- 1{{. G *nO+[ &cA,  /#1 4WZ /
 g )
@ 5(/W,
1 E5{v~9
 K3G 8Fu {*c[ L 7 # JD ` Fm SZ H X] KP
 ;l/Y
U /{ \X KtG.\n 3+[BXvw W
6  EU
? &Z  I<  
S g7 &0  }1 q I{ f k5W  *H4,g |[ '4  ]$_Z  ( 2i	J ?P/ WQ{a	GWd[ 0kF

1 
]Z  }.o >\..K 
l| Q){  &H KN4~4X% +c  #Z D  5
  	, !Je| C5PG {GO~ MRJMAN@G
Z H+ HP
Nb-9Y
{5`
x[Hj

 a~HjrSrܝ #
mZ n".n,0Rh|db
\UH+`
d
~w d
%{e ] Uh6(3m5}Z htG
 {(&/|a}^u
q&H e
n~/V#UOsT 3X L
- $5Z  +J
 
,-D$h0E;W  { /  H`P&
g~
(  	s^   B[ Z S
 {> 	2) ;/{|0	
9GGdp OWjA :Z I 
	 o#0-/{qn 
@ H%M V   , HS  :Z 
$@ !
G #S-T }$
R #{fAC%
C 
H'
 Ng d&O 1Ue' ($  Z \  :2C 1l J6B0b i Z.fz\I% %RG % y!*"  * ?R%3n (
j|Z ,
6H,
m -J(
{QTp'
mH%
 
b; 
  6
3Z n
pkC 

D.v 
ۜzF#H3] @uK( dZ  @A@.V{&
z=25L2GB<
}w,p1
1 
V%
Z Q$
{
43
.:9
\W0|5h4
GT6I-
J/7 +
N  &ST*
L!}o)
I6 `Z t+
BLH2
,-+;
IEz.:  GHw / ! 
 
, ,J:)
 1
Z  ;3
 3
 v /.P/
S FI{(/
 4H63 9f7, RWq =7T
 "Z ] .#  . g/xz#G4

zGz .+
+ #  D
C
@[$ 
Z  
 H
	*$,[$	z!b H8d  .
 '6)!
6( F1'/'
	 +'nZ B. "!7	 ( z, @gz!#E
L<EGI
M
%Pi
eSdZ N=u  Eh	/-@	NPzB 2 M
2H}D _2H9 I:J| 8vtCV 6Z  7h: 	&8 D/<8 `z Q@ 1hG}B ?  ".9% Vg8n 0Z <
 D ,=" v.^<z$Rx@ Gk,E dLKs,[ F 6Z A
 82Z?E 4(/>/ "Bz&K = GU	=HT=
 M@
 /P
Z e
 8 p/'zjPy*$(b\Fb v^?N:3RZ N:z l7D/ C
	z/ A	?
G?
&!IF
! H#L
  5 r ;SmZ |^b"t _x
P 1 _  {3{r TH9J 4 P+
 5 K ,
" )@
^Z L
*q eK6%0EK
-3z7X\R
 )GWO
#"#<
"	 p#

>b*
Z !/	 Hm^ 1  
bz<H 	> e> ~lP	S
Z Ehsx` /;a
ryA:j 	I<  u{(w	p { Z   5Ad5J
. O2 {G `w
 G $e  Y#Z }p)a *0(&'kzM,5aH8L4?A!+# ^f%#t,+ Z ; . ^d~.qX/,zRD ~)IH   ' )	U )< %
Z %
E[\
R(+.y
BzY 
1Ge
+Xid{
%< 
= _w\Z  b	VY+f.3Vz`.G	d }V= v Z :qLXD
 - o  iyf 7 8Gv[
 a$d k 
 \ E4M
/ 5a  
H,tZ  w
]$#U 8!
g k -
t~ (zn{
	Ik #%
  d @.3
A
g zJ
lyZ  j(L
2 9UnG
m. UA
xzv;
 $H  =
{d^4B
 QL  [F
 ޫ:DUu RZ C8T 6B0 &- I1J /.z}W2U 
H o-
Z $Fd V , D/  T1! !Z 4 3 6{S5 $.66l$zI;] vIGA 1 I` -
 nH
	 X! * =
 v3Z  2 A6R(* --
(; $$zD( !HH :.b D 1%,dfN!@Z   	R 8
 .  
r`zD
	H I 1(1*t  J\D Z ;h%Qxh]/3 _	A{y ^Y

! IL\
pcabT
LhZ  
A
,Pu4
7O. 1
7eDz >1
:H _/
 w-Yn>[0 >xZ  kLyNlM
z1g.J5I6z P/0GtX %K!U
!Y*kE VN:
 & 'Z 5	N./- #s'z.V
G2	Q  /c c# 
 $
Z  m%
M&
\ /O`*x z w) )pH*%p		W *
#WZ 	
K 
	A
.  ]H"{eH 	9	W! dh# (m$ Z = &6 \IV(/ 3	.t<+' )z
0XT/H7p!#6	W=j
0%n?dA +&
<gA  !Z :w# iGH>e.SRB
xy?FB 	kHzF{{ N_	W I4 FJ -	NI XZ DF]E ,/"xJQ k	kz7O 0HR	W0QW e	N& 1	O9 /Z $T_ 2ED\	] /BYg
zY;l
I~k
]	W
k
Uzt
 ^
u <Z C 2 z-H*l
m_	
-u#t
Y 6Qji #1Z df(Aa^
z "1 Z
r  zS
 GDN
4z	g`S
	 ]
2	xc$Z 7fU G? g #2d
fL{R ^&EH
	{V>m
	 &U
![
Wq G34Y
. X۠Z  ^O
IA  ߏ<iC
zj g4	:
  zl z9
H=
i %Q	A
t SRD 4 = 	       -"          $ 	 '                                                                                  B 3Z >
A C9- :
Q6 >2O5
_ [z]K2
L "Iu1
19 , c	 8
i >
	H9{ +
Z * 
6M7b! 23  =)6z  = ="H uw  	  
 92EZ E4OzS3Mz %X=

yI&
!m	 m

)N
m%RZ y 0  19 4[z  MG& )7
Ne 
i Qt 'b Z ` T- ;g /n  {  Bp0H$z~(
NBE l_	6  
DBZ   W
j + <
i (/
`-5z 
ao 4H 
T *
N4 
!#$     Z  i*+( 0y0  01{u 1H46
N 6 r6 #8  
.Z i< 
% % ? 0 I4{ IWH _} c
N Mcc _dS V ZdU 
WZ O-Zh$  #|wNs0 GEH{c@ 
H G @<b
NA P    aeZ bj l
7W 
#1o
5 ]z q'g%G Y$ 4
 y2G 5
=+ <M4
*#Z  ()   l m8  #1M|) PZ  !HA*
 l
/
u R+
 i`)
5 !%Z  "e0}1?7 { 6.kH a
 b "S
kܦ ,i
&yZ ^

f G/Jz:} rGW 8
 C +b #J39( BZ  %I
#M 7 q	
X
 L0 a
5 $z > c &>I ^_ 
  	#G #3 ) 5Z  C 3-Gumw $/? 

 !z#	 IH
 c'
"3 C
 8 Z  $ |,   &h ^]/4 {!? HoD 
 FM  \ tZ  Bg G]d0$0  Zg z} P~
HF? b;) "#+ W -Z  -	U 
	M <i/ 
? 9{x>,s RGA k` /C` PZ
di D, L aZ vq 26+?+6a/h
A.{v  .%zI 2
v!B !%v h T3 ) Z E
i !uK/ %{r5R$vr{Hw "  ) J
 Z  	[	
B . 2{ۑ{n)	3I (	t(  &
c&W)MOZ 5'
<	$:! - % m {k.A4HM75w  c; / >;= F#: bZ G=  

g?
2 T Zs/7@j  0d{fE6GK/
 S
 &eY\	hc!}B [	 [Z  mV
D,U/qhW>D|b{TlFH@P
~T;X
K V
"#Z tN

{D
/>
xz_?
Hg =
VQ_
5
e^)RfmZ @ v%

/-{\Xc1g G*0V 

/3
2 %|6
$ KN[ < DZ ;B/ 0C R.H A4  mzYgIh lI=Q .m
Y*T* 6 SR c1>M 4'Z  EK "!}B 0EyTkJOQI M
HWF?mE;
Z  _=
3:80T3azS1- q
ZHD,
`
  .
 'A2
~k3
(Z 3
85
Q0z 8
}O{OoR:
lHl :
o
	:
'1x9
[dy9
 Z y8
%7
18
zM;
v H_E
XxK
P
8 P
4,0 M6Z 2SO2y %^(2C^
"RzKfV
w HO
L
1V ];W^ Z  {W %9 UR 2'S^zJW_ ZHbQY 

SS'DNCQg~Z KYQ""RX1N
f{G1 B
~F0:
Y 5 ?6 &k5Z l2 $)
2S
fzGI
(GIHG3
.
!
/X ?{y
2 
;Z V'
B )'a~0
Dp619
B3{E>
C)I|B
K"
HC
Gn X?
3Z B
Z jDP)c E1 ~C HjzEU@G#H< +
Hi5h CE2 E4 
 Z I6B ,W 5 	1-
0 ܄zD0$!
9. IS-
6 fl
H- 	
	* 0 	\ 0isr Z .1y s1Mw 6zAq uHQc 6
H_ [ p 5u'r Z  5 0'7
~/nA-
jN',{B	
\5GIT4
H ; ;+5->
 #tpC/[  Z  F
 2 :%
	mM.l qzAZ:HEF
HPpBwn?!y "uZ CPQ2c#6/ 
C{A
H 
 z	P8
CD(Y>k 5?Z 24  ZF3^)0 P.. {{{BK I} Qj2 	P,h wD <\f l cZ \  8D3> 7.g yA
G<Q9GI$s	PFi1t 46	P 5sp
 ,Z  M 2$,4. Al 	 -5do #zBBGGe:	P -
8	`g%
K }H^
H1qZ 

14&V,A :TKzDT
I*IR:
PN	P :N|RG޸
;1Z 
B42R n-1 {Ic 7H<I~ o.	P5f [T A=b 9mQ ;Z "f3H-XR
yKdM7eIFFvT>EZ
:
TP 
!V
 T2Z WH

 62O z7
q ---
 %zO *
$ !"Hi3
5r  CvH
3  Yb
 fhp
 =Z 
ib !0 Qw,^)
!xeyT 
4*G
 vZ-2
@ZZ  J
[C/U

m 5d۲+^
mSzX  
 ?H
vO m
 @  S
  [C	
 YWZ j& l-  Q,"
]~ <y\#9
_5 G-))  &v !^ 2z	Q  ny CZ   Ipz H*Vh	 61:-^hd| 66yb_: /II ]H	%vY[!^vQT  V BBg -Z h1  ( +j - :
@*yfS
6	H`
CvS
34 =1

D
Z V
lh& 97-+	yk 9cmH B) ,J
	A}&H	,Z A]#2s-F}zn $ZH_ 
wV C 
 o 	dgZ ~	E!
5	,P[LysT=/RHfX	L6.	;f0N;k& r;3!Z  # mz igXwf,n7zx<3qH 3@<+e41d& ES%\Z <!
k T , Z#	y{ed<_H I^ (`    tZ  _ 4 g[/|"zz~( H K P ;\mb > #e
A /Z [
S 
w /+ 9 y  .
f  I x @ ScY~ c-7   L6

 J1Z O! s( N r"( M/ o y  3W J =)s
E z Cmb
8 kfcH
Q qC :
j
 !Z  <
  u $EL
 5 )  c
 @y iHw
 I .y
 a a
 r B
 b[ eK
	U 4۠Z 
j @ll;
 GC/ { z kH 5 H 5_A "Fq
 <